#ifndef Selection_h
#define Selection_h






namespace BIOS {

class ClassifierTest;
class ClassificationResults;
class CPT;

class Selection {

/**
Selection can be done in three ways:
1. Embeded in a learning algorithmParameters (not in this class)
2. Filtered before using the sample to learn a classifier or whatever. 
3. Wrapping a learning algorithmParameters so that accuracy will drive the selected attributes, as the treeWrapper selmode

There is other classification:
1. by-user selection (when selected attributes are chosen by the user).
2. Class-driven discretization

Any of them can be filtered or embedded, while wrapping forces class-driven
*/

private:


Correlation<int>* correlation;
SelModeClass *selModeClass;
//ListOfAttributes* listOfAttributes;
int classNum;
intList* allAttributes;
floatMLSample* sample;
intMLSample* discSample;
//SelMode selMode;
//AttributeSelection* attributeSelection;
floatList* selectAttributes(floatMLSample* narrowSample);
double getThreshold(SelMode selMode, intList* selectedAtts, AlgType algType, LossFunction* lossFunction, char* filename, char* secondFilename, floatList* algorithmParameters=NULL);
VerbosityClass *verbosity;

public:

Selection(floatMLSample* sample, int classNum, VerbosityClass *verbosity); //
	
	intList* getSelection(SelMode selMode, AlgType algType, LossFunction* lossFunction, char*filename, char* secondFilenamme, floatList* selectionParameters=NULL, char* selectionFile=NULL, floatList* algorithmParameters=NULL);
	~Selection();
    	intList*  hillClimbingSelection(SelMode selMod, bool forward, AlgType algType, floatList* algorithmParameters, LossFunction* lossFunction, char* filename, char* secondFilename);
	int findAttribute(intList* selectedAttributes, SelMode selMod, bool forward, float &currentThreshold, AlgType algType, floatList* algorithmParameters, LossFunction* lossFunction, char* filename, char* secondFilename);
intList*  classAssociationSelection(SelMode selMod, floatList* selectionParameters=NULL, intList *selectedAttributes=NULL);
intList*  classAssociationByPairsSelection(SelMode selMod, floatList* selectionParameters=NULL, intList *originalSelectedAttributes=NULL);
//	intList* treeWrapperSelection(LossFunction* lossFunction, AlgType algType, floatList* algorithmParameters);

floatList* treeWrapperSelection(LossFunction* lossFunction, AlgType& algType, floatList*& algorithmParameters, float rightDistanceThreshold, float leftDistanceThreshold, ClassificationResults* rightResults, floatList*& currentVars, int& otherVarsSize, char* filename, char* secondFilename);



intList*  oneByOneWrapperSelection(SelMode selMod, AlgType algType, floatList* algorithmParameters, LossFunction* lossFunction, char* filename, char* secondFilename);

double* getAttributesQualityUsingReliefF(int m, int k, int classPosition, CPT** probTables);


};


}
#endif

//#include "Selection.cpp"//
