/* File: AssociateContainer.h */


#ifndef __AssociateContainer_h__
#define __AssociateContainer_h__





/**
    @memo Declaration of an AssociateContainer (FIFO)
    @doc
    */

//using namespace UTILS;

namespace BIOS
{

  /************************/
  /* AssociateContainer DEFINITION */
  /************************/
//template <class T> class list: public vector<T>{};
//typedef vector ListOfPointers;

  /**
          @memo AssociateContainer 
   
  	@doc
          Definition:
          A set of AssociateContainer's features 
   
          Memory space: O(SizeP), which SizeP being the number of elements in the AssociateContainer
   
      @author Maria M. Abad Grau
  	@version 1.0
  */


  template <template<class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> class AssociateContainer: public Cont<T>
  {
public:

  char outputSeparator;

  void insertElementFromString(string s);
  AssociateContainer<Cont, T>(char* file, char* tokens=NULL, char outputSeparator=',');
  // AssociateContainer<Cont, T>(AssociateContainer<Cont, T>& source, Sampling* sampling):Cont<T>(source, sampling){};

  AssociateContainer(char outputSeparator=',');
  AssociateContainer(int i, char outputSeparator=',');

  int size();
  void changeElementAtPos(T element, int pos);

  AssociateContainer(typename AssociateContainer::iterator first, typename AssociateContainer::iterator last, char outputSeparator=' ');
  // AssociateContainer(const AssociateContainer &source);

  AssociateContainer(AssociateContainer &source);
  // AssociateContainer<Cont, T>(ArrayList &source, Sampling* sampling);

  void init(char outputSeparator=' ');
   

  typename AssociateContainer<Cont, T>::iterator findElement(T &value);

  ~AssociateContainer(){empty();};

  //void readInfo (ifstream * is, char* tokens=NULL);

  virtual T readElement (ifstream * source, char* tokens);

  void getInfo(const char *FileName, char* tokens=NULL);

  void insertElement(T element);

  T pop();

  void insertElementAtPos(T element, int pos);
  void insertElementAtPointer(T element, typename Cont<T>::iterator it);
  void order(bool ascendant=true); 
  void orderPointer(bool ascendant=true); 
  void basicOrder(); 
  void empty();
  bool includes(AssociateContainer<Cont, T>* source);
  typename AssociateContainer<Cont, T>::iterator getFirst();
  typename AssociateContainer<Cont, T>::iterator getNext(typename AssociateContainer<Cont, T>::iterator iterator2);
  typename AssociateContainer<Cont, T>::iterator getLast();
  T& getFirstElement();
  T& getLastElement();
  T& getElement(typename AssociateContainer<Cont, T>::iterator it);
  T& getElement(int position);

/***************************************/

  typename AssociateContainer<Cont, T>::iterator 
  removeNode(typename AssociateContainer<Cont, T>::iterator it, typename AssociateContainer<Cont, T>::iterator it2);

/******************************************************************/

  typename AssociateContainer<Cont, T>::iterator 
  removeNode(typename AssociateContainer<Cont, T>::iterator it) ;



  typename AssociateContainer<Cont, T>::iterator removeNode(int position);
  typename AssociateContainer<Cont, T>::iterator getNode(int position);
  int getPosition(typename AssociateContainer<Cont, T>::iterator it) ;

  T* getTable();

  virtual AssociateContainer<Cont, T> *clone();
  void copyPaste(AssociateContainer<Cont, T>* source);

   AssociateContainer<set, int>* copyPositionsByContents(AssociateContainer<Cont, T>* c, int type);
   AssociateContainer<Cont, T>* copyElementsByContents(AssociateContainer * Source, int type, bool orderedByThis=true);
   AssociateContainer<Cont, T>* copyElementsIn(AssociateContainer* Source, bool orderedByThis=true);
   AssociateContainer<Cont, T>* copyElementsNotIn(AssociateContainer * Source, bool orderedByThis=true);
   AssociateContainer<set, int>* copyPositionsWithElementsIn(AssociateContainer<Cont, T>* Source);
   AssociateContainer<set, int>* copyPositionsWithoutElementsIn(AssociateContainer<Cont, T>* Source);

   AssociateContainer<Cont, T>* copyElementsWithoutPositionsIn(AssociateContainer<set, int> * sourceList);
   AssociateContainer<Cont, T>* copyElementsWithPositionsIn(AssociateContainer<set, int> * sourceList, bool orderedByThis=true);
   AssociateContainer<Cont, T>* extractElementsWithoutPositionsIn(AssociateContainer<set, int> * sourceList);
   AssociateContainer<Cont, T>* extractElementsWithPositionsIn(AssociateContainer<set, int> * sourceList);
   AssociateContainer<Cont, T>* copyElementsByPositions(AssociateContainer<set, int> * sourceList, int type, bool orderedByThis=true);
   AssociateContainer<Cont, T>* extractElementsByPositions(AssociateContainer<set, int> * sourceList, int type, bool orderedByThis=true);
   AssociateContainer<Cont, T>* mergeWith(AssociateContainer<Cont, T>* secondList);



   void removeElementsIn(AssociateContainer* Source);
   void removeElements(bool* table);
//R/   AssociateContainer<vector, Integer*>* getIntegerList();
  // AssociateContainer< set, Integer*>* getIntegerSet();
//R/   AssociateContainer<vector, int>* getIntListFromPointerList();

 //  AssociateContainer<set, Integer*>* getIntegerSetFromIntegerList();
//R/   AssociateContainer<vector, int>* getListFromString();

   AssociateContainer<Cont, string>* getStringList();
//R/   AssociateContainer<vector, int>* getIntList();

   AssociateContainer<Cont, T>* reverse();
 
   AssociateContainer<Cont, T>* removeSubsets ();
   AssociateContainer<Cont, T>* getCommonNodes (AssociateContainer<Cont, T>* otherSet);
   bool comparison(AssociateContainer<Cont, T> & Source, int type);


  };  // End of class AssociateContainer
  
  
  

typedef AssociateContainer<set, bool> boolSet;
typedef AssociateContainer<set, int> intSet;
typedef AssociateContainer<set,float> floatSet;
typedef AssociateContainer<set,double> doubleSet;
typedef AssociateContainer<set,string> stringSet;
typedef AssociateContainer<set, long long int> longLongSet;

//R/typedef boolVector boolList;
//R/typedef intVector intList;
//R/typedef floatVector floatList;
//R/typedef doubleVector doubleList;
//R/typedef stringVector stringList;
//R/typedef longLongVector longLongList;

//R/typedef AssociateContainer<vector,Integer*> IntegerVector;
//R/typedef AssociateContainer<vector,Integer*> IntegerList;


  /*______________________________________________________*/

///template <class T, template <class T> class Cont>
template <class T, template<class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont>  
ostream& operator<<(ostream& out, AssociateContainer<Cont, T>& l);

  
 /*______________________________________________________*/

typedef map<long long int, double,  std::less<long long int>,boost::pool_allocator<std::pair<const long long int, double> > > MAP;

} // end namespace
#endif


/* Fin Fichero: AssociateContainer.h */


/* Fin Fichero: AssociateContainer.h */
