
#ifndef __Basic2_cpp__
#define __Basic2_cpp__


#include "Basic2.h"
using namespace std;

namespace BIOS
{


//R/template <class T, template <class T> class Cont>
	template <class Cont, class T>
	bool empty ( Container<Cont, T>* lista )
	{
		return lista==NULL || lista->size() ==0;
	}
	/*_______________________________________________________________*/

	longLongList* getIndividualNumbers ( char* input )
	{
		longLongList* result=new longLongList();
		stringList* vals=getStringVector ( input, "," ), *list2;
		char value[100];
		for ( int i=0;i<vals->size();i++ )
		{
			strcpy ( value, vals->getElement ( i ).c_str() );

			list2=getStringVector ( value, ":" );
			if ( list2->size() >2 )
			{
				cout << "getIndividualNumbers: Error in argument, character ':' is allowed only once\n";end();
			}
			if ( atoi ( list2->getFirstElement().c_str() ) ==-1 || atoi ( list2->getLastElement().c_str() ) ==-1 )
				{cout << "getIndividualNumbers: Error in argument, -1 is not allowed in an interval\n";end();}
			if ( atoi ( list2->getFirstElement().c_str() ) >atoi ( list2->getLastElement().c_str() ) )
				{cout << "getIndividualNumbers: Error in argument, is not a correct interval\n";end();}
			if ( list2->size() ==1 )
				result->insertElement ( atol ( list2->getFirstElement().c_str() ) );
			zap ( list2 );
		}
		return result;
	}
	/*_______________________________________________________________*/

	PairOfLongsVector* getConsecutiveNumbers ( char* input )
	{
// a list with pairs of values: first and last
		PairOfLongsVector* result=new PairOfLongsVector();
		stringList* vals=getStringVector ( input, "," ), *list2;
		char value[100];
		PairOfLongs *pair;
		for ( int i=0;i<vals->size();i++ )
		{
			strcpy ( value, vals->getElement ( i ).c_str() );

			list2=getStringVector ( value, ":" );
			if ( list2->size() >2 )
			{
				cout << "getConsecutiveNumbers: Error in argument, character ':' is allowed only once\n";end();
			}
			if ( atoi ( list2->getFirstElement().c_str() ) ==-1 || atoi ( list2->getLastElement().c_str() ) ==-1 )
				{cout << "getConsecutiveNumbers: Error in argument, -1 is not allowed in an interval\n";end();}
			if ( atoi ( list2->getFirstElement().c_str() ) >atoi ( list2->getLastElement().c_str() ) )
				{cout << "getConsecutiveNumbers: Error in argument, is not a correct interval\n";end();}
			if ( list2->size() ==2 )
			{
				pair=new PairOfLongs ( atol ( list2->getFirstElement().c_str() ), atol ( list2->getLastElement().c_str() ) );
				result->insertElement ( pair );
			}
			zap ( list2 );
		}
		return result;
	}

	/*_______________________________________________________________*/

	longLongList* getNumbers ( char* input )
	{
		longLongList* result=new longLongList();
		stringList* vals=getStringVector ( input, "," ), *list2;
		char value[100];
		for ( int i=0;i<vals->size();i++ )
		{
			strcpy ( value, vals->getElement ( i ).c_str() );

			list2=getStringVector ( value, ":" );
			if ( list2->size() >2 )
			{
				cout << "Error in argument, character ':' is allowed only once\n";end();
			}
			if ( atoi ( list2->getFirstElement().c_str() ) ==-1 || atoi ( list2->getLastElement().c_str() ) ==-1 )
				{cout << "Error in argument, -1 is not allowed in an interval\n";end();}
			if ( atoi ( list2->getFirstElement().c_str() ) >atoi ( list2->getLastElement().c_str() ) )
				{cout << "Error in argument, is not a correct interval\n";end();}
			for ( long long int j=atol ( list2->getFirstElement().c_str() );j<=atol ( list2->getLastElement().c_str() );j++ )
			{
				result->insertElement ( j );
			}
			zap ( list2 );
		}
		return result;
	}


	/* _____________________________________________________*/

	stringVector*  getStringVector ( char * genotypebuf2, const char* tokensSource )
	{
try
{
		if ( genotypebuf2==NULL ) return NULL;
		char *genotypebuf=new char[strlen ( genotypebuf2 ) +1];

		stringVector* strList=NULL;
		strcpy ( genotypebuf, genotypebuf2 );
		char tokens[10];

		if ( tokensSource==NULL )
			strcpy ( tokens, "\t, \n\r" );
		else
		{
			if ( strstr ( tokensSource, ",\"" ) !=NULL ||
			        strstr ( tokensSource, "\"," ) !=NULL )
			{
				string st=string ( tokensSource );
				replaceAll ( st, string ( "\"," ), string ( "\t" ) );
				replaceAll ( st, string ( ",\"" ), string ( "\t" ) );
				strcpy ( tokens, st.c_str() );
				strcpy ( genotypebuf, genotypebuf+1 );//remove first char (double quote magetrk)
				genotypebuf[strlen ( genotypebuf )-1]='\0'; // remove last char
				string st2=string ( genotypebuf );
				string oldS=string ( "\",\"" ), newS=string ( "\t" );
				replaceAll ( st2, oldS, newS );
				strcpy ( genotypebuf,st2.c_str() );
			}
			else strcpy ( tokens, tokensSource );
		}

		string s;
		char *cad;
		cad = strtok ( genotypebuf, tokens );
		int i=0;
		while ( cad!=NULL ) // && cad[0]!='\n')// && cad[0]!='\r' && cad[0]!='/')
		{
			if ( i==0 ) strList=new stringVector();
			s=string ( cad );


			strList->insertElement ( s );
			cad = strtok ( NULL, tokens );
			i++;
		};
		zaparr ( genotypebuf );
		return strList;
}
catch ( BasicException& be ) {be.addMessage ( "\ncalled from stringVector*  getStringVector ( char * genotypebuf2, const char* tokensSource )" ); throw;};
	};
	/*_____________________________________________________________*/

	double trapezoid_area ( double x1, double x2, double y1, double y2 )
	{
		double height_avg= ( y1+y2 ) /2;
		double base=fabs ( x1-x2 );
		return base*height_avg;
	}
	/*_____________________________________________________________*/

	PairOfDoublesVector* computeROC ( doubleList*positives, doubleList*negatives )
	{
		if ( positives==NULL || negatives==NULL )
			throw NullValue ( "BIOS::computeAUC(doubleList*truePositives, doubleList*trueNegatives)" );
  PairOfDoublesVector* result=new PairOfDoublesVector();
  PairOfDoubles* point;
		FreqAndKeyVector* all=new FreqAndKeyVector();
		doubleList* list;
		FreqAndKey* res;
		for ( int i=0; i<2;i++ )
		{
			if ( i==0 ) list=negatives; else list=positives;
			for ( doubleList::iterator it=list->begin(); it<list->end(); it++ )
			{
				res=new FreqAndKey ( list->getElement ( it ), i );
				all->insertElement ( res );
			}
		}

		all->sort ( false );

		int fp=0, tp=0;
		double f_prev=-MAXDOUBLE, area;

		for ( FreqAndKeyVector::iterator it=all->begin(); it<all->end(); it++ )
		{
			res=all->getElement ( it );
			if ( res->First!=f_prev )
		{
    result->insertElement(new PairOfDoubles(fp/(double)negatives->size(), tp/(double)positives->size(), '\0', '\0'));
				f_prev=res->First;
			}
			if ( res->Second==1 ) // positive value
				tp++; else fp++;
		}
		result->insertElement(new PairOfDoubles(fp/(double)negatives->size(), tp/(double)positives->size(), '\0', '\0'));
		return result;
	}
	/*_____________________________________________________________*/

	double computeAUC (	PairOfDoublesVector* roc )
	{
		double result=0;
  PairOfDoubles* point, *lastPoint;

		for (int i=1; i<roc->size(); i++)
		{
  point=roc->getElement(i);
  lastPoint=roc->getElement(i-1);
   result=result+trapezoid_area (point->First, lastPoint->First, point->Second, lastPoint->Second );
			}
		return result;
	}
	/*_____________________________________________________________*/

	double computeAUC2 ( doubleList*positives, doubleList*negatives ) // Fogarti et al. 2005 estimation
	{
		double result=0;
		if ( positives==NULL || negatives==NULL )
			throw NullValue ( "BIOS::computeAUC(doubleList*truePositives, doubleList*trueNegatives)" );


		for ( doubleList::iterator it=positives->begin(); it<positives->end(); it++ )
			for ( doubleList::iterator it2=negatives->begin(); it2<negatives->end(); it2++ )
			{
				if ( *it>*it2 ) result++;
				if ( *it==*it2 ) result=result+0.5;
			}
		return result/ ( positives->size() *negatives->size() );
	}
	

	/* _____________________________________________________*/

}
// end namespace

//#include "basic.cpp"
#endif


