/* File: Container.cpp */


#ifndef __Container_cpp__
#define __Container_cpp__




#include "Container.h"
//#include <../../GeneticUnitCounts.h>




/**
@memo Declaration of a list (FIFO)
@doc
*/


namespace BIOS
{

	/************************/
	/* list DEFINITION */
	/************************/


	/**
	@memo list

	  @doc
	  Definition:
	  A set of list's features

		Memory space: O(SizeP), which SizeP being the number of elements in the list

		  @author Maria Mar Abad Grau<< "\n
		  @version 1.0
	*/





	/*______________________________________________________*/
	/*
	  template <class Cont, class T>
	void order (Container<Cont, T>* const & l, bool ascendant)
	{
	l->sort(ascendant);
	}

	 /*______________________________________________________*/
	/*
	  template <class Cont, class T>
	void order (Container<Cont, T*>* const  & l, bool ascendant)
	{
	l->sortPointer(ascendant);
	}


	/*____________________________________________________________ */

	template <class T, class U>
	ostream& operator<< ( ostream& out, map<T, U>& l )
	{
		for ( typename map<T, U>::iterator it = l.begin(); it != l.end(); it++ )
		{
			out << ( *it ).first <<": " << ( *it ).second <<"\n";
		}
		return out;
	}

	/*______________________________________________________*/

	template <class Cont, class T>
	ostream& operator<< ( ostream& out, Container<Cont, T>& l )
	{
		for ( typename Container<Cont, T>::iterator p = l.begin(); p != l.end(); p++ )
		{
			if ( p==l.begin() && l.leftDelimiter!='\0' ) out << l.leftDelimiter;
			out << *p;
			if ( l.size() >1 && ( l.getPosition ( p ) < ( l.size()-1 ) ) && l.outputSeparator!='\0' )
			{
				out <<l.outputSeparator;
			}
		}
		if ( l.rightDelimiter!='\0' )
		{
			out <<l.rightDelimiter;
		}
		return out;
	}
	/*______________________________________________________*/

	template <class Cont, class T>
	ostream& operator<< ( ostream& out, Container<Cont, T*>& l )
	{
//out << "INIII\n";
		for ( typename Container<Cont, T*>::iterator p = l.begin(); p != l.end(); p++ )
		{
			if ( p==l.begin() && l.leftDelimiter!='\0' ) out << l.leftDelimiter;
			if ( ( T* ) *p!=NULL ) out << **p;
//out << "outputseparatoris" << l.outputSeparator << "next\n";
			if ( l.size() >1 && ( l.getPosition ( p ) < ( l.size()-1 ) ) && l.outputSeparator!='\0' )
			{
				out <<l.outputSeparator;
			}
		}
		if ( l.rightDelimiter!='\0' )
		{
			out << l.rightDelimiter;
		}
		return out;
	}




	/**********************************/
	/* DEFINITIONS OF THE FUNCTIONS */
	/**********************************/


	/*____________________________________________________________ */

	template <class Cont, class T>
	Container<Cont, T>::Container ( int size, int startingPoint, int way, char outputSeparator, char leftDelimiter, char rightDelimiter ) :Cont()
	{
		init ( outputSeparator, leftDelimiter, rightDelimiter );
		switch ( way )
		{
			case 1:
				for ( int i=0; i<size;i++ )
					this->insertElement ( startingPoint+i );
				break;
			case 0:
				for ( int i=0; i<size;i++ )
					this->insertElement ( startingPoint );
				break;
			case -1:
				for ( int i=0; i<size;i++ )
					this->insertElement ( startingPoint-i );
				break;
			default:
				throw BadFormat ( "Container<Cont, T>::Container(int size, int startingPoint, int way, char outputSeparator, char leftDelimiter, char rightDelimiter):Cont()" );
				break;
		}
	}

	/*____________________________________________________________ */

	template <class Cont, class T>    template <class Cont2, class U> Container<Cont, T>::Container ( Container<Cont2, U> &source ) :Cont()
	{
		init ( source.outputSeparator, source.leftDelimiter, source.rightDelimiter );
		// this->outputSeparator=source.outputSeparator;
		for ( typename Container<Cont2, T>::iterator it=source.getFirst(); it!=source.end(); it++ )
			insertHardElement ( *it );

	}

	/*____________________________________________________________ */

	template <class Cont, class T>
	Container<Cont, T>::Container ( Container &source ) :Cont()
	{
		init ( source.outputSeparator, source.leftDelimiter, source.rightDelimiter );
		for ( typename Container<Cont,T>::iterator it=source.begin(); it!=source.end(); it++ )
			this->insertHardElement ( *it );
	}

	/*____________________________________________________________ */

	template <class Cont, class T>
	Container<Cont, T>::Container ( char outputSeparator, char leftDelimiter, char rightDelimiter ) :Cont()
	{
		init ( outputSeparator, leftDelimiter, rightDelimiter );
	}
	/*____________________________________________________________ */

	template <class Cont, class T>
	Container<Cont, T>::Container ( Container &source, typename Container< Cont, T>::iterator first, typename Container<Cont, T>::iterator last ) :Cont()
	{

		init ( source.outputSeparator, source.leftDelimiter, source.rightDelimiter );
		if ( first>last ) throw BadFormat ( "Container(Container &source, typename Container< Cont, T, STL2>::iterator first, typename Container<Cont, T>::iterator last" );
		for ( typename Container<Cont,T>::iterator it=first; it!=last; it++ )
			this->insertHardElement ( *it );


		/*
		   int iniPos=source.getPosition(first), lastPos=source.getPosition(last);
		   this->removeObjects(this->begin()+lastPos+1, this->end());
		   this->removeObjects(this->begin(), this->begin()+iniPos);
		*/
	}




	/*____________________________________________________________ */

	template <class Cont, class T>
	Container<Cont, T>::Container ( const char* filename, const char* tokens, char outputSeparator, char leftDelimiter, char rightDelimiter ) :Cont()
	{
		try
		{
			init ( outputSeparator, leftDelimiter, rightDelimiter );
			this->getInfo ( filename, tokens );
		}
		catch ( BasicException& be )
		{
			be.addMessage ( "\ncalled from Container<Cont, T>::Container (const char* filename, const char* tokens, char outputSeparator, char leftDelimiter, char rightDelimiter)" );
			throw;
		};
	}

	/*____________________________________________________________ */

	template <class Cont, class T>
	Container<Cont, T>::Container ( T* array, int size ) :Cont()
	{
		init();
		for ( int i=0; i<size;i++ )
			this->insertElement ( ( T& ) array[i] );
	}

	/*___________________________________________________________________________________________*/


	template <class Cont, class T>  Container<Cont, T>* Container<Cont, T>::clone()
	{
		Container<Cont, T>*result=new Container<Cont, T> ( *this );
		return result;
	}

	/*___________________________________________________________________________________________*/


	template <class Cont, class T>  Container<Cont, T>* Container<Cont, T>::emptyCopy()
	{
		Container<Cont,T>* result=clone();
		result->empty();
		return result;
	}
	/*___________________________________________________________________________________________*/

	template <class Cont, class T> void Container<Cont, T>::init ( char outputSeparator, char leftDelimiter, char rightDelimiter )
	{
		this->outputSeparator=outputSeparator;
		this->leftDelimiter=leftDelimiter;
		this->rightDelimiter=rightDelimiter;
	}
	/*_____________________________________________ */

	template <class Cont, class T> int Container<Cont, T>::size() const
	{
//cout << "size is: " << this->Cont::size() <<"\n";
		return ( int ) this->Cont::size();
	}

	/*____________________________________________________________ */

	template <class Cont, class T> void Container<Cont, T>::empty()
	{
//if (this->begin()!=this->end())
//cout <<"will empty" << this->size() <<" objects\n";
		if ( this->size() >0 )
			this->removeObjects ( 0, this->size() );
	};
	/*____________________________________________________________ */

	template <class Cont, class T>   typename Container<Cont, T>::iterator Container<Cont, T>::getFirst()
	{
		return ( typename Container<Cont, T>::iterator ) this->begin();
	};

	/*____________________________________________________________ */

	template <class Cont, class T> typename Container<Cont, T>::iterator Container<Cont, T>::getNext ( typename Container<Cont, T>::iterator iterator2 )
	{
		return ++iterator2;
	};
	/*____________________________________________________________ */

	template <class Cont, class T> typename Container<Cont, T>::iterator Container<Cont, T>::getPrevious ( typename Container<Cont, T>::iterator iterator2 )
	{
		return --iterator2;
	};

	/*____________________________________________________________ */

	template <class Cont, class T>  typename Container<Cont, T>::iterator Container<Cont, T>::getLast()
	{
		return ( typename Container<Cont, T>::iterator ) this->end();
	};

	/*____________________________________________________________ */

	template <class Cont, class T> T& Container<Cont, T>::getFirstElement()
	{
		return this->front(); //getElement(this->end()); // this->front()
	};
	/*____________________________________________________________ */

	template <class Cont, class T> T& Container<Cont, T>::getLastElement()
	{
		return this->back(); //getElement(this->begin()); //this->back();
	};
	/*____________________________________________________________ */

	template <class Cont, class T> T& Container<Cont, T>::getElement ( typename Container<Cont, T>::iterator it ) const
	{
		return ( T& ) *it;
//return this->getElement(this->getPosition(it));
	};
	/*____________________________________________________________ */
	/*
	 Container<Cont, T>T* Container<Cont, T*, STL2>::getElement(typename Container<Cont, T*, STL2>::iterator it)
	{
	return (T*)*it;
	};


	/*____________________________________________________________ */

	template <class Cont, class T> void Container<Cont, T>::setOutputSeparator ( char outputSeparator )
	{
//cout << "outputseparator is assigned to be" << outputSeparator << "me gusta\n";
		this->outputSeparator=outputSeparator;
	};

	/*____________________________________________________________ */

	template <class Cont, class T> void Container<Cont, T>::setDelimiters ( char leftDelimiter, char rightDelimiter )
	{
		this->leftDelimiter=leftDelimiter;
		this->rightDelimiter=rightDelimiter;
	};

	/*____________________________________________________________ */

	template <class Cont, class T> void Container<Cont, T>::insertElement ( typename Container<Cont, T>::iterator first, typename Container<Cont, T>::iterator second )
	{
try
{
		for ( typename Container<Cont, T>::iterator it=first; it!=second;it++ )
			insertElement ( *it );
// return this->insert(this->end(), first, second);
}
	catch ( BasicException& be ) {be.addMessage ( "\ncalled from void Container<Cont, T>::insertElement ( typename Container<Cont, T>::iterator first, typename Container<Cont, T>::iterator second )" ); throw;};
	};

	/*____________________________________________________________ */

	template <class Cont, class T> void Container<Cont, T>::insertHardElement ( typename Container<Cont, T>::iterator first, typename Container<Cont, T>::iterator second )
	{
		for ( typename Container<Cont, T>::iterator it=first; it!=second;it++ )
			insertHardElement ( *it );
// return this->insert(this->end(), first, second);
	};


	/*____________________________________________________________ */

	template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::changeReference ( const T& element )
	{
		Container<Cont, T>* result=new Container<Cont, T>();

		for ( typename Container<Cont, T>::iterator it=this->begin(); it!=this->end();it++ )
			result->insertElement ( getElement ( it ) +element );
		return result;
// return this->insert(this->end(), first, second);
	};





	/*___________________________________________________________________________________________*/

	template <class Cont, class T> void Container<Cont, T>::insertElement ( T element )
	{
//		insert ( it, element );
		this->insertElement ( element, ( typename Container<Cont, T>::iterator ) this->end() );
	}

	/*___________________________________________________________________________________________*/

	template <class Cont, class T> void Container<Cont, T>::insertElementAtPos ( T element, int pos )
	{
		try
		{
			insertElement ( ( const T& ) element, getNode ( pos ) );
		}
		catch ( BasicException & be )
		{
			be.addMessage ( "\ncalled from void Container<Cont, T>::insertElementAtPos (T element, int pos)" );
			throw;
		};



	}


	/*___________________________________________________________________________________________*/

	template <class Cont, class T> void Container<Cont, T>::insertElement ( T element, typename Container<Cont, T>::iterator it )
	{
//cout << "here\n";
		this->insert ( it, element );

	}

	/*___________________________________________________________________________________________*/
// why is this needed?
/*
	template <> void Container<vector<Haplotype*>, Haplotype*>::insertElement ( Haplotype* element,  Container<vector<Haplotype*>, Haplotype*>::iterator it )
	{
//cout << "here\n";
		insert ( it, element );

	}
	/*___________________________________________________________________________________________*/

	template <class Cont, class T> void Container<Cont, T>::insertElementFromString ( string s )
	{
		T e;
		insertElement ( fromString ( e, s ) );
	}


	/*____________________________________________________________ */

	template <class Cont, class T> T& Container<Cont, T>::getElement ( int position )
	{
		try
		{
			if ( position>=size() ) throw OutOfBounds ( position, this->size(), "Container<Cont, T>::getElement(int position) " );
			return ( T& ) ( *this ) [position];
			/*
						int i=0;
						for ( typename Container<Cont, T>::const_iterator it=this->begin(); it!=this->end(); it++ )
						{
							if ( i==position ) return ( T& ) *it;
							i++;
						};
						*/

		}
		catch ( BasicException & be )
		{
			be.addMessage ( "\ncalled from  T& Container<Cont, T>::getElement ( int position ) const)" );
			throw;
		};
	};





	/*____________________________________________________________ */
	/*
	// Container<Cont, T>
	template <template <class T, typename _Alloc=std::allocator<T> > class Vector<T>::Class, class T>
	//template < template < class T, typename _Alloc=std::allocator<T> > class classCont=vector, class T >
	 T&  Container<vector<T>, T>::getElement(int position)

	//template <> int& intV::getElement(int position)
	{
	return this->at(position);
	};


	/***************************************/

	template <class Cont, class T>
	void Container<Cont, T>::removeNode ( typename Container<Cont, T>::iterator it )
	{
//T val=this->getElement(it);
//
//this->removeNodeWithObject(p, it);
		if ( it==this->end() )  throw NullValue ( "void Container<Cont, T>::removeNode (typename Container<Cont, T>::iterator it)" );
		zap ( ( T& ) *it );
		this->erase ( it );

	};
	/***************************************/
	/*
	 Container<Cont, T>
	void Container<Cont, typename Selec<IsPrimitive<T>::r, T, void>::R NewT, STL2>::removeNodeWithObject(Primitive p, typename Container<Cont, T>::iterator it)
	{
	this->erase(it);
	}
	};
	/***************************************/

	template <class Cont, class T>
	void Container<Cont, T>::removeObjects ( typename Container<Cont, T>::iterator it, typename Container<Cont, T>::iterator it2 )
	{
//cout <<"now here\n";
		for ( typename Container<Cont, T>::iterator it1=it; it1!=it2; it1++ )
		{
//cout <<"erasing\n";
//zap(getElement(this->size()-1));
			zap ( ( T& ) *it1 );
//zap(getElement(it1));
//cout <<"end erasing\n";
// if only zap(&) is defined, as currently, zap(*it1) will give an error for containers of primitive types or of objets in the stack (no pinters))
// if zap(*&) and zap(&) are both defined, if zap(*it1) is written instead, function zap(T&) will be allways called, instead of zap(T*&) for those objects in the heap
		}
//cout <<"size is:" << size() <<"\n";
		this->erase ( it, it2 );

//cout <<"now size is:" << size() <<"\n";
	};
	/***************************************/

	template <class Cont, class T>
	void Container<Cont, T>::removeObjects ( int firstPos, int lastPos )
	{
		try
		{
// <<"here called\n";
			this->removeObjects ( this->getNode ( firstPos ), this->getNode ( lastPos ) );
		}
		catch ( BasicException & be )
		{
			be.addMessage ( "\ncalled from  void Container<Cont, T>::removeObjects (int firstPos, int lastPos)" );
			throw;
		};

	};



	/*___________________________________________________________________________________*/


	template <class Cont, class T>
	template <class U>
	typename Container<Cont, T>::iterator
	Container<Cont, T>::findElementContainingInternalElement ( U element )
	{
//cout <<" findinel" << *element <<"\n";
		for ( typename Container<Cont, T>::iterator p=this->getFirst();p!=this->end();p++ )
		{
			if ( this->getElement ( p )->findElement ( ( const U& ) element ) !=this->getElement ( p )->end() ) return p;
		}

		return this->end();

	};
	
	


	/*___________________________________________________________________________________*/
	/*

	  template <class Cont, class T>
	  template <class U>
	  typename Container<Cont, T>::iterator
	  Container<Cont, T>::findElementContainingEqualInternalElement (U element)
	  {
	    for (typename Container<Cont, T>::iterator p=this->getFirst();p!=this->end();p++)
	      if (this->getElement (p)->findEqualElement ( (const U&) element) !=this->getElement (p)->end() ) return p;

	    return this->end();

	  };

	  /*______________________________________________________*/

	/*
	template <>
	template <class U>
	SetOfCliques::iterator SetOfCliques::findElementContainingInternalElement(U& element)
	{
	Clique * clique;
	for (SetOfCliques::iterator p=this->getFirst();p!=this->end();p++)
	{
	clique=*p;
	for (Clique::iterator p2=clique->getFirst();p2!=clique->end();p2++)
		if (**p2==*element) return p;
	}
	return this->end();
	//return this->at(position);
	//return this->getElement(this->getNode(position));
	};

	 /*____________________________________________________________ */

	template <class Cont, class T>
	void Container<Cont, T>::removeNode ( int position )
	{
		try
		{
			removeNode ( getNode ( position ) );
		}
		catch ( BasicException & be )
		{
			be.addMessage ( "\ncalled from  void Container<Cont, T>::removeNode (int position)" );
			throw;
		};

	};

	/*____________________________________________________________ */

	template <class Cont, class T> typename Container<Cont, T>::iterator Container<Cont, T>::getNode ( int position )
	{
		if ( size() <position ) throw OutOfBounds ( position, size(), " template <class Cont, class T> typename Container<Cont, T>::iterator Container<Cont, T>::getNode (int position)" );
		typename Container<Cont, T>::iterator it=this->begin();
		if ( position<0 ) return this->end();
		for ( int i=0;i<position;i++ ) ++it;
		return it;
	};
	/*____________________________________________________________ */


	template <class Cont, class T> int Container<Cont, T>::getPosition ( typename Container<Cont, T>::iterator it )
	{
		typename Container<Cont, T>::iterator it2;
		int pos=0;
		for ( it2=this->begin();it2!=it;++it2 )
		{
			++pos;
			if ( pos>size() ) throw OutOfBounds ( size(), pos, "template <class Cont, class T> int Container<Cont, T>::getPosition (typename Container<Cont, T>::iterator it)" );
		}
		if ( pos==size() ) return -1;
		return pos;
	};
	/*____________________________________________________________ */


	template <class Cont, class T>
	Container<set<Integer*>, Integer*>* Container<Cont,T>::getIntegerSetFromIntegerList()
	{
		Container<set<Integer*>, Integer*> *integerSet=new Container<set<Integer*>, Integer*> ( true );
		typename Container<vector<Integer*>, Integer*>::iterator p=this->getFirst();
		Integer* i;
		while ( p!=this->end() )
		{
			i=new Integer ( *this->getElement ( p ) );
			integerSet->insert ( i );
			zap ( i );
			p=this->getNext ( p );
		}
		return integerSet;
	}

	/*____________________________________________________________ */

	template <class Cont, class T> bool Container<Cont, T>::includes ( Container<Cont, T> * Source )
	{
		if ( Source==NULL )
		{
			cout <<"Error in Container<Cont, T>::includes";
			end();
		}

		if ( this->size() <Source->size() ) return false;
		typename Container<Cont,T>::iterator p=Source->getFirst();
		while ( p!=Source->end() )
		{
			if ( findElement ( getElement ( p ) ) ==this->end() ) return false;
			p=Source->getNext ( p );
		}
		return true;
	}
	/*____________________________________________________________ */

	template <class Cont, class T> T& Container<Cont, T>::changeElementAtPos ( T element, int pos )
	{
		try
		{
			T& val=getElement ( pos );
			this->erase ( this->getNode ( pos ) );
//this->removeNode(pos);
			this->insertElementAtPos ( element, pos );
			return val;
		}
		catch ( BasicException & be )
		{
			be.addMessage ( "\ncalled from T& Container<Cont, T>::changeElementAtPos (T element, int pos)" );
			throw;
		};

	}


	/*___________________________________________________________ */

	template <class Cont, class T> typename Container<Cont, T>::iterator Container<Cont, T>::getClosestGreaterPointerToElement ( T argument, bool checkOrder )
	{
// precond: this must be ordered
		if ( checkOrder==true )
		{
			cout <<"Error in list<T>::getClosestGreaterPointerToElement, not ordered";
			exit ( 0 );
		}
		// it returns a pointer to the element in the list which has the closest upper value than argument
		typename Container<Cont, T>::iterator pk=this->getFirst();


		while ( pk!=this->end() )
		{

			if ( *this->getElement ( pk ) >*argument ) return pk;// change to make it works for primitive values

			pk=this->getNext ( pk );
		}
		return pk;
	};
	/*___________________________________________________________ */
	/*
	    Container<Cont, T>void Container<Cont, T>::readInfo (ifstream * is, char* tokens)
	  {

	char a,b;
	 a=is->get();
	 if (a!=EOF) b=is->get();
	int i =0;
	    while (a!=EOF && b!=EOF)
	    {
	     is->putback(b);
	     is->putback(a);
	    insertElement(readElement(is, tokens));
	a=is->get();
	 if (a!=EOF) b=is->get();
	i++;
	//cout << "\nsig: " << i;
	  }

	  }

	/*___________________________________________________________ */
	/*
	    Container<Cont, T>void Container<Cont, T>::readInfo (ifstream * is, char* tokens)
	  {

	    while (!is->eof())
	    {
	//     is->putback(b);
	//     is->putback(a);
	    insertElement(readElement(is, tokens));
	//a=is->get();
	 //if (a!=EOF) b=is->get();
	//cout << "\nsig: " << i;
	  }

	  }


	  /* _____________________________________________________*/


//virtual T readElement (ifstream * source, const char* tokens, int* pos=NULL, int size=0);

	/* _____________________________________________________*/


	template <class Cont, class T> T Container<Cont, T>::readElement ( ifstream * source, const char* tokens, int* pos, int size )
	{

		T  val, val2;
		char* genotypebuf=NULL;//new char[100000];//NULL;
		genotypebuf=CaptureLine ( source );
//cout << "buf is: " << genotypebuf << "\n";
		val2=BIOS::fromString ( val, string ( genotypebuf ) );
		zaparr ( genotypebuf );
		return val2;
	};
	/*____________________________________________________________ */

	template <class Cont, class T> void Container<Cont, T>::getInfo ( const char *FileName, const char* tokens, int* pos, int size )
	{
		try
		{
			ifstream InputFile;
			T element, el;
			OpenInput ( FileName, &InputFile );
			int i=0;
			while ( !InputFile.eof() && InputFile.peek() !=EOF && InputFile.peek() !='\n'  && InputFile.peek() !='\r' )
			{
				el=readElement ( &InputFile, tokens, pos, size );
				insertElement ( el );


				//	 cout <<"line " << i << "has been read\n";
				i++;
			}
			InputFile.close();
		}
		catch ( BasicException& be )
		{
			be.addMessage ( "\ncalled from  Container<Cont, T>::getInfo(,..." );
			throw;
		};

	};

	/*___________________________________________________________________________________________*/

	template <class Cont, class T> bool Container<Cont, T>::hasElementsInHeap()
	{
		return BIOS::isAPointer ( ( T& ) *this->begin() );
	}
	/*___________________________________________________________________________________________*/

	template <class Cont, class T> void Container<Cont, T>::insertHardElement ( const T& element )
	{
// it should not work for Cont=set; if Cont=set, use just insert(element)
//cout << "lement " << element << " is about to be inserted\n";



//zap(*it1);

//const T& element2=element;
		/*T* element2;
		if (hasElementsInHeap()) { element2=new &T(*element); cout <<"HHHHH:\n" << element <<"\n";}
		else element2=(T*)&element;
		*/


		T element2=BIOS::clone ( ( T& ) element );// we need to use (T&) to consider whether is a pointer or not

		this->insertElement ( element2 );
//cout << "innnn\n";



//if (this->hasElementsInHeap()) {this->insertElement(element.clone()); cout <<"HHHHH:\n" << element <<"\n";}
//else {this->insertElement(element); } //cout <<"nohard:" << element <<"\n";}


//cout << "lsat element inserted was:" << getLastElement() <<"\n";

	}
	/*___________________________________________________________________________________________*/
	/*
	   template <class Cont, class T> void Container<Cont, T>::insertHardElement(const T*& element)
	  {
	cout <<"---------\n";
	this->insertElement(element);

	  }

	   /*___________________________________________________________________________________________*/

	template <class Cont, class T> typename Container<Cont, T>::iterator Container<Cont, T>::findElement ( const T& element, bool usePointer )
	{
		try
		{
// if a primitive data, second argument is useless
// if not: if usePointer, identity will be used, if not, equivalency (status object) will be used in comparisons
			if ( !isAPointer ( ( T& ) element ) || usePointer )
			{
				return find ( this->begin(), this->end(),  element );
			}
			else
			{
				return findEqualElement ( element );
			}
		}
		catch ( BasicException & be )
		{
			be.addMessage ( "\ncalled from Container<Cont, T>::iterator Container<Cont, T>::findElement (const T& element, bool usePointer)" );
			throw;
		};
	}
	
	/*___________________________________________________________________________________________*/

	template <class Cont, class T> typename Container<Cont, T>::iterator Container<Cont, T>::findEqualElement ( const T& element )
	{
		try
		{

//cout <<"element is: " << *element << "\n";
			for ( typename Container<Cont, T>::iterator it=this->begin(); it!=this->end(); it++ )
			{

//cout <<"el" << **it <<"\n";
				if ( **it== *element )
				{
					return it;
				}
//cout <<"INNN333\n";
			}
//cout <<"INNN44\n";
			return this->end();
		}
		catch ( BasicException & be )
		{
			be.addMessage ( "\ncalled from typename Container<Cont, T>::iterator Container<Cont, T>::findEqualElement (const T& element)" );
			throw;
		};
	}
	
	/*___________________________________________________________________________________________*/
	
	

	//template <> GeneticUnitCountsList::iterator GeneticUnitCountsList::findEqualElement ( const GeneticUnitCounts*& element )
	
	//template <> Vector<GeneticUnitCounts*>::Class::iterator Vector<GeneticUnitCounts*>::Class::findEqualElement ( const GeneticUnitCounts*& element ) 
	//template <> typename Container<vector<GeneticUnitCounts*>, GeneticUnitCounts*>::iterator Container<vector<GeneticUnitCounts*>, GeneticUnitCounts*>::findEqualElement ( const GeneticUnitCounts*& element ) 

	
	//template <class Cont, class T> typename Container<Cont, T>::iterator Container<Cont, T>::findEqualElement ( const T& element )
	
	//std::allocator<BIOS::GeneticUnitCounts*>
	
	


	/*___________________________________________________________________________________________*/

// these are to prevent compilation errors in findEqualElements when using primitive data
// it would be better if we used the approach in insertHardElement, which calls to BIOS::clone(element), as there are two definitions for clone depending on whether the argument is a pointer or not (not done yet)
// or even better to use bios::isAPointer(element) inside the method findEqualElement

	template <> stringList::iterator stringList::findEqualElement ( const string& element ) {};
	template <> stringSet::iterator stringSet::findEqualElement ( const string& element ) {};
	template <> intList::iterator intList::findEqualElement ( const int& element ) {};
	template <> intSet::iterator intSet::findEqualElement ( const int& element ) {};
	template <> doubleList::iterator doubleList::findEqualElement ( const double& element ) {};
	template <> doubleSet::iterator doubleSet::findEqualElement ( const double& element ) {};
	template <> floatList::iterator floatList::findEqualElement ( const float& element ) {};
	template <> floatSet::iterator floatSet::findEqualElement ( const float& element ) {};
	template <> longLongList::iterator longLongList::findEqualElement ( const long long& element ) {};
	template <> longLongSet::iterator longLongSet::findEqualElement ( const long long& element ) {};
	
	/*___________________________________________________________________________________________*/

	template <class Cont, class T> bool Container<Cont, T>::operator== ( Container<Cont, T> & otherContainer )
	{
		if ( isAPointer ( this->getElement ( this->begin() ) ) ) return sameState ( &otherContainer );

		T element, element2;
		for ( typename Container<Cont, T>::iterator it=this->begin(); it!=this->end(); it++ )
		{
			element=this->getElement ( it );
			element2=otherContainer.getElement ( getPosition ( it ) );
			if ( ( element==element2 ) ==false ) return false;
		}
		return true;
	}

	/*___________________________________________________________________________________________*/

	template <class Cont, class T> bool Container<Cont, T>::sameState ( Container<Cont, T> * otherContainer )
	{
		T element, element2;
		for ( typename Container<Cont, T>::iterator it=this->begin(); it!=this->end(); it++ )
		{
			element=this->getElement ( it );
			element2=otherContainer->getElement ( getPosition ( it ) );
			if ( ! ( * ( T& ) element==* ( T& ) element2 ) ) return false;
		}
		return true;
	}

	/*___________________________________________________________________________________________*/

// these are to prevent compilation errors in sameState when using primitive data

	template <> bool stringList::sameState ( stringList* otherContainer ) {};
	template <> bool stringSet::sameState ( stringSet* otherContainer ) {};
	template <> bool intList::sameState ( intList* otherContainer ) {};
	template <> bool intSet::sameState ( intSet* otherContainer ) {};
	template <> bool doubleList::sameState ( doubleList* otherContainer ) {};
	template <> bool doubleSet::sameState ( doubleSet* otherContainer ) {};
	template <> bool floatList::sameState ( floatList* otherContainer ) {};
	template <> bool floatSet::sameState ( floatSet* otherContainer ) {};
	template <> bool longLongList::sameState ( longLongList* otherContainer ) {};
	template <> bool longLongSet::sameState ( longLongSet* otherContainer ) {};
	template <> bool Container<vector<allele>, allele>::sameState ( alleleList* otherContainer ) {};
	template <> bool Container<vector<base>, base>::sameState ( baseList* otherContainer ) {};
	template <> bool alleleSet::sameState ( alleleSet* otherContainer ) {};
	template <> bool baseSet::sameState ( baseSet* otherContainer ) {};
	template <> bool Container<Container<std::vector<float, std::allocator<float> >, float>, float>::sameState ( Container<Container<std::vector<float, std::allocator<float> >, float>, float>* otherContainer )
	{
		try
		{
			throw NonImplemented ( "Container<Container<std::vector<float, std::allocator<float> >, float>, float>::sameState" );

		}

		catch ( BasicException& be )
		{
			be.addMessage ( "\ncalled from bool Container<Container<std::vector<float, std::allocator<float> >, float>, float>::sameState" );
			throw;
		};
	};
	template <> bool Container<Container<std::vector<int, std::allocator<int> >, int>, int>::sameState
	( Container<Container<std::vector<int,
	  std::allocator<int> >, int>, int>* otherContainer )
	{
		try
		{
			throw NonImplemented ( "Container<Container<std::vector<int, std::allocator<int> >, int>, int>::sameState" );




		}

		catch ( BasicException& be )
		{
			be.addMessage ( "\ncalled from void bool Container<Container<std::vector<int, std::allocator<int> >, int>, int>::sameState" );
			throw;
		};



	};



	/*___________________________________________________________________________________________*/
	/*
	    template <class Cont, class T> typename Container<Cont, T>::iterator Container<Cont, T>::findElement(const T*& element)
	  {
	cout <<"poo\n";
	//cout <<"\nbegin is:" << *this->begin(); // << ", and end is" << this->back();
	//return find(element);
	 return find(this->begin(), this->end(), (const T&) *element);
	  }

	    /*___________________________________________________________________________________________*/
	/*
	    template <class Cont, class T> typename Container<Cont, T>::iterator Container<Cont, T>::findElement(const T*& element)
	  {
	 return find(this->begin(), this->end(), *element);
	  }



	/*____________________________________________________________ */
	/*
		template <class Cont, class T> T& Container<Cont, T>::operator[] ( int position ) const
		{
			return ( T& ) this->at ( position );

		};
		/*____________________________________________________________ */

	template <class Cont, class T> T* Container<Cont, T>::getTable()
	{
		T*elements=new T[this->size() ];
		int i=0;
		typename Container<Cont, T>::iterator p=this->getFirst();
		while ( p!=this->end() )
		{
			elements[i]=this->getElement ( p );
			p=this->getNext ( p );
			i++;
		}
		return elements;
	}
	/*____________________________________________________________ */

	template <class Cont, class T> T* Container<Cont, T>::toArray()
	{
		return getTable();
	}

	/*___________________________________________________________________________________________*/

	template <class Cont, class T>
	template <class Cont2, class U>
	Container<Cont2, U>* Container<Cont, T>::convertPrimitiveList ( Container<Cont2, U> * cont )
	{
//it converts among different primitive lists
		cont=new Container<Cont2, U>();
		for ( typename Container<Cont, T>::iterator p=this->begin(); p!=this->end();++p )
			cont->insertHardElement ( ( U ) *p );

		return cont;
	}
	/*___________________________________________________________________________________________*/

	template <class Cont, class T>
	template <class Cont2, class U>
	Container<Cont2, U>* Container<Cont, T>::getPrimitiveContainerFromPointerContainer ( Container<Cont2, U>* type )
	{
//it converts among different primitive lists
		Container<Cont2, U>* cont=new Container<Cont2, U>();
		for ( typename Container<Cont, T>::iterator p=this->begin(); p!=this->end();++p )
			cont->insertElement ( ( U ) ( ( T ) *p )->getValue() );

		return cont;
	}

	/*___________________________________________________________________________________________*/

	template <class Cont, class T>
	intList* Container<Cont, T>::getIntList()
	{
//it converts other primitive number list (like float or double) in an intList

		intList *primitiveList;
		return convertPrimitiveList ( primitiveList );
	}

	/*___________________________________________________________________________________________*/

	template <class Cont, class T>
	floatList* Container<Cont, T>::getFloatList()
	{
//it converts other primitive number list to a floatList
		floatList *primitiveList;
		return convertPrimitiveList ( primitiveList );
	}

	/*___________________________________________________________________________________________*/
	/*
	    Container<Cont, T>floatList* Container<Cont, T>::getFloatList()
	  {
	//it converts other primitive number list (like float or double) in an intList
	    floatList *primitiveList=new intList();
	    typename Container<Cont, T>::iterator p;
	    for (p=this->begin(); p!=this->end();++p)
	          primitiveList->insertElement((float)*p);

	    return primitiveList;
	  }
	  /*___________________________________________________________________________________________*/
	template <> intList* stringList::getListFromString()
	{
//it converts a stringList in an intList
		intList *primitiveList=new intList();
		int wilk;
		stringList::iterator p;
		for ( p=this->begin(); p!=this->end();++p )
			primitiveList->insertElement ( BIOS::fromString ( wilk, ( string ) *p ) );

		return primitiveList;
	}

	/*____________________________________________________________ */

//template <class Cont, class T>
//template <class Cont2, class U>
//Container<Cont2, U>* Container<Cont, T>::getPrimitiveContainerFromPointerContainer ( Container<Cont2, U>* type )

	template <class Cont, class T>    template <class Cont2, class U>   Container<Cont2, U>* Container<Cont, T>::fromStringContainer ( Container<Cont2, U>* contType, U type2 )
	{
try
{
//it converts a stringList in an intList
		Container<Cont2, U>* primitiveList=new Container<Cont2, U>();
		typename Container<Cont, T>::iterator p;
		for ( p=this->begin(); p!=this->end();++p )
			primitiveList->insertElement ( BIOS::fromString ( type2, ( string ) *p ) );

		return primitiveList;
}
	catch ( BasicException& be ) {be.addMessage ( "\ncalled from Container<Cont2, U>* Container<Cont, T>::fromStringContainer ( Container<Cont2, U>* contType, U type2 )" ); throw;};
	}

	/*____________________________________________________________ */

	template <class Cont, class T>  double Container<Cont, T>::getDistance ( T arg1, bool max, int position, bool toLeft )
	{
		try
		{
			bool distance=true;
			bool atts=true;
			double result=MAXFLOAT, temp;
			if ( max ) result=-MAXFLOAT;
			for ( typename Container<Cont, T>::iterator it=this->begin(); it!=this->end();it++ )
			{
				temp= ( double ) arg1->getDistance ( this->getElement ( it ), position, toLeft );
				if ( ( temp<result && !max ) || ( temp>result && max ) )
					result=temp;
			}
			return result;
		}
		catch ( BasicException& be )
		{
			be.addMessage ( "\ncalled from  Container<Cont, T>::getDistance(T arg1, bool max, int* posArray, int length) " );
			throw;
		};
	};

	/*____________________________________________________________ */

	template <class Cont, class T>  double Container<Cont, T>::getDistanceInSortedContainer ( T arg1, bool max, int position, bool toLeft,  int firstPosition, int lastPosition, double currentResult )
	{
throw NonImplemented("Container<Cont, T>::getDistanceInSortedContainer ");
}
/*
		try
		{
			bool distance=true;
			bool atts=true;
			double result=currentResult, temp, leftTemp, rightTemp;
			int endInterval=(lastPosition-firstPosition)/2;
			if ( max ) result=-MAXFLOAT;
			if ( firstPosition==-1 )
			{
				firstPosition=0;
				lastPosition=size();
				
				//result= ( double ) arg1->getDistance ( this->getElement ( middle ), position, toLeft );
				}
				endInterval=(lastPosition-firstPosition)/2;

			if (firstPosition==lastPosition) return arg1->getDistance ( this->getElement ( firstPosition ), position, toLeft );
			if (endInterval>firstPosition) leftTemp=getDistanceInSortedContainer ( arg1, max, position, toLeft,  firstPosition, endInterval, result );
			else leftTemp= ( double ) arg1->getDistance ( this->getElement ( endInterval ), position, toLeft );
			if (endInterval<lastPosition) rightTemp=getDistanceInSortedContainer ( arg1, max, position, toLeft,  endInterval, lastPosition, result );
			else rightTemp= ( double ) arg1->getDistance ( this->getElement ( endInterval ), position, toLeft );
			if ( ( leftTemp<result && !max ) || ( leftTemp>result && max ) )
				result=leftTemp;
			else
			if ( ( rightTemp<result && !max ) || ( rightTemp>result && max ) )
				result=rightTemp;

			return result;
		}
		catch ( BasicException& be )
		{
			be.addMessage ( "\ncalled from  Container<Cont, T>::getDistance(T arg1, bool max, int* posArray, int length) " );
			throw;
		};
	};

	/*____________________________________________________________ */

	template <class Cont, class T>  double Container<Cont, T>::getMinDistance ( T arg1, int position, bool toLeft, bool sorted )
	{
try
{
//		if ( sorted ) return getDistanceInSortedContainer ( arg1, false, position, toLeft );
//		else 
return getDistance ( arg1, false, position, toLeft );
}
		catch ( BasicException & be )
		{
			be.addMessage ( "\ncalled from  double Container<Cont, T>::getMinDistance ( T arg1, int position, bool toLeft, bool sorted )" );
			throw;
		};
	};
	/*____________________________________________________________ */

	template <class Cont, class T> double Container<Cont, T>::getMaxDistance ( T arg1, int position, bool toLeft, bool sorted )
	{
try
{
//		if ( sorted )  return getDistanceInSortedContainer ( arg1, true, position, toLeft );
//		else 
return getDistance ( arg1, true, position, toLeft );
}
		catch ( BasicException & be )
		{
			be.addMessage ( "\ncalled from  double Container<Cont, T>::getMaxDistance ( T arg1, int position, bool toLeft, bool sorted )" );
			throw;
		};

	};


	/*____________________________________________________________ */



	template <class Cont, class T> intSet* Container<Cont, T>::getPositionsWithExtremeDistance ( T element, bool max, int position, bool toLeft )
	{
		try
		{
			intSet*result=new intSet();
			double extreme=MAXFLOAT;
			if ( max ) extreme=-extreme;
			double currentDistance;
			if ( size() ==0 ) throw NullValue ( "intSet* Container<Cont, T>::getPositionsWithExtremeDistance(T element, bool max)" );
			for ( typename Container<Cont, T>::iterator it=this->begin(); it!=this->end(); it++ )
			{
				currentDistance=element->getDistance ( *it, position, toLeft );
				if ( ( currentDistance>=extreme && max ) || ( currentDistance<=extreme && !max ) )
				{
					//		val=new FreqAndKey ( currentDistance, getPosition ( it ) );
					if ( ( currentDistance>extreme && max ) || ( currentDistance < extreme && !max ) )
						result->empty();
					extreme=currentDistance;
					result->insertElement ( getPosition ( it ) );
				}
			}
			if ( result->size() ==0 ) throw NullValue ( "intSet* Container<Cont, T>::getPositionsWithExtremeDistance(T element, bool max)-B" );
			return result;
		}
		catch ( BasicException& be )
		{
			be.addMessage ( "\ncalled from Container<Cont, T>::getPositionsWithExtremeDistance ( U element, bool max, int position, bool toLeft )" );
			throw;
		};
	};
	/*____________________________________________________________ */

	template <class Cont, class T>   intSet* Container<Cont, T>::getPositionsWithMaxDistance ( T element, int position, bool toLeft )
	{
		try
		{
			return getPositionsWithExtremeDistance ( element, true, position, toLeft );
		}
		catch ( BasicException& be )
		{
			be.addMessage ( "\ncalled from Container<Cont, T>::getPositionsWithMaxDistance ( U element, bool max, int position, bool toLeft )" );
			throw;
		};

	}

	/*____________________________________________________________ */


	template <class Cont, class T> intSet* Container<Cont, T>::getPositionsWithMinDistance ( T element,int position, bool toLeft )
	{
		try
		{
			return getPositionsWithExtremeDistance ( element, false, position, toLeft );
		}
		catch ( BasicException& be )
		{
			be.addMessage ( "\ncalled from Container<Cont, T>::getPositionsWithMinDistance ( U element, bool max, int position, bool toLeft )" );
			throw;
		};

	}


	/*___________________________________________________________________________________*/


	template <class Cont, class T>
	template <class U>
	intSet*
	Container<Cont, T>::getPositionsWithInternalExtremeDistance ( U element, bool max, int position, bool toLeft )
	{
		try
		{
			intSet* result=new intSet(), *partialResult=NULL;
			double currentDistance=-MAXFLOAT, distance;
			if ( !max ) currentDistance=MAXFLOAT;
			//	 cout << "current list is: " << *this <<"\n";
			//	 cout << "Element is: " << *element <<"\n";
			for ( typename Container<Cont, T>::iterator p=this->getFirst();p!=this->end();p++ )
			{
				if ( this->getElement ( p )->size() >0 )
				{
					partialResult=this->getElement ( p )->getPositionsWithExtremeDistance ( element, max, position, toLeft );
					//cout <<"\npartialresults for element " << *this->getElement(p) <<" are: " << *partialResult;
					if ( partialResult->size() >0 )
					{
//cout << "one element is:" << *this->getElement ( p )->getElement ( partialResult->getElement ( 0 ) ) <<"\n";
						distance=this->getElement ( p )->getElement ( partialResult->getElement ( 0 ) )->getDistance ( element, position, toLeft );
						//			  cout <<"\nthe distance from " << *this->getElement(p)->getElement(partialResult->getElement(0)) <<" to " << *element <<" is " << distance <<"\n";
						if ( ( max && distance>=currentDistance ) || ( !max && distance<=currentDistance ) )
						{
							if ( ( max && distance>currentDistance ) || ( !max && distance<currentDistance ) )
							{
//cout << "result size is:" << result->size() <<"\n";
//cout << "vals:" << *result <<"\n";
								result->empty();
//cout << "after empty\n";
							}
							currentDistance=distance;
							result->insertElement ( this->getPosition ( p ) );
//cout << "after inserting\n";
						}
					}
					else throw NullValue ( "intSet*	Container<Cont, T>::getPositionsWithInternalExtremeDistance ( U element, bool max, int position, bool toLeft )" );
				}
				zap ( partialResult );
			}
			//    cout <<"pos with min distance is: " << *result <<"\n";
			if ( result->size() ==0 )  throw NullValue ( "intSet*	Container<Cont, T>::getPositionsWithInternalExtremeDistance ( U element, bool max, int position, bool toLeft )-B" );
			return result;
		}
		catch ( BasicException& be )
		{
			be.addMessage ( "\ncalled from Container<Cont, T>::getPositionsWithInternalExtremeDistance ( U element, bool max, int position, bool toLeft )" );
			throw;
		};
	};


	/*___________________________________________________________________________________*/


	template <class Cont, class T>
	template <class U>
	intSet*
	Container<Cont, T>::getPositionsWithInternalMinDistance ( U element, int position, bool toLeft )
	{
		try
		{
			return getPositionsWithInternalExtremeDistance ( element, false, position, toLeft );
		}
		catch ( BasicException& be )
		{
			be.addMessage ( "\ncalled from Container<Cont, T>::getPositionsWithInternalMinDistance ( U element, int position, bool toLeft )" );
			throw;
		};
	};


	/*___________________________________________________________________________________*/


	template <class Cont, class T>
	template <class U>
	intSet*
	Container<Cont, T>::getPositionsWithInternalMaxDistance ( U element )
	{
		try
		{
			return getPositionsWithInternalExtremeDistance ( element, true );
		}
		catch ( BasicException& be )
		{
			be.addMessage ( "\ncalled from Container<Cont, T>::getPositionsWithInternalMaxDistance ( U element )" );
			throw;
		};

	};

	/*___________________________________________________________________________________________*/

	template <class Cont, class T> stringList* Container<Cont, T>::getStringList()
	{
//it converts a primitive number list to a stringList
		stringList* res;
		return this->toString ( res );
		/*
		    stringList*primitiveList=new stringList((bool)false);
		    typename Container<Cont, T>::iterator p;
		    for (p=this->begin(); p!=this->end();++p)
		          primitiveList->insertElement(tos(*p));

		    return primitiveList;
		*/
	}
	/*___________________________________________________________________________________________*/

	template <class Cont, class T> stringList* Container<Cont, T>::toStringList()
	{
//it converts a primitive number list to a stringList
		return getStringList();
	}

	/*___________________________________________________________________________________________*/

	template <class Cont, class T>
	template <class Cont2, class U>
	Container<Cont2, U>* Container<Cont, T>::toString ( Container<Cont2, U>* type )
	{
		Container<Cont2, U> *primitiveList=new Container<Cont2, U> ();
		for ( typename Container<Cont, T>::iterator p=this->begin(); p!=this->end();++p )
			primitiveList->insertElement ( tos ( *p ) );

		return primitiveList;

	}
	/*___________________________________________________________________________________________*/

	template <class Cont, class T> T Container<Cont, T>::pop()
	{
		T val=this->back();
		this->pop_back();
		return val;
	}

	/*___________________________________________________________________________________________*/

	template <> Container<vector<Integer*>, Integer*>* intList::getIntegerList()
	{
		Container<vector<Integer*>, Integer*> *integerList=new Container<vector<Integer*>, Integer*> ( true );
		intList::iterator p=this->getFirst();
		Integer* i;
		while ( p!=this->end() )
		{
			i=new Integer ( *p );
			integerList->insertHardElement ( i );
			p=this->getNext ( p );
		}
		return integerList;
	}
	/*___________________________________________________________________________________________*/

//template <template <class, class> class Cont, class T, template<class> class STL2=std::allocator>
// template <>
	template <>
	IntegerSet* intList::getIntegerSet()
	{
		Container<vector<Integer*>, Integer*> *integerList=this->getIntegerList();
		IntegerSet *integerSet=integerList->getIntegerSetFromIntegerList();
		zap ( integerList );

		return integerSet;
	}

	/*____________________________________________________________ */

	template <class Cont, class T> void Container<Cont, T>::removeElements ( bool* table )
	{
		try
		{
			throw NonImplemented ( "Container<Cont, T>::removeElements(bool* table)" );
			/*
			    int i=0;
			    typename Container::iterator p=getFirst(), p2;
			    while (p!=this->end())
			    {
			      if (table[i])
			{
			       this->removeNode(p);
			}
			      p=this->getNext(p);
			      i++;
			     }
			*/
		}
		catch ( BasicException& be )
		{
			be.addMessage ( "\ncalled from template <class Cont, class T> void Container<Cont, T>::removeElements ( bool* table )" );
			throw;
		};

	}
	/*____________________________________________________________ */

	template <class Cont, class T> void Container<Cont, T>::removeElementsIn ( Container<Cont, T>* sourceList )
	{
		try
		{
			if ( sourceList==NULL )
			{
				cout <<"Error in list::selectElementsByContents";
				end();
			}

			typename Container::iterator p=sourceList->getFirst(), p2;

			while ( p!=sourceList->end() )
			{

				p2=this->findElement ( sourceList->getElement ( p ) );

				if ( p2 !=this->end() )
					this->removeNode ( p2 );

				p=sourceList->getNext ( p );
			}

		}
		catch ( BasicException& be )
		{
			be.addMessage ( "\ncalled from void Container<Cont, T>::removeElementsIn (Container<Cont, T>* sourceList)" );
			throw;
		};
	}
	/*____________________________________________________________ */

	template <class Cont, class T> Container<vector<int>,int> * Container<Cont, T>::copyPositionsByContents ( Container<Cont, T>* sourceList, bool within, bool orderedByThis, bool missingData )
	{
		if ( sourceList==NULL )
		{
			cout <<"Error in list::selectElementsByContents";
			end();
		}

		intList* newList=new intList ( ( bool ) false, this->outputSeparator, this->leftDelimiter, this->rightDelimiter );
		typename Container<Cont,T>::iterator p2;
		if ( orderedByThis )
			for ( typename Container<Cont, T>::iterator p=this->getFirst(); p!=this->end(); p++ )
			{
				p2=sourceList->findElement ( *p );
				if ( ( !within && p2==sourceList->end() ) || ( within && p2!=sourceList->end() ) )
					newList->insertElement ( this->getPosition ( p ) );
				else if ( missingData ) newList->insertElement ( -1 );
			}
		else
			for ( typename Container<Cont, T>::iterator p=sourceList->getFirst(); p!=sourceList->end(); p++ )
			{
				p2=this->findElement ( *p );
				if ( ( !within && p2==this->end() ) || ( within && p2!=this->end() ) )
					newList->insertElement ( this->getPosition ( p2 ) );
				else if ( missingData ) newList->insertElement ( -1 );
			}

		return newList;
	}
	/*____________________________________________________________ */

	template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::copyElementsByContents ( Container<Cont, T> * Source, bool within, bool orderedByThis )
	{
		// type=0: common, 1: different
//cout <<"2spaatorthisis" << this->outputSeparator <<"her\n";

		intList* newList=this->copyPositionsByContents ( Source, within );
//cout <<"intsize:" << newList->size() <<"\n";
//cout <<"2spaatornewsis" << newList->outputSeparator <<"her\n";
		Container<Cont, T> *result=this->copyElementsWithPositionsIn ( newList, orderedByThis );
		zap ( newList );
		return result;
	}


	/*____________________________________________________________ */

	template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::copyElementsWithPositionsIn ( intList* sourceList, bool orderedByThis )
	{
		try
		{
			longLongList* other=new longLongList();
			for ( intList::iterator it=sourceList->begin(); it<sourceList->end(); it++ )
				other->insertElement ( sourceList->getElement ( it ) );
			Container<Cont, T>* newList=copyElementsWithPositionsIn ( other, orderedByThis );
			zap ( other );
			return newList;
		}
		catch ( BasicException be )
		{
			be.addMessage ( "\ncalled from Container<Cont, T>* Container<Cont, T>::copyElementsWithPositionsIn (intList* sourceList, bool orderedByThis)" );
			throw;
		};
	}
	/*____________________________________________________________ */

	template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::copyElementsWithPositionsIn ( longLongList* sourceList, bool orderedByThis )
	{
		try
		{
			if ( sourceList==NULL ) throw NullValue ( "Error 1 in Container::copyElementsByPositions" );
// cout <<"orderedByThis: " << orderedByThis << "\n";
			Container<Cont, T>* newList=this->emptyCopy();
			longLongList* sourceList2=new longLongList ( *sourceList );
			int pos=0;
//  cout << "list is:" << *sourceList2 << "\n";
			if ( orderedByThis )
				for ( typename Container::iterator p=this->begin();p!=this->end();p++ )
				{
					while ( sourceList2->findElement ( pos ) !=sourceList2->end() )
					{
						// cout << "found element at pos " << pos << " to be " << *p << "and will cop\n";
						newList->insertHardElement ( *p );
						sourceList2->removeNode ( sourceList2->findElement ( pos ) );
					}
					pos++;
				}
			else
				for ( longLongList::iterator p2=sourceList->getFirst();p2!=sourceList->end();p2++ )        newList->insertHardElement ( *this->getNode ( *p2 ) );

			delete sourceList2;
			return newList;
		}
		catch ( BasicException  & be )
		{
			be.addMessage ( "\ncalled from Container<Cont, T>* Container<Cont, T>::copyElementsWithPositionsIn (longLongList* sourceList, bool orderedByThis)" );
			throw;
		};
	}
	/*____________________________________________________________ */

	template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::copyElementsWithoutPositionsIn ( intList* sourceList )
	{
try
{
//   cout <<"original positions list that will not be used:" << *sourceList <<"\n";
		longLongList* other=new longLongList();
		for ( intList::iterator it=sourceList->begin(); it<sourceList->end(); it++ )
			other->insertElement ( sourceList->getElement ( it ) );

//cout <<"new original positions list that will not be used:" << *sourceList <<"\n";
		Container<Cont, T>* newList=copyElementsWithoutPositionsIn ( other );
		zap ( other );
		return newList;
}
    catch ( BasicException& be ) {
        be.addMessage ( "\ncalled from template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::copyElementsWithoutPositionsIn ( intList* sourceList )" );
        throw;
    };
	}
	/*____________________________________________________________ */

	template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::copyElementsWithoutPositionsIn ( longLongList* sourceList )
	{
try
{
		if ( sourceList==NULL ) throw NullValue ( "Error 1 in Container::copyElementsWithoutPositionsIn" );

		Container<Cont, T>* newList=new Container<Cont, T>();
		int pos=0;

		for ( typename Container::iterator p=this->getFirst();p!=this->end();p++ )
		{
			if ( sourceList->findElement ( pos ) ==sourceList->end() )
				newList->insertHardElement ( *p );
			pos++;
		}

		return newList;
}
    catch ( BasicException& be ) {
        be.addMessage ( "\ncalled from template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::copyElementsWithoutPositionsIn ( longLongList* sourceList )" );
        throw;
    };
	}

	/*____________________________________________________________ */

	template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::copyElementsWithPositionsIn ( intSet* sourceSet, bool orderedByThis )
// type 0; copywith, 1: copyWithout
	{
try
{
		intList* sourceList=new intList ( *sourceSet );
		Container<Cont, T>* result=copyElementsWithPositionsIn ( sourceList, orderedByThis );

		zap ( sourceList );

		return result;
}
    catch ( BasicException& be ) {
        be.addMessage ( "\ncalled from template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::copyElementsWithPositionsIn ( intSet* sourceSet, bool orderedByThis )" );
        throw;
    };
	}
	/*____________________________________________________________ */

	template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::copyElementsWithoutPositionsIn ( intSet* sourceSet )
// type 0; copywith, 1: copyWithout
	{
try
{
		intList* sourceList=new intList ( *sourceSet );
		Container<Cont, T>* result=copyElementsWithoutPositionsIn ( sourceList );
		zap ( sourceList );
		return result;
}
    catch ( BasicException& be ) {
        be.addMessage ( "\ncalled from template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::copyElementsWithoutPositionsIn ( intSet* sourceSet)" );
        throw;
    };
	}
	/*____________________________________________________________ */

	template <class Cont, class T> void Container<Cont, T>::removeElementsWithPositionsIn ( intSet* sourceSet )
// type 0; copywith, 1: copyWithout
	{
		if ( sourceSet==NULL ) throw NullValue ( "void Container<Cont, T>::removeElementsWithoutPositionsIn ( intSet* sourceSet )" );

		intList* sourceList=new intList ( *sourceSet );
		sourceList->sort ( false );



		for ( typename intList::iterator p=sourceList->getFirst(); p!=sourceList->end(); p++ )
			removeNode ( this->getNode ( *p ) );

		zap ( sourceList );
	}
	/*____________________________________________________________ */

	template <class Cont, class T> void Container<Cont, T>::removeElementsWithPositionsIn ( Container<vector<int>,int>* sourceSet )
// type 0; copywith, 1: copyWithout
	{
		if ( sourceSet==NULL ) throw NullValue ( "void Container<Cont, T>::removeElementsWithoutPositionsIn ( intSet* sourceSet )" );

		intList* sourceList=new intList ( *sourceSet );
		sourceList->sort ( false );


		for ( typename intList::iterator p=sourceList->getFirst(); p!=sourceList->end(); p++ )
			removeNode ( this->getNode ( *p ) );
		zap ( sourceList );
	}
	/*____________________________________________________________ */

	template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::extractElementsByPositions ( intSet* sourceList, bool within, bool orderedByThis )
// type 0: extractWith, 1: extractWithout
	{
		try
		{
			Container<Cont, T>* newList;
			if ( within )
			{
				newList=copyElementsWithPositionsIn ( sourceList, orderedByThis );
				this->removeElementsWithPositionsIn ( sourceList );
			}
			else
			{
				newList=copyElementsWithoutPositionsIn ( sourceList );
// remove elements
				//		this->removeElementsWithPositionsIn ( sourceList );to define
				throw NonImplemented ( "Container<Cont, T>* Container<Cont, T>::extractElementsByPositions (intSet* sourceList, bool within, bool orderedByThis)" );
			}
			return newList;
		}
		catch ( BasicException & be )
		{
			be.addMessage ( "\ncalled fromContainer<Cont, T>* Container<Cont, T>::extractElementsByPositions (intSet* sourceList, bool within, bool orderedByThis)" );
			throw;
		};
	};
	/*____________________________________________________________ */

	template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::extractElementsByPositions ( Container<vector<int>,int> * sourceList, bool within, bool orderedByThis )
// type 0: extractWith, 1: extractWithout
	{
		try
		{
			Container<Cont, T>* newList;
			if ( within )
			{
				newList=copyElementsWithPositionsIn ( sourceList, orderedByThis );
				this->removeElementsWithPositionsIn ( sourceList );
			}
			else
			{
				newList=copyElementsWithoutPositionsIn ( sourceList );
// remove elements
				//		this->removeElementsWithPositionsIn ( sourceList );to defin

				throw NonImplemented ( "Container<Cont, T>* Container<Cont, T>::extractElementsByPositions (Container<vector<int>,int>* sourceList, bool within, bool orderedByThis)" );
			}
			return newList;
		}
		catch ( BasicException & be )
		{
			be.addMessage ( "\ncalled fromContainer<Cont, T>* Container<Cont, T>::extractElementsByPositions (Container<vector<int>,int>* sourceList, bool within, bool orderedByThis)" );
			throw;
		};
	};

	/*____________________________________________________________ */

	template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::mergeWith ( Container<Cont, T>* secondList )
	{
		try
		{
			throw NonImplemented ( "template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::mergeWith ( Container<Cont, T>* secondList ):check code, do not remove the first list?\n" );
			Container<Cont, T>* result=new  Container<Cont, T>();

			merge ( this->begin(), this->end(),  // merge sequences
			        secondList->begin(), secondList->end(),
			        result->begin() );


			return result;

		}
		catch ( BasicException & be )
		{
			be.addMessage ( "\ncalled from template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::mergeWith ( Container<Cont, T>* secondList )" );
			throw;
		};

	}



	/*____________________________________________________________ */


	template <class Cont, class T> void Container<Cont, T>::copyPaste ( Container<Cont, T>* sourceList, int firstPosition, int nextOfLastPosition )
	{
		//  cout << "about\n";
		//  cout << "size of this is:" << size() << " while size of other is:" << sourceList->size() <<"\n";
		Container<Cont, T>* copy=sourceList->copyPaste ( firstPosition, nextOfLastPosition );
		//	cout << "copy made\n";
		this->insertHardElement ( copy->begin(), copy->end() );
//		copy->erase (copy->begin(), copy->end() );
		zap ( copy );
	};


	/*____________________________________________________________ */


	template <class Cont, class T>  Container<Cont, T>* Container<Cont, T>::copyPaste ( int firstPosition, int nextOfLastPosition )
	{
		try
		{
			//  cout << "about to clone\n";
			Container<Cont, T>* result=this->clone();
//cout << "size of the clone is:" << result->size() <<"\n";
			result->removeObjects ( result->getNode ( nextOfLastPosition ), result->end() );
			result->removeObjects ( result->begin(), result->getNode ( firstPosition ) );
			return result;
		}
		catch ( BasicException & be )
		{
			be.addMessage ( "\ncalled from Container<Cont, T>* Container<Cont, T>::copyPaste (int firstPosition, int nextOfLastPosition)" );
			throw;
		};

	};

	/*____________________________________________________________ */


	template <class Cont, class T> void Container<Cont, T>::paste ( Container<Cont, T>* sourceList, int firstPosition, int nextOfLastPosition )
	{
		try
		{
			this->insertElement ( sourceList->getNode ( firstPosition ), sourceList->getLastTrueNode ( nextOfLastPosition ) );
		}
		catch ( BasicException & be )
		{
			be.addMessage ( "\ncalled from void Container<Cont, T>::paste (Container<Cont, T>* sourceList, int firstPosition, int nextOfLastPosition)" );
			throw;
		};

	};


	/*____________________________________________________________ */


	template <class Cont, class T> typename Container<Cont, T>::iterator Container<Cont, T>::getLastTrueNode ( int position )
	{
		try
		{
			if ( position==-1 ) return getNode ( size() );
			else return getNode ( position );
		}
		catch ( BasicException & be )
		{
			be.addMessage ( "\ncalled from Container<Cont, T>::iterator Container<Cont, T>::getLastTrueNode (int position)" );
			throw;
		};

	};

	/*____________________________________________________________ */


	template <class Cont, class T>  Container<Cont, T>* Container<Cont, T>::paste ( int firstPosition, int nextOfLastPosition )
	{
		try
		{
			Container<Cont, T>* result=this->emptyCopy();
			result->insertElement ( this->getNode ( firstPosition ), this->getLastTrueNode ( nextOfLastPosition ) );
			return result;
		}
		catch ( BasicException & be )
		{
			be.addMessage ( "\ncalled from Container<Cont, T>* Container<Cont, T>::paste (int firstPosition, int nextOfLastPosition)" );
			throw;
		};

	};



	/*____________________________________________________________ */


	template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::extractElementsWithPositionsIn ( intSet * sourceList )
	{
		return extractElementsByPositions ( sourceList, true );
	};

	/*____________________________________________________________ */


	template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::extractElementsWithPositionsIn ( Container<vector<int>,int> * sourceList )
	{
		return extractElementsByPositions ( sourceList, false );
	};
	/*____________________________________________________________ */


	template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::extractElementsWithoutPositionsIn ( intSet * sourceList )
	{
		return extractElementsByPositions ( sourceList, false );
	};




	/*____________________________________________________________ */

	template <class Cont, class T>
	Container<Cont, T>* Container<Cont, T>::copyElementsIn ( Container<Cont, T> * Source, bool orderedByThis )
	{
		return copyElementsByContents ( Source, true, orderedByThis );
	}
	/*____________________________________________________________ */

	template <class Cont, class T>
	Container<Cont, T>* Container<Cont, T>::copyElementsNotIn ( Container<Cont, T> * Source, bool orderedByThis )
	{
		return copyElementsByContents ( Source, false, orderedByThis );
	}
	/*____________________________________________________________ */
	/*
	    template <class Cont, class T> intSet * Container<Cont, T>::copyPositionsWithElementsInUnrepeatedList(Container<Cont, T> * Source, bool orderedByThis)
	  {
	    intList* list= copyPositionsByContents(Source, true);
	    intSet* result=new intSet(*list);
	    zap(list);
	    return result;
	  }
	/*____________________________________________________________ */

	template <class Cont, class T> intSet * Container<Cont, T>::copyPositionsWithElementsInSet ( Container<set<T>,T> * Source, bool orderedByThis, bool missingData )
	{
		Container<vector<T>,T>* source=new Container<vector<T>,T> ( *Source );
		intList* list= copyPositionsByContents ( source, true, orderedByThis, missingData );
		intSet* result=new intSet ( *list );
		zap ( source );
		zap ( list );
		return result;
	}
	/*____________________________________________________________ */

	template <class Cont, class T> Container<vector<int>,int> * Container<Cont, T>::copyPositionsWithElementsIn ( Container<Cont, T> * Source, bool orderedByThis, bool missingData )
	{
		return copyPositionsByContents ( Source, true, orderedByThis, missingData );
	}
	/*____________________________________________________________ */

	template <class Cont, class T> Container<vector<int>,int> * Container<Cont, T>::copyPositionsWithoutElementsIn ( Container<Cont, T>* Source )
	{
		return copyPositionsByContents ( Source, false );
	}

	/*____________________________________________________________ */

	/*
	 Container<Cont, T>
	void Container<Cont, T>::sort(typename Container<Cont, T>::ierator begin, typename Container<Cont, T>::iterator end, Compare comp)
	{
	return std::sort(begin, end, comp);
	}


	/*____________________________________________________________ */

	template <class Cont, class T>
	void Container<Cont, T>::shuffle()
	{
		try
		{
			int originalSize=this->size();
			Sampling *sampling=new Sampling ( this->size() );
			for ( int i=0; i<originalSize;i++ )
				insertElement ( this->getElement ( sampling->getPositionsTable() [i] ) );
			this->erase ( this->getNode ( 0 ), this->getNode ( originalSize ) );
			zap ( sampling );
		}
		catch ( BasicException & be )
		{
			be.addMessage ( "\ncalled from void Container<Cont, T>::shuffle()" );
			throw;
		};

	}


	/*____________________________________________________________ */

	template <class Cont, class T>
	void Container<Cont, T>::sort ( bool ascendant )
	{
//    if (ascendant) std::sort ( (typename Container<Cont, T>::iterator) this->getFirst(), (typename Container<Cont, T>::iterator) this->getLast(), BIOS::compare<T>);
//    else std::sort ( (typename Container<Cont, T>::iterator) this->getFirst(), (typename Container<Cont, T>::iterator) this->getLast(), BIOS::compareInv<T>);
		if ( ascendant ) std::sort ( this->getFirst(), this->getLast(), BIOS::compare<T> );
		else
		{

			std::sort ( this->getFirst(), this->getLast(), BIOS::compareInv<T> );
		}
	};


	/*____________________________________________________________ */

	template <class Cont, class T> void Container<Cont, T>::orderFunction ( bool compareArg ( const T& arg1, const T& arg2 ) )
	{
		sort ( this->begin(), this->end(), compareArg );
	};
	/*____________________________________________________________ */
	/*
	 Container<Cont, T>void Container<Cont, T>::orderPointer(bool ascendant)
	{
	 if (ascendant) sort(this->begin(), this->end(), comparePointer<T>);
	 else sort(this->begin(), this->end(), compareinvPointer<T>);
	};
	/*____________________________________________________________ */
	/*
	 Container<Cont, T>void Container<Cont, T>::orderPointer(bool compareArg(const T& arg1, const T& arg2))
	{
	sort(this->begin()/vector, this->end(), compareArg);
	};
	/*____________________________________________________________ */
	/*
	template <class Cont, class T> void Container<Cont, T>::basicOrder()
	{
	 sort(this->begin(), this->end());
	 };
	/*____________________________________________________________ */

	template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::reverse()
	{
		Container<Cont, T>* result=new Container<Cont, T>();
		typename Container<Cont, T>::iterator p=this->GetLast();
		while ( p!=this->end() )
		{
			result->insertHardElement ( *p );
			p=this->GetPrevious ( p );
		}
		return result;
	}

	/* _____________________________________________________*/

	template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::fromString ( string s )
	{
		try
		{
			throw NonImplemented ( "Container<Cont, T>" );
		}

		catch ( BasicException& be )
		{
			be.addMessage ( "\ncalled from template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::fromString ( string s )" );
			throw;
		};
	}
	/*____________________________________________________________ */

	template <class Cont, class T>
	void Container<Cont, T>::print()
	{
		cout << *this << endl;
	}

	/*____________________________________________________________ */

	template <class Cont, class T>
	void Container<Cont, T>::print ( char* file )
	{
		OutputFile.open ( file, ifstream::out );
		OutputFile << *this << endl;
		OutputFile.close();
	}
/*____________________________________________________________ */

	
	template <class Cont, class T>
	void Container<Cont, T>::print (ostream& out)
	{
	  out << *this << endl;
	}

	/*____________________________________________________________ */

	/*
	template <template <class, class> class Cont, class T, template<class> class STL2=std::allocator>
	struct IT
	{
	typedef Container<Cont, T>::iterator Class;
	};

	template <template <class, class> class Cont, class T, template<class> class STL2=std::allocator>
	T& IT::Class::getElement()
	{
	return (T&)*this;
	}
	*/
	/*
	template <class T>
	T& std::_Rb_tree_const_iterator<T>::getElement()
	{
	return (T&)*this;
	}
	*/

} // end namespace
#endif

/* Fin Fichero: list.cpp */
// void zap<list<float>::node*>(list<float>::node*&);

//BIOS::Container::Container< Cont, T >(char * file, const char * tokens, char outputSeparator, bool delimiter)
//{
//}


