
#ifndef __ExcepBasic__
#define __ExcepBasic__

#include <iostream>


using namespace std;

namespace BIOS
{

  template <class T> string tos (T i);


  class BasicException
  {
    protected: string message;
    public:
      BasicException()
      {
       message=string();
      }
 BasicException(const BasicException &other)
      {
        message=string(other.message);
      }
      BasicException(string m)
      {
        message=m;
      }
      void addMessage (const char* m)
      {
        message=message+string (m);
      }
      void PrintMessage()
      {
        cout << "\nBasic exception at " << message << ".\n";
      };
      void addMessage (string message)
      {
        this->message=this->message+message;
      };
  };
  /*________________________________________*/


  class NullValue: public BasicException
  {
    public:


      NullValue ( string message )
      {
        this->message=string ( message );
//PrintMessage(this->message.c_str());
      }

      NullValue (const char* message )
      {
        this->message=string ( message );
//PrintMessage(this->message.c_str());
      }
      void setMessage (string newmessage) {message=newmessage;};
      NullValue() {};
      //NullValue(NullValue & nv){message=nv.message;};
      void PrintMessage()
      {
        cout << "\nNullValueException: Null value (pointer == NULL) at " << message << ".\n";
      }
      void PrintMessage ( const char* f )
      {
        cout << "\nNullValueException: Null value (pointer == NULL) at " << f <<" called from " << message << ".\n";
      }

  };
  class NoWindow: public BasicException
  {
    public:


      NoWindow ( string message )
      {
        this->message=string ( message );
//PrintMessage(this->message.c_str());
      }
      NoWindow() {};
      void PrintMessage()
      {
        cout << "\nNoWindowException: No windows at " << message << ".\n";
      }
      void PrintMessage ( const char* f )
      {
        cout << "\nNoWindowException: No windows at " << f <<" called from " << message << ".\n";
      }

  };

  class NonImplemented: public BasicException
  {
    public:

      NonImplemented ( string message )
      {
        this->message=string ( message );
//PrintMessage(this->message.c_str());
      }
      NonImplemented() {};
      void PrintMessage()
      {
        cout << "\nNonImplementedException: Non implemented at " << message << ".\n";
      }
      void PrintMessage ( const char* f )
      {
        cout << "\nNonImplementedException: Non implemented at " << f <<" called from " << message << ".\n";
      }

  };

class NonDefinedMethod: public BasicException
  {
    public:

      NonDefinedMethod ( string message )
      {
        this->message=string ( message );
//PrintMessage(this->message.c_str());
      }
      NonDefinedMethod() {};
      void PrintMessage()
      {
        cout << "\nNonDefinedMethodException: This method should never be called at " << message << ".\n";
      }
      void PrintMessage ( const char* f )
      {
        cout << "\nNonDefinedMethodException: This method should never be called at " << f <<" called from " << message << ".\n";
      }

  };


  class MissingArguments
  {
    public:
      string message;

      MissingArguments ( string message )
      {
        this->message=string ( message );
      }
      MissingArguments() {};
      void PrintMessage()
      {
        cout << "\nMissingArgumentsException: Missing arguments at " << message << ".\n";
      }
      void PrintMessage ( const char* f )
      {
        cout << "\nMissingArgumentsException: Missing arguments at " << f <<" called from " << message << ".\n";
      }

  };

  class NanValue: public BasicException
  {
    public:
      NanValue (string message)
      { this->message=string (message);}
      NanValue() {};
      void PrintMessage()
      {
        cout << "\nNanValueException: NaN value at " << message <<"\n";
      }
      void PrintMessage ( const char* f )
      {
        cout << "\nNanValueException: NaN value at " << f <<" called from " << message <<  "\n";
      }

  };


  class NoMemory: public BasicException
  {
    public:
      NoMemory() {};
      NoMemory ( string s )
      {this->message=s;};
      void PrintMessage()
      {
        cout << "\nNoMemory Exception: Not enough memory " << message <<".\n";
      }
      void PrintMessage ( const char* f )
      {
        cout << "\nNoMemoryException: Memory fault at " << f << ".\n";
      }
  };

  class OutOfBounds: public BasicException
  {
    public:

      int first, second;

      OutOfBounds() {};

      OutOfBounds ( int first, int second)
      {
        this->first=first;
        this->second=second;
      }

      OutOfBounds ( int first, int second, const char* message )
      {
        this->first=first;
        this->second=second;
        this->message=message;
      }
      void PrintMessage ( string s )
      {
        cout << "\nOutOfBoundsException: Trying to access position: " << first <<" at " << s << " but there are only " << second <<" positions [0:" << second-1 << "].\n";
      };
      void PrintMessage ( )
      {
        cout << "\nOutOfBoundsException: Trying to access position: " << first  << " but there are only " << second <<" positions [0:" << second-1 << "].\n" <<" at " << message  <<"\n";
      };
  };

  class DivisionByZero: public BasicException
  {
    public:


      DivisionByZero() {};



      DivisionByZero (const char* message )
      {
        this->message=message;
      }
      void PrintMessage ( string s )
      {
        cout << "\nDivisionByZeroException: Trying to divide by zero at " << s << ".\n";
      };
      void PrintMessage ( )
      {
        cout << "\nDivisionByZeroException: Trying to divide by zero at " << message << ".\n";
      };
      void addMessage (const char* message2 )
      {
        message=message+string (message2);
      };
  };

  class Overflow: public BasicException
  {
    public:


      Overflow() {};



      Overflow (const char* message )
      {
        this->message=message;
      }
      void PrintMessage ( string s )
      {
        cout << "\nOverflowException: Overflow at " << s << ".\n";
      };
      void PrintMessage ( )
      {
        cout << "\nOverflowException: Overflow at " << message << ".\n";
      };
      void addMessage (const char* message2 )
      {
        message=message+string (message2);
      };
  };

  class Underflow: public BasicException
  {
    public:


      Underflow() {};



      Underflow (const char* message )
      {
        this->message=message;
      }
      void PrintMessage ( string s )
      {
        cout << "\nUnderflowException: Underflow at " << s << ".\n";
      };
      void PrintMessage ( )
      {
        cout << "\nUnderflowException: Underflow at " << message << ".\n";
      };
      void addMessage (const char* message2 )
      {
        message=message+string (message2);
      };
  };


  template <class T> class OutOfRange: public BasicException
  {
    public:
      T val;
      OutOfRange() {};
      OutOfRange ( T val, const char* message )
      {
        this->val=val;
//if (message!=NULL)
        this->message=string ( message );
      }

      OutOfRange ( T val, string message )
      {
        this->val=val;
//if (message!=NULL)
        this->message= message;
      }
      void addMessage (string newMessage) {message=message+newMessage;}
      void PrintMessage ( T value )
      {
        cout << "OutOfRangeException: Some value " << value << " is out of range, val is :" << val << " called from " << message << ".\n";
      }
      void PrintMessage()
      {
        cout << "OutOfRangeException: Some value is out of range, val is:" << val << " at " << message << ".\n";
      }
      void PrintMessage ( const char * message )
      {
        cout << "OutOfRangeException: Some value is out of range, val is: " << val << " at " << message <<" called from " << this->message <<".\n";
      }
  };

  typedef OutOfRange<int> ORI;
  typedef OutOfRange<double> ORD;
  typedef OutOfRange<long long int> ORLLI;

  class BadSize: public BasicException
  {

public:
      int first, second;
    

      BadSize() {};

      BadSize ( const char* f )
      {
        this->message=string (f);
      };
/*
      BadSize ( const char * t, int first, int second )
      {
        this->message=string (t);
        this->first=first;
        this->second=second;
      };
*/
      BadSize ( int first, int second, const char * t )
      {
        this->message=string (t);
        this->first=first;
        this->second=second;
      };
      void PrintMessage()
      {
        cout << "\nBadSizeException: Different sizes " << first << " versus " << second << " at " << message <<".\n";
      }
      void PrintMessage ( int first, int second )
      {
        cout << "\nBadSizeException: Different size: " << first <<":" << second <<".\n";
      }
      void PrintMessage ( const char * t, int first, int second )
      {
        cout << "\nBadSizeException: Different size in " << t << ": " << first <<":" << second <<".\n";
      }
      void PrintMessage ( const char * t )
      {
        cout << "\nBadSizeException: Different size in " << message << ": " << first <<":" << second <<" at " << t << ".\n";
      }
  };



  class EOFile: public BasicException
  {
string file;
    public:
      EOFile(const char* f, const char* mess) {file=string(f); message=string(mess);};
      void PrintMessage ()
      {
        //cout << "\nError at " << message <<": File " << file << " lacks an EOL char at the " << line << " line. Found " << val <<" instead.\n";
				cout << "\nEOFileException: File " << file << " reached EOF when reading, called from " << message << ".\n";
      };
  };

  class BadFile: public BasicException
  {
    public:
      void PrintMessage()
      {
        cout << "\nBadFileException: Incorrect file format.\n";
      }
  };

  class NoEOL: public BasicException
  {
      int val;
      string line;
      string file;
    public:
      NoEOL() {};
      NoEOL (const char* f, const char* mess ) {file=string ( f ); message=string(mess);};

/*
      NoEOL (int val, int line, const char* file)
      {
        this->val=val;
        this->file=file;
        this->line=tos (line);
        if (line==-1) this->line=string ("last");
      };
      */
      void PrintMessage (const char* message2)
      {
        //cout << "\nError at " << message <<": File " << file << " lacks an EOL char at the " << line << " line. Found " << val <<" instead.\n";
				cout << "\nNoEOLException: File " << file << " lacks an EOL char at " << message2      <<" called from " << message << ".\n";
      };
            void PrintMessage ()
      {
        //cout << "\nError at " << message <<": File " << file << " lacks an EOL char at the " << line << " line. Found " << val <<" instead.\n";
				cout << "\nNoEOLException: File " << file << " lacks an EOL char at " << message << ".\n";
      };
  };


  class ErrorFile: public BasicException
  {
      string s;
      bool eof, fail, bad;
    public:
     // ErrorFile() {};
   //   ErrorFile (bool eof, bool fail, bool bad) {this->eof=eof; this->fail=fail; this->bad=bad;};
      ErrorFile (const char* file, const char* mess ) {s=string ( file ); message=string(mess);};
      void PrintMessage(const char * message2)
      {
        cout << "\nErrorFileException: File " << s << " does not exist, is damaged or cannot be created at " << message2      <<" called from " << message << ".\n";
      }
      void PrintMessage()
      {
        cout << "\nErrorFileException: File " << s << " does not exist, is damaged or cannot be created at " << message << ".\n";
      }
  
  };
 class ErrorFileDoesNotExist: public BasicException
  {
      string s;
      bool eof, fail, bad;
    public:
     // ErrorFile() {};
   //   ErrorFile (bool eof, bool fail, bool bad) {this->eof=eof; this->fail=fail; this->bad=bad;};
      ErrorFileDoesNotExist (const char* file, const char* mess ) {s=string ( file ); message=string(mess);};
      void PrintMessage(const char * message2)
      {
        cout << "\nErrorFileDoesNotExistException: File " << s << " does not exist or is damaged at " << message2      <<" called from " << message << ".\n";
      }
      void PrintMessage()
      {
        cout << "\nErrorFileDoesNotExistException: File " << s << " does not exist or it is damaged at " << message << ".\n";
      }

  };

 class ErrorFileCannotBeCreated: public BasicException
  {
      string s;
      bool eof, fail, bad;
    public:
     // ErrorFile() {};
   //   ErrorFile (bool eof, bool fail, bool bad) {this->eof=eof; this->fail=fail; this->bad=bad;};
      ErrorFileCannotBeCreated (const char* file, const char* mess ) {s=string ( file ); message=string(mess);};
      void PrintMessage(const char * message2)
      {
        cout << "\nErrorFileCannotBeCreated exception: File " << s << " cannot be created at " << message2      <<" called from " << message << ".\n";
      }
      void PrintMessage()
      {
        cout << "\nErrorFileCannotBeCreated exception: File " << s << " cannot be created at " << message << ".\n";
      }
  
  };


  class AlreadyExist: public BasicException
  {
string file;
    public:
      
      AlreadyExist (const char* fil, const char* name ) {file=string(fil); message=string ( name );};
      AlreadyExist () {};
      void PrintMessage()
      {
        cout << "\nAlreadyExistException: File " << file << " already exists at " << message << ".\n";;
      }
  };

  class AlreadyOpen: public BasicException
  {
  string file;
    public:
      AlreadyOpen (const char* s, const char* mess ) {file=string(s), message=string ( mess );};
      AlreadyOpen () {};
      void PrintMessage(const char* message2)
      {
        cout << "\nAlreadyOpenException: Stream for file " << file << " already open at " << message2 <<".\n"  <<" called from " << message << ".\n";;
      }
            void PrintMessage()
      {
        cout << "\nAlreadyOpenException: Stream for file " << file << " already open at " << message << ".\n";;
      }
  };


  class EmptyFile: public BasicException
  {
  string s;
    public:
      EmptyFile (const char* file, const char* name ) {s=string(file); message=string ( name );};
      EmptyFile () {};
      void PrintMessage ( const char* message2 )
      {
        cout << "\nEmptyFileException: File " << s << " does not have data, at " << message2 <<".\n"  <<" called from " << message << ".\n";;
      }
            void PrintMessage ()
      {
        cout << "\nEmptyFileException: File " << s << " does not have data, at " << message << ".\n";;
      }
  };


  class NonBoolean
  {
    public:
      void PrintMessage()
      {

        cout << "NonBooleanxception: Error, must be a boolean value (0 or 1)\n";
      }
  };

  class NonInteger: public BasicException
  {
    public:
      double val;
      string message;
      NonInteger ( double val, const char* message )
      {
        this->val=val;
        this->message=string ( message );
      }
      void PrintMessage()
      {

        cout << "NonIntegerException: Error, " << val << " must be an integer value at " << message <<"\n";
      }
  };




  class BadFormat: public BasicException
  {
    public:
      BadFormat ( string message )
      {
        this->message=string ( message );
      };
      BadFormat ( const char* message )
      {
        this->message=string ( message );
      };
      BadFormat() {message=string("");};
      void PrintMessage()
      {
        cout << "BadFormatException: incorrect format at " << message <<"\n";
      }
      void PrintMessage ( const char* file )
      {
        cout << "BadFormatException: incorrect format in file " << file << "\n";
      }
      void PrintMessage ( const char* file, const char* message )
      {
        cout << "BadFormatException at " << message << ", incorrect format in file " << file << "\n";
      }
  };

  class NonDefined: public BasicException
  {
    public:

      NonDefined ( string message )
      {
        this->message=string ( message );
      };
      NonDefined ( const char* message )
      {
         this->message==string ( message );
      };

      NonDefined() {};

      void PrintMessage()
      {

        cout << "NonDefinedException: Error, undefined method at " << message <<"\n";
      }
      void PrintMessage ( const char* file )
      {

        cout << "NonDefinedException: Error, undefined method in file " << file << "\n";
      }
      void PrintMessage ( const char* file, const char* message2 )
      {

        cout << "NonDefinedException: Error at " << message2 << ", undefined method in file " << file << "\n";
      }
      void PrintMessage ( string message2 )
      {

        cout << "NonDefinedException: Error at " << message2 << ", undefined method called from " << message << "\n";
      }
  };


  class ZeroValue: public BasicException
  {
    public:
      ZeroValue() {};
      ZeroValue ( string s )
      {
        this->message=s;
      }
      void addMessage (const char*message)
      {
        this->message=this->message+string (message);
      }
      void PrintMessage()
      {

        cout << "ZeroValueException: Error, value is zero at " << message << "\n";
      }
      void PrintMessage ( const char* s )
      {

        cout << "ZeroValueException: Error, value is zero at " << s << " called from " << message <<"\n";
      }
  };



  class NonProb: public BasicException
  {
      double val;
    public:
      NonProb()
      {
      };
/* NonProb(const NonProb &other)
      {
        val=string(other.val);
      }
*/

      NonProb ( string s, double val )
      {
        this->message=s;
        this->val=val;
      }


      void PrintMessage()
      {

        cout << "NonProbException: Error, " << val << " is not a probability at "  << message <<  "\n";
      }
      void PrintMessage ( float val )
      {

        cout << "NonProbException: Error, " << val << " is not a probability at " << message << "\n";
      }
      void PrintMessage ( const char* s )
      {

        cout << "\nNonProbException: Error, not a probability at " << s << " called from " << message <<"\n";
      }
  };


  class NonDiscrete: public BasicException
  {
    public:
      NonDiscrete ( string s )
      {
        this->message=s;
      }
      void PrintMessage()
      {

        cout << "NonDiscreteException: Error, non discretized attribute\n";
      }
      void PrintMessage ( const char* s )
      {

        cout << "\nNonDiscreteException: Error, non discretized attribute " << message << " called from " << s <<"\n";
      }
  };

  class MissingValue: public BasicException
  {
    public:
      MissingValue ( string s )
      {
        message=s;
      };
      MissingValue() {};
      void PrintMessage()
      {

        cout << "MissingValueException: Error, missing value at " << message << "\n";
      }
      void PrintMessage ( const char* message, int row, string col )
      {

        cout << "MissingValueException: Error, missing value in row " << row << " and col " << col << " at " << message << "\n";
      }
      void PrintMessage ( const char* message )
      {

        cout << "MissingValueException: Error, missing value  at " << message << "\n";
      }
  };



} // end namespace
#endif
