/* File: HeteroListPair.h */


#ifndef __HeteroListPair_cpp__
#define __HeteroListPair_cpp__



using namespace std;

namespace BIOS {



  template < class P, class Q>  HeteroListPair<P,Q>::HeteroListPair(Container<vector<P>, P>* First, Container<vector<Q>, Q>* Second) {this->First=NULL; this->Second=NULL; if (First!=NULL) this->First=new Container<vector<P>, P>(*First); if (Second!=NULL) this->Second=new Container<vector<Q>, Q>(*Second);};
              
	template < class P, class Q> HeteroListPair<P,Q>::HeteroListPair(HeteroListPair<P, Q>& p) {this->First=NULL; this->Second=NULL; if (p.First!=NULL) this->First=new Container<vector<P>, P>(*p.First); if (p.Second!=NULL) this->Second=new Container<vector<Q>, Q>(*p.Second);};
              
  template < class P, class Q> HeteroListPair<P,Q>::HeteroListPair() {First=new Container<vector<P>, P>(); Second=new Container<vector<Q>, Q>();};
              
  template < class P, class Q> HeteroListPair<P,Q>::~HeteroListPair() {zap (First), zap(Second);};
		   
	template < class P, class Q> P HeteroListPair<P,Q>::getFirst(){return First;};
		      
	template < class P, class Q> Q HeteroListPair<P,Q>::getSecond(){return Second;};
	   //HeteroListPair<P, Q>*  estimateMLE (HeteroListPair<P, Q>* currentEstimation, HeteroListPair<P, Q> * ambiguousCounts, MultidimensionalEmptyTable<int>* ambiguousTable, MultidimensionalEmptyTable<int>* solvedTable, double totalCounts, int it);
	template < class P, class Q> void HeteroListPair<P,Q>::insertElement(P first, Q second){First->insertElement(first); Second->insertElement(second);};

	template < class P, class Q> void HeteroListPair<P,Q>::addValue(P first, Q second)
	{
		typename Container<vector<P>, P>::iterator it=this->First->findElement(first); 
		int i; 
		if (it!=First->end()) 
		{i=First->getPosition(it); 
		(*Second)[i]=(*Second)[i]+second;}
		else insertElement(first, second);
	}
		
	template < class P, class Q>  Q HeteroListPair<P,Q>::getValue(P key) {typename Container<vector<P>, P>::iterator it; it=First->findElement(key); if (it!=First->end()) return Second->getElement(First->getPosition(it));}; 
	   
	template < class P, class Q> Q HeteroListPair<P,Q>::getValueAtPos(int pos) {return Second->getElement(pos);}; 

  
/*______________________________________________________*/

template<class T, class U> ostream& operator<<(ostream& out, HeteroListPair<T, U>& heteroListPair)
{
 
out << "(" << *heteroListPair.First <<", " << *heteroListPair.Second <<")";

return out;
  }

/*_________________________________________________________________*/

  template < class P, class Q>  HeteroListPair<P, Q>::HeteroListPair(Container<vector<P>, P> *source)
{
First=new Container<vector<P>, P>(); 
Second=new Container<vector<Q>, Q>();
long long int pos;
for (int i=0; i<source->size(); i++)
{
pos=source->getElement(i);
addValue(pos, 1);
}
}

/*_________________________________________________________________*/

  template < class P, class Q>   void HeteroListPair<P, Q>::updateListFromCounters(Container<vector<P>, P> *source)
{
long long int pos;
for (int i=0; i<source->size(); i++)
{
pos=source->getElement(i);
addValue(pos, 1);
}
}

/*_________________________________________________________________*/

template<> HeteroListPair<long long int, double>* HeteroListPair<long long int, double>::getComposedList(longLongList *firstList, longLongList* secondList)
{
long long int pos;
HeteroListPair<long long int, double>* result=new HeteroListPair<long long int, double>(firstList);
result->updateListFromCounters(secondList);
return result;
}

/*_________________________________________________________________________*/
/*
template<> HeteroListPair<long long int, double>*  HeteroListPair<long long int, double>::estimateMLE (HeteroListPair<long long int, double>* currentEstimation, HeteroListPair<long long int, double> * ambiguousCounts,  MultidimensionalEmptyTable<int>* ambiguousTable, MultidimensionalEmptyTable<int>solvedTable, double totalCounts, int it)
{
//intList* dimList=currentEstimation->dimensionList;
//MultidimensionalTable<double>* result=new MultidimensionalTable<double>(dimList);
//intList* dimList=new intList();
//MultidimensionalEmptyTable<double>* ambiguousTable=new MultidimensionalEmptyTable<double>(dimList);
HeteroListPair<longLongList*, doubleList*>* result;
longLongList* keys=new longLongList();
doubleList* values=new doubleList();
result=new HeteroListPair<longLongList*, doubleList*>(keys, values);
double val, pS, pAcc, *p1, p2, p3;
int iterations;
int *ambiguousConf, totalSolvedConfs, *solvedConf, *complementarySolvedConf, solvedConfPos, complementarySolvedConfPos;
longLongList::iterator it, it2;
doubleList:: iterator it3;
int pos=0;
for (it=ambiguousCounts->First->begin(); it<ambiguousCounts->First->end(); it++) // for each ambiguous configuration (as genotypes)
{
val=ambiguousCounts->Second->getElement(pos);
ambiguousConf=ambiguousTable->getPositions(ambiguousCounts->First->getElement(it));
totalSolvedConfs=ambiguousTable->getTotalSolvedConfs(ambiguousConf);
pAcc=0;
if (totalSolvedConfs<=2) iterations=1; else iterations =2;
if (val>0)
for (int cont=0; cont<iterations; cont++) // first cont for abs freqs, second for relative freqs
for (int j=0; j<totalSolvedConfs; j++) // for each possible complete configuration, as haplotypes
{
solvedConf=ambiguousTable->getSolvedConf(ambiguousConf, j, true);
complementarySolvedConf=ambiguousTable->getSolvedConf(ambiguousConf, j, false);
solvedConfPos=solvedTable->getPos(solvedConf);
complementarySolvedConfPos=solvedTable->getPos(complementarySolvedConf);
//it2=result->First->findElement(solvedConfPos);
if (totalSolvedConfs==1) 
result->addValue(solvedConfPos, val*2/totalCounts); // known
else if (totalSolvedConfs==2) result->addValue(solvedConfPos, val/totalCounts); // known
else if (cont==0)
pAcc=pAcc+currentEstimation->getValue(solvedConfPos)*currentEstimation->getValue(complementarySolvedConfPos)/2;
else // cont==1
{
pS=currentEstimation->getValue(solvedConfPos)*currentEstimation->getValue(complementarySolvedConfPos);
result->addValue(solvedConfPos, val*pS/pAcc/totalCounts);
}
zaparr(solvedConf); zaparr(complementarySolvedConf);
}
zaparr(ambiguousConf);
pos++;
}
double t=0, check=0;
pos=0;
for (it3=result->Second->begin(); it3<result->Second->end(); it3++)
{
 t=t+fabs(result->getElement(it3)-currentEstimation->getElement(pos));
 check=check+result->getElement(it3);
 pos++;
}
if (check > (1+zero) || check < (1-zero)) 
{
cout << "error in EM, check is " << check;
cout << "\nCurrent est:\n" << *result <<"\n";
cout << "\nold est:\n" << *currentEstimation <<"\n";
cout <<"\ngenotypes:\n" << *ambiguousCounts <<"\n";
cout <<"\ntotalCounts:" << totalCounts <<"\n";
end();
}

zap(currentEstimation);
if (t>= 0.00005 && it>0) result=estimateMLE (result, ambiguousCounts, ambiguousTable, solvedTable, totalCounts, it-1);
return result;
};
*/
}//end namespace
#endif
