/* File: HeteroListPair.h */


#ifndef __HeteroListPair_h__
#define __HeteroListPair_h__



using namespace std;

namespace BIOS {


// is a pair of lists
template < class P, class Q> class HeteroListPair
  {
public:
           Container<vector<P>, P>* First;
           Container<vector<Q>, Q>* Second;
           HeteroListPair(Container<vector<P>, P>* First, Container<vector<Q>, Q>* Second) ;
           HeteroListPair(HeteroListPair<P, Q>& p) ;
           HeteroListPair() ;
           ~HeteroListPair() ;
	  // bool operator>(const HeteroListPair<P, Q>& p) {if (First>p.First || First==p.First && Second>p.Second) return true; else return false;};
	  // bool operator<(const HeteroListPair<P, Q>&p) {if (First<p.First|| First==p.First && Second<p.Second) return true; else return false;};
	  // bool operator==(HeteroListPair<P, Q>p) {if (First==p.First && Second==p.Second) return true; else return false;};
          // void setValues(Container<vector, P>* f, Container<vector, Q>* s) {First=f; Second=s;};
	   P getFirst();
	   Q getSecond();
	   //HeteroListPair<P, Q>*  estimateMLE (HeteroListPair<P, Q>* currentEstimation, HeteroListPair<P, Q> * ambiguousCounts, MultidimensionalEmptyTable<int>* ambiguousTable, MultidimensionalEmptyTable<int>* solvedTable, double totalCounts, int it);
	   void insertElement(P first, Q second);
		 	
	   void addValue(P first, Q second);
		
	   Q getValue(P key) ; 
	   
	   Q getValueAtPos(int pos) ; 

static HeteroListPair<P, Q>* getComposedList( Container<vector<P>, P>*fatherHaps, Container<vector<P>, P>* motherHaps);

HeteroListPair(Container<vector<P>, P>*source);
void updateListFromCounters(Container<vector<P>, P> *source);



  };

/*
	template<class T> bool compare( const HeteroListPair<T>& arg1, const HeteroListPair<T>& arg2)
	{
return arg1>arg2;
}
*/
/*______________________________________________________*/

template<class T, class U> ostream& operator<<(ostream& out, HeteroListPair<T, U>& heteroListPair);

/*_________________________________________________________________________*/
/*
template<> HeteroListPair<long long int, double>*  HeteroListPair<long long int, double>::estimateMLE (HeteroListPair<long long int, double>* currentEstimation, HeteroListPair<long long int, double> * ambiguousCounts,  MultidimensionalEmptyTable<int>* ambiguousTable, MultidimensionalEmptyTable<int>solvedTable, double totalCounts, int it)
{
//intList* dimList=currentEstimation->dimensionList;
//MultidimensionalTable<double>* result=new MultidimensionalTable<double>(dimList);
//intList* dimList=new intList();
//MultidimensionalEmptyTable<double>* ambiguousTable=new MultidimensionalEmptyTable<double>(dimList);
HeteroListPair<longLongList*, doubleList*>* result;
longLongList* keys=new longLongList();
doubleList* values=new doubleList();
result=new HeteroListPair<longLongList*, doubleList*>(keys, values);
double val, pS, pAcc, *p1, p2, p3;
int iterations;
int *ambiguousConf, totalSolvedConfs, *solvedConf, *complementarySolvedConf, solvedConfPos, complementarySolvedConfPos;
longLongList::iterator it, it2;
doubleList:: iterator it3;
int pos=0;
for (it=ambiguousCounts->First->begin(); it<ambiguousCounts->First->end(); it++) // for each ambiguous configuration (as genotypes)
{
val=ambiguousCounts->Second->getElement(pos);
ambiguousConf=ambiguousTable->getPositions(ambiguousCounts->First->getElement(it));
totalSolvedConfs=ambiguousTable->getTotalSolvedConfs(ambiguousConf);
pAcc=0;
if (totalSolvedConfs<=2) iterations=1; else iterations =2;
if (val>0)
for (int cont=0; cont<iterations; cont++) // first cont for abs freqs, second for relative freqs
for (int j=0; j<totalSolvedConfs; j++) // for each possible complete configuration, as haplotypes
{
solvedConf=ambiguousTable->getSolvedConf(ambiguousConf, j, true);
complementarySolvedConf=ambiguousTable->getSolvedConf(ambiguousConf, j, false);
solvedConfPos=solvedTable->getPos(solvedConf);
complementarySolvedConfPos=solvedTable->getPos(complementarySolvedConf);
//it2=result->First->findElement(solvedConfPos);
if (totalSolvedConfs==1) 
result->addValue(solvedConfPos, val*2/totalCounts); // known
else if (totalSolvedConfs==2) result->addValue(solvedConfPos, val/totalCounts); // known
else if (cont==0)
pAcc=pAcc+currentEstimation->getValue(solvedConfPos)*currentEstimation->getValue(complementarySolvedConfPos)/2;
else // cont==1
{
pS=currentEstimation->getValue(solvedConfPos)*currentEstimation->getValue(complementarySolvedConfPos);
result->addValue(solvedConfPos, val*pS/pAcc/totalCounts);
}
zaparr(solvedConf); zaparr(complementarySolvedConf);
}
zaparr(ambiguousConf);
pos++;
}
double t=0, check=0;
pos=0;
for (it3=result->Second->begin(); it3<result->Second->end(); it3++)
{
 t=t+fabs(result->getElement(it3)-currentEstimation->getElement(pos));
 check=check+result->getElement(it3);
 pos++;
}
if (check > (1+zero) || check < (1-zero)) 
{
cout << "error in EM, check is " << check;
cout << "\nCurrent est:\n" << *result <<"\n";
cout << "\nold est:\n" << *currentEstimation <<"\n";
cout <<"\ngenotypes:\n" << *ambiguousCounts <<"\n";
cout <<"\ntotalCounts:" << totalCounts <<"\n";
end();
}

zap(currentEstimation);
if (t>= 0.00005 && it>0) result=estimateMLE (result, ambiguousCounts, ambiguousTable, solvedTable, totalCounts, it-1);
return result;
};
*/
}//end namespace
#endif
