/* File: HeteroPair.h */


#ifndef __HeteroPair_cpp__
#define __HeteroPair_cpp__



using namespace std;

namespace BIOS
{


	template < class P, class Q> HeteroPair<P,Q>::HeteroPair ( P f, Q s ) {First=BIOS::clone ( f ); Second=BIOS::clone ( s );};
	//template < class P, class Q> HeteroPair<P,Q>::HeteroPair(HeteroPair<P, Q>* p) {First=p->First; Second=p->Second;};
	template < class P, class Q> HeteroPair<P,Q>::HeteroPair ( const HeteroPair<P, Q>& p ) {First=BIOS::clone ( p.First ); Second=BIOS::clone ( p.Second );}
	template < class P, class Q> HeteroPair<P,Q>::HeteroPair() {};
	template < class P, class Q> HeteroPair<P,Q>::~HeteroPair() {empty();};
	template < class P, class Q> void 	HeteroPair<P,Q>::empty() {zap ( First ); zap ( Second );};

	/*______________________________________________________*/


	template < class P, class Q> bool HeteroPair<P,Q>::operator> ( const HeteroPair<P, Q>& p ) const
	{
		if ( First>p.First || ( First==p.First && Second>p.Second ) ) return true;
		else return false;
	};

	/*______________________________________________________*/


	template < class P, class Q> bool HeteroPair<P,Q>::operator< ( const HeteroPair<P, Q>&p )  const
	{
//cout << "inside comparing heteroPair\n";
//cout << "comparing current value: " << *this <<"\n";

//cout << "comparing current value first: " << p.First << "and second: " << p.Second <<"\n";
		if ( First<p.First|| ( First==p.First && Second<p.Second ) ) return true;
		else return false;
	};

	/*______________________________________________________*/


	template < class P, class Q>  HeteroPair<P,Q> & HeteroPair<P,Q>::operator= ( const HeteroPair<P,Q>& other )
	{
		zap ( this );
		this=other.clone();
		return *this;
	}
	/*______________________________________________________*/



	template < class P, class Q> bool HeteroPair<P,Q>::operator== ( const HeteroPair<P, Q>p ) const
	{
		if ( First==p.First && Second==p.Second ) return true;
		else return false;
	};

	/*______________________________________________________*/

	template < class P, class Q> void HeteroPair<P,Q>::setValues ( P f, Q s )
	{
		First=f; Second=s;
	};

	/*______________________________________________________*/

	template < class P, class Q> P HeteroPair<P,Q>::first()
	{
		return First;
	};

	/*______________________________________________________*/

	template < class P, class Q> Q HeteroPair<P,Q>::second()
	{
		return Second;
	};

	/*______________________________________________________*/

	template < class P, class Q> P HeteroPair<P,Q>::getFirst()
	{
		return First;
	};

	/*______________________________________________________*/

	template < class P, class Q> Q HeteroPair<P,Q>::getSecond()
	{
		return Second;
	};

	/*______________________________________________________*/

	template < class P, class Q> HeteroPair<P,Q>* HeteroPair<P,Q>::clone()
	{
		return new HeteroPair<P,Q> ( *this );
	};
	/*______________________________________________________*/

	template <class T, class U> HeteroPair<T, U>* HeteroPair<T, U>::fromString ( string s )
	{
		throw NonImplemented ( "static HeteroPair* fromString(string s)" );
	}
	/*______________________________________________________*/

	template<class T, class U> ostream& operator<< ( ostream& out, HeteroPair<T, U>*& heteroPair )
	{

		out << "(" << heteroPair->First <<", " << heteroPair->Second <<")";

		return out;
	}

	/*______________________________________________________*/

	template<class T, class U> ostream& operator<< ( ostream& out, HeteroPair<T*&, U*&>*& heteroPair )
	{

		out << "(" << *heteroPair->First <<", " << *heteroPair->Second <<")";

		return out;
	}

	/*______________________________________________________*/

	template<class T, class U> ostream& operator<< ( ostream& out, HeteroPair<T, U>& heteroPair )
	{

		out << "(" << heteroPair.First <<", " << heteroPair.Second <<")";

		return out;
	}



}//end namespace
#endif
