/* File: SlidingWindows.cpp */


#ifndef __SlidingWindows_cpp__
#define __SlidingWindows_cpp__



namespace BIOS {


/************************/
/* SNP'S GENOTYPE DEFINITION */
/************************/


/**
        @memo SlidingWindows

	@doc
        Definition:throw (NoWindow)
									IT decomposes a region of regionLength positions, starting at "firstPosition" in slinding windows of size "windowSize" and offset "offset"        

        Memory space:

        @author Maria M. Abad Grau
	@version 1.0
*/



SlidingWindows::SlidingWindows(int windowSize, int offset, int regionLength, int firstPosition) 
{
try
{
if (regionLength<windowSize) throw OutOfBounds(windowSize, regionLength, "SlidingWindows::SlidingWindows(int windowSize, int offset, int regionLength, int firstPosition)");
if (offset<1) throw OutOfRange<int>(offset, "SlidingWindows::SlidingWindows(int windowSize, int offset, int regionLength, int firstPosition): offset has to be at least 1");
this->windowSize=windowSize;
this->offset=offset;
this->firstPosition=firstPosition;
this->regionLength=regionLength;
this->totalOverlaps=NULL;
setTotalCompleteWindows();
setLastWindowSize();
setWindowOverlaps();
}
catch (BasicException& be){be.addMessage("\ncalled from  SlidingWindows(int windowSize, int offset, int regionLength, int firstPosition) "); throw;};
};

/*___________________________________________________________________________*/


  		  SlidingWindows::SlidingWindows ()
{
};
/*___________________________________________________________________________*/

  		  SlidingWindows::~SlidingWindows ()
{
zaparr(totalOverlaps);

if ( windowOverlaps != NULL){
	for ( int i=0; i<regionLength; i++)
	delete windowOverlaps[i];
	
	delete windowOverlaps;
}

};
/*___________________________________________________________________________*/

		  
void SlidingWindows::setWindowOverlaps() 
{
int firstPos;
totalOverlaps=Initialize(regionLength,0);

//print(totalOverlaps, regionLength);
windowOverlaps=new intSet*[regionLength];
for (int i=0; i<regionLength; i++)
 windowOverlaps[i]=new intSet();  

for (int i=0; i<totalCompleteWindows; i++)
{
firstPos=getFirstAbsolutePositionAtWindow(i);
 for (int j=firstPos; j<firstPos+windowSize; j++)
{
  windowOverlaps[j]->insertElement(i);
 // windowOverlaps[i]->insertElement(j);
 // totalOverlaps[j]++;
  }
}
/*firstPos=getFirstAbsolutePositionAtWindow(totalCompleteWindows);
int lastWindowSize=getLastWindowSize();
 for (int j=firstPos; j<firstPos+windowSize; j++)
  windowOverlaps[totalCompleteWindows]->insertElement(j);
  */
for (int i=0; i<regionLength; i++)
{
totalOverlaps[i]=windowOverlaps[i]->size();
//cout << "overlaps at pos " << i << ": " << *windowOverlaps[i] <<"\n";
//cout << "totaloverlaps:" << totalOverlaps[i] <<"\n";


 //if (windowOverlaps[i]->size()!=totalOverlaps[i])
 //throw OutOfBounds(windowOverlaps[i]->size(), totalOverlaps[i], "SlidingWindows::setWindowOverlaps() ");
}
};

/*___________________________________________________________________________*/

intSet* SlidingWindows::getWindowOverlapsForPosition(int position)
{
if (position<0 || position>=regionLength) throw OutOfBounds(position, regionLength, "getWindowOverlapsForPosition");
return windowOverlaps[position];
}


/*___________________________________________________________________________*/

int SlidingWindows::getTotalOverlapsForPosition(int position)
{
if (position<0 || position>=regionLength) throw OutOfBounds(position, regionLength, "getTotalOverlapsForPosition");
return totalOverlaps[position];
}

/*___________________________________________________________________________*/


int SlidingWindows::getLastPositionUsedByCompleteWindows()
{
return getFirstAbsolutePositionAtWindow (totalCompleteWindows-1)+windowSize-1;
}
/*___________________________________________________________________________*/


int SlidingWindows::getLastRelativePositionUsedByCompleteWindows()
{
return getFirstRelativePositionAtWindow (totalCompleteWindows-1)+windowSize-1;
}
/*___________________________________________________________________________*/


int SlidingWindows::getTotalUsedSNPs()
{
return getLastRelativePositionUsedByCompleteWindows()+1;
}
/*___________________________________________________________________________*/

		  
void SlidingWindows::setTotalCompleteWindows() 
{
totalCompleteWindows=0;
for (int i=0; i<regionLength/offset;i++)
if ((offset*i+windowSize)<=regionLength) totalCompleteWindows++;
//regionLength/offset-(int)ceil(windowSize/offset)+1;
if (totalCompleteWindows==0) 
throw NoWindow("SlidingWindows::setTotalCompleteWindows()");
};

/*___________________________________________________________________________*/

		  
void SlidingWindows::setLastWindowSize() 
{
lastWindowSize=windowSize;
if (((totalCompleteWindows-1)*offset+windowSize)<regionLength) 
lastWindowSize=regionLength-offset*totalCompleteWindows;
};

/*___________________________________________________________________________*/

		  
int SlidingWindows::getLastWindowSize() 
{
return lastWindowSize;
};

/*___________________________________________________________________________*/

		  
int SlidingWindows::getSizeOfWindow(int windowPos) 
{
try
{
if (windowPos<totalCompleteWindows) return windowSize;
else return lastWindowSize;
}
	catch (BasicException& be){be.addMessage("\ncalled from int SlidingWindows::getSizeOfWindow(int windowPos) "); throw;};
};
/*___________________________________________________________________________*/

		  
int SlidingWindows::getTotalWindows() 
{
if (((totalCompleteWindows-1)*offset+windowSize)<regionLength) return totalCompleteWindows+1;
else return totalCompleteWindows;
};

/*___________________________________________________________________________*/

int SlidingWindows::getTotalCompleteWindows()
{
return totalCompleteWindows;
}
/*___________________________________________________________________________*/

int SlidingWindows::getRegionLength()
{
return regionLength;
}

/*___________________________________________________________________________*/

int SlidingWindows::getFirstAbsolutePositionAtWindow (int windowIndex)
{
return windowIndex*offset;
};

/*___________________________________________________________________________*/

int SlidingWindows::getFirstRelativePositionAtWindow (int windowIndex)
{
return getFirstAbsolutePositionAtWindow(windowIndex)+firstPosition;
};

/*___________________________________________________________________________*/

void SlidingWindows::getAbsolutePos(int *out, int window)
{
try
{
	int first = window * offset;

	for(int i=0; i<windowSize; i++)
		out[i] = first+i;
}
	catch (BasicException& be){be.addMessage("\ncalled from void SlidingWindows::getAbsolutePos(int *out, int window)"); throw;};
}

/*___________________________________________________________________________*/

int SlidingWindows::getWindowSize()
{
return windowSize;
}
/*___________________________________________________________________________*/

int SlidingWindows::getOffset()
{
return offset;
}

/*___________________________________________________________________________*/

int* SlidingWindows::getAbsolutePositions(int window)
{
try
{
//cout << getSizeOfWindow(window) << "\n";
int*	result=new int[getSizeOfWindow(window)];

	for(int i=0; i<getSizeOfWindow(window); i++)
		result[i] = getFirstAbsolutePositionAtWindow(window)+i;
  return result;		
	}
	catch (BasicException& be){be.addMessage("\ncalled from int* SlidingWindows::getAbsolutePositions(int window)"); throw;};	
}





};  // End of Namespace

#endif

/* End of file: SlidingWindows.cpp */




