/* File: ListOfOrderedAttributes.cpp */


#ifndef __ListOfOrderedAttributes_cpp__
#define __ListOfOrderedAttributes_cpp__



#include "ListOfOrderedAttributes.h"


//using namespace UTILS;


namespace BIOS
{



  /**********************************/
  /* DEFINITIONS OF THE FUNCTIONS */
  /**********************************/


ListOfOrderedAttributes* ListOfOrderedAttributes::clone()
  {
return new ListOfOrderedAttributes(*this);
  };
/*___________________________________________________________*/

 ListOfOrderedAttributes::ListOfOrderedAttributes(floatList* positionsVector):ListOfAttributes()
  {
this->positionsVector=NULL;
if (positionsVector!=NULL) this->positionsVector=new floatList (*positionsVector);
  };
/*___________________________________________________________*/


 ListOfOrderedAttributes::ListOfOrderedAttributes(int totalAtts, int totalMods,floatList* positionsVector):ListOfAttributes(totalAtts, totalMods)
{
this->positionsVector=NULL;
if (positionsVector!=NULL)
 this->positionsVector=new floatList(*positionsVector);
}
  /*___________________________________________________________*/

  ListOfOrderedAttributes::ListOfOrderedAttributes(ListOfOrderedAttributes & vectorOfOrderedAttributes):ListOfAttributes(vectorOfOrderedAttributes)
  {
 this->positionsVector=NULL;
if (vectorOfOrderedAttributes.positionsVector!=NULL)
 this->positionsVector=new floatList(*vectorOfOrderedAttributes.positionsVector);
};

 

  /*___________________________________________________________ */

  ListOfOrderedAttributes::ListOfOrderedAttributes(char* texto):ListOfAttributes(texto)
  {
try
{
this->positionsVector=NULL;
readPositions(texto);
//cout <<"  ListOfOrderedAttributes::ListOfOrderedAttributes finished";
}
catch (BasicException & be) {be.addMessage ("\ncalled from ListOfOrderedAttributes::ListOfOrderedAttributes(char* texto):ListOfAttributes(texto)"); throw;};
  }
  

/*____________________________________________________________________*/

  void ListOfOrderedAttributes::readPositions(char* filename)
{
	positionsVector=NULL;
char filePos[256];
changeExtension(filename, filePos, "pos");
  if (fileExists(filePos))
{
   positionsVector=new floatList(filePos);
if (positionsVector->size()!=size())
{
cout <<"Error in ListOfOrderedAttributes::readPositions, there are " << positionsVector->size() <<" rows in file pos while there are " << size() <<" attributes";
end();
}
}
else
{
cout <<"Error in ListOfOrderedAttributes::readPositions(char* filename), file .pos does not exist";
end();
}
}

  
  /*___________________________________________________________ */

  ListOfOrderedAttributes::~ListOfOrderedAttributes()
  {
  zap(positionsVector);

  };
  
  
 
   /*___________________________________________________________ */
   
   ListOfOrderedAttributes* ListOfOrderedAttributes::select()
  {
  ListOfOrderedAttributes* newList=new ListOfOrderedAttributes();
newList->positionsVector=NULL;

 newList->positionsVector=new floatList();
    ListOfOrderedAttributes::iterator p=getFirst();

    while (p!=end())
    {
      if (getElement(p)->isSelected())
{
       newList->insertElement(getElement(p));
newList->positionsVector->insertElement(positionsVector->getElement(getPosition(p)));
}
      p=getNext(p);
    }
    return newList;
  }
 
/*___________________________________________________________ */

  void ListOfOrderedAttributes::getDiscreteListOfAttributes(ListOfOrderedAttributes* vectorOfDiscreteOrderedAttributes)
  {
ListOfAttributes::getDiscreteListOfAttributes(vectorOfDiscreteOrderedAttributes);
 vectorOfDiscreteOrderedAttributes->positionsVector=new floatList(*positionsVector);

}
  /*___________________________________________________________ */
/*
  ListOfOrderedAttributes* ListOfOrderedAttributes::GetDiscreteListOfAttributes()
  {
    ListOfOrderedAttributes* vectorOfOrderedAttributes= new ListOfOrderedAttributes();
  GetDiscreteListOfAttributes(vectorOfOrderedAttributes);
   return (vectorOfOrderedAttributes);
  }

 
/*____________________________________________________________________________________ */

  float ListOfOrderedAttributes::getMaxBasicDistance(int att)
  {


if (positionsVector->getElement(att)==-1) return 1;
float max=0;
for (int i=0;i<size();i++)
if (positionsVector->getElement(i)!=-1)
if (getBasicDistance(att,i)>max) 
max=getBasicDistance(att,i);
return max;
}
/*___________________________________________________________*/

Attribute* ListOfOrderedAttributes::Pop()
{
positionsVector->pop();
Attribute* a=Container<vector<Attribute*>,Attribute*>::pop();
return a;
}
 /*___________________________________________________________*/

string ListOfOrderedAttributes::getName()
{
return string("ListOfOrderedAttributes");
}
/*____________________________________________________________________________________ */

  Pair<int> ListOfOrderedAttributes::getExtremes(int att, float maxDistance)
  {
Pair<int> extremes;
extremes.First=att;
extremes.Second=att;
bool foundLeft=false;
for (int i=0;i<size();i++)
if (positionsVector->getElement(i)!=-1 && positionsVector->getElement(att)!=-1)
{
if (i<=att && !foundLeft){if (getBasicDistance(att,i)<=maxDistance) {extremes.First=i; foundLeft=true;}}
if (i>=att && getBasicDistance(att,i)<=maxDistance) extremes.Second=i;
}
return extremes;
}

/*____________________________________________________________________________________ */

  float ListOfOrderedAttributes::getDistance(int att, int att2)
  {
if (positionsVector->getElement(att)!=-1 && positionsVector->getElement(att2)!=-1)
return 1-getWeight(att, att2);
else return 1.0;
}
/*____________________________________________________________________________________ */

  float ListOfOrderedAttributes::getBasicDistance(int att, int att2)
  {
if (positionsVector->getElement(att)!=-1 && positionsVector->getElement(att2)!=-1)
return fabs(positionsVector->getElement(att)-positionsVector->getElement(att2));
else return 1.0;
}
/*____________________________________________________________________________________ */

  float ListOfOrderedAttributes::getWeight(int att, int att2)
  {
if (positionsVector->getElement(att)!=-1 && positionsVector->getElement(att2)!=-1)
return exp(-getBasicDistance(att, att2)/(float)100000);
else return 1.0;
}

 /*______________________________________________________*/

ListOfOrderedAttributes* ListOfOrderedAttributes::copyAttributesWithPositionsIn(intList* columns, bool isThis)
{
ListOfOrderedAttributes* res= new ListOfOrderedAttributes();
res->positionsVector=new floatList();

intList::iterator p=columns->getFirst();
while(p!=columns->end())
{
res->insertElement(this->getElement(columns->getElement(p)));
res->positionsVector->insertElement(this->positionsVector->getElement(columns->getElement(p)));
p=columns->getNext(p);
}
return res;
}
};  // Fin del Namespace

#endif

/* Fin Fichero: ListOfOrderedAttributes.h */
