
#ifndef __basic_cpp__
#define __basic_cpp__


#include "basic.h"


namespace BIOS
{




	/*
		template<class T> bool compare(const T arg1, const T arg2)
		{
	//cout <<"here\n" << arg1 << arg2; exit(0);
		return arg1<arg2;

		}


		/*____________________________________________________________ */

//template<class T> bool comparePointer(const T &  arg1, const T &  arg2) {return (*arg1<*arg2);};

	/*____________________________________________________________ */

//template<class T> bool compareInvPointer(const T & arg1, const T & arg2) {return (*arg1>*arg2);};
	/*____________________________________________________________ */


//template<class T> bool compare (const T&  arg1, const T& arg2) {return (arg1<arg2);};

	/*____________________________________________________________ */


//template<class T> bool compareInv (const T&  arg1, const T& arg2) {return (arg1>arg2);};


	template<class T> bool compare ( const T&  arg1, const T& arg2 ) {return ( *arg1<*arg2 );};


	/*____________________________________________________________ */
	/*
		template<class T> bool compare(const T* & arg1, const T* & arg2)
		{
	//cout <<"herePoint\n" << *arg1 << *arg2; exit(0);
		return *arg1<*arg2;

		}

	/*____________________________________________________________ */


	template<class T> bool compareInv ( const T&  arg1, const T& arg2 ) {return ( *arg1>*arg2 );};



	template<> bool compare ( const int&  arg1, const int& arg2 ) {return ( arg1<arg2 );};
	template<> bool compare ( const double&  arg1, const double& arg2 ) {return ( arg1<arg2 );};
	template<> bool compare ( const float&  arg1, const float& arg2 ) {return ( arg1<arg2 );};
	template<> bool compare ( const long int&  arg1, const long int& arg2 ) {return ( arg1<arg2 );};
	template<> bool compare ( const long long int&  arg1, const long long int& arg2 ) {return ( arg1<arg2 );};
	template<> bool compare ( const bool&  arg1, const bool& arg2 ) {return ( arg1<arg2 );};
	template<> bool compare ( const char&  arg1, const char& arg2 ) {return ( arg1<arg2 );};
	template<> bool compare ( const string&  arg1, const string& arg2 ) {return ( arg1<arg2 );};

	template<> bool compareInv ( const int&  arg1, const int& arg2 ) {return ( arg1>arg2 );};
	template<> bool compareInv ( const double&  arg1, const double& arg2 ) {return ( arg1>arg2 );};
	template<> bool compareInv ( const float&  arg1, const float& arg2 ) {return ( arg1>arg2 );};
	template<> bool compareInv ( const long int&  arg1, const long int& arg2 ) {return ( arg1>arg2 );};
	template<> bool compareInv ( const long long int&  arg1, const long long int& arg2 ) {return ( arg1>arg2 );};
	template<> bool compareInv ( const bool&  arg1, const bool& arg2 ) {return ( arg1>arg2 );};
	template<> bool compareInv ( const char&  arg1, const char& arg2 ) {return ( arg1>arg2 );};
	template<> bool compareInv ( const string&  arg1, const string& arg2 ) {return ( arg1>arg2 );};

	/*____________________________________________________________ */
	/*
	template<class T>
	struct Compare {
	 bool operator() (const T* & arg1, const T* & arg2) {cout <<"ww\n"; return (*arg1<*arg2);};
	 bool operator() (const T & arg1, const T & arg2) { cout <<"nopint\n"; return (arg1<arg2);};
	};

		/*____________________________________________________________ */
	/*
	template<class T>
	struct CompareInv {
	 bool operator() (const T* & arg1, const T* & arg2) { return (*arg1>*arg2);};
	 bool operator() (const T & arg1, const T & arg2) { return (arg1>arg2);};
	};

	//template<class T> Compare<T> compare;

		/*____________________________________________________________ */
	/*
	//template<template<class T> class s, class U>
	template <template <class, class> class Cont, class T, template<class> class STL2>
	bool compare(const Container<Cont, T, STL2>* & arg1, const Container<Cont, T, STL2>* & arg2)
	{
	//cout <<"herePoint\n" << *arg1 << *arg2; exit(0);
	return *arg1<*arg2;

	}
	/*____________________________________________________________ */
	/*
	template<class T> bool compareinv(const T*&arg1, const T*& arg2)
	{
	return *arg1>*arg2;
	}
	/*---------------------------------------------------------------*/
	/*

	template<class T> bool compareinv(const T&arg1, const T& arg2)
	{
	return arg1>arg2;
	};
	*/
	/*____________________________________________________________ */

	double addBayes ( double Total, BayesType Bayes, float distance, float alpha, double totalConfigurations )
	{
		switch ( Bayes )
		{
			case MLE: break;
			case UBalpha: Total=Total+ ( alpha/ ( float ) totalConfigurations ); break;
			case equilibrium: break;
			case BDistanceUniform: Total=Total+ ( alpha/totalConfigurations ) * ( 1-exp ( -distance/ ( float ) 100000 ) ); break;
		}
		return Total;
	}

	/*____________________________________________________*/

	int atoiTrim (const char* st )
	{
string s=string(st);
int result, pos=findFirstDigit(s);
return atoi(&st[pos]);
}
	/*____________________________________________________*/

	int findFirstDigit ( string st )
	{
		int i=0;
		while ( i< ( st.length() ) )
		{
			if ( isdigit ( st[i] ) ) return i;
			i++;
		}
		return -1;
	}

	template <class T> void print ( T* array, int length, ofstream* out )
	{
		for ( int i=0; i<length;i++ )
			out << array[i];
	}

// template <class T> void pr(T* o)
// {
// 	cout << *o;
// }

	/*---------------------------------------------------------------*/

	int fromString ( int i, string s )
	// convert  string
	{
		return atoi ( s.c_str() );
	};

	/*---------------------------------------------------------------*/

	allele fromString ( allele i, string s )
	// convert  string
	{
		return ConvertAllele ( s.c_str() );
	};
	/*---------------------------------------------------------------*/

	long long int fromString ( long long int i, string s )
	// convert  string
	{
		return atol ( s.c_str() );
	};
	/*---------------------------------------------------------------*/

	float fromString ( float i, string s )
	// convert  string
	{
		return atof ( s.c_str() );
	};
	/*---------------------------------------------------------------*/

	double fromString ( double i, string s )
	// convert  string
	{
		return atof ( s.c_str() );
	};
	/*---------------------------------------------------------------*/

	bool fromString ( bool i, string s )
	// convert  string
	{
		return atoi ( s.c_str() );
	};
	/*---------------------------------------------------------------*/

	char* fromString ( char* cad, string s )
	// convert  string
	{
		char *result=new char[s.length() +1];
		strcpy ( result, s.c_str() );
		return result;
		//	return s.c_str();
	};
	/*---------------------------------------------------------------*/

	string fromString ( string i, string s )
	// convert  string
	{
		return string ( s );
	};
	/*---------------------------------------------------------------*/

	template <class T> T fromString ( T i, string s )
	// convert  string
	{
		return ( T ) i->fromString ( s );
	};
	/*---------------------------------------------------------------*/

	template <> ofstream* fromString ( ofstream* i, string s )
	// convert  string
	{
		throw NonImplemented ( "fromString(ofstream* i, string s)" );
	};


	/*---------------------------------------------------------------*/

	template <class T> string tos ( T i )
	// convert  string
	{
		stringstream s; // (stringstream::in | stringstream::out);
		s << i;
		return s.str();
	};
	/*---------------------------------------------------------------*/


	template <> string tos ( double i )
	// convert  string
	{
		char cad [20];
		sprintf ( cad, "%0.5lf", i );
		return ( string ( cad ) );

	};


	/*---------------------------------------------------------------*/

	string tos ( double i, int integerPart, int decimalPart )
	// convert  string
	{
		char cad [20];
		char cad2[10];
		strcpy ( cad2, "%" );
		sprintf ( cad2, "%s%d", cad2, integerPart );
		strcat ( cad2, "." );
		sprintf ( cad2, "%s%d", cad2, decimalPart );
		strcat ( cad2, "lf" );
		sprintf ( cad, cad2, i );
		return ( string ( cad ) );

	};

	/////////

	int pow ( int base, int exp )
	{
		return ( int ) std::pow ( ( double ) base, ( double ) exp );
	}
	////////////////
	double log_2 ( double numero ) //
	{
		//
		double result=0;//
		result=log ( numero ) /log ( ( double ) 2 );//
		return ( result );//
	}//
	/*___________________________________________________________________*/

	double logB ( int base, double numero )
	{
	return std::log(numero)/std::log(base);
	}

	/*___________________________________________________________________*/

	/////////
	template <class T> T sum ( T* array, unsigned int length )
	{
		T total=0;
		for ( int i=0; i<length;i++ )
			total=total+array[i];
		return total;
	}

	/////////
	template <class T> void change ( T & val1, T  & val2 ) //=swap
	{
		T s;
		s=val1;
		val1=val2;
		val2=s;
	}

	template <class T> ostream& print ( T* array, int size, ostream& out )
	{
		for ( int i=0; i<size;i++ )
			out << array[i] << " ";
		return out;
	}

	template <class T> ostream& printArray ( T* array, int size, ostream& out )
	{
		out << "(";
		for ( int i=0; i<size-1;i++ )
			out << array[i] << ", ";
		out << array[size-1] << ")";
		return out;
	}
	/*---------------------------------------------------------------*/

	/*
	template <class T> ostream& operator<<(ostream& out, T[]array)
	{
	return print(array, 0, out);
	}
	/////////
	/*---------------------------------------------------------------*/

	template <class T>
	T * initializeFrom ( T val, int size )
	{
		T * x;

		if ( ( x = new T [size] ) ==NULL ) //
			throw BIOS::NoMemory ( "basic::initializeFrom" );

		for ( int i=0; i<size;i++ )
			x[i]=val++;

		return ( x );
	}
	/////////
	/*---------------------------------------------------------------*/

	template <class T>
	T * Initialize ( int size, T val )
	{
		T * x;

		if ( ( x = new T [size] ) ==NULL ) //
			throw BIOS::NoMemory ( "basic::initialize" );


		InitializeList ( x, size, val );
		return ( x );
	}
	/*---------------------------------------------------------------*/

	template <class T>
	void InitializeList ( T* list, int size, T val )
	{
		for ( int i=0;i<size;i++ )
			list[i]=val;
	}
	/*---------------------------------------------------------------*/

	template <class T>
	void disperseValues ( T* array, int size, T* pos, T* targetArray, int sizeTarget )
	{
		// copy values from array to targetArray at positions specified in array pos. Arrays pos and array have same size, leq of array sizeTarget
		//try
		{
			if ( sizeTarget<size )
				throw BIOS::NoMemory ( "basic::disperseValues" );

			for ( int i=0;i<size;i++ )
				if ( pos[i]>=sizeTarget ) throw NoMemory ( "basic::disperseValuesb" );
				else targetArray[pos[i]]=array[i];

		}
		/*catch (NoMemory NM)
		{
				NM.PrintMessage("basic::disperseValues");

		}
		*/


	}
	/*---------------------------------------------------------------*/

	template <class T>
	void reorderValues ( T* array, int size, T* targetPos,  T* targetArray )
	{
		for ( int i=0;i<size;i++ )
			targetArray[targetPos[i]]=array[i];
	}

	/*---------------------------------------------------------------*/

	template <class T>
	void collapseValues ( T* array, int size, T* pos, T* targetArray, int sizeTarget )
	{
		// copy values from array to targetArray at positions specified in array pos. Arrays pos and targetArray have same size, leq of array array

		if ( sizeTarget>size )
		{
			cout <<"\nTarget has size " << sizeTarget <<" and source " << size;

			throw NoMemory ( "collapseValues" );
		}
		for ( int i=0;i<sizeTarget;i++ )
			if ( pos[i]>=size )
			{
				cout <<"\nTrying to access at pos " << pos[i] <<" when source size is " << size;

				throw NoMemory ( "collapseValues" );
			}
			else targetArray[i]=array[pos[i]];



	}
	/*---------------------------------------------------------------*/

	template <class T> bool IsOne ( T value )
	{
		double val= ( double ) value;
		if ( ( val>= ( 1.0-zero ) ) && ( val<= ( 1.0+zero ) ) )
			return true;
		else return false;
	}
	/*---------------------------------------------------------------*/

	bool fileExists ( const char* namefile )
	{
		struct stat fs;
		//		cout <<"val" << stat(namefile, &fs);
		if ( stat ( namefile, &fs ) ==0 ) return ( true ); else return ( false );
	}
	/*---------------------------------------------------------------*/

	int maxlong () //
	{
		//
		int larg, result=0; //
		unsigned int contador;//
		for ( contador=0; contador< ( sizeof ( larg ) *8 ); contador++ ) //
			result=result+pow ( 2, contador ); //
		return ( result ); //
	} //
	/*---------------------------------------------------------------*/

	bool IsAZero ( unsigned int column, unsigned int pos )
	{
		// this function returns 0 if pos has a 0 at column or 1 if it has a 1 at column, considering
		// a basis2 table with TotalColumns (i.e., 2^TotalColumns positions)
		//cout <<"pos:" << pos <<", column:" << column;
		unsigned int min= ( pos/pow ( 2,column+1 ) ) *pow ( 2,column+1 );
		//	cout <<"min:" << min;
		//(pos%(2^column-1));
		unsigned int max= min+pow ( 2,column );
		//	cout <<"max:" << max;
		if ( ( pos>=min ) && ( pos<max ) )
			return true;
		else return false;
	}
	/*---------------------------------------------------------------*/

	int getGauss ( int num ) {if ( num<1 ) return 0; return num+num* ( num-1 ) /2;}

	/*---------------------------------------------------------------*/

	unsigned long int getTotalColumns ( char* filename )
	{
		try
		{

 ifstream InputFile;
			char * cad=NULL, * genotypebuf=NULL;

			unsigned int maxN=100000000;


			if ( ( genotypebuf=new char[maxN*4] ) ==NULL )
				throw NoMemory ( "getTotalColumns" );
			//if ((cad=new char[maxN*4])==NULL)
			// throw NoMemory();



			InputFile.open ( filename, ifstream::in );

			if ( InputFile.peek() ==EOF )
				throw EmptyFile ( filename, "getTotalColumns" );

			InputFile.getline ( genotypebuf, maxN*4, '\n' );

			InputFile.close();




			unsigned long int Columns=0;

			cad = strtok ( genotypebuf," ,\t" );

			do
			{
				cad = strtok ( NULL," ,\t" );
				Columns++;
			}
			while ( cad!=NULL );

			//zap(cad);
			zaparr ( genotypebuf );

			return Columns;
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from getTotalColumns" ); throw;};


	}

	////////
	// Put an assert to check if x is NULL, this is to catch
	// program "logic" errors early. Even though  works
	// fine with NULL by using assert you are actually catching
	// "bad code" very early

	// Defining Zap using templates
	// Use zap instead of delete as this will be very clean
	template <class T>
	void zap ( T & x )
	{
		try
		{
			if ( x!=NULL )
			{
//cout << "actual deleting\n";
				delete x;
			}
			x=NULL;
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from basic::zap(T&x)" ); throw;};
	};


	template <> void zap ( void* & i ) {};
	template <> void zap ( int & i ) {};
	template <> void zap ( allele & i ) {};
	template <> void zap ( base & i ) {};
	template <> void zap ( bool & i ) {};
	template <> void zap ( float & i ) {};
	template <> void zap ( double & i ) {};
	template <> void zap ( char & i ) {};
	template <> void zap ( long long int & i ) {};
	template <> void zap ( string & i ) {};


	/*_______________________________________________________________*/

	template <class T>
	bool isAPointer ( T & x )
	{
		return true;
	};
	/*_______________________________________________________________*/

	template <> 	bool isAPointer ( int & x ) {return false;};
	template <> 	bool isAPointer ( allele & x ) {return false;};
	template <> 	bool isAPointer ( base & x ) {return false;};
	template <> 	bool isAPointer ( bool & x ) {return false;};
	template <> 	bool isAPointer ( float & x ) {return false;};
	template <> 	bool isAPointer ( double & x ) {return false;};
	template <> 	bool isAPointer ( char & x ) {return false;};
	template <> 	bool isAPointer ( long long int & x ) {return false;};
	template <> 	bool isAPointer ( string & x ) {return false;};

	/*______________________________________*/
	/*
	template <class T, class U> intList::iterator findElement(T* container, U &* element)
	{
	return container->findEqualElement (*element);
	};

	/*______________________________________*/
	/*
	template <> intList::iterator findElement(intList* container, int & i){return find (container->begin(), container->end(),  element);};

	template <> doubleList::iterator findElement(doubleList* container, int & i){return find (container->begin(), container->end(),  element);};

	/*
	template <> void zap(int & i){};
	template <> void zap(allele & i){};
	template <> void zap(bool & i){};
	template <> void zap(float & i){};
	template <> void zap(double & i){};
	template <> void zap(char & i){};
	template <> void zap(long long int & i){};
	template <> void zap(string & i){};
	*/
	/*______________________________________*/
	/*
		template <class T>
			void emptyObject(T & x)
		{
	cout <<"dDDd\n";
	if (x!=NULL)
	delete x;
	//x=NULL;
	cout <<"END\n";
			};
	/*______________________________________*/
	/*
		template <>
			void emptyObject(void*& x)
		{
			};
	/*______________________________________*/
	/*
		template <class T>
			void zap(T&  x)
		{
	cout <<"OOOOO\n";
			};
	/*______________________________________*/
	/*
		template <class T>
			void emptyObject(T & x)
		{
	cout <<"nothimg to be emptied\n";
			};

	//////////////////////////////////
		template <class T>
			void deepZap(T & x)
		{
			if (x!=NULL)
				x->empty();
	zap(x);
		}
	*/
	// In C++ the reason there are 2 forms of the delete operator is because
	// there is no way for C++ to tell the difference between a pointer to
	// an object and a pointer to an array of objects. The delete operator
	// relies on the programmer using "[]" to tell the two apart.
	// Hence, we need to define zaparr function below.
	// To delete array of pointers

	template <class T>
	void zaparr ( T & x )
	{
		//  assert(x != NULL);
		if ( x!=NULL )
		{
			delete [] x;
		}
		x = NULL;
	}

	/*_______________________________________________________________*/

	template <class T>
	void zaparr ( T & x, int size )
	{
		//  assert(x != NULL);
		if ( x!=NULL )
		{
			for ( int i=0;i<size;i++ )
			{
//cout << "deleting pos " << i <<"\n";
				zap ( x[i] );
			}
			delete [] x;
			x = NULL;
		}
	}
	/*_______________________________________________________________*/

	template <class T>
	T* clone ( T* & x )
	{
		if ( x==NULL ) return NULL;
		return (T*)x->clone(); //new T(*x);
	};

	/*____________________________________________________________________*/

	template <class T>
	T clone ( T & x )
	{
		return x;
	};

	/*_______________________________________________________________*/

	template <>
	ofstream* clone ( ofstream* & x )
	{
		throw NonImplemented ( "ofstream* BIOS::clone( ofstream* & x)" );
	};

	/*_______________________________________________________________*/

	float GetMean ( float * values, int size )
	{
		float total=0;
		for ( int i=0;i<size;i++ )
			total=total+values[i];
		return total/size;
	}
	/*_______________________________________________________________*/

	template <class T> T GetMean ( Pair<T>* values, int size, bool first )
	{
		T total=0;
		for ( int i=0;i<size;i++ )
			if ( first )   total=total+values[i].First;
			else total=total+values[i].Second;
		return total/size;
	}

	/*_______________________________________________________________*/

	void end()
	{
		cout <<"\n";
		exit ( 0 );
	}


	/*_______________________________________________________________*/

	float GetSampleSD ( float * values, int size )
	{
		float mean=GetMean ( values, size );
		float sd=0;
		for ( int i=0;i<size;i++ )
			sd=sd+std::pow ( values[i]-mean, 2 );
		sd=sqrt ( sd/ ( float ) ( size-1 ) );
		return sd;
	}
	/*_______________________________________________________________*/

	template<class T> T sum ( T * values, int size )
	{
		T total=0;
		for ( int i=0;i<size;i++ )
			total=total+values[i];
		return total;
	}
	/*_______________________________________________________________*/

	template<class T> void normalize ( T * values, int size )
	{
		T total=0;
		for ( int i=0;i<size;i++ )
			total=total+values[i];
		if ( total==0 )
		{
			for ( int i=0;i<size;i++ )
				cout <<"\nvalues[" << i<<"]=" <<values[i];
			throw ZeroValue ( "normalize()" );
		}
		for ( int i=0;i<size;i++ )
			//if (total==0) values[i]=1/size;
//		  else
			values[i]=values[i]/total;
	}
	/*_______________________________________________________________*/

	template<> void normalize ( double * values, int size )
	{
		double total=0;
		for ( int i=0;i<size;i++ )
			total=total+values[i];
//cout << "total is: " << total <<"\n";
		if ( total==0 || total== MAXDOUBLE || isNAN ( total ) || isinf ( total ) )
		{
			for ( int i=0;i<size;i++ )
				cout <<"\nvalues[" << i<<"]=" <<values[i];
			throw ZeroValue ( "normalize()" );
		}
		for ( int i=0;i<size;i++ )
			//if (total==0) values[i]=1/size;
//		  else
			values[i]=values[i]/total;
	}
	/*_______________________________________________________________*/

	template<class T> void logNormalize ( T * values, int size )
	{
// does not work neither
// used when values are logarithms to avoid underflow
// values[i]=log(p[i])
// maxLog is the maxmum of the values
		T maxLog=MINDOUBLE; for ( int i=0;i<size;i++ ) if ( values[i]>maxLog ) maxLog=values[i];
// we could compute each normalized value as exp(value[i]/sum_i(exp(value[i]) but this did not solve the problem of underflow
// What we did is to use solution given by Wen 2007:
// original p[i] (exp(values[i]) can be also expressed as exp(values[i]-maxLog)*exp(maxLog)
// therefore, each normalized value can be computed as (exp(val[i]-maxLog)*exp(maxLog))/sum_i ((exp(value[i]-maxLog)*exp(maxLog))
// which is  (exp(val[i]-maxLog))/sum_i ((exp(value[i]-maxLog)*exp(maxLog))
// so that we never have to compute exp(value[i]) for small probabilities
		T total=0;
		for ( int i=0;i<size;i++ )
			total=total+exp ( values[i]-maxLog ) *exp ( maxLog );
		if ( total==0 )
		{
			for ( int i=0;i<size;i++ )
				cout <<"\nvalues[" << i<<"]=" <<values[i];
			throw ZeroValue ( "logNormalize()" );
		}
		for ( int i=0;i<size;i++ )
			values[i]=exp ( values[i]-maxLog ) *exp ( maxLog ) /total;
	}
	/*---------------------------------------------------------------*/
	int median ( int * ip, int  size )
	{
		if ( ( size % 2 ) != 0 )
			return ip[size / 2];
		else
			return ( ip[size / 2 - 1] +
			         ip[size / 2] ) / 2; // it is not exact, because sometimes we can have an interval and the median is undetermined
		// here we get the floor value
	}
	/*---------------------------------------------------------------*/

	long factorial ( long n )
	{
		if ( n<1 )
			return 1;	// we set 0! = 1
		return n*factorial ( n-1 );
	}
	/*---------------------------------------------------------------*/

	long product ( long first, long last )
	{
		long r=1;
		if ( first>last )
		{
			cout <<"Error in product";
			end();
		}
		for ( int i=first;i<=last;i++ )
			r=r*i;
		return r;
	}


	/*---------------------------------------------------------------*/

	double factln ( long n )
	{
// it returns ln(n!)
		if ( n<0 ) throw ZeroValue ( "double factln(long n)" );
		if ( n<=1 ) return 0;
		return gammln ( n+1.0 );
	}
	/*---------------------------------------------------------------*/

	double combinations ( long n, long m )
	{
		if ( n<m )
		{
			throw OutOfBounds ( m, n, "basic: combinations, n<m" );
			end();
		}
		return floor ( 0.5+exp ( factln ( n )-factln ( m )-factln ( n-m ) ) );
		/* it only works for small numbers
		if (n==m) return 1;
		long max=maxi(n,m);
		long min=mini(n,m);
		return product(min+1, max)/factorial(max-min);
		*/
	}
	/*---------------------------------------------------------------*/

	double getAccuraciesSampleVariance ( int num, int total )
	{
		double mean=num/ ( double ) total;
		if ( total==num ) return 0;
		else return num/ ( double ) ( total-1 )-std::pow ( ( double ) mean, ( double ) 2 ) * ( total ) / ( double ) ( total-1 );
	}
	/*---------------------------------------------------------------*/

	double getAccuraciesSampleSD ( int num, int total )
	{
		return sqrt ( getAccuraciesSampleVariance ( num, total ) );
	}
	/*____________________________________________________________________*/

	bool IsOne ( double number )
	{
		if ( number>=1 )
			if ( ( number-zero ) <1 )
				return true;
			else return false;
		if ( number<1 )
			if ( ( number+zero ) >1 )
				return true;
			else return false;
		return false;
	}
	/*---------------------------------------------------------------*/

	double median ( double * ip, int  size )
	{
		return percentile ( ip, size, 50 );
	}
	/*---------------------------------------------------------------*/

	double proportion ( double * ip, int  size, int scale, double prop )
	{
		int lower=size;
		int upper=0;
		int lowerprop= ( int ) floor ( size * prop/ ( double ) scale );
		double range=ip[size]-ip[0];
		double intervalprop;
		double val=ip[lowerprop];
		for ( int i=0;i<size;i++ )
		{
			if ( ( ip[i]==val ) && ( lower==size ) )
				lower=i;
			if ( ip[i]==val ) upper=i;
		}
		if ( upper>lower && ip[upper]>ip[lower] )
		{
			intervalprop= ( double ) ( ip[upper]-ip[lower] ) / ( double ) range;
			return ip[lower]+ ( ip[upper]-ip[lower] ) * ( double ) ( prop-lowerprop ) / ( double ) intervalprop;
		}
		else return ip[lower];
	}

	/*---------------------------------------------------------------*/

	double percentile ( double * ip, int size, double perc )
	{
		return proportion ( ip, size, 100, perc );
	}
	/*__________________________________________________________*/

	double permile ( double *ip, int size, double perm )
	{
		return proportion ( ip, size, 1000, perm );
	}
	/*
			int lower=size;
			int upper=0;
			int lowerperc=(int) floor (size * perc/(double)100);
			double range=ip[size]-ip[0];
			double intervalperc;
			double val=ip[lowerperc];
			for (int i=0;i<size;i++)
			{
				if ((ip[i]==val) && (lower==size))
					lower=i;
				if (ip[i]==val) upper=i;
			}
			if (upper>lower && ip[upper]>ip[lower])
			{
				intervalperc=(double)(ip[upper]-ip[lower])/(double)range;
				return ip[lower]+(ip[upper]-ip[lower])*(double)(perc-lowerperc)/(double)intervalperc;
			}
			else return ip[lower];
		}
		/*---------------------------------------------------------------*/

	double percentile ( struct FreqAndVal * ip, int  size, double perc )
	{
		double TotalFrequency=0.0;
		// Use pont instead of perc because FreqAndVal.frequency can sum other than 1.
		for ( int i=0;i<size;i++ )
			TotalFrequency=TotalFrequency+ip[i].frequency;
		double freq= ( double ) perc*TotalFrequency/ ( double ) 100;
		int lower=size;
		int upper=0;
		double val=0; //ip[(int) floor (size * perc/(double)100)].value;
		double lowerfreq, upperfreq;
		// double range=ip[size].value-ip[0].value,
		//double intervalfreq;
		TotalFrequency=0.0;
		//cout<<"freq:"<<freq;
		try
		{
			for ( int i=0;i<size;i++ )
			{
				TotalFrequency=TotalFrequency+ip[i].frequency;
				if ( TotalFrequency>freq && lower==size && i>0 )
				{
					val=ip[i-1].value;
					lower=i-1;
					upper=i;
					lowerfreq=TotalFrequency-ip[i].frequency;
					upperfreq=TotalFrequency;
				}
				if ( TotalFrequency==freq || ( TotalFrequency>freq && i==0 ) )
				{
					upper=i;
					lower=i;
				}
			}
			return ip[upper].value;
		}

		catch ( BasicException& be ) {be.addMessage ( "\ncalled from percentile" ); throw;};

	}
	/*---------------------------------------------------------------*/


	template<class T> int getPositionOfTheClosestValueUsingBinarySearch ( T* a,  T target, int searchType, int size )
	{
//searchType is 0 for exact search, -1 for the closest lower  value if the target is not found, and +1 for the closest larger value if the target is not found
		int low=0, high=size;
		while ( low <= high )
		{
			int middle = low + ( high - low ) /2;
			if ( target < a[middle] )
				high = middle - 1;
			else if ( target > a[middle] )
				low = middle + 1;
			else
				return middle;
		}
		if ( searchType==0 ) return size;
		if ( searchType==-1 ) return high;
		if ( searchType==1 ) return low;
	}

	/*---------------------------------------------------------------*/

	double getPValue ( double * ip, int  size, double testVal )
	{
//print(ip, size);
//cout <<"testval is: " << testVal <<"\n";
		double p=0;
//print(ip, size);
//cout << "looking for:" << testVal <<"\n";
		int i=getPositionOfTheClosestValueUsingBinarySearch ( ip, testVal, 1, size );
//cout << "value found is at pos:"<< i << " and is:" << ip[i] <<"\n";
		if ( i==0 ) return 1; if ( i==size ) return 0; return 1- ( ( i-1 ) / ( double ) size );
		/*
				while (  i<size )
				{
		//cout <<"i is: " << i <<"\n";
					if ( testVal>ip[i] )

						if ( i==0 ) return 1; else  return 1- (( i-1 ) / ( double ) size);

					i++;
				}
		//cout <<"end cicle, p is: " << p <<"\n";
				return p;
		*/
	}
	/*---------------------------------------------------------------*/
	template <class T> T maxi ( T a, T b ) //
	{
		//
		if ( a >= b ) //
			return ( a );//
		else return ( b );//
	}//
	/*---------------------------------------------------------------*/
	double max ( struct FreqAndVal a, struct FreqAndVal b ) //
	{
		//
		if ( a.frequency >= b.frequency ) //
			return ( a.value );//
		else return ( b.value );//
	}//
	/*---------------------------------------------------------------*/
	template <class T> T mini ( T a, T b ) //
	{
		//
		if ( a <= b ) //
			return ( a );//
		else return ( b );//
	}//
	/*---------------------------------------------------------------*/
	template <class T> T GetExtreme ( T* array, int size, bool IsMax=true ) //
	{
		//
		return array[GetExtremePos ( array, size, IsMax ) ];
	}//
	/*---------------------------------------------------------------*/
	template <class T> int GetExtremePos ( T* array, int size, bool IsMax=true ) //
	{
		//
		T Extreme=array[0];
		int ExtremePos=0;

		for ( int i=1;i<size;i++ )
			if ( ( array[i]>Extreme && IsMax==true ) || ( array[i]<Extreme && IsMax==false ) )
			{
				Extreme=array[i];
				ExtremePos=i;
			}
		return ( ExtremePos );
	}//
	/*---------------------------------------------------------------*/
	template <class T> T GetMax ( T* array, int size ) //
	{
		return GetExtreme ( array, size, true );
	}
	/*---------------------------------------------------------------*/
	template <class T> T GetMin ( T* array, int size ) //
	{
		return GetExtreme ( array, size, false );
	}
	/*---------------------------------------------------------------*/
	template <class T> int GetMaxPos ( T* array, int size ) //
	{
		return GetExtremePos ( array, size, true );
	}
	/*---------------------------------------------------------------*/
	template <class T> int GetMinPos ( T* array, int size ) //
	{
		return GetExtremePos ( array, size, false );
	}
	/*---------------------------------------------------------------*/
	bool isANumber ( const char* cad )
	{
		int i=0;
		bool dot=false;
		while ( i<strlen ( cad ) )
		{
			if ( i==0 )
			{
				if ( cad[i]!='-' && cad[i]!='+' && cad[i]!='.' && ( cad[i]<'0' || cad[i]>'9' ) )
				{
					cout <<"val" << cad[i];
					return false;
				}
				else if ( cad[i]=='.' ) dot=true;

			}
			else
			{
				if ( cad[i]!='.' && ( cad[i]<'0' || cad[i]>'9' ) )
					return false;
				else if ( cad[i]=='.' )
						if ( dot==true ) return false; else dot=true;
			}
			i++;
		}

		return true;
	}
	/*---------------------------------------------------------------*/
	bool isAnInteger ( const char* cad )
	{
		if ( isANumber ( cad ) && strchr ( cad, '.' ) ==NULL )
			return true;
		else return false;
	}
	/*---------------------------------------------------------------*/
	bool isAFloat ( const char* cad )
	{
		return isANumber ( cad ) && !isAnInteger ( cad );
	}
	/*---------------------------------------------------------------*/
	void changeExtension ( char* FileSource, char*FileTarget, const char* Extension )
	{
		char* pointer=strrchr ( FileSource, '.' );
		if ( pointer==NULL ) throw NullValue ( string ( "Error in basic::ChangeExtension" ) +string ( ", no dot char found in file name " ) +string ( FileSource ) );
		/*
				int pos=-1;
				for ( unsigned int i=0;i<strlen ( FileSource );i++ )
					if ( FileSource[i]=='.' )
						pos=i;
		cout << "original file is:" << FileSource;
		cout <<"\ndot is at pos " << pos <<"\n";
		if (pos==-1) throw BadFormat("Error in basic::ChangeExtension");
		*/
		int pos=pointer-FileSource;
		strncpy ( FileTarget, FileSource, pos );
		FileTarget[pos]='.';
		FileTarget[pos+1]='\0';
		//FileTarget = strtok(FileTarget+2, ".")-2;
		strcat ( FileTarget, Extension );
//		strcat (FileTarget, "\0");
		//  cout <<"\n" << FileTarget;
		//  exit(0);
	}
	/*---------------------------------------------------------------*/
	char* GetFileExtension ( char* FileSource )
	{
		char* pointer=strrchr ( FileSource, '.' );
		if ( pointer==NULL ) throw NullValue ( "Error in basic::ChangeExtension" );
		int pos=pointer-FileSource;
		/*		int pos=0;
				for ( unsigned int i=0;i<strlen ( FileSource );i++ )
					if ( FileSource[i]=='.' )
						pos=i;*/
		char * p=&FileSource[pos+1];
		return p;
	}
	/*---------------------------------------------------------------*/
	char* getFilePath ( const char* FileSource )
	{      string path=getFilePathStr(FileSource);
		char *result=new char [path.length()+1];
		strcpy(result, path.c_str());
		result[path.length()]='\0';
		return result;
	}
/*---------------------------------------------------------------*/
	string getFilePathStr ( const char* FileSource )
	{
		bool found=false;
		int lastPos=strlen ( FileSource )-1;
		while ( lastPos>0 && !found )

			if ( FileSource[lastPos]=='/' ) {found=true; lastPos++;}
			else lastPos--;




		char* path=new char [lastPos+1];
		for ( unsigned int i=0;i<lastPos;i++ )
			path[i]=FileSource[i];
		path[lastPos]='\0';
                string result=string(path);
                zaparr(path);
		return result;
	}
	/*---------------------------------------------------------------*/

	char* removeDir ( const char* FileSource )
	{
		char* p=new char [1024];

		unsigned int pos=0, i;
		for ( i=0;i<strlen ( FileSource );i++ )
			if ( FileSource[i]=='/' )
				pos=i+1;

		for ( i=0;i<strlen ( FileSource )-pos;i++ )
			p[i]=FileSource[i+pos];
		p[i]='\0';
		return p;

	}
	/*---------------------------------------------------------------*/

	char* removeExtension ( const char* FileSource )
	{
		string s="";
		char* result;
		int pos=0;
		for ( unsigned int i= ( strlen ( FileSource )-1 ); i>=0;i-- )
			if ( FileSource[i]=='.' )
			{
				for ( int j=0;j<i;j++ )
					s=s+tos ( FileSource[j] );
				result=new char[s.length() +2];// if only +1, segmentation error
				strcpy ( result, s.c_str() );
				return result;
			}
		throw BadFormat ( "removeExtension" );
//			return NULL;
	}
	/*---------------------------------------------------------------*/
	char* getFilename ( const char* FileSource )
	{
		char* p=removeDir ( FileSource );
		return strtok ( p, "." );
		return p;
	};
	/*---------------------------------------------------------------*/
	void ChangeFilename ( char* FileSource, char*FileTarget, char* newname )
	{
		char *p=GetFileExtension ( FileSource );

		strcpy ( FileTarget, newname );
		strcat ( FileTarget, "." );
		strcat ( FileTarget, p );
	}
	/*_________________________________________________________*/

	char* AddFilename ( char* FileSource, char* chunk )
	{
		char *p;
		p=new char[1024];
		strcpy ( p, getFilename ( FileSource ) );
		strcat ( p, chunk );
		ChangeFilename ( FileSource, p, p );
		return p;
	}
	/*_________________________________________________________*/

	void AddFilename ( char* FileSource, char* FileTarget, char* chunk )
	{
		strcpy ( FileTarget, getFilename ( FileSource ) );
		strcat ( FileTarget, chunk );
		ChangeFilename ( FileSource, FileTarget, FileTarget );
	}
	/*---------------------------------------------------------------*/
	bool HasThisExtension ( char* FileSource,const  char* Extension, unsigned short int ExtensionLength )
	{
		char * p=GetFileExtension ( FileSource );
		if ( strncmp ( p, Extension, ExtensionLength ) ==0 ) return true; else return false;

	}
	/*---------------------------------------------------------------*/
	int getLineSize ( ifstream * source )
	{


		int p=source->tellg();
		char* c;
		while ( *c!=EOF && *c!='\n' )
		{
			p=p+1;
			c= ( char* ) ( source+p );
		}
		p=p+1;
		return p+1;
	}

	/*---------------------------------------------------------------*/
	char* CaptureLine ( ifstream * source )
	{
		try
		{
			if ( source->is_open() ==false )
			{
				cout <<"Error in CaptureLine";
				exit ( 0 );
			}
			char* buffer=NULL;//=NULL
			string s;

//cout <<"source is:" << source <<"\n";
//return new char[13789];
			std::getline ( *source, s );

//return new char[10];
			if ( s[s.length()-1]=='\r' ) // DOS Mode
			{
				buffer=new char[s.length() ];
				strncpy ( buffer, s.c_str(), s.length()-1 );
				buffer[s.length()-1]='\0';
			}
			else
			{
				buffer=new char[s.length() +1];
				strcpy ( buffer, s.c_str() );
//		strcat (buffer, "\0");
				buffer[s.length() ]='\0';
			}
			return buffer;
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from char* CaptureLine ( ifstream * source )" ); throw;};
	}


	/*_______________________________________________________________*/

	int GetLineLength ( char * FileName )
	{

 ifstream InputFile;
		OpenInput ( FileName, &InputFile );

		char c;
		int i=0;
		do
		{
			InputFile.get ( c );
			i++;
		}
		while ( c!='\n' && c!=EOF );

		InputFile.close();
		return i;
	}


	/*---------------------------------------------------------------*/
	void NextLine ( ifstream* InputFile )
	{

		char c;
		int i=0;
		while ( InputFile->peek() !='\n' )
		{
			InputFile->get ( c );
			i++;
		}
		InputFile->get ( c );

	}
	/*____________________________________________________*/

	void splitword ( char * out, char *in, char stop )
	{
		int i, j,k;
		for ( i=0; in[i] && ( in[i]!=stop ); i++ )
			out[i]=in[i];

		out[i]='\0'; //terminar
		if ( in[i] )
			++i;

		k=strlen ( in )-strlen ( out );

		for ( j=0; ( in[j]&& ( j<k ) ); ) // desplazar el resto de in
			in [j++]=in[i++];
		in[j]='\0';
	}

	/*____________________________________________________*/

	bool isNAN ( double val )
	{
		return ( isnan ( val ) !=0 );
	}
	/*______________________________________________________________*/

	void fileCopy ( char* forigen, char* fdestino )
	{
		string s=string ( "cp " ) +string ( forigen ) +string ( " " ) +string ( fdestino );
		system ( s.c_str() );
//cout << s << " done\n";
		/*
		ofstream OutputFile;
		ifstream InputFile;
				OpenOutput(fdestino, &OutputFile);
			OpenInput(forigen, &InputFile);
				char a;

				InputFile.get(a);

				while (!InputFile.eof())
				{
					OutputFile << a;
					InputFile.get(a);
				}
				OutputFile.close();
				InputFile.close();
		*/
	}
	/*______________________________________________________________*/

	void fileAppend ( char* forigen, char* fdestino )
	{

 ifstream InputFile;
		OpenOutputAdd ( fdestino, &OutputFile );
		OpenInput ( forigen, &InputFile );

		char a;

		InputFile.get ( a );

		while ( !InputFile.eof() )
		{
			OutputFile << a;
			InputFile.get ( a );
		}
		OutputFile.close();
		InputFile.close();
	}
	/*____________________________________________________*/

	void CopyWithoutChar ( char * out, char *in, char rem )
	{
		int tam=strlen ( in ), i=0, j=0;
		while ( i<tam )
		{
			while ( i<tam && in[i]!=rem )
			{
				out[j]=in[i];
				i++;
				j++;
			}
			if ( i<tam ) // then rem
				i++;
		}
		out[j]='\0';
	}
	/*---------------------------------------------------------------*/
	int getTotalLines ( const char * FileName )
	{
 ifstream InputFile;
		//int length=GetLineLength (FileName);
		//length=5000;
		int i=0;
		//char line[length];

		OpenInput ( FileName, &InputFile );
		char* genotypebuf=NULL;

	if (InputFile.eof() || InputFile.peek() ==EOF ) return 0;
		do
		{

			genotypebuf=CaptureLine ( &InputFile );

			//	InputFile.getline (line, length*2, '\n');
			i++;
			zaparr ( genotypebuf );
		}
		while ( !InputFile.eof() ); // && InputFile.peek() !='\n' && InputFile.peek() !='\r' );

		if ( InputFile.peek() ==EOF ) i--;
		InputFile.close();
		return i;
	}
	/*____________________________________________________________ */

	void OpenOutputBasic ( const char* filename, ofstream* OutputFile, bool add )
	{
try
{
		if ( !add )
		{
//if (fileExists(filename)) throw ErrorFile(filename, "void OpenOutputBasic ( const char* filename, ofstream* OutputFile, bool add )");
		OutputFile->open ( filename, ifstream::out );
		}
		else OutputFile->open ( filename, ifstream::app );
		if ( OutputFile->fail() )
		{
			cout << "Error, check file permits and ownership\n";
			if (add) throw ErrorFileDoesNotExist ( filename, "OpenOutputBasic" ); else ErrorFileCannotBeCreated(filename, "OpenOutputBasic");
		}
}
catch ( BasicException& be ) {be.addMessage ( "\ncalled from OpenOutputBasic ( const char* filename, ofstream* OutputFile, bool add )" ); throw;};
	}
	/*____________________________________________________________ */

	void OpenOutput ( const char* filename, ofstream* OutputFile )
	{
		try
		{
//OutputFile->clear();
			OpenOutputBasic ( filename, OutputFile, 0 );
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from OpenOutput" ); throw;};
	}
	/*____________________________________________________________ */

	void OpenOutputAdd ( char* filename, ofstream* OutputFile )
	{
		try
		{
			OpenOutputBasic ( filename, OutputFile, 1 );
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from OpenOutputAdd" ); throw;};
	}
	/*____________________________________________________________ */

	void CheckFile ( char* FileName, bool exists )
	{

		try
		{
			if ( ( !fileExists ( FileName ) && exists ) || ( fileExists ( FileName ) && !exists ) )
				throw ErrorFile ( FileName, "CheckFile" );
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from CheckFile" ); throw;};

	}
	/*____________________________________________________________ */

	void OpenInput ( const char* FileName, ifstream* InputFile )
	{

		if ( InputFile->is_open() ) throw AlreadyOpen ( FileName, "OpenInput" );
		if ( !fileExists ( FileName ) ) throw ErrorFile ( FileName, "OpenInput" );
		InputFile->open ( FileName, ifstream::in );
		InputFile->seekg ( -1, ifstream::end );
		if ( InputFile->peek() !='\n' && InputFile->eof() ) throw NoEOL ( FileName, "OpenInput" ); //InputFile->peek(), -1, FileName);
		InputFile->seekg ( 0, ifstream::beg );
		if ( InputFile->eof() )
			//  if (InputFile->eof())
			throw EmptyFile ( FileName, "OpenInput" );
	}
	/*____________________________________________________________ */

	long int fileSize ( char* nomfich )
	{
		FILE *fichero;

		if ( ( fichero=fopen ( nomfich, "rb" ) ) ==NULL )
			return -1;


		long int posicion, taman;
		posicion=ftell ( fichero );
		fseek ( fichero, 0L, 2 ); //2: ir al final del fichero
		taman=ftell ( fichero );
		fseek ( fichero, posicion, 0 ); //0: ir al principio
		fclose ( fichero );
		return ( taman );
	}
	/*____________________________________________________________ */

	uli getSize ( ifstream* f )
	{
		f->seekg ( 0, ios::end );
		uli length = f->tellg();
		f->seekg ( 0, ios::beg );
		return ( length );
	}

	/*_______________________________________________________________*/

	void replaceAll ( string &source, string oldPattern, string newPattern )
	{
		int pos=source.length();
		while ( source.rfind ( oldPattern, pos ) !=string::npos )
		{
//cout <<"\nfound at pos " << source.rfind(oldPattern, pos);
			source.replace ( source.rfind ( oldPattern, pos ), oldPattern.length(), newPattern );
//cout <<"\n\nnow is " << source;
		}
	}

	/*_____________________________________________________________*/

	int GetStringLinePosition ( char* FileName, char* string )
	{

 ifstream InputFile;
		// if not found, return the total number of lines in the file
		OpenInput ( FileName, &InputFile );
		int length=100000;
		int i=0;
		bool found=false;
		char line[length];
		do
		{
			InputFile.getline ( line, length, '\n' );
			if ( strstr ( line, string ) !=NULL )
				found=true;
			else i++;
		}
		while ( !InputFile.eof() && !found );

		InputFile.close();
		return i;
	}
}
// end namespace
#endif



