#ifndef Doublevec_HPP
#define Doublevec_HPP 1

// header file for double precision dvector and matrix classes
// doublevec - double dvector indexed from 0
// dvector - double dvector indexed from offset, can't remember what it does
// dv2d - double matrix indexed from 0, supports matrix arithmetic
// dsvd - set of three matrices forming singular value decomposition of source matrix
// rank_table - not distributing this code yet



namespace BIOS { 


class doublevec{
protected:
double *v;
int sz;
public:
doublevec(doublevec const &);
doublevec(int);
doublevec(void);
doublevec& operator=(doublevec const &);
doublevec operator+(doublevec const &);
doublevec operator-(doublevec const &);
int size(void) {return sz;}
double* vec(void) {return v;}
~doublevec();
void fprintf(FILE *fp,char *form);
void print(string form= "%3.2g  ") { fprintf(stdout,(char*)form.c_str()); }
double& operator[](int i){return v[i];}
void setValueAtPos(int i, double val) {v[i]=val;}
};

typedef doublevec *DBLVPOINTER;

typedef double *DBLPOINTER;

extern int default_vec_error(const char *s);
extern int (*vec_error)(const char*);
extern "C" {
extern int comp_row(void const *,void const *);
}
}

#endif

