#ifndef Dsvd_HPP
#define Dsvd_HPP 1

// header file for double precision dvector and matrix classes
// doublevec - double dvector indexed from 0
// dvector - double dvector indexed from offset, can't remember what it does
// dv2d - double matrix indexed from 0, supports matrix arithmetic
// dsvd - set of three matrices forming singular value decomposition of source matrix
// rank_table - not distributing this code yet



namespace BIOS { 



class dsvd {
public:
dv2d U,W,V,UT,VT,Winv;
// keep decomposition in UT,W,VT
// it may often be more efficient, if slightly less convenient
// to use UT and VT directly rather than U and V
int done,gotU,gotV,gotWinv;
int OK(void);
dsvd(int,int);
dsvd(dsvd const &);
//dsvd(dv2d&);
~dsvd(){};
dv2d solve(dv2d const &);
dv2d svbksb(dv2d const &);
int setU();
int setV();
int setWinv(double lim=1e-6);
void zerod(double lim=1e-6);
dv2d operator*(dv2d const &);
int dcmp(dv2d &);
dsvd& operator=(dsvd const &);
};


extern int default_vec_error(const char *s);
extern int (*vec_error)(const char*);
extern "C" {
extern int comp_row(void const *,void const *);
}
}

#endif

