

#ifndef __pca_h__
#define __pca_h__


/***********************  Contents  ****************************************
C* Principal Components Analysis: C, 638 lines. ****************************
C* Sample input data set (final 36 lines). *********************************
C****************************************************************************/



/*********************************/
/* Principal Components Analysis */
/*********************************/

/*********************************************************************/
/* Principal Components Analysis or the Karhunen-Loeve expansion is a
   classical method for dimensionality reduction or exploratory data
   analysis.  One reference among many is: F. Murtagh and A. Heck,
   Multivariate Data Analysis, Kluwer Academic, Dordrecht, 1987.

   Author:
   F. Murtagh
   Phone:        + 49 89 32006298 (work)
                 + 49 89 965307 (home)
   Earn/Bitnet:  fionn@dgaeso51,  fim@dgaipp1s,  murtagh@stsci
   Span:         esomc1::fionn
   Internet:     murtagh@scivax.stsci.edu
   
   F. Murtagh, Munich, 6 June 1989                                   */   
/*********************************************************************/



namespace BIOS {


float **matrix(int n, int m);
void corcol(float **data, int n, int m, float ** symmat);
void covcol(float** data, int n, int m, float ** symmat);
void scpcol(float** data, int n, int m, float** symmat);
float *avector(int n);
void tred2(float** a, int n, float* d, float *e);
void tqli(float d[], float e[], int n, float **z);
void free_matrix(float** mat, int n,int m);
void free_vector(float *v, int n);
floatSample* getPCA(floatSample* sample, int totalComps, bool corr);

};
#endif
#define SIGN(a, b) ( (b) < 0 ? -fabs(a) : fabs(a) )


