/* File: PhylogeneticDistance.h */

#ifndef __BivariateCountsAlongSecondVar_cpp__
#define __BivariateCountsAlongSecondVar_cpp__

//using namespace stats;

namespace BIOS {

/*______________________________________________________________*/

BivariateCountsAlongSecondVar::BivariateCountsAlongSecondVar(int totalPermutations,int totalSecondVars): SampleGenericCounts(totalPermutations)
{
this->firstVarList=NULL;
this->arrayOfSecondVarList=NULL;
this->totalSecondVars=totalSecondVars;
this->firstRankList=NULL;
};

/*______________________________________________________________*/

BivariateCountsAlongSecondVar::BivariateCountsAlongSecondVar(doubleList* firstVarList, doubleList** secondVarList, int totalPermutations, int totalSecondVars): SampleGenericCounts(totalPermutations)
{
this->firstVarList=firstVarList; //->clone();
this->arrayOfSecondVarList=secondVarList;
this->totalSecondVars=totalSecondVars;
firstRankList=Spearman::setRankingList(firstVarList);
this->ties=Spearman::ties(firstRankList);
/*
if (totalSecondVars>0)
{
this->arrayOfSecondVarList=new doubleList*[totalSecondVars];
for (int j=0; j<totalSecondVars; j++)
this->arrayOfSecondVarList[j]=secondVarList[j]->clone();
}
*/
};

/*______________________________________________________________*/

BivariateCountsAlongSecondVar::BivariateCountsAlongSecondVar(BivariateCountsAlongSecondVar& other): SampleGenericCounts((SampleGenericCounts&) other)
{
this->firstVarList==NULL;
this->arrayOfSecondVarList==NULL;
if (other.firstVarList!=NULL) this->firstVarList=other.firstVarList;//->clone();
this->arrayOfSecondVarList=other.arrayOfSecondVarList;
this->totalSecondVars=other.totalSecondVars;
this->firstRankList=other.firstRankList->clone();
/*
if (other.arrayOfSecondVarList!=NULL)
{
this->arrayOfSecondVarList=new doubleList*[totalSecondVars];
for (int j=0; j<totalSecondVars; j++)
this->arrayOfSecondVarList[j]=other.arrayOfSecondVarList[j]->clone();
}
*/
};
/*______________________________________________________________*/

/*______________________________________________________________*/

BivariateCountsAlongSecondVar* BivariateCountsAlongSecondVar::clone()
{
return new BivariateCountsAlongSecondVar(*this);
}

/*_________________________________________________________________*/

 BivariateCountsAlongSecondVar::~BivariateCountsAlongSecondVar()
 {
zap(firstRankList);
for (int i=0; i<totalPermutations; i++)
{
zap(((BivariateCountsAlongSecondVar*)permutations[i])->firstVarList);
zap(((BivariateCountsAlongSecondVar*)permutations[i])->firstRankList);
}
//zaparr(arrayOfSecondVarList, totalSecondVars);
 };
 /*_________________________________________________________________*/



void BivariateCountsAlongSecondVar::print(ostream&)
{
throw NonImplemented("void BivariateCountsAlongSecondVar::print(ostream&)");
}

 /*_________________________________________________________________*/


int BivariateCountsAlongSecondVar::getTotalSecondVars()
{
return totalSecondVars;
}
 /*_________________________________________________________________*/

void BivariateCountsAlongSecondVar::setPermutations()
{
if (permutations!=NULL) return;
permutations=new SampleGenericCounts*[totalPermutations];
doubleList* firstVariablePermutation=NULL;

//cout << "setting permutations\n";

for (int i=0; i<totalPermutations; i++)
{
//if (i%1000==0)
//cout <<"perm number " << i <<"\n";
firstVariablePermutation=firstVarList->clone();
firstVariablePermutation->shuffle();
permutations[i]=new BivariateCountsAlongSecondVar(firstVariablePermutation, arrayOfSecondVarList, 0, totalSecondVars);
}




}


/*_________________________________________________________________*/
 


};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */




