#ifndef __GenericMeasure_h__
#define __GenericMeasure_h__

namespace BIOS
{

	/**
	   @memo GenericMeasure
	   @doc
	   Definition:
	  
	An abstract class for GenericMeasure

	   @author María Mar Abad Grau
	   @version 1.0
	  
	  */

	class MeasureResults;

	class SampleGenericCounts;

	class GenericMeasure
	{


		public:
			
			bool permutations;

			SampleGenericCounts* counts;

			/**
			*	Constructor
			*/
			GenericMeasure ( bool permutations=false );

			GenericMeasure (SampleGenericCounts* geneticCounts, bool permutations=false );

			GenericMeasure ( GenericMeasure& other );


			/**
			*	Destructor
			*/
			virtual ~GenericMeasure();

			virtual GenericMeasure* clone() =0;

			virtual GenericMeasure* getNewGenericMeasure ( SampleGenericCounts* genericCounts, SampleGenericCounts** training=NULL, SampleGenericCounts** test=NULL ) =0;

			virtual GenericMeasure* inferGenericMeasure ( SampleGenericCounts* genericCounts ) =0;

//    virtual GenericCounts* getCounts(char* filename, int totalPermutations, int* pos, int size)=0;


			virtual MeasureResults* getResults() =0;

			virtual double getStatistic()=0;

			//virtual double getPValue(double* nullArray, int totalPermutations, double measure);

			virtual stringList* getHeadFile() =0;

			virtual void setPermutations(int totalPermutations);

			virtual void setPermutations();

			SampleGenericCounts ** getPermutations ();

			virtual string getName() =0;
			virtual string getShortName() { return getName(); } ;

			virtual bool operator== ( GenericMeasure& otherMeasure ) {throw NonImplemented ( " bool operator==(GenericMeasure& otherMeasure)" ); };

			virtual double getPVal();

  			virtual GenericMeasure* getNewMeasure(SampleGenericCounts* genericCounts, SampleGenericCounts** training=NULL, SampleGenericCounts** test=NULL)=0;

			virtual  GenericMeasure* fromString ( string s ) =0;

			friend ostream& operator<< ( ostream& out, GenericMeasure& l )
			{
				try
				{
					l.print ( out );
				}
				catch ( BasicException& be ) {be.addMessage ( "\ncalled from ostream& operator<<(ostream& out, GenericMeasure& l)  " ); throw;};
				return out;
			};

			virtual void print ( ostream& ) =0;

virtual double getBestPVal();

//static double getBestStatistic();

	virtual double getWorstStatistic();

virtual void setCounts(SampleGenericCounts* genericCounts);

virtual SampleGenericCounts* getCounts();


	};



	/*
	{

	}
	*/

};

#endif
