#ifndef MLEst_cpp//
#define MLEst_cpp//



namespace BIOS 
{

/*______________________________________________________*/

template<class T> MLEst<T>::MLEst(BayesType bayesType, float alpha): DependenceMeasure<T>(bayesType, alpha)
{
}

/*______________________________________________________*/

template <class T> double MLEst<T>::getMeasure(CPT *s1, CPT* s2)
{
cout <<"MLEst<T>::getMeasure not defined yet";
end();
}
/*______________________________________________________*/

template<class T> bool MLEst<T>::better(double m1, double m2)
{
if (m1<m2) return true; else return false;
}


/*______________________________________________________*/

template<> double MLEst<int>::getMeasure(CPT *pt, CPT* priors)
{
//It is used to compute MLEst of x versus MLEst of x | y 
// If s2 has no values, we compute MLEst of x
//if not, we computeMLEst of x | y
// definition: LL(B|D)=N\sum_i \sum _{val(i), parents conf(i)} \hat p(i,parents i) log(\hat p(i|parents i)) (=-2xEntropy)
//ProbabilityTable* s1=pt->getProbabilityTable();

if (bayesType!=MLE) pt->addPrior(*priors);
int xTotalMods=pt->getDimensionList()->getElement(0);
double MLEst=0;
Prob p, margP;//, prior;
//int* pos=NULL;

//cout <<*pt;
for (int j=0;j<pt->getSize();j++)
{
//  pos=pt->getPositions(j);
  p=pt->getValue(j);
//  prior=priors->getValue(j);
  margP=Prob(p.getNumerator(), pt->getTotalSample());
if (p.getDenominator()!=0 && p.convert()>0)
    MLEst=MLEst+margP.convert()*log2(p.convert());
//zap(pos);
}
return pt->getTotalSample()*MLEst;
}
/*______________________________________________________*/

template<class T> ostream& operator<<(ostream& out, MLEst<T>& lista)
{
 
out << *lista.sample;

return out;
  }

  
} // end namespace
#endif
