/* File: PhylogeneticDistance.h */

#ifndef __SampleGenericCounts_h__
#define __SampleGenericCounts_h__

//using namespace stats;

namespace BIOS {


/************************/
/* SNP'S MultimarkerMeasure DEFINITION */
/************************/


/**
        @memo GenericCounters required for a GenericMeasure

	@doc
        Definition:

     it will obtain the counts from a file with a sample

    
        @author Maria M. Abad
	@version 1.0
*/

class TestModeClass;
class GenericSample;
class VectorOfParentalHaplotypes;
class VectorOfParentalGenotypes;

 
class	SampleGenericCounts {


public:
  int totalPermutations;

protected:


SampleGenericCounts** permutations;

//char* filename;

//GenericSample* genericSample;

//char* fileName;
//TestModeClass* testModeClass;
//GenericSample* genericSample;


/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/





      public:

//SampleGenericCounts(char* file, TestModeClass* testModeClass);

SampleGenericCounts(int totalPermutations=0);

 SampleGenericCounts(SampleGenericCounts& source);

//virtual SampleGenericCounts* clone()=0;

//virtual void divideSample()=0;

//MeasureResults** getResults(ListOfGenericMeasures* test, int*pos, int size);
//intSet* selectPositions(int foldSize, Sampling* sampling, int i);

//virtual bool isEmpty()=0;

virtual~SampleGenericCounts();

friend ostream& operator<<(ostream& out, SampleGenericCounts& l) {l.print(out); return out; };

virtual void print(ostream&)=0;

virtual int getTotalPermutations();

virtual SampleGenericCounts** getPermutations();

virtual void setPermutations ();

virtual int getTotalSecondVars();

virtual SampleGenericCounts* clone()=0;

virtual VectorOfParentalHaplotypes* getParentalHaplotypesList();

virtual int getTotalPos();

virtual VectorOfParentalGenotypes* getParentalGenotypes();

virtual int size();

};

};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */




