/* File: StatisticalTestResults.h */

#ifndef __StatisticalTestResults_cpp__
#define __StatisticalTestResults_cpp__





namespace BIOS
{

 StatisticalTestResults:: StatisticalTestResults():MeasureResults()
   {
pVal=0;
   this->totalMultiTest=0;
   }
   
       /*________________________________________________________________________*/

    StatisticalTestResults:: StatisticalTestResults(StatisticalTestResults& other):MeasureResults()
   {
//other.printClass();
   this->pVal=other.pVal;
   this->totalMultiTest=other.totalMultiTest;
   }

/*________________________________________________________________________*/

   double StatisticalTestResults::getTotalMultiTest()
    {
    return totalMultiTest;
}

     /*________________________________________________________________________*/


   StatisticalTestResults:: StatisticalTestResults(double pVal, double totalMultiTest):MeasureResults()
   {
   try
   {
   this->pVal=pVal;
   this->totalMultiTest=totalMultiTest;
   }
catch (BasicException& be){be.addMessage("\ncalled from StatisticalTestResults:: StatisticalTestResults(double pVal):MeasureResults()"); throw;};
   };
   
   /*________________________________________________________________________*/
   
    StatisticalTestResults::~StatisticalTestResults()
    {
    };
    
      /*________________________________________________________________________*/
  
    void StatisticalTestResults::set()
    {
    this->pVal=0;
   this->totalMultiTest=0;
    };
    
          /*________________________________________________________________________*/
  
    void StatisticalTestResults::empty()
    {
    set();
    };
    
          /*________________________________________________________________________*/
  
    StatisticalTestResults* StatisticalTestResults::clone()
    {
    return new StatisticalTestResults(*this);
    };


          /*________________________________________________________________________*/
  
  double StatisticalTestResults::getMainResult()
  {
  return pVal;
  }

  /*________________________________________________________________________*/
  
   
void StatisticalTestResults::addResult(MeasureResults*m, int size)
{
if (size>0)
pVal=pVal+(((StatisticalTestResults*)m)->pVal/(double)size);
else pVal=1;
//throw BadFormat("StatisticalTestResults::addResult(),nonsense");
}
/*________________________________________________________________________*/

void StatisticalTestResults::printHeading(ostream& out)
{
out << "p val";
}
/*________________________________________________________________________*/

void StatisticalTestResults::printHeadingPlus(string s, ostream& out)
{
printHeading(out);
}
/*________________________________________________________________________*/

void StatisticalTestResults::print(ostream& out, bool verticalPrint)
{
try
{
//double pVal2=0.0445;
//cout <<"inside sttistiaprint\n";
if (!verticalPrint) out << "pVal" <<":\t";
out << pVal;
}
    catch (BasicException& be) {be.addMessage ("\ncalled from void StatisticalTestResults::print(ostream& out, bool verticalPrint)"); throw;};
}


};  // Fin del Namespace

#endif

/* Fin Fichero: TestModeClass.h */
