/* File: BidimensionalVarsTable.h */


#ifndef __BidimensionalVarsTable_h__
#define __BidimensionalVarsTable_h__


using namespace std;

namespace BIOS
{

  /////////////////////////////////////////
  template <class T> class BidimensionalVarsTable: public VarsTable<T>, public BidimensionalTable<T> //
  {//
 

private:

double getMeanXY();
double getMarginalMean(int var);
double getMarginalMeanOfSquares(int var);

public:
double getTotalConditional(int var, int modality);

BidimensionalVarsTable<T>(intList *varList, intList* dimList); 
BidimensionalVarsTable<T>(int xSize, int ySize);
  
void set();
double getCovariance();
double getCorrelationCoefficient();
double getR2();
double getStDev(int var);
double getVariance(int var);
void setValue(int i, int j, T value);


};
}
#endif
