/* File: PotentialList.cpp */


#ifndef __PotentialList_cpp__
#define __PotentialList_cpp__

using namespace std;

namespace BIOS
{
PotentialList::~PotentialList(){};

/*____________________________________________________________________________________ */
 
PotentialList* PotentialList::operator/(PotentialList* otherPotentialList)
{
return product(otherPotentialList, false);
}
/*____________________________________________________________________________________ */
 
PotentialList* PotentialList::operator*(PotentialList* otherPotentialList)
{
return product(otherPotentialList, true);
}

/*____________________________________________________________________________________ */

PotentialList* PotentialList::marginalize(intSet* marginalSet)
{
intSample* varSets=this->getVarSets();
intList* intlist=varSets->flatSample(), *marginalVars;
zap(varSets);
intSet *completeSet=new intSet(*intlist), *remainingSet;
zap(intlist);
completeSet->copyPaste(marginalSet);
remainingSet=completeSet->copyElementsNotIn(marginalSet);

PotentialList* result=this->project(completeSet), *temp;
PotentialTable *PT, *PT2;
Integer* i;
// for each remaining var
for (intSet::iterator pl=remainingSet->begin(); pl!=remainingSet->end(); pl++)
{
if (result->size()<2) 
{
zap(remainingSet);
temp=result->project(marginalSet);
zap(result);
return temp;
}
 temp=result->extractSubPotential(*pl);
 PT=temp->productTable();
 marginalVars=new intList(*PT->varList);
 marginalVars->removeNode(marginalVars->findElement(*pl));
 PT2=PT->marginalize(marginalVars);
 result->insertElement(PT2);
 zap(PT2);
 zap(PT);
 zap(temp);
 zap(marginalVars);
}; 
zap(remainingSet);
temp=result->project(marginalSet);
zap(result);
return temp;
};
/*____________________________________________________________________________________ */

PotentialList* PotentialList::extractSubPotential(int var)
{
intSample* varSets=getVarSets();
intSet* posSet=new intSet();
for (intSample::iterator it=varSets->begin(); it!=varSets->end(); it++)
 if (varSets->getElement(it)->findElement(var)!=varSets->getElement(it)->end()) posSet->insertElement(varSets->getPosition(it));
PotentialList *result=(PotentialList*)this->extractElementsWithPositionsIn(posSet);
zap(posSet);
zap(varSets);
return result;
}
/*____________________________________________________________________________________ */

PotentialList* PotentialList::project(intSet* marginalSet)
{
intList* marginalList=new intList(*marginalSet);
PotentialTable* marginal;
PotentialList* marginalPotentials=new PotentialList();
intList* adaptedMarginalList;
for (PotentialList::iterator p=begin();p!=end();p++)
{
adaptedMarginalList=getElement(p)->varList->copyElementsIn(marginalList);
marginal=getElement(p)->marginalize(adaptedMarginalList);
if (adaptedMarginalList->size()>0)
marginalPotentials->insertElement(marginal);
zap(adaptedMarginalList);
zap(marginalList);
};
return marginalPotentials;
}
/*____________________________________________________________________________________ */

PotentialList::PotentialList():Container<vector<PotentialTable*>, PotentialTable*>()
{
}
/*____________________________________________________________________________________ */

PotentialList::PotentialList(PotentialList& otherPotential):Container<vector<PotentialTable*>, PotentialTable*>(otherPotential)
{
};
/*____________________________________________________________________________________ */

intSample* PotentialList::getVarSets()
{
intSample* varSample= new intSample();
intList *intLista;
for (PotentialList::iterator p=this->begin();p!=this->end(); p++)
{
if (this->getElement(p)->varList!=NULL)
{
intLista=new intList(*this->getElement(p)->varList);
varSample->insertElement(intLista);
}
}
return varSample;
}
/*___________________________________________________________________*/



PotentialList* PotentialList::eliminate()
{
// it removes those potentials completely covered by others in a recursive manner
PotentialList* potentialTableList=new PotentialList(*this), *potentialTableList2;
PotentialTable *pot, *pot2, *pot3;
intSample* varSets=potentialTableList->getVarSets();
intList* varSet;
bool total=0;
int blanket;
while (varSets->size()>1 && total<varSets->size())
{
varSet=varSets->pop();
pot=potentialTableList->pop();
blanket=varSets->getOptimalBlanket(varSet);
if (blanket!=-1)
{
potentialTableList2=potentialTableList->eliminate();
zap(potentialTableList);
potentialTableList=potentialTableList2;
}
else 
{
varSets->insertElementAtPos(varSet,0);
potentialTableList->insertElementAtPos(pot,0);
}
total++;
}
zap(varSets);
return potentialTableList;
};

/*__________________________________________________________________*/

PotentialList* PotentialList::simplify()
{
// it removes those potentials completely covered by others in a recursive manner
PotentialList* potentialTableList=new PotentialList(*this), *potentialTableList2;
PotentialTable *pot, *pot2, *pot3;
intSample* varSets=potentialTableList->getVarSets();
intList* varSet;
bool total=0;
int blanket;
while (varSets->size()>1 && total<varSets->size())
{
varSet=varSets->pop();
pot=potentialTableList->pop();
blanket=varSets->getOptimalBlanket(varSet);
if (blanket!=-1)
{
pot3=potentialTableList->getElement(blanket);
pot2=*pot*pot3;
zap(pot);
potentialTableList->removeNode(blanket);
zap(varSet);
potentialTableList->insertElementAtPos(pot2, blanket);
potentialTableList2=potentialTableList->simplify();
zap(potentialTableList);
potentialTableList=potentialTableList2;
}
else 
{
varSets->insertElementAtPos(varSet,0);
potentialTableList->insertElementAtPos(pot,0);
}
total++;
}
zap(varSets);
return potentialTableList;
};

/*____________________________________________________________________________________ */

PotentialTable* PotentialList::productTable()
{
try
{
if (size()==0) return NULL;
PotentialList::iterator p=this->getFirst();
PotentialTable* result=new PotentialTable(*this->getElement(p)), *temp;
p=this->getNext(p);
while (p!=this->end())
{
 temp=*result*this->getElement(p);
 zap(result);
 result=temp;
 p=this->getNext(p);  
}
return result;
}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from PotentialTable* PotentialList::productTable()" ); throw;};

}

/*____________________________________________________________________________________ */

PotentialList* PotentialList::product(PotentialList* otherPotentialList, bool product)
{
intSample* varSets, *otherVarSets=otherPotentialList->getVarSets();
int optimalBlanket, i=0; 
PotentialList* result=new PotentialList(*this), *result2;
PotentialTable* pt, *pt2, *pt3;
for (intSample::iterator p=otherVarSets->begin(); p!=otherVarSets->end(); p++)
{
varSets=result->getVarSets();
optimalBlanket=varSets->getOptimalBlanket(otherVarSets->getElement(p));
if (optimalBlanket==-1)
{
if (product)
result->insertHardElement(otherPotentialList->getElement(i));
else
{
pt=new PotentialTable(*otherPotentialList->getElement(i));
pt2=new PotentialTable(*pt);
pt2->initialize(1);
pt3=*pt2/pt;
zap(pt);
zap(pt2);
result->insertElement(pt3);
}
}
else
{
pt=result->getElement(optimalBlanket);
pt2=pt->product(otherPotentialList->getElement(i), product);
result->removeNode(optimalBlanket);
result->insertElementAtPos(pt2, optimalBlanket);
}
i++;
zap(varSets);
}
zap(otherVarSets);
result2=result->simplify();
zap(result);
return result2;
}

/*__________________________________________________________________________*/

void PotentialList::removeInconsistenciesWithEvidence(intList*inputPattern)
{
 PotentialTable* potential;
 intList* inputPattern2; 
  for (PotentialList::iterator p=begin(); p!=end(); p++)
       {
       potential=*p;
       inputPattern2=inputPattern->copyElementsWithPositionsIn(potential->varList, false);
       potential->removeInconsistenciesWithEvidence(inputPattern2, 0);
       zap(inputPattern2);
       }
}

};  // Fin del Namespace
//

#endif
