/* File: ProbabilityTable.h */


#ifndef __ProbabilityTable_cpp__
#define __ProbabilityTable_cpp__




using namespace std;


namespace BIOS
{

 


 
  /*______________________________________________________*/

  template<> ProbabilityTable::VarsTable(intSample*  sample, intList *varList, intList* dimensionList, ListOfAttributes* listOfAttributes, floatList* alphaNumerator, float alphaDenominator) throw (OutOfRange<long long int>):MultidimensionalTable<Prob>(dimensionList)//,  intSample::NodePointer first, intSample::NodePointer last):MultidimensionalTable<Prob>(dimensionList)
  {
     set(sample, varList, dimensionList, listOfAttributes, alphaNumerator, alphaDenominator);
   };
/*______________________________________________________*/

  template<> void ProbabilityTable::set(intSample*  sample, intList *varList, intList* dimensionList, ListOfAttributes* listOfAttributes, floatList* alphaNumerator, float alphaDenominator) throw (OutOfRange<long long int>)//, intSample::NodePointer first, intSample::NodePointer last)
  {

int i;
 VarsTable<int>* pT=new VarsTable<int>(sample, varList, dimensionList, listOfAttributes);
  try{
  set(varList, pT->totalSample);
 for (i=0;i<this->getSize();i++)
{
if (alphaNumerator==NULL)
  this->table[i]=Prob(pT->getValue(i)+alphaDenominator/(double)this->getSize(), totalSample+alphaDenominator);
else  this->table[i]=Prob(pT->getValue(i)+alphaNumerator->getElement(i), totalSample+alphaDenominator);
 //   
}
zap(pT);
}
catch (NonProb n){n.PrintMessage("VarsTable<Prob>::set(intSample*  sample, intList *varList, intList* dimensionList)");}
catch (MissingValue mv)
{
cout <<"\nNum:" << pT->getValue(i) <<", den:" << totalSample;
mv.PrintMessage("VarsTable<Prob>::set"); end();}
catch (ZeroValue zv){zv.PrintMessage("VarsTable<Prob>::set");end();}

    //  cout <<"totalcounts" << this->getTotalCounts();

 };
 

 
/*_______________________________________________________________*/

 template<> VarsTable<Prob>* VarsTable<Prob>::getConditional(intList* conditionalVarList)
  {
try
{
 VarsTable<Prob>* conditional=new  VarsTable<Prob>(*this), *marginals=this->marginalize(conditionalVarList);
int* posi, *posi2=new int [marginals->getDimension()], p, *index;
float num, den;
bool first;

intList * indexList=varList->copyPositionsWithElementsIn(conditionalVarList);
index=indexList->getTable();
zap(indexList);
for (int i=0;i<conditional->getSize();i++)
{
posi=conditional->getPositions(i);
num=conditional->getValue(posi).getNumerator();
collapseValues(posi, conditional->getDimension(), index, posi2, marginals->getDimension());
den=marginals->getValue(posi2).getNumerator();
zap(posi);
conditional->setValue(i, Prob(num,den));
}
zap(marginals);
zap(index);
zap(posi2);
return conditional;
}
catch (NonProb n){n.PrintMessage("VarsTable<Prob>::getConditional(intList* conditionalVarList)");}
catch (MissingValue mv){mv.PrintMessage("VarsTable<Prob>::getConditional"); end();};

}



/*_______________________________________________________________*/

//typedef VarsTable<Prob> ProbabilityTable;
/*_______________________________________________________________*/
/*
   template <> ProbabilityTable* ProbabilityTable::marginalize(intList* sourceVarList)
  {

 if (varList==NULL || sourceVarList==NULL) {cout <<"Error 1 in VarsTable::marginalization"; end();}
    
    if (varList->includes(sourceVarList)==false)
    {
      cout <<"Error in VarsTable::marginalization, marginal list " << *sourceVarList <<" is not included in current var list " << *varList; end();
    }

    if (sourceVarList->size()==0) return new VarsTable<Prob>(*this);
    if (sourceVarList->size()==varList->size()) return new VarsTable<Prob>(*this);

    intList* newPosList=varList->copyPositionsWithElementsIn(sourceVarList);
    intList* newVarList=varList->copyElementsIn(sourceVarList);
    //cout <<this->print();
    //cout <<"vars:" << varList->print() <<"chosenpos:" << newPosList->print() <<"\n";
    //end();
    MultidimensionalTable<Prob>* mT=this->project(newPosList);
    VarsTable<Prob>* newVarsTable=new VarsTable<Prob>(*mT, varList, totalSample);
    //newVarsTable->varList=new intList(*newVarList);
//newVarsTable->totalSample=this->totalSample;
    //end();
    zap(newVarList);
    zap(newPosList);
    zap(mT);


    return newVarsTable;
}

   /*______________________________________________________*/

  ostream& operator<<(ostream& out, ProbabilityTable& p)
  {
     char posChar[2000];
    int *pos=NULL;
    int pv;
    cout <<"Total counts: " << p.totalCounts <<"\n"; 
    for (int i=0; i<p.getSize();i++)
    {
      pos=p.getPositions(i);
      out << "\nProb (";
      strcpy(posChar,"\0");

      for (int j=0; j<p.varList->size();j++)
      {


        sprintf(posChar, "%d= %d, ", p.varList->getElement(j), pos[j]);
       out << "var ";
        out << string(posChar);
      }

      out << ") = ";


     // out << tos(p.getValue(pos));
        out << "[" << p.getValue(pos).getNumerator() <<", " << p.getValue(pos).getDenominator() <<"]";

      zaparr(pos);
    };
  
    return out;
  }

   /*______________________________________________________*/

}
  
#endif
