/* File: Binomial.cpp */


#ifndef __Binomial_cpp__
#define __Binomial_cpp__


#include "Binomial.h"


namespace BIOS {



double Binomial::pdfBinomial(double val, int samples, double prob)
{
try
{
// probability density function




return std::pow(prob, val)*std::pow(1-prob, samples-val)*combinations(samples, (long int) val);
}
catch (BasicException& be) {be.addMessage ("\ncalled from  Binomial::pdfBinomial(double val, int samples, double prob)"); throw;};

}

/**********************************/

double Binomial::testBinomial(double val, int samples, double prob)
{
return cpdfBinomial(val, samples, prob);
}


/**********************************/
double Binomial::cpdfBinomial(double val, int samples, double prob)
{
try
{
double result=0;
if (val<=0) return 0.0;
for (int i=0; i<=val; i++)
result=result+pdfBinomial(i, samples, prob);
return 1-result;
}
catch (BasicException& be) {be.addMessage ("\ncalled from  Binomial::cpdfBinomial(double val, int samples, double prob)"); throw;};
}

/**********************************/
Binomial::Binomial(int n, double Prob)
{
Size=2;
this->n=n;
p=Prob;
values=Initialize(n, 0);
setAllValues();
pointer=0;
}
/**********************************/
Binomial::Binomial(int n)
{
Size=2;
this->n=n;
values=Initialize(n, 0);
pointer=0;
}
/**********************************/
Binomial::~Binomial()
{
zaparr(values);
}
/**********************************/
int* Binomial::getFrequencies()
{
int* frequencies=Initialize(Size, 0);
for (int i=0;i<n;i++)
 frequencies[values[i]]++;
return frequencies;
}
/**********************************/
int Binomial::getPointer()
{
return pointer;
}
/**********************************/
int Binomial::getNextValue()
{
pointer++;
if (pointer>n) 
{
//cout <<"error in Binomial::getNextValue()";
throw OutOfRange<int>(pointer, "Binomial::getNextValue()"); 
}
return values[pointer-1];
}
/**********************************/
void Binomial::setAllValues()
{
if (n==1)
 values[0]=random_binomial();
else
{
Binomial* one;
for (int i=0;i<n;i++)
{
one=new Binomial(1, p);
values[i]=one->random_binomial();
zap(one);
}
};
};
/**********************************/

int Binomial::random_binomial()
{
//if (n!=1)
//throw BadSize("Binomial::random_binomial()");
double t=p/(1-p);
double u=RAND_UNIFORME;
double p0=std::pow((1-p),n);
double g=p0;
unsigned int k=0;
while (u>g)
    {
    p0*=t*(n-k)/(k+1);
    g+=p0;
    k++;
    };
return n-k;
}

/**********************************/
/*
int Binomial::random_binomial()
{
double t=p/(1-p);
double u=RAND_UNIFORME;
double p0=std::pow(p,n);
double g=p0;
unsigned int k=0;
while (u>g)
    {
    p0*=t*(n-k)/(k+1);
    g+=p0;
    k++;
    };
return k;
}
*/

};  // End of Namespace

#endif

/* End of file: Binomial.h */




