
#ifndef __Spearman_cpp__
#define __Spearman_cpp__

namespace BIOS
{


	Spearman::Spearman ( BivariateCountsAlongSecondVar* bvCounts, int secondVarPos,  doubleList**arrayOfSecondRankList, intList* ties2List, intList*hasMissing, bool permutations, double*nullArray) : GenericMeasure ( ( SampleGenericCounts* ) bvCounts, permutations )
	{
		try
		{
			this->nullArray=nullArray;
this->arrayOfSecondRankList=arrayOfSecondRankList;
			this->firstList=bvCounts->firstVarList; //->clone();
			if ( secondVarPos>=bvCounts->totalSecondVars ) throw OutOfBounds ( secondVarPos, bvCounts->totalSecondVars, "Spearman ( BivariateCountsAlongSecondVar* bvCounts, int secondVarPos, int totalPermutations )" );
			this->secondList=bvCounts->arrayOfSecondVarList[secondVarPos]; //->clone();
			this->firstRankList=bvCounts->firstRankList;
			this->secondRankList=arrayOfSecondRankList[secondVarPos];
			this->secondVarPos=secondVarPos;
			ties1=bvCounts->ties;
   this->ties2List=ties2List;
			ties2=(bool)ties2List->getElement(secondVarPos);
			measure=-2;
   actualFirstRankList=NULL;
			actualSecondRankList=NULL;
   actualFirstList=NULL;
			actualSecondList=NULL;
   this->hasMissing=hasMissing;
   if (hasMissing->getElement(secondVarPos)==1)
   {
   removeNans();
   actualFirstRankList=setRankingList(actualFirstList);
   actualSecondRankList=setRankingList(actualSecondList);
   }
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from Spearman::Spearman ( BivariateCountsAlongSecondVar* bvCounts, int secondVarPos, int totalPermutations ) " ); throw;};
	}


	/*______________________________________________________*/

	Spearman::Spearman ( Spearman& other ) : GenericMeasure ( other )
	{
		nullArray=other.nullArray;
		firstList=other.firstList;
		secondList=other.secondList;
		firstRankList=other.firstRankList;
		secondRankList=other.secondRankList; 

		actualFirstList=NULL;
		actualSecondList=NULL;
		actualFirstRankList=NULL;
		actualSecondRankList=NULL; 
  this->arrayOfSecondRankList=other.arrayOfSecondRankList;
		if ( other.actualFirstList!=NULL )
			actualFirstList=other.actualFirstList;
		if ( other.actualSecondList!=NULL )
			actualSecondList=other.actualSecondList;
		if ( other.actualFirstRankList!=NULL )
			actualFirstRankList=other.actualFirstRankList;
		if ( other.actualSecondRankList!=NULL )
			actualSecondRankList=other.actualSecondRankList;
		measure=other.measure;
		ties1=other.ties1;
		ties2=other.ties2;
		secondVarPos=other.secondVarPos;
 ties2List=other.ties2List;
hasMissing=other.hasMissing;
	}


	/*______________________________________________________*/

	Spearman::~Spearman()
	{

	zap ( actualFirstList );
		zap ( actualSecondList );

		zap ( actualFirstRankList );
		zap ( actualSecondRankList );
//		zaparr ( nullArray );

	}

	/*______________________________________________________*/

	GenericMeasure* Spearman::getNewGenericMeasure ( SampleGenericCounts* genericCounts, SampleGenericCounts** training, SampleGenericCounts** test )
	{
		throw NonImplemented ( "GenericMeasure* Spearman::getNewGenericMeasure ( SampleGenericCounts* genericCounts, SampleGenericCounts** training=NULL, SampleGenericCounts** test=NULL )" );
	}
	/*______________________________________________________*/

	Spearman* Spearman::clone()
	{
		return new Spearman ( *this );
	}
	/*______________________________________________________*/

	GenericMeasure*  Spearman::inferGenericMeasure ( SampleGenericCounts* genericCounts )
	{
		throw NonImplemented ( "GenericMeasure*  Spearman::inferGenericMeasure ( SampleGenericCounts* genericCounts ) " );
	};

	/*______________________________________________________*/

	MeasureResults* Spearman::getResults()
	{
		throw NonImplemented ( "MeasureResults* Spearman::getResults() " );
	};

	/*______________________________________________________*/

	stringList* Spearman::getHeadFile()
	{
		throw NonImplemented ( "stringList* Spearman::getHeadFile()" );
	};
	/*______________________________________________________*/

	void Spearman::print ( ostream& out )
	{
		if ( firstList!=NULL ) out <<"first list of values: " <<*firstList <<"\n";
		if ( secondList!=NULL ) out <<"second list of values: " <<*secondList  <<"\n";
		if ( firstRankList!=NULL ) out <<"first rank list: " <<*firstRankList  <<"\n";
		if ( secondRankList!=NULL ) out <<"second rank list: " <<*secondRankList  <<"\n";
	};
	/*______________________________________________________*/

	string Spearman::getName()
	{
		throw NonImplemented ( "string Spearman::getName()" );
	};

	/*______________________________________________________*/


	GenericMeasure*  Spearman::fromString ( string s )
	{
		throw NonImplemented ( " GenericMeasure*  Spearman::fromString ( string s )" );
	};;;
	/*______________________________________________________*/


	GenericMeasure* Spearman::getNewMeasure ( SampleGenericCounts* genericCounts, SampleGenericCounts** training, SampleGenericCounts** test )
	{
		return new Spearman ( ( BivariateCountsAlongSecondVar* ) genericCounts, secondVarPos, arrayOfSecondRankList, ties2List, hasMissing, false, NULL );
	};
	/*______________________________________________________*/


	void Spearman::setSecondList ( doubleList* valueList )
	{
		if ( secondList!=NULL )
		{
			zap ( secondList );
			zap ( secondRankList );
			ties2=false;
		}
		secondList=valueList;
//this->secondList->sort(false);
		setSecondRankingList();
		measure=-2;
	}
	/*______________________________________________________*/


	void Spearman::removeNans ( )
	{
		try
		{
if (actualSecondList!=NULL || actualFirstList!=NULL) throw BadFormat("	void Spearman::removeNans ( )");
			if ( firstList==NULL || secondList==NULL ) throw BadFormat ( "void Spearman::removeNans (  )" );
			if ( firstList->size() !=secondList->size() ) throw OutOfBounds ( firstList->size(), secondList->size() );
			intSet* removePos=new intSet();
			for ( int i=0; i<firstList->size(); i++ )
				if ( isNAN ( firstList->getElement ( i ) ) || isNAN ( secondList->getElement ( i ) ) )
					removePos->insertElement ( i );
   actualFirstList=firstList->clone();
   actualSecondList=secondList->clone();
			if ( removePos->size() >0 )

			{
				actualFirstList->removeElementsWithPositionsIn ( removePos );
				actualSecondList->removeElementsWithPositionsIn ( removePos );
			}

			zap ( removePos );
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from void Spearman::removeNans ( )" ); throw;};
	}
	/*______________________________________________________*/

	void Spearman::setSecondRankingList()
	{
		if ( secondRankList!=NULL ) zap ( secondRankList );
		secondRankList=setRankingList ( secondList );
		/*
		doubleList* sortedSecondList=secondList->clone();
		sortedSecondList->sort(true);
		secondRankList=new doubleList();
		doubleList::iterator it2;
		for (doubleList::iterator it=secondList->begin(); it!=secondList->end(); it++)
		{
		it2=sortedSecondList->findElement(*it);
		if (it2==sortedSecondList->end()) throw NullValue("void Spearman::setSecondRankingList()");
		secondRankList->insertElement(sortedSecondRankList->getElement(sortedSecondList->getPosition(it2)));
		}
		zap(sortedSecondList);
		*/
		ties2=ties ( secondRankList );
	}
	/*______________________________________________________*/

	void Spearman::setFirstRankingList()
	{
		if ( firstRankList!=NULL ) {zap ( firstRankList ); ties1=false;}
		firstRankList=setRankingList ( firstList );
		ties1=ties ( firstRankList );
	}
	/*______________________________________________________*/

	bool Spearman::ties ( doubleList* rankList )
	{
		bool ties=false;
		doubleList* sortedRankList=rankList->clone();
		sortedRankList->sort ( true );
		for ( int i=1; i<sortedRankList->size(); i++ )
			if ( sortedRankList->getElement ( i ) ==sortedRankList->getElement ( i-1 ) )
			{
				ties=true;
				break;
			}
		zap ( sortedRankList );
		return ties;
	}


	/*______________________________________________________*/

	doubleList* Spearman::setRankingList (  doubleList*   valueList )
	{
intList* nanPositions=new intList();
		PairOfDoublesVector* originalOrder=new PairOfDoublesVector();
		for ( int i=0; i<valueList->size(); i++ )
if (isNAN (valueList->getElement(i))) nanPositions->insertElement(i);
else 	originalOrder->insertElement ( new PairOfDoubles ( valueList->getElement ( i ), i ) );


//cout << "original order is: " << *originalOrder <<"\n";
		originalOrder->sort ( true );
//cout << "original order now is: " << *originalOrder <<"\n";
//if (originalOrder->size()!=valueList->size())
//throw OutOfBounds(originalOrder->size(), valueList->size(), "doubleList* Spearman::setRankingList ( doubleList* valueList )");
		PairOfDoublesVector* newOrder=new PairOfDoublesVector();
		for ( int i=0; i<originalOrder->size(); i++ )
			newOrder->insertElement ( new PairOfDoubles ( originalOrder->getElement ( i )->Second, i ) );
		newOrder->sort ( true );
		doubleList* result=new doubleList(), *orderedResult=new doubleList ( originalOrder->size(), 1 );
		int numberOfIdenticalValues=1;
		double total=orderedResult->getElement ( 0 );
		for ( int i=1; i<=originalOrder->size(); i++ )
		{
			if ( i<originalOrder->size() && originalOrder->getElement ( i )->First ==originalOrder->getElement ( i-1 )->First )
			{
				numberOfIdenticalValues++;
				total=total+orderedResult->getElement ( i );
			}
			else
			{
//cout << "i is:" << i << "\n";
				if ( numberOfIdenticalValues>1 )
					for ( int i2=i-1; i2>= ( i-numberOfIdenticalValues ); i2-- )
					{
						( *orderedResult ) [i2]=total/numberOfIdenticalValues;
					}
				numberOfIdenticalValues=1;
				if ( i<originalOrder->size() )
					total=orderedResult->getElement ( i );;
			}
		}
		zap ( originalOrder );
		for ( int i=0; i<orderedResult->size(); i++ )
			result->insertElement ( orderedResult->getElement ( ( int ) newOrder->getElement ( i )->Second ) );

		for ( int i=0; i<nanPositions->size(); i++ )
			result->insertElementAtPos ( std::numeric_limits<double>::quiet_NaN(), nanPositions->getElement(i) );
		zap ( newOrder );
		zap ( orderedResult );
zap(nanPositions);
		return result;
	}
	/*______________________________________________________*/
	/*
		ostream& operator<< ( ostream& out, Spearman& l )
		{
			out << "First list of values: " << *l.firstList <<"\n";
			out << "First list of ranks: "  << *l.firstRankList <<"\n";
			out << "Second list of values: "<< *l.secondList <<"\n";
			out << "Second list of ranks: "  << *l.secondRankList <<"\n";
			return out;
		}

		/*______________________________________________________*/

	double Spearman::getMeasure()
	{
		if ( measure==-2 ) setMeasure();
		return measure;
	}

	/*______________________________________________________*/

	double Spearman::getStatistic()
	{
		return getMeasure();
	}


	/*______________________________________________________*/
/*
	double Spearman::getBestPVal()
	{
		//if ( counts->getPermutations() ==NULL ) return getStatistic();
		double mini=1, current;
		Spearman* c;
		for ( int i=0; i<counts->getTotalSecondVars();i++ )
		{
			c=new Spearman ( ( BivariateCountsAlongSecondVar* ) counts, i, 0 );
			current=c->getPVal();
			if ( current  < mini ) mini=current;
			zap ( c );
		}
		return mini;
	}

	/*______________________________________________________*/

	double Spearman::getBestStatistic ( SampleGenericCounts* counts, doubleList** arrayOfSecondRankList, intList* ties2List, intList* hasMissing )
	{
		//if ( counts->getPermutations() ==NULL ) return getStatistic();
		double maxi=0, current;
		Spearman* c;
		for ( int i=0; i<counts->getTotalSecondVars();i++ )
		{
//if (i%1000==0)
//cout << "getting statistic value for permutations in snp " << i <<"\n";
			c=new Spearman ( ( BivariateCountsAlongSecondVar* ) counts, i, arrayOfSecondRankList, ties2List, hasMissing, 0, NULL);
	current=fabs ( c->getMeasure() );
			if ( current  > maxi ) maxi=current;
			zap ( c );
		}
		return maxi;
	}

	/*______________________________________________________*/

	double Spearman::getWorstStatistic(SampleGenericCounts* counts, doubleList** arrayOfSecondRankList, intList* ties2List, intList* hasMissing)
	{
		//if ( counts->getPermutations() ==NULL ) return getStatistic();
		double mini=MAXFLOAT, current;
		Spearman* c;
		cout << "total vars:" << counts->getTotalSecondVars() <<"\n";
		cout << "permuted expressions: " << * ( ( BivariateCountsAlongSecondVar* ) counts )->firstVarList <<"\n";
		for ( int i=0; i<counts->getTotalSecondVars();i++ )
		{
			c=new Spearman ( ( BivariateCountsAlongSecondVar* ) counts, i, arrayOfSecondRankList, ties2List, hasMissing);
			current=fabs ( c->getMeasure() );
			cout << "statistics in permutation x for second var at pos: " << i <<": " << current <<"\n";
			if ( current  < mini ) mini=current;
			zap ( c );
		}
		return mini;
	}
	/*______________________________________________________*/

	double Spearman::getMeanD()
	{
		double result=0;
		if ( firstRankList==NULL || secondRankList==NULL )
			throw NullValue ( "double Spearman::getMeanD()" );
		double n=firstRankList->size();
		for ( int i=0; i<n;i++ )
			result=result+firstRankList->getElement ( i ) +secondRankList->getElement ( i );
		double n3const=n* ( n*n-1 ) /3;
		return ( n3const-result/3 ) /2;
	}

	/*______________________________________________________*/

	double Spearman::getStdD()
	{
		double x=0, y=0;
		if ( firstRankList==NULL || secondRankList==NULL )
			throw NullValue ( "double Spearman::getMeanD()" );
		double n=firstRankList->size();
		for ( int i=0; i<n;i++ )
		{
			x=x+firstRankList->getElement ( i );
			y+=secondRankList->getElement ( i );
		}
		double n3const=n* ( n*n-1 ) /3;
		return sqrt ( ( n3const/2-x/3 ) * ( n3const/2-y/3 ) / ( n-1 ) );
	}

	/*______________________________________________________*/

	void Spearman::setMeasure()
	{
		try
		{
   doubleList*X=actualFirstRankList, *Y=actualSecondRankList;
   if (actualFirstList==NULL)
  {
X=firstRankList;
Y=secondRankList;
}


			Pearson* pearson;
			if ( Y==NULL ) throw NullValue();
			double d2=0, n=firstRankList->size(), actualSize=0;
			for ( int i=0; i<X->size(); i++ )
  //  if (!isNAN(firstRankList->getElement ( i )) && !isNAN(secondRankList->getElement ( i )))
{
				d2=d2+std::pow ( X->getElement ( i )-Y->getElement ( i ),2 );
actualSize++;
}
			double n3const=n* ( n*n-1 ) *3;
//measure=1-(6*d2)/(n*(n*n-1));

			if ( !ties1 && !ties2 ) measure=1-3* ( 6*d2 ) /n3const;
			else
			{
//cout <<*this <<"\n";
				pearson=new Pearson ( X, Y, (int)actualSize );
				measure=pearson->getMeasure();

				double meanD = getMeanD();
				double stdD = getStdD();
				double r= ( meanD - d2 ) / ( sqrt ( actualSize-1 ) *stdD );


//if (measure!=(1-3*(6*d2)/n3const))
//cout << "pearsonMeasure is: " << measure << " ehile we had " << (1-3*(6*d2)/n3const) <<"\n";
//exit(0);
// t = Inf*sign(r);
// p= 2*tcdf(-abs(t),n-2);2 sides
// p = tcdf(-t,n-2);// right
// p = tcdf(t,n-2); // left
				zap ( pearson );
			}

		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from void Spearman::setMeasure()" ); throw;};

	}


	/*______________________________________________________*/

	double Spearman::getPVal()
	{
		double pVal;


		if ( measure==-2 ) measure=getMeasure();
		double t=measure*sqrt ( ( firstRankList->size()-2 ) / ( 1-measure*measure ) );
//cout << " t is: " << t << " and p val is: " << tStudent(t, firstRankList->size()-2) <<"\n";
		if ( ties1 || ties2 )
			pVal= tStudent ( t, firstRankList->size()-2 );
		else pVal=-1; //throw NonImplemented ( "double Spearman::getPVal()" ); // algorithm AS89 }


		if ( !permutations ) return pVal;
// permutations
		else
		{
			//cout <<"measure with perms is:" << this->getName() <<"\n";
			double result=1;
			doubleList* null=new doubleList();
			//	double* nullArray;
			if ( counts->getPermutations() ==NULL )
				counts->setPermutations();
			if ( nullArray==NULL )
			{
//cout << "total perms:"<< counts->getTotalPermutations() <<"\n";
				for ( int i=0; i<counts->getTotalPermutations(); i++ )
				{
					//if ( i%100==0 )  cout <<"spearman, permutation " << i+1 <<"\n";

					if ( i%100==0 )
						cout << "computing best statistic for permutation " << i+1 << " out of " << counts->getTotalPermutations() << "\n";
					null->insertElement ( fabs ( Spearman::getBestStatistic ( counts->getPermutations() [i], arrayOfSecondRankList, ties2List, hasMissing ) ) );
				}
				null->sort();
				nullArray=null->getTable();
				zap ( null );
//  cout <<*null <<"\nwhile real pvalue is:" << pVal <<"\n";
			}
//else cout << "null distribution alrady estimated using permutations\n";
//cout << "getting permuted p val\n";
			result=getPValue ( nullArray, counts->getTotalPermutations(),fabs ( getMeasure() ) );
//cout <<"finalkresultinSpear:" << result <<"\n";

			//		zaparr ( nullArray );
			return result; //counts->getTotalSecondVars();
		}
	}

	/*_____________________________________________________________*/
	/*
		double Spearman::getPVal()
	  {
	  //cout <<"measure with perms is:" << this->getName() <<"\n";
	  double result=1;
	  doubleList* null=new doubleList();
	  double* nullArray;
	 GenericMeasure* gm;
	  if (geneticCounts->getPermutations()==NULL)
	  genericCounts->setPermutations();


	  for (int i=0; i<genericCounts->getTotalPermutations(); i++)
	  {
	  //if (i%10==0)  cout <<"permutation " << i <<"\n";
	   gm=getNewMeasure(genericCounts->getPermutations()[i]);
	   null->insertElement(gm->getStatistic());
	   zap(gm);
	  }
	  null->sort();
	//  cout <<*null <<"\nwhile real value is:" << getStatistic() <<"\n";
	  nullArray=null->getTable();
	  result=getPValue(nullArray, tuCounts->getTotalPermutations(), getStatistic());
	  zap(null);
	  zaparr(nullArray);
	  return result;
	  }


	/*______________________________________________________*/


}
#endif
