
#ifndef __Spearman_h__
#define __Spearman_h__

namespace BIOS
{
	class SampleGenericCounts;

class BivariateCountsAlongSecondVar;

	class Spearman: public GenericMeasure
	{
		protected:
			doubleList* firstList, *secondList, *firstRankList, *secondRankList, *actualFirstRankList, *actualSecondRankList, *actualFirstList, *actualSecondList;
			double measure;
			bool ties1, ties2;
			int secondVarPos;
   doubleList** arrayOfSecondRankList;
  intList* ties2List, *hasMissing;
  

		protected:
			doubleList* getRankingList();
			double getMeanD();
			double getStdD();

		public:

	double* nullArray;
			//Spearman ( doubleList* firstList, doubleList* secondList, int totalPermutations );

	Spearman ( BivariateCountsAlongSecondVar* bvCounts, int secondVarPos, doubleList**arrayOfSecondRankList, intList* ties2List, intList* hasMissing, bool permutations=0, double* nullArray=NULL );

Spearman(Spearman& other);
			~Spearman();

			static bool ties ( doubleList* rankList );
			void setSecondList ( doubleList* valueList );
			void setFirstRankingList();
			void setSecondRankingList();
			static doubleList* setRankingList ( doubleList*  valueList );
			double getMeasure();
			double getStatistic();

//			virtual double getBestPVal();
			static double getBestStatistic(SampleGenericCounts* counts, doubleList** arrayOfSecondRankList, intList* ties2List, intList* hasMissing);
	static double getWorstStatistic(SampleGenericCounts* counts, doubleList** arrayOfSecondRankList, intList* ties2List, intList* hasMissing);
			void setMeasure();
			double getPVal();
			Spearman* clone();
			virtual GenericMeasure* getNewGenericMeasure ( SampleGenericCounts* genericCounts, SampleGenericCounts** training=NULL, SampleGenericCounts** test=NULL );

			virtual GenericMeasure* inferGenericMeasure ( SampleGenericCounts* genericCounts ) ;

//    virtual SampleGenericCounts* getCounts(char* filename, int totalPermutations, int* pos, int size)=0;


			virtual MeasureResults* getResults();

			virtual stringList* getHeadFile();

			virtual string getName();


			virtual  GenericMeasure* fromString ( string s );

virtual void print ( ostream& );

void removeNans();


			virtual GenericMeasure* getNewMeasure ( SampleGenericCounts* genericCounts, SampleGenericCounts** training=NULL, SampleGenericCounts** test=NULL );
			//friend ostream& operator<< ( ostream& out, Spearman& l );
	};
}
#endif
