
      #include <math.h>


#ifndef __beta_cpp__
#define __beta_cpp__

/*********************************************************************
   Returns the beta distribution
   From "Numerical recipes in c"        
*********************************************************************/
namespace BIOS {



double beta(double z, double w) 
//  Returns the value of the beta function B(z, w).
{
return exp(gammln(z)+gammln(w)-gammln(z+w));	
};


double betai(double a, double b, double x)
{
try
{
double bt;
if (x < 0.0 || x > 1.0) throw BadFormat("betai");
if (x== 0.0 || x == 1.0) bt=0.0;
else bt=exp(gammln(a+b)-gammln(a) -gammln(b) + a*log(x)+b*log(1.0-x));
if (x<(a+1.0)/(a+b+2.0)) return bt*betacf(a,b,x)/a;
else return 1.0-bt*betacf(b,a,1.0-x)/b;
}
catch ( BasicException& be ) {be.addMessage ( "\ncalled from double betai(double a, double x)" ); throw;};
}
#define MAXIT 100
#define EPS 3.0e-7
#define FPMIN 1.0e-30
double betacf(double a, double b, double x)
{
try
{
int m, m2;
double aa, c, d, de1, h, qab, qam, qap;
qab=a+b;
qap=a+1.0;
qam=a-1.0;
c=1.0;
d=1.0-qab*x/qap;
if (fabs(d) < FPMIN) d=FPMIN;
d=1.0/d;
h=d;
for (m=1; m<MAXIT;m++)
{
m2=2*m;
aa=m*(b-m)*x/((qam+m2)*(a+m2));
d=1.0+aa*d;
if (fabs(d)<FPMIN) d=FPMIN;
c=1.0+aa/c;
if (fabs(c)<FPMIN) c=FPMIN;
d=1.0/d;
h*=d*c;
aa=-(a+m)*(qab+m)*x/((a+m2)*(qap+m2));
d=1.0+aa*d;
if (fabs(d) < FPMIN) d=FPMIN;
c=1.0+aa/c;
if (fabs(c)<FPMIN) c=FPMIN;
d=1.0/d;
de1=d*c;
h*=de1;
if (fabs(de1-1.0) < EPS) break;
}
if (m>MAXIT) throw OutOfBounds(m, MAXIT);
return h;
}
catch ( BasicException& be ) {be.addMessage ( "\ncalled from double betacf(double a, double x)" ); throw;};
}
};

#endif
