
#ifndef __WeightedChiSquared_c__
#define __WeightedChiSquared_c__

namespace BIOS
{

  
/*_______________________________________________________________*/
/*
double pdfWeightedChiSquared(double x, int df)
{
// is this corrent? 
double h=df/(double)2;
if (x<=0) return 0.0;
return (std::pow(x, h-1)*exp(-x/2))/(std::pow(2,h)*gamma(h));
}

/*_______________________________________________________________*/

double pdfTestWeightedChiSquare(double x, doubleList* weights) 
//Approximation by Gabler & Wolff 86
// it computes an approximation of p value p(w>x), with w being the weighted chi square distribution, weight vector and df degrees of freedom:
//pr(sum weight*x_i^2 > x) where x_i ~N(0,1) and sum weights=1
// computes as the maximum between 1-sum d_i * gammai(1/(2d_i), x/(2d_i) and pdfchi^2(weights->size()) for x/(prod d_i)^(1/n) 
{
 double result=0, dZero, H, delta;
 double DS=1;
 // it computes G(x)
double totalWeights=0;
 for (doubleList::iterator it=weights->begin(); it<weights->end(); it++)
 if (weights->getElement(it)!=0)
 {
 dZero=0.5/weights->getElement(it);
 result=result+weights->getElement(it)*gammai(dZero, x*dZero);
 DS=DS*weights->getElement(it);
totalWeights=totalWeights+weights->getElement(it);
 }
if (totalWeights>(1+zero) || totalWeights<(1-zero))
 throw NonProb("pdfTestWeightedChiSquare", totalWeights); 
if (result<(1+zero) && result>(1-zero)) 
result=0;
else result=1-result;
 // it computes H(x)
H=pdfTestChiSquare(x/std::pow(DS, 1/(double)weights->size()), weights->size());
if (H>(result+zero)) result=H;
return result;
}
/*_______________________________________________________________*/

double pdfTestWeightedChiSquareTDT(double x, doubleList* weights)
//Approximation by Gabler & Wolff 86
// it computes an approximation of p value p(w>x), with w being the weighted chi square distribution, weight vector and df degrees of freedom:
//pr(sum weight*x_i^2 > x) where x_i ~N(0,1) and sum weights=1
// computes as the maximum between 1-sum d_i * gammai(1/(2d_i), x/(2d_i) and pdfchi^2(weights->size()) for x/(prod d_i)^(1/n) 
{

 double result=0, dZero, H, delta;
 double DS=1;
double tdtCorrection=(weights->size()-1)/(double)weights->size();
 
 // it computes G(x)
double totalWeights=0;
//cout << "weights:" << *weights <<"\n";
 for (doubleList::iterator it=weights->begin(); it<weights->end(); it++)
 if (weights->getElement(it)!=0)
 {
 dZero=tdtCorrection*(0.5/weights->getElement(it));
 result=result+weights->getElement(it)*gammai(dZero, x*dZero);
 DS=DS*weights->getElement(it);
totalWeights=totalWeights+weights->getElement(it);
 }
if (totalWeights>(1+zero) || totalWeights<(1-zero))
if (totalWeights==0) return 1;
else throw NonProb("pdfTestWeightedChiSquareTDT", totalWeights); 
//cout << "result in chi:" << result <<"\n";
if (result<(1+zero) && result>(1-zero)) 
result=0;
else result=1-result;
 // it computes H(x)
//cout << "result2 in chi:" << result <<"\n";
H=pdfTestChiSquare(x*tdtCorrection/std::pow(DS, 1/(double)weights->size()), weights->size()-1);
//cout << "result H in chi:" << H <<"\n";
if (H>(result+zero)) result=H;//H never used as result is always larger or equal than H

//cout << "result  final in chi:" << result <<"\n";
return result;
}
/*_______________________________________________________________*/

double pdfTestWeightedChiSquareTDT2(double x, doubleList* weights)
//Approximation by Gabler & Wolff 86
// it computes an approximation of p value p(w>x), with w being the weighted chi square distribution, weight vector and df degrees of freedom:
//pr(sum weight*x_i^2 > x) where x_i ~N(0,1) and sum weights=1
// computes as the maximum between 1-sum d_i * gammai(1/(2d_i), x/(2d_i) and pdfchi^2(weights->size()) for x/(prod d_i)^(1/n) 
{
 double result=0, dZero, H, delta;
 double DS=1;
double tdtCorrection=1; //;
 
 // it computes G(x)
double totalWeights=0;

 for (doubleList::iterator it=weights->begin(); it<weights->end(); it++)
 if (weights->getElement(it)!=0)
 {
 dZero=tdtCorrection*(0.5/weights->getElement(it));
 result=result+weights->getElement(it)*gammai(dZero, x*dZero);
 DS=DS*weights->getElement(it);
totalWeights=totalWeights+weights->getElement(it);
 }
if (totalWeights>(1+zero) || totalWeights<(1-zero))
 throw NonProb("pdfTestWeightedChiSquareTDT", totalWeights); 
if (result<(1+zero) && result>(1-zero)) 
result=0;
else result=1-result;
 // it computes H(x)
H=pdfTestChiSquare(x*tdtCorrection/std::pow(DS, 1/(double)weights->size()), weights->size()-1);
if (H>(result+zero)) result=H;//H never used as result is always larger or equal than H
return result;
}
/*_______________________________________________________________*/
/*
double pdfTestWeightedChiSquare2(double x, doubleList* weights, int df)
// it computes an approximation of p value given x (weighted chi square value), weight vector and df degrees of freedom:
//pr(sum weight*x_i^2 > x) where x_i ~N(0,1) and sum weights=1
// computes as the maximum between 1-sum d_i * gammai(1/(2d_i), x/(2d_i) and pvalue of chi^2(weights->size()) for x/(prod d_i)^(1/n) 
{

 double result=0, dZero, G, delta;
 double DS=1;
 
 // it computes G(x)
 for (doubleList::iterator it=weights->begin(); it<weights->end(); it++)
 {
 dZero=0.5/weights->getElement(it);
 result=result+weights->getElement(it)*gammai(dZero, x*dZero);
 DS=DS*weights->getElement(it);
 }
 return 1-result;
}
/*_______________________________________________________________*/
/*
double cdfWeightedChiSquared(double x, int df)
{
double h=df/(double)2;
return BIOS::gammai(h,x/2)/(h);
}

/****************************************************************************/
/*
double weightedChiTest (double* observed, double*expected, int df)
// it computes p value given the df+1 absolute frequencies and the df+1 expected values
{
double chi=0;
for (int i=0;i<=df;i++)
{
if (expected[i]==0) throw NanValue("chiTest");
 chi=chi+std::pow(observed[i]-expected[i],2)/expected[i];
}
return pdfTestWeightedChiSquared(chi, df);
}

/****************************************************************************/

}
#endif
