#ifndef __AssociationTable_cpp__
#define __AssociationTable_cpp__


namespace BIOS
{



	AssociationTable::AssociationTable ( int cols, double minFreq, bool HWE) :BidimensionalTable<double> ( 2,cols )
	{
		partition = NULL;
		this->minFreq=minFreq;
		this->HWE=HWE;
	};



	/*_____________________________________________________________________________________________________________*/


	AssociationTable::AssociationTable ( const AssociationTable& other ) :BidimensionalTable<double> ( ( BidimensionalTable<double>& ) other )
	{
		partition=NULL;
		if ( other.partition!=NULL ) partition = other.partition->clone();
		this->minFreq=other.minFreq;
		this->HWE=other.HWE;
	};

	/*_____________________________________________________________________________________________________________*/
/*

	AssociationTable* AssociationTable::clone()
	{
		return new AssociationTable ( *this );
	}


	/*_____________________________________________________________________________________________________________*/


	AssociationTable::~AssociationTable()
	{
		empty();
	}

	

	/*_____________________________________________________________________________________________________________*/



	AssociationTable::AssociationTable ( VectorSample<GeneticUnitCounts*>::Class * countsPartition, int totalRows, double minFreq, bool HWE)
			:BidimensionalTable<double> ( totalRows, countsPartition->size() )
	{
		try
		{
			this->partition=NULL;
			if ( countsPartition==NULL ) throw NullValue ( " AssociationTable::AssociationTable (Container<vector<HaplotypeCountsList*>, HaplotypeCountsList*>* partition, double minFreq, bool HWE)" );
			this->minFreq=minFreq;
			this->HWE=HWE;	
			Vector<GeneticUnit*>::Class* hs;
			this->partition=new GeneticUnitSample ( '\t', '[',']' );
			Vector<GeneticUnitCounts*>::Class * hv; // it could be HaplotypeTUCountsVector, or HaplotypeCaseControlList or GenotypeCaseControlList
			GeneticUnitCounts* hc;
			for ( VectorSample<GeneticUnitCounts*>::Class::iterator it=countsPartition->begin(); it<countsPartition->end(); it++ )
			{
				hs=new GeneticUnitVector ( '\t', '[',']' );
				hv=countsPartition->getElement ( it );
				for ( Vector<GeneticUnitCounts*>::Class::iterator it2=hv->begin(); it2<hv->end(); it2++ )
				{
					hc=hv->getElement ( it2 );
					hs->insertHardElement ( hc->getGeneticElement() );
					addValue ( 0, countsPartition->getPosition ( it ), hc->getFirstFrequency() );
					addValue ( 1, countsPartition->getPosition ( it ), hc->getSecondFrequency() );
					if (getXDim()==3) addValue ( 2, countsPartition->getPosition ( it ), hc->getThirdFrequency() );
				}
				if ( hs->size() >0 ) this->partition->insertElement ( hs );
			}


			if ( !HWE && getTotalRowCount ( 2 ) ==0 ) emptyAll();
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from AssociationTable::AssociationTable ( Container<vector<HaplotypeCountsList*>, HaplotypeCountsList*>* partition, double minFreq, bool HWE )" ); throw;};

	};




	/*_____________________________________________________________________________________________________________*/


	AssociationTable::AssociationTable (Vector<GeneticUnitCounts*>::Class * p, int totalRows, double minFreq, bool HWE ):BidimensionalTable<double> ( totalRows,p->size() )
	{
// p will be HaplotypeTUCountsVector, HaplotypeCaseControlCountsVector or GenotypeCaseControlCountsVector
		// *positions and length are not used and they should be removed.
	try
		{
		  
//		  cout << "creating table from "<< *p <<"\n";
			this->partition=NULL;
			if ( p==NULL ) throw NullValue ( "AssociationTable::AssociationTable ( HaplotypeCountsList * p, int* positions, int length, double minFreq, bool HWE )" );
//cout << "current is:" << *this <<"\n";
			this->minFreq=minFreq;
			this->HWE=HWE;
			 Vector<GeneticUnit*>::Class* hs;
			this->partition=new GeneticUnitSample ( '\t', '[',']' );

			GeneticUnitCounts* hc;
			GeneticUnit* h;
//cout <<"creating table from vector of hapcounts: "  << *p << endl;
			for (   Vector<GeneticUnitCounts*>::Class::iterator it=p->begin(); it<p->end(); it++ )
			{
				hs= new GeneticUnitVector ( '\t', '[',']' );
				hc=p->getElement ( it );
				hs->insertHardElement ( hc->getGeneticElement() );
//cout << "hs is:" << *hs <<"\n";
//cout << "will be added at position " <<  p->getPosition ( it ) << "the value: " << hc->getFirstFrequency() << " and " <<  hc->getSecondFrequency() << " and " << hc->getThirdFrequency() << endl;
				addValue ( 0, p->getPosition ( it ), hc->getFirstFrequency() );
				addValue ( 1, p->getPosition ( it ), hc->getSecondFrequency() );
				if (getXDim()==3) addValue ( 2, p->getPosition ( it ), hc->getThirdFrequency() );
				partition->insertElement ( hs );
//cout << "after inserting in partition\n";
			}
//			cout << "at the end is:";
//			cout << this->BidimensionalTable<double>::print() <<"\n";
//cout <<"total row counts is: " << getTotalRowCount () << endl;
if ( !HWE && getTotalRowCount () ==0 ) 
{
  //cout << "emptyall\n";
  emptyAll();
}
			
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from AssociationTable::AssociationTable(HaplotypeCountsList * p, int* positions, int length, double minFreq, bool HWE)) " ); throw;};
	};

/*______________________________________________________________________________________________*/

double AssociationTable::getTotalUsedGenotypes()
{
return (getTotalFirstRow()+getTotalSecondRow())/2;
}

	/*______________________________________________________________________________________________*/


	AssociationTable* AssociationTable::getFilteredTable()
	{
// for !HWE it removes those columns that does not have any T or U transmission at all or is under minFreq
		try
		{
			int totalColumns=this->getYDim();

			for ( int i=0; i<this->getYDim(); i++ )
				if ( ( !HWE && ( getColumnCount ( i ) ==0 || getColumnCount ( i ) <minFreq ) ) || ( HWE && ( getValue ( 2,i ) ==0 || getValue ( 2,i ) <minFreq ) ) )
					totalColumns--;
			if ( totalColumns==0 ) return NULL;
			if ( totalColumns<0 ) throw OutOfRange<int> ( totalColumns, "AssociationTable<T>* AssociationTable<T>::getFilteredTable()" );
//return NULL;
			AssociationTable* result=this->createEmptyTable ( totalColumns );
			result->partition=new GeneticUnitSample ( '\t', '[',']' );
			int pos=0;
			for ( int j=0; j<getYDim(); j++ )
				if ( ( !HWE && getColumnCount ( j ) >0 && getColumnCount ( j ) >=minFreq ) || ( HWE && ( getValue ( 2,j ) >0 && getValue ( 2,j ) >=minFreq ) ) )
				{
					result->partition->insertHardElement ( this->partition->getElement ( j ) );
					for ( int i=0; i<getXDim(); i++ )
						result->setValue ( i, pos, getValue ( i, j ) );
					pos++;
				}
			if ( pos!=totalColumns ) throw OutOfBounds ( totalColumns, pos, "AssociationTable::getFilteredTable(int minFreq, bool HWE)" );
			return result;
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from AssociationTable* AssociationTable::getFilteredTable()) " ); throw;};
	};

	/*__________________________________________________________________________________________*/


	void AssociationTable::empty()
	{
//cout << "partition removed\n";
		zap ( partition );
	}

	/*__________________________________________________________________________________________*/


	void AssociationTable::emptyAll()
	{
		empty();// zap partition
		BidimensionalTable<double>::empty();
		MultidimensionalTable<double>::empty(); // zap table
		MultidimensionalEmptyTable<double>::empty(); // zap dimensionList
	}
	/*__________________________________________________________________________________________*/


	void AssociationTable::filter()
	{
		try
		{
if (partition==NULL) 
{
  //cout<< "partition is null\n";
  return;
}
//cout << "filtering\n";
			if (partition->size() ==0 )  {emptyAll(); return;};
			AssociationTable* f=this->getFilteredTable();
			if ( f==NULL ) {emptyAll(); return;}
			//  if (partition==NULL) return;
			zap ( this->partition );
			this->partition=f->partition->clone();

			reset ( f->getXDim(), f->getYDim() );

			for ( int i=0; i<f->getXDim();i++ )
				for ( int j=0; j<f->getYDim();j++ )
					setValue ( i,j,f->getValue ( i,j ) );
//cout <<"this dedddis:\n";
//cout <<* this <<"\n";
			zap ( f );
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from void AssociationTable::filter()) " ); throw;};
	}





	/*_____________________________________________________________*/


		void AssociationTable::update ( SampleGeneticCounts* sampleCounts, bool useDistances, bool treeDT, int position, bool toLeft )
		{
			try
			{
				double firstRow, secondRow;
				Vector<GeneticUnitCounts*>::Class* counts=sampleCounts->getCountsVector(); // abstract method

				AssociationTable* oldData=this->clone();
				initialize(); // set table counts to 0
				//cout <<"current table should have all cells 0: " << *this << end;
				double minDistance=-1, tempMin;
				int selectedPos;
				intSet* minPos, *minPos2;
				GeneticUnit* h, *closestH;
				double cases, controls;
				GeneticUnitCounts* element;
				//cout <<"updating\n";
				//cout <<"new vals are: " << *counts <<"\n";
				for ( Vector<GeneticUnitCounts*>::Class::iterator it=counts->begin(); it!=counts->end(); it++ )
				{
					element=counts->getElement ( it );
					h=element->getGeneticElement ();
					firstRow=element->getFirstFrequency();
					secondRow=element->getSecondFrequency();
					if ( h!=NULL )
					{
						minPos=oldData->partition->getPositionsWithInternalMinDistance ( h, position, toLeft );

						selectedPos=minPos->getElement ( rand() %minPos->size() );
						if ( !useDistances || treeDT )
						{
						 // cout << "we should not be here\n";
							minPos2=oldData->partition->getElement ( selectedPos )->getPositionsWithMinDistance ( h , position, toLeft );
							closestH=oldData->partition->getElement ( selectedPos )->getElement ( minPos2->getElement ( 0 ) );
							if ( !useDistances )
								if ( h->getDistance ( closestH, -1 ) !=0 )
									selectedPos=rand() %oldData->partition->size(); // not exactly the same haplotype
							zap ( minPos2 );
						}
						addValue ( 0, selectedPos, firstRow );
						addValue ( 1, selectedPos, secondRow );
						zap ( minPos );
					}
				}
				delete oldData;
				//cout << "after udating is: " << *this << endl;
				//exit(0);
			}
			catch ( BasicException& be ) {be.addMessage ( "\ncalled from  template <> void AssociationTable<HaplotypeCaseControlCountsVector>::update ( SampleGeneticCounts<T>* hapCounts, bool useDistances, bool treeDT, int position, bool toLeft )" ); throw;};
		}

		/*_____________________________________________________________*/
/*

	 void AssociationTable::update2 ( VectorOfParentalHaplotypes* parentalHaplotypesList, bool useDistances, bool treeDT, int position, bool toLeft )
	{
		try
		{
int currentYDim=getYDim();
			//BIOS::print (parentalHaplotypesList->getPositions(), parentalHaplotypesList->getLength());
			//exit(0);
			AssociationTable* oldData=this->clone();
			initialize(); // set table counts to 0
			double minDistance=-1, tempMin;
			int selectedPosT, selectedPosU;
			intSet* minPosT, *minPosU, *minPosT2, *minPosU2;
			Haplotype* ht, *hu, *closestHt, *closestHu;
			ParentalHaplotypesUsingPointers* element;
				BidimensionalTable<double>::empty(); // zaparr(table);
				MultidimensionalTable<double>::set(); // create an empty table
			//oldData->partition->print();
			//PartitionAsSetSampleOfHaplotypes::iterator posT, posU;
//cout <<"list:" << *parentalHaplotypesList <<"\n";
			for ( VectorOfParentalHaplotypes::iterator it=parentalHaplotypesList->begin(); it!=parentalHaplotypesList->end(); it++ )
			{
				element=parentalHaplotypesList->getElement ( it );
				for ( int parent=0; parent<2;parent++ )
				{
					ht=element->getHap ( parent, t );
					hu=element->getHap ( parent, u );
					if ( ht!=NULL && hu!=NULL )
					{
						minPosT=oldData->partition->getPositionsWithInternalMinDistance ( ht, position, toLeft );
//cout << "haploT: " << * ht << " is closest to one in partitions: " << *minPosT <<"\n";
						minPosU=oldData->partition->getPositionsWithInternalMinDistance ( hu, position, toLeft );
//cout << "haploU: " << * hu << " is closest to one in partitions: " << *minPosU <<"\n";

						//selectedPosT=minPosT->getElement ( rand() %minPosT->size() );
			   //selectedPosU=minPosU->getElement ( rand() %minPosU->size() );
						selectedPosT=minPosT->getElement( 0 );
						selectedPosU=minPosU->getElement( 0 );
						if ( !useDistances || treeDT )
						{
							minPosT2=oldData->partition->getElement ( selectedPosT )->getPositionsWithMinDistance ( ht , position, toLeft );
							minPosU2=oldData->partition->getElement ( selectedPosU )->getPositionsWithMinDistance ( hu , position, toLeft );
							closestHt=oldData->partition->getElement ( selectedPosT )->getElement ( minPosT2->getElement ( 0 ) );
							closestHu=oldData->partition->getElement ( selectedPosU )->getElement ( minPosU2->getElement ( 0 ) );
							if ( !useDistances )
							{
								if ( ht->getDistance ( closestHt, -1 ) !=0 )
									selectedPosT=rand() %oldData->partition->size(); // not exactly the same haplotype
								if ( hu->getDistance ( closestHu, -1 ) !=0 )
									selectedPosU=rand() %oldData->partition->size(); // not exactly the same haplotype
							}
							zap ( minPosT2 );
							zap ( minPosU2 );
						}
						if ( ( minPosT->size() ==1 && minPosU->size() ==1 && selectedPosT !=selectedPosU ) || ( treeDT && closestHt!=closestHu ) ) // only hetero
						{
							addValue ( 0, selectedPosT, 1 );
							addValue ( 1, selectedPosU, 1 );
						}
						else addValue ( 2, selectedPosT, 2 );

//cout << *this <<"\n";
						zap ( minPosT ); zap ( minPosU );
					}
				}
			}
			delete oldData;
			//filter();// those partitions with no hetero genotypes will be removed
if (getYDim()!=currentYDim)  throw OutOfBounds ( getYDim(), currentYDim, "AssociationTable::update2* weights)" );

		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from  void AssociationTable::update (VectorOfParentalHaplotypes* parentalHaplotypesList)" ); throw;};
	}
	
		
	/*___________________________________________________________________________________________*/



	/*_____________________________________________________________*/

	
		double AssociationTable::getPVal()
	  {
//cout << "here:" <<pdfTestChiSquare(getStatistic(),getYDim()) <<"\n";
	//cout <<"dinn\n";
	//cout <<"p val for st:" << getStatistic() <<" is: " << pdfTestChiSquare(getStatistic(),getYDim()-1) << "\n";
	  return pdfTestChiSquare(getStatistic(),getYDim()-1);
	  }

	/*___________________________________________________________________________________________*/



	double AssociationTable::getStatistic ( bool HWE )
	{
		if ( HWE ) throw BadFormat ( "double AssociationTable<HaplotypeCaseControlCountsVector>::getStatistic ( bool HWE )" );
		double sum=0;
		double observed, expected, prob, cases=getTotalFirstRow(), controls=getTotalSecondRow();
		double totalHaps=cases+controls;
		for ( int i=0; i<getYDim();i++ )
		{
			prob= ( getValue ( 0,i ) +getValue ( 1,i ) ) /totalHaps;
			observed = getValue ( 0,i ); // cases
			expected = prob*cases;
			//cout << "expected for cases and column " << i << " is: " << expected << endl;
			if ( expected>0 ) sum+=std::pow ( observed-expected, 2 ) /expected;

			observed = getValue ( 1,i ); // controls
			expected = prob*controls;
			//cout << "expected for controls and column " << i << " is: " << expected << endl;
			if ( expected>0 ) sum+=std::pow ( observed-expected, 2 ) /expected;			
		}
		//cout << "statistic for table:\n" << *this <<"\n is: " << sum << endl;
		return sum;
	};

	


	/*_____________________________________________________________*/

	doubleList* AssociationTable::getGeneticUnitFreqs()
	{
		doubleList* results=new doubleList();
		//if ( getTotalTransmissionCount ( ut ) ==0 )
		//	throw ZeroValue ( "AssociationTable::getHapFreqs()" );
		for ( int i=0; i<getYDim(); i++ )
			if ( getTotalRowCount ( 2 ) ==0 ) results->insertElement ( 0 );
			else results->insertElement ( ( getValue ( 0,i ) +getValue ( 1,i ) ) / ( double ) getTotalRowCount ( 2 ) );
//cout <<"size is: " << results->size() << " and size ydim is: " << getYDim() <<"\n";
		return results;
	}

	/*_____________________________________________________________*/


			doubleList* AssociationTable::getCounts ( int row )
	{
		doubleList* results=new doubleList();
		for ( int i=0; i<getYDim(); i++ )
			switch ( row )
			{
			case 0: case 1: results->insertElement ( getValue (row,i ) );break;
				case 2: results->insertElement ( getValue ( 0,i ) +getValue ( 1,i ) ); break;
			}
		return results;
	}

/*_____________________________________________________________*/

			doubleList* AssociationTable::getFreqs(int row)
	{
		doubleList* results=new doubleList();
		//if ( getTotalTransmissionCount ( ut ) ==0 )
		//	throw ZeroValue ( "TDTtable::getHapFreqs()" );
		double totalRowsCount= getTotalRowCount (  );
		for ( int i=0; i<getYDim(); i++ )
if ( totalRowsCount ==0 ) results->insertElement ( 0 );
else
switch ( row )
{
			case 0: case 1: results->insertElement ( getValue (row,i )/  totalRowsCount );break;
				case 2: results->insertElement ( getValue ( 0,i )/ totalRowsCount +getValue ( 1,i )/totalRowsCount); break;
			}
					return results;
	}


	/*_____________________________________________________________*/


	double AssociationTable::getColumnCount ( int genPos, int rowCode )
	{
		double result;
		switch ( rowCode )
		{
		case 0: case 1: result=getValue ( rowCode, genPos ); break;
			case 2: result=getValue ( 0, genPos ) +getValue ( 1,genPos ); break;
		}
		return result;
	}






	/*_____________________________________________________________*/


	double AssociationTable::getTotalRowCount ( int rowCode )
	{
// rowCode: 0 is first row, 1 is second row, 2 is both
if (rowCode<0 || rowCode> 2)
  throw OutOfBounds(rowCode, 2, "double AssociationTable::getTotalRowCount ( int rowCode )");
  double result=0;
for ( int i=0; i<getYDim(); i++ )
		switch ( rowCode )
		{
		case 0: case 1: result=result+getValue ( rowCode, i ); break;
			case 2: result=result+getValue ( 0, i )+getValue ( 1, i ); break;
		}
		return result;
	}


	


	/*_____________________________________________________________*/

/*
	double AssociationTable::getTotalRow ( int row )
	{
		double result=0;
		for ( int i=0; i<getYDim(); i++ )
			result=result+getValue ( row, i );
		return result;
	}

	/*_____________________________________________________________*/


	double AssociationTable::getTotalFirstRow ()
	{
		return getTotalRowCount ( 0 );
	}
	/*_____________________________________________________________*/


	double AssociationTable::getTotalSecondRow ()
	{
		return getTotalRowCount ( 1 );
	}



	/*_____________________________________________________________*/

	void  AssociationTable::print ( ostream& out )
	{
//cout <<"totaldims:" << l.getYDim();
		if ( partition!=NULL )
		{
			out << "\t" << *partition <<"\n";
			for ( int i=0; i<=getYDim();i++ )
				out <<"___\t";
			out <<"\n";
			for ( int tr=0; tr<getXDim(); tr++ )
			{
			//  cout << "row heading for row " << tr << endl;
				out << getRowHeading(tr);
				out <<"\t";
				for ( int i=0; i<getYDim();i++ )
				{
				  //cout << "cell value for cell " << tr << "-" << i << endl;
					out << getValue ( tr,i );
					if ( i< ( getYDim()-1 ) ) out <<"\t"; else out <<"\n";
				}
			}
		}
	}

/*_____________________________________________________________*/

	string  AssociationTable::getRowHeading (int i )
	{
	switch (i)
	{
	case 0: return  firstHeading(); break;
	case 1: return secondHeading(); break;
	case 2: return thirdHeading(); break;
	}
}

	
	/*_____________________________________________________________*/


	ostream& operator<< ( ostream& out, AssociationTable& l )
	{
//cout <<"totaldims:" << l.getYDim();
		l.print ( out );
		return out;
	}

	/*_____________________________________________________________*/

	int AssociationTable::findColumn ( GeneticUnit *h )
	{
// it returns the column position of the set of haplotypes where the haplotype h belongs to. -1 if not present

		return partition->getPosition ( partition->findElementContainingInternalElement ( h ) );
	}

/*_____________________________________________________________*/

bool  AssociationTable::operator==(AssociationTable& other) 
{throw NonImplemented("AssociationTable::operator==(TDTtable& other)");
};


	/*_____________________________________________________________*/

	void AssociationTable::copyFrequenciesTo ( VectorSample<GeneticUnitCounts*>::Class * p )
	{
		 Vector<GeneticUnitCounts*>::Class * hv;
		GeneticUnitCounts* hc;


		// for each haplotype in p
		for (  VectorSample<GeneticUnitCounts*>::Class::iterator it=p->begin(); it<p->end(); it++ )
		{
			hv=p->getElement ( it );
			for (  Vector<GeneticUnitCounts*>::Class::iterator it2=hv->begin(); it2<hv->end(); it2++ )
			{
				hc=hv->getElement ( it2 ); // <<- haplotype

				// Find haplotype in this
				int column = findColumn ( hc->getGeneticElement() );

				// copy frequencies
				if ( column != -1 )
				{
					hc->setFirstFrequency(getValue ( 0, column ));
					hc->setSecondFrequency(getValue ( 1, column ));
					if (getXDim()==2) hc->setThirdFrequency(getValue ( 2, column ));
				}

			}

		}


	}

	

		/*_____________________________________________________________*/

	void AssociationTable::twice()
	{
		for ( int i=0; i<getYDim();i++ )
		{

			for ( int k=0; k<3;k++ )
				setValue ( k, i, 2*getValue ( k, i ) );


		}
	}

};

#endif
