#ifndef __AssociationTable_h__
#define __AssociationTable_h__

namespace BIOS
{

	/**
	   @memo AssociationTable
	   @doc
	   Definition:
	  Table with
	  1. as many columns as genetic units (genotypes or haplotypes) and two rows to store T/U frequencies for trio samples and the TDT algorithm (columns in this case are haplotypes)  OR to store Case/Control haplotype/genotype frequencies for case/control samples

	   @author María M. Abad Grau
	   @version 1.0
	  
	  */




typedef VectorSample<GeneticUnitCounts*>::Class GeneticUnitCountsSample;
typedef VectorSample<GeneticUnit*>::Class GeneticUnitSample;
typedef Vector<GeneticUnitCounts*>::Class GeneticUnitCountsVector;
typedef Vector<GeneticUnit*>::Class GeneticUnitVector;


	class VectorOfParentalHaplotypes;
// typedef SingleAncestorGraph<DirectedArc, HaplotypeTUCounts*, void> TreeOfHaplotypeTUCounts;

	class AssociationTable: public BidimensionalTable<double>
	{


		protected:

			double minFreq;

			bool HWE;


		public:
			//! Vector of vector of geneticUnits (haplotypes or genotypes) from which the table is created
			GeneticUnitSample * partition;


			/**
			*	Constructor
			*/
			AssociationTable ( int cols, double minFreq=0, bool HWE=false );

			/**
			*	Destructor
			*/
			virtual	~AssociationTable();

			virtual AssociationTable* createEmptyTable(int totalColumns)=0;

			static AssociationTable* fromString ( string s ) {throw NonImplemented ( "static AssociationTable* fromString(string s)" );};

			virtual void empty();


	doubleList* getGeneticUnitFreqs();
			void emptyAll();

			AssociationTable ( const AssociationTable& other );

			/**
			*	Constructor from a vector of genetic unit counts
			* 	Creates a table from the T/U or Case/control data in a vector of haplotypes/genotypes.
			* It creates a partition with one haplotype/genotype at each haplotypeVector or genotypeVector in the partition
			*	The number of columns in the table will be the number of haplotypes in the vextor.
			*	The number of rows will be two. The first for the Transmitted haplotypes. The second for the Non transmitted.
			*	@param p HaplotypVector from which to fill the table
			*/

			AssociationTable (GeneticUnitCountsVector * genCounts, int totalRows=2, double minFreq=0, bool HWE=0);

/**
		*	Constructor from a partition
		* 	Creates a table from the genetic unit data in a partition
		*	The number of columns in the table will be the number of vectors (subsets) in countPartitions.
		*	The number of rows will be two or three. The first for the Transmitted/case haplotypes/genotypes. The second for the Non transmitted/control haplotypes/genotypes and the third for homozygous transmissions in TU data sets.
		*	@param p Partition from which to fill the table
		*/		
			AssociationTable(GeneticUnitCountsSample * countsPartition, int totalRows=2, double minFreq=0, bool HWE=0);

			virtual AssociationTable* clone()=0;
			
			virtual void removeSemiHomo(SampleGeneticCounts* hapCounts){};

			AssociationTable* getFilteredTable();

			virtual void update ( SampleGeneticCounts* counts, bool useDistances, bool treeDT, int position, bool toLeft );

			//virtual GeneticUnitCountsVector* getCountsVector(); 

			void filter();
			
			/**
			* Find the column containing genetic unit g
			* @param g genotype to be found in this table.
			* @return column in the table. -1 if not found
			*/
			int findColumn ( GeneticUnit *h );


			double getStatistic ( bool HWE=false );

			double getTotalRowCount ( int rowCode=2 );

			double getColumnCount ( int genPos, int rowCode=2 );

			double getTotalFirstRow();

			double getTotalSecondRow();
			
			virtual double getTotalUsedGenotypes();

  			doubleList* getCounts(int row=2);

doubleList* getFreqs(int row=2);

			//double getTotalRow ( int row );

			virtual void copyFrequenciesTo ( VectorSample<GeneticUnitCounts*>::Class * p );

			virtual bool operator== ( AssociationTable& other );

			void print ( ostream& out );

			void twice();

			string getRowHeading(int i);

			virtual string thirdHeading(){ return string("");};

			virtual string firstHeading()=0;

			virtual string secondHeading()=0;

virtual double getPVal();
	};




	ostream& operator<< ( ostream& out, AssociationTable& l );



};

#endif
