/* File: PhylogeneticDistance.h */

#ifndef __CaseControlCounts_h__
#define __CaseControlCounts_h__

//using namespace stats;

namespace BIOS {


/************************/
/* SNP'S MultimarkerMeasure DEFINITION */
/************************/


/**
        @memo TUCounters for a given window in a TrioSample

	@doc
        Definition:

       Class used mainly to compute multimarker TU measures. In order to similarity measures to can be applied, haplotype counters (or freqs if EM-freq is used) for each couple must be independently kept 

       With this purpose, the data structures required is:
 
       Container<vector, ParentalHaplotypes> *parentalHaps   

        @author Maria M. Abad
	@version 1.0
*/

class HapExtractionConfiguration;
class HaplotypeGeneticCountsVector;
class HaplotypeCaseControlCounts;

typedef Vector<HaplotypeCaseControlCounts*>::Class HaplotypeCaseControlCountsVector;
 
class	CaseControlCounts: public GeneticCounts {

private:


//GenericSample* genotypes; // genotype counters, required to compute permutations
CaseControlCounts** permutations;


public:


//HaplotypeCaseControlCountsVector* haplotypeCaseControlCountsVector; 



/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

private:


//void set(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations);  



      public:

CaseControlCounts();

//	CaseControlCounts(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, AlleleOrderType alleleOrderType=LeftRight, PhaseAlg=weighted, EMDistributions emDistributions=UTDistributions, EMRestriction emRestriction=triosBasedRestriction, int totalPermutations=100);

CaseControlCounts(int*pos, int length, HapExtractionConfiguration* hapExtractionConfiguration, HaplotypeCaseControlCountsVector* haplotypeCountsVector, int totalPermutations);


//CaseControlCounts(char* filename, HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations);
	
 CaseControlCounts(CaseControlCounts& source);
 
 
virtual CaseControlCounts* clone();

virtual ~CaseControlCounts();

void setPermutations();

};  // End of class CaseControlCounts








};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */




