#ifndef __CommandLineParser_cpp__
#define __CommandLineParser_cpp__

namespace BIOS {

	CommandLineParser::CommandLineParser(int argc, char*argv[])
	{
		this->argc = argc;
		this->argv = argv;	

		this->parse();	
	};

	CommandLineParser::~CommandLineParser()
	{
		free(pos);
	};

	void CommandLineParser::parse()
	{

		struct arg_str *sample_name = arg_str1(NULL,NULL,"<sample_name>","Input sample name. It is the common part of filename  (all except the _?.gou>)");
		struct arg_int *sample_number = arg_int0("Nn","sample_number", "<sample number>","Total number of samples. Default 1");
		
		struct arg_int *allele_order = arg_int0("Oo","order", "<allele order>","Allele order type. Default 2 which indicates that haplotypes are knwon");

		struct arg_int *emdist = arg_int0("Dd","emdist", "<EMDistributions>","EMDistributions. Default 0");
		struct arg_int *emrest = arg_int0("Rr","emrest", "<EMRestriction>","EMRestriction. Default 0");
		struct arg_int *phase_arg = arg_int0("Pp","phase", "<PhaseAlg>","PhaseAlg. Default 0");
	
		struct arg_int *first_arg = arg_int0("Ff","first", "<first position>","Position of the first allele. Default 0");
		struct arg_int *length_arg = arg_int0("Ll","length", "<haplotype length>","Haplotype length. Default 10");
		struct arg_lit *homo_arg = arg_lit0(NULL,"homo","Allow homozigotic parents. Default no");
		struct arg_int *freq_arg = arg_int0("Qq","freq", "<MinFreq>","MinFreq. Default 0");
	

		struct arg_lit *help  = arg_lit0(NULL,"help",       "print this help and exit");
		struct arg_end * end = arg_end(10);

		void * argtable[] = {sample_name, sample_number,allele_order,emdist,emrest,phase_arg,first_arg,length_arg,homo_arg,freq_arg, help, end};	
	
		if (arg_nullcheck(argtable) != 0)
			printf("error: insufficient memory\n");

		// Default values
		sample_number->ival[0] = 1;
		allele_order->ival[0] = 2;
		emdist->ival[0] = 0;
		emrest->ival[0] = 0;
		phase_arg->ival[0] = 0;
		first_arg->ival[0] = 0;
		length_arg->ival[0] = 10;
		freq_arg->ival[0] = 0;	
	
		int nerrors = arg_parse(argc,argv,argtable);
	

		if (help->count > 0 )
		{
		    printf("\nUsage: %s",argv[0]);
		    arg_print_syntax(stdout,argtable,"\n");
		    printf("\nProgram to calculate distances in samples.\n");
		    printf("The program accepts the following arguments.\n\n");
		    arg_print_glossary(stdout,argtable,"  %-25s %s\n");
			printf("\n");
		    
		    //exit (0);
			parsingOK = false;
			return;
		}	
	
		if (nerrors > 0){
			arg_print_errors(stdout,end,argv[0]);
			parsingOK = false;
			return;
			//exit(1);
		}



		onlyHetero=true;
		firstPosition=first_arg->ival[0];
		length=length_arg->ival[0];
		char filename[256], filenameWilk[256]="\0", filename2[256]="\0", filename3[256]="\0", ext[256];
		char  RecString[10]="\0";
      

		strcpy (filename, sample_name->sval[0]);

		totalSamples=sample_number->ival[0];



		minFreq=freq_arg->ival[0];
		int prop=1;
		
		PhaseAlg phaseAlg;
		EMDistributions emDistributions;
		EMRestriction emRestriction;
		alleleOrderType=(AlleleOrderType)allele_order->ival[0];

		if (alleleOrderType!=LeftRight && alleleOrderType!=LeftRightUsingTrios) throw BadFormat(string("main, alleleOrderType\n"));

		emDistributions=(EMDistributions)emdist->ival[0];
		emRestriction=(EMRestriction)emrest->ival[0];
		phaseAlg=(PhaseAlg)phase_arg->ival[0];


		if (phaseAlg!=maxFreq && phaseAlg!=weighted && phaseAlg!=onlyKnown) throw BadFormat(string("main, phase alg\n"));
		if (emDistributions!=UTDistributions && emDistributions!=oneDistribution) throw BadFormat(string("main, EM distributions\n"));
		if (emRestriction!=noRestriction && emRestriction!=triosBasedRestriction) throw BadFormat(string("main, EM restriction\n"));



		bool maxHap=true;

		bool knownPhase=false;

		if (alleleOrderType==LeftRight) knownPhase=true;


		if (homo_arg->count > 0 )
			onlyHetero = 0;
		else 
			onlyHetero = 1;
		

		strcpy ( filenameWilk, filename);


		// Remove path from filename

		char * pch;
		pch=strrchr(filenameWilk,'/');
		if (pch==NULL){
			strcpy(filename3, filenameWilk);
		}
		else
		{
			int pos_last_slash = pch-filenameWilk+1;
			strcpy(filename3, filenameWilk+pos_last_slash);
		}    

      	sprintf(filename3, "%s_f%d_w%d_minFreq%d", filename3, firstPosition, length, minFreq); 

      	if (onlyHetero) strcat(filename3, "_OnlyHetero");
      	strcat(filename3, ".pd");

		if (!knownPhase) 
		{
			strcat(filename3, "Unknown-");
			strcat(filename3, tos(phaseAlg).c_str());
		}


		// Find recombination
		char * rec_pch;
		rec_pch = strstr(filename3, "Rec");
		if (rec_pch)
			strncpy(RecString, rec_pch+3, 9);
		else
			strcpy(RecString, "nf");

      

		SNPPos SNP1=firstPosition, SNP2;



		double TDT_r0r1_results=0, TDT_results=0;


		double TDT_r0r1_results_old_=0;
		int actualTotalSamples=0;

		std::vector<double> treedt;
/*
		for(int v=0;v<vKlevels.size();v++)
			treedt.push_back(0);

		std::vector<double> treedtMin;
		for(int v=0;v<vKlevels.size();v++)
			treedtMin.push_back(0);
	*/

		//MultimarkerMeasure<TrioSample>* PM=NULL;
		TrioCountersHapUAndT* TM=NULL;


		TrioSample*	sample=NULL;
		//PhylogeneticDistance *phylogeneticDistance=NULL;

		size=length;
		double recFraction=0.5, recFraction2=0.5; 


		//SNPPos pos[size];
		pos = (SNPPos *)malloc( size * sizeof(SNPPos) );

		for (int i=0; i<size; i++)
			pos[i]=firstPosition+i;


		//strcpy(sampleFileName, filenameWilk);
		sampleFileName = string( filenameWilk );
		outPutFileName = string( filename3 );


		arg_freetable(argtable,sizeof(argtable)/sizeof(argtable[0]));				
	
		parsingOK = true;
	};

	std::string CommandLineParser::ithSampleFileName(int i)
	{
		//string out = string( sampleFileName );
		string out;

		out = sampleFileName + string("_") + tos(i) + ".gou";

		return out;
	
//		strcpy ( filename2,sampleFileName);
//		strcat ( filename2, string("_"+tos(s)).c_str());
//		strcat(filename2, ".gou");
	};

};


#endif

