#ifndef __CommandLineParser_h__
#define __CommandLineParser_h__

namespace BIOS {

	/** 
	* 	Class used to read command line arguments for TrioSample programs
	*/

	class CommandLineParser {

		public:
		bool parsingOK;

		int argc; 
		char**argv;

		//! Total number of files from which to create samples
		int totalSamples;

		bool onlyHetero;
		SNPPos firstPosition, length;
		int minFreq;

		//! Common name for all sample files;
		//char sampleFileName[256];
		string sampleFileName;

		AlleleOrderType alleleOrderType;
	
		std::string ithSampleFileName(int i);

		std::string outPutFileName;


		SNPPos *pos;
		int size;



		CommandLineParser(int argc, char*argv[]);

		~CommandLineParser();

		void parse();
	};


};


#endif



