#ifndef __CommandLineParserGWAS_h__
#define __CommandLineParserGWAS_h__

namespace BIOS {

	/** 
	* 	Class used to read command line arguments for TrioSample programs
	*	Only one file will be specified. Example program to use this class: linkageAnalysis.cpp
	*/

	class CommandLineParserGWAS{
	private:
		bool checkFileName;
			
		public:
		bool parsingOK;

		int argc; 
		char**argv;

		//! List of measure names
		string measures;
		//! File name including path
		string path;
		//! File name without path
		string fileName;
		//! File name without path and without extension
		string fileNameNoExtension;
		//!Allele order type. Default 2 which indicates that haplotypes are knwon
		AlleleOrderType alleleOrderType;
		//! Sliding windows width
		int window_width;
		//! Sliding windows offset
		int window_offset;
		//! Total number of files from which to create samples
		int totalSamples;
		//! External Test mode (tHoldout==2, tTraining==3)
		int testMode;
		//! internal Test mode (tHoldout==2, tTraining==3)
		int internalTestMode;		
		//! If true process only the first window. Else process all possible windows moving with the given offset.
		bool onlyFirstWindow;

		//! test name, extracted from input sample name
		string test;
		//! model name, extracted from input sample name
		string model;
		//! Relative risk, extracted from input sample name
		string RR;
		//! recombination fraction, extracted from input sample name
		string recombination;
		//! Number of permutations 
		int permutations;
		

		CommandLineParserGWAS(int argc, char*argv[], bool checkFileName=true);

		~CommandLineParserGWAS();

		void parse();

		string ithSampleFileName(int i);

		bool splitFileName();
	};


};


#endif



