/* File: Diplotype.cpp */


#ifndef __Diplotype_cpp__
#define __Diplotype_cpp__


#include "Diplotype.h"

//using namespace UTILS;

namespace BIOS {


/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/
/*
  template <> Diplotype Container<vector<Diplotype>, Diplotype>::readElement (ifstream * source, const char* tokens, int* pos, int size)
{
cout << "Diplotype Container<vector, Diplotype>::readElement not implemented  yet";
end();
};
*/

/******************************************************************/
/*
template <> void Container<vector, Diplotype, std::allocator>::removeNode(Container<vector, Diplotype, std::allocator>::iterator it) 
{
//cout << "insiderem\n";
//zap(this->getElement(it));
//return it2; //this->erase(it);
};

///////////////////
//// public ////////
///////////////////

Diplotype::Diplotype(){};

/*
Diplotype::Diplotype(const DiplotypeS D)
{
Dip.Left=D.Left;
Dip.Right=D.Right;
}
*/
/*____________________________________________________________ */

Diplotype::Diplotype ()
{
}
/*____________________________________________________________ */

Diplotype::Diplotype (const Diplotype & source)
{
this->Left=source.Left;
this->Right=source.Right;
}
/*____________________________________________________________ */

Diplotype::Diplotype (allele left, allele right)
{
try
{
checkAllele(left);
checkAllele(right);
this->Left=left;
this->Right=right;
}
catch (NonSNP & ns){ns.addMessage("\ncalled from Diplotype::Diplotype (allele left, allele right)"); throw;}
}
/*____________________________________________________________ */
/*
Diplotype::Diplotype (DiplotypeS Dip)
{
this->Dip=Dip;
}
/*____________________________________________________________ */

Diplotype::~Diplotype ()
{
//cout <<"nothing to be done\n";
//Dip.Left=NA;
//Dip.Right=NA;
}
/*____________________________________________________________ */

Diplotype* Diplotype::clone ()
{
return new Diplotype(*this);
}
/*____________________________________________________________ */
/*
int Diplotype::getGenotypeCode ()
{
if (!isANonMissingSNP()) 
throw BadFormat(" at Diplotype::isHeterozygous ");
Diplotype D2=Diplotype(*this);
if (D2.getLeftAllele()>D2.getRightAllele())
 D2.changeAlleles();
if (D2.isHomozygous())
return (int) D2.getLeftAllele()-1;
switch ((int)D2.getLeftAllele()-1)
{
case 0: return 4+(int)D2.getRightAllele()-2;break;//4, 5, 6 for AC, AG, AT respectively
case 1: return 7+(int)D2.getRightAllele()-3;break;//7, 8 for CG, CT respectively
default: return 9; break;//9 for GT 
}
}
/*____________________________________________________________ */

int Diplotype::getGenotypeCode (allele& left, allele& right)
{
if (!isANonMissingSNP(left, right)) 
throw BadFormat(" at Diplotype::getGenotypeCode ");
if (left>right)
 changeAlleles(left, right);
if (Diplotype::isHomozygous(left, right))
return (int) left-1;
switch ((int)left-1)
{
case 0: return 4+(int)right-2;break;//4, 5, 6 for AC, AG, AT respectively
case 1: return 7+(int)right-3;break;//7, 8 for CG, CT respectively
default: return 9; break;//9 for GT 
}
}

/*____________________________________________________________ */

void Diplotype::OrderMajorFirst(allele MajorAllele)
{
try
{
checkAllele(MajorAllele);
	// for those heterozygous positions, rewrite first MajorAllele, second Minor Allele.
	// NOT implemented: if only one allele is missing, write it in the second positions

      if (Diplotype::isANonMissingSNP()) 
      if (isHeterozygous(MajorAllele) && Left!=MajorAllele)
        changeAlleles();
 }
catch (BasicException & ns){ns.addMessage("\ncalled from Diplotype::OrderMajorFirst(allele MajorAllele)"); throw;}
}

/*____________________________________________________________ */

void Diplotype::orderMajorFirst(allele& left, allele& right, allele MajorAllele)
{
try
{
checkAllele(MajorAllele);
	// for those heterozygous positions, rewrite first MajorAllele, second Minor Allele.
	// NOT implemented: if only one allele is missing, write it in the second positions
      if (Diplotype::isANonMissingSNP(left, right)) 
      if (isHeterozygous(left, right, MajorAllele) && left!=MajorAllele)
        changeAlleles(left, right);
 }
catch (BasicException & ns){ns.addMessage("\ncalled from Diplotype::OrderMajorFirst(allele& left, allele& right, allele MajorAllele)"); throw;}
}

/*____________________________________________________________ */

void Diplotype::orderByAlphabeticOrder(allele& left, allele& right, allele MajorAllele)
{
try
{
checkAllele(MajorAllele);
	// for those heterozygous positions, rewrite first MajorAllele, second Minor Allele.
	// NOT implemented: if only one allele is missing, write it in the second positions
      if (Diplotype::isANonMissingSNP(left, right)) 
      if (isHeterozygous(left, right, MajorAllele) && left>right)
        changeAlleles(left, right);
 }
catch (BasicException & ns){ns.addMessage("\ncalled from Diplotype::OrderMajorFirst(allele& left, allele& right, allele MajorAllele)"); throw;}
}

/*____________________________________________________________ */

void Diplotype::setAsKnown(allele& left, allele& right)
{
try
{
left=(allele)abs(left);
right=(allele)abs(right);
 }
catch (BasicException & ns){ns.addMessage("\ncalled from Diplotype::OrderMajorFirst(allele& left, allele& right, allele MajorAllele)"); throw;}
}
/*____________________________________________________________ */

void Diplotype::setAsKnown()
{
try
{
Left=(allele)abs(left);
Right=(allele)abs(right);
 }
catch (BasicException & ns){ns.addMessage("\ncalled from Diplotype::OrderMajorFirst(allele& left, allele& right, allele MajorAllele)"); throw;}
}

/*____________________________________________________________ */
/*
void Diplotype::OrderRandomly(allele MajorAllele)
{
try
{
checkAllele(MajorAllele);
	// for those heterozygous positions, rewrite alleles randomly
 unsigned short int random;

      if (isHeterozygous(MajorAllele)) 
	  {
		random=rand() % (2);
//if (random==0) cout <<"0"; else cout <<"1";
		if (random==0 && Left!=MajorAllele)
        changeAlleles();
 	   if (random==1 && Left==MajorAllele)
        changeAlleles();
	  }
}
catch (NonSNP & ns){ns.addMessage("\ncalled from Diplotype::OrderRandomly(allele MajorAllele)"); throw;}
}
/*____________________________________________________________ */

void Diplotype::orderRandomly(allele& left, allele& right, allele MajorAllele)
{
try
{
checkAllele(MajorAllele);
	// for those heterozygous positions, rewrite alleles randomly
 unsigned short int random;

      if (isHeterozygous(left, right, MajorAllele)) 
	  {
		random=rand() % (2);
//if (random==0) cout <<"0"; else cout <<"1";
		if (random==0 && left!=MajorAllele)
        changeAlleles(left, right);
 	   if (random==1 && left==MajorAllele)
        changeAlleles(left, right);
	  }
}
catch (NonSNP & ns){ns.addMessage("\ncalled from Diplotype::OrderRandomly(allele MajorAllele)"); throw;}
}

/*____________________________________________________________ */


bool Diplotype::isHeterozygous (allele oneAllele)
{
try
{
checkAllele(oneAllele);
if (!isANonMissingSNP()) 
throw BadFormat(" at Diplotype::isHeterozygous (allele oneAllele)");
return 
		((Left==oneAllele && Right!=oneAllele) ||
		 (Left!=oneAllele && Right==oneAllele));
}
catch (BasicException & ns){ns.addMessage("\ncalled from Diplotype::isHeterozygous (allele oneAllele)"); throw;}
}
/*____________________________________________________________ */


bool Diplotype::isHeterozygous (allele& left, allele& right, allele oneAllele)
{
try
{
checkAllele(oneAllele);
if (!isANonMissingSNP(left, right)) 
throw BadFormat(" at Diplotype::isHeterozygous(allele& left, allele& right, allele oneAllele)");
return 
		((abs(left)==abs(oneAllele) && abs(right)!=abs(oneAllele)) ||
		 (abs(left)!=abs(oneAllele) && abs(right)==abs(oneAllele)));
}
catch (NonSNP & ns){ns.addMessage("\ncalled from Diplotype::isHeterozygous (allele oneAllele)"); throw;}
}

/*____________________________________________________________ */

/*
bool Diplotype::isHeterozygous (allele oneAllele, allele otherAllele)
{
try
{
checkAllele(oneAllele);
checkAllele(otherAllele);
if (!isANonMissingSNP(oneAllele, otherAllele)) 
throw BadFormat(" at Diplotype::isHeterozygous ");
return 
		((Left==oneAllele && Right==otherAllele) ||
		 (Left==otherAllele && Right==oneAllele));
}
catch (NonSNP & ns){ns.addMessage("\ncalled from Diplotype::isHeterozygous (allele oneAllele, allele otherAllele)"); throw;}
}
/*____________________________________________________________ */


/*
bool Diplotype::isHeterozygous (MultiallelicHetero m, allele* alleles, int totalAlleles)
{
int i=mini((int)Dip.Left, (int)Dip.Right);
int j=maxi((int)Dip.Left, (int)Dip.Right);
int k, l, a, b;
//int k=mini((int)alleles, (int)alleles);
//int l=maxi((int)alleles, (int)alleles);
if (!isANonMissingSNP()) 
throw BadFormat(" at Diplotype::isHeterozygous ");
//return false; 
switch ((int)m) 
{
case 0: a=0; b=1; break;
case 1: a=0; b=2; break;
case 3: a=1; b=2; break;
case 4: a=1; b=3; break;
case 5: a=2; b=3; break;
}
if (b>=totalAlleles) return false;


k=mini((int)alleles[a], (int)alleles[b]);
l=maxi((int)alleles[a], (int)alleles[b]);
if (i==k && j==l) return true;
return false;
};
/*____________________________________________________________ */

/*

bool Diplotype::isHeterozygous ()
{
if (!isANonMissingSNP()) 
{
cout <<*this;
throw BadFormat(" at Diplotype::isHeterozygous ");
}
return 		(Left!=Right);
}
/*____________________________________________________________ */



bool Diplotype::isHeterozygous (allele& left, allele &right)
{
if (!isANonMissingSNP(left, right)) 
{
cout <<left <<" " << right;
throw BadFormat(" at Diplotype::isHeterozygous (allele& left, allele &right)");
}
return 		(left!=right);
}
/*___________________________________________________*/
/*
bool Diplotype::isHomozygous (allele oneAllele)
{
try
{
checkAllele(oneAllele);
if (!isANonMissingSNP()) 
{
cout <<*this;
throw BadFormat(" at Diplotype::isHomozygous1 ");
}
return Left==oneAllele && Right==oneAllele;
}
catch (NonSNP & ns){ns.addMessage("\ncalled from Diplotype::isHomozygous (allele oneAllele)"); throw;}
}
/*___________________________________________________*/

bool Diplotype::isHomozygous (allele&left, allele&right, allele oneAllele)
{
try
{
checkAllele(oneAllele);
if (!isANonMissingSNP(left, right)) 
{
cout <<left <<" " << right;
throw BadFormat(" at Diplotype::isHomozygous1 ");
}
return abs(left)==abs(oneAllele) && abs(right)==abs(oneAllele);
}
catch (NonSNP & ns){ns.addMessage("\ncalled from Diplotype::isHomozygous (allele oneAllele)"); throw;}
}

/*___________________________________________________*/
/*
bool Diplotype::isHomozygous1 (allele MajorAllele)
{
try
{
checkAllele(MajorAllele);
if (!isANonMissingSNP()) 
{
cout <<*this;
throw BadFormat(" at Diplotype::isHomozygous1 ");
}
return Left==MajorAllele && Right==MajorAllele;
}
catch (NonSNP & ns){ns.addMessage("\ncalled from Diplotype::isHomozygous1 (allele MajorAllele)"); throw;}
}
/*___________________________________________________*/

bool Diplotype::isHomozygous1 (allele& left, allele& right, allele MajorAllele)
{
try
{
checkAllele(MajorAllele);
if (!isANonMissingSNP(left, right)) 
{
cout <<left <<" " << right;
throw BadFormat(" at Diplotype::isHomozygous1(allele& left, allele& right, allele MajorAllele) ");
}
return abs(left)==abs(MajorAllele) && abs(right)==abs(MajorAllele);
}
catch (NonSNP & ns){ns.addMessage("\ncalled from Diplotype::isHomozygous1 (allele MajorAllele)"); throw;}
}


/*___________________________________________________*/

/*
bool Diplotype::isHomozygous2 (allele MajorAllele)
{
try
{
checkAllele(MajorAllele);
if (!isANonMissingSNP()) 
{
cout <<*this;
throw BadFormat(" at Diplotype::isHomozygous2 ");
}
return Left!=MajorAllele && Right!=MajorAllele;
}
catch (NonSNP & ns){ns.addMessage("\ncalled from Diplotype::isHomozygous (allele MajorAllele)"); throw;}
};

/*___________________________________________________*/


bool Diplotype::isHomozygous2 (allele& left, allele& right, allele MajorAllele)
{
try
{
checkAllele(MajorAllele);
if (!isANonMissingSNP(left, right)) 
{
cout <<left <<" " << right;
throw BadFormat(" at Diplotype::isHomozygous2 (allele& left, allele& right, allele MajorAllele) ");
}
return abs(left)!=abs(MajorAllele) && abs(right)!=abs(MajorAllele);
}
catch (NonSNP & ns){ns.addMessage("\ncalled from Diplotype::isHomozygous (allele MajorAllele)"); throw;}
};

/*___________________________________________________*/
/*
bool Diplotype::isHomozygous ()
{
if (!isANonMissingSNP()) 
{
cout <<left <<" " << right;
throw BadFormat(" at Diplotype::isHomozygous ");
}
return Left==Right;
};

/*___________________________________________________*/

bool Diplotype::isHomozygous (allele & left, allele &right)
{
if (!isANonMissingSNP(left, right)) 
{
cout <<left <<" " << right;
throw BadFormat(" at Diplotype::isHomozygous ");
}
return abs(left)==abs(right);
};

/*___________________________________________________*/

bool Diplotype::IsEqual(Diplotype g)
{
return  Left==g.getLeftAllele() && Right==g.getRightAllele();

}

/*___________________________________________________*/

bool Diplotype::operator==(const Diplotype & g)
{
return  IsEqual(g);

}

/*____________________________________________________________ */
           
bool Diplotype::isANonMissingSNP ()
{
return !isAMissingSNP(true) && !isAMissingSNP(false);
}
/*____________________________________________________________ */
           
bool Diplotype::isANonMissingSNP (allele& left, allele&right)
{
return !isMissing(left) && !isMissing(right);
}

/*____________________________________________________________ */

bool Diplotype::isAnUnphasedSNP (allele& left, allele&right)
{
return isUnphased(left) || isUnphased(right);
}


/*____________________________________________________________ */
           
bool Diplotype::isAMissingSNP (bool left)
{
if (left) return isMissing((allele)Left);
else return isMissing((allele)Right);
}

/*____________________________________________________________ */

bool Diplotype::isAnUnphasedSNP (bool left)
{
if (left) return isUnphased((allele)Left);
else return isUnphased((allele)Right);
}

/*____________________________________________________________ */
/*           
bool Diplotype::isAMissingSNP (allele& all)
{
return isMissing(all);
}
/*____________________________________________________________ */
           
bool Diplotype::leftIsMissing ()
{
return isAMissingSNP(true);
}
/*____________________________________________________________ */
           
bool Diplotype::rightIsMissing ()
{
return isAMissingSNP(false);
}
/*____________________________________________________________ */
           
bool Diplotype::isAMissingSNP ()
{
return !isANonMissingSNP();
}

/*___________________________________________________________ */

void Diplotype::changeAlleles ()
{
change (Left,Right);
}
/*___________________________________________________________ */

void Diplotype::changeAlleles (allele& left, allele& right)
{
change (left,right);
}
/*___________________________________________________________ */
/*
void Diplotype::markAlleles ()
{
if (!IsMarked())
{
//cout <<"DIPleft:" << Dip.Left <<"new:" << (allele)-(int)Dip.Left;
//cout <<"DIpRight:" << Dip.Right  <<"new:" << (allele)-(int)Dip.Right <<"\n";
  Left=(allele)-(int)Left;
  Right=(allele)-(int)Right;
}
}
/*___________________________________________________________ */

void Diplotype::markAlleles (allele& left, allele& right)
{
if (!isMarked(left, right))
{
//cout <<"DIPleft:" << Dip.Left <<"new:" << (allele)-(int)Dip.Left;
//cout <<"DIpRight:" << Dip.Right  <<"new:" << (allele)-(int)Dip.Right <<"\n";
  left=(allele)-(int)left;
  right=(allele)-(int)right;
}
}

/*___________________________________________________________ */

bool Diplotype::IsMarked ()
{
  return (int)Left<0 || (int)Right<0;
}
/*___________________________________________________________ */

bool Diplotype::isMarked (allele & left, allele & right)
{
  return (int)left<0 || (int)right<0;
}
/*__________________________________________________________*/

allele Diplotype::getLeftAllele ()
{
	return Left;
}
/*__________________________________________________________*/

allele Diplotype::getRightAllele ()
{
	return Right;
}
/*__________________________________________________________*/

void Diplotype::checkAllele (allele a)
{
if (abs((int)a)>5 || abs((int)a)<1)
throw NonSNP((int)a, "Diplotype::checkAllele (allele a)");
}
/*__________________________________________________________*/

void Diplotype::setLeftAllele (allele Left)
{
try
{
checkAllele(Left);
	this->Left=Left;
}
catch (NonSNP & ns){ns.addMessage("\ncalled from Diplotype::setLeftAllele (allele Left)"); throw;}
}
/*__________________________________________________________*/

void Diplotype::setRightAllele (allele Right)
{
try
{
checkAllele(Right);
this->Right=Right;
}
catch (NonSNP & ns){ns.addMessage("\ncalled from Diplotype::setRightAllele (allele Right)"); throw;}
}
/*__________________________________________________________*/

void Diplotype::setAlleles (allele Left, allele Right)
{
try
{
	setLeftAllele(Left);
 setRightAllele(Right);
}
catch (NonSNP & ns){ns.addMessage("\ncalled from Diplotype::setAlleles (allele Left, allele Right)"); throw;}
}

/*____________________________________________________________ */
/*
string Diplotype::print(HaplotypeType h)
{
char line[10];
if (h==left) sprintf(line, "%d\0", (int)Dip.Left);
else sprintf(line, "%d\0", (int)Dip.Right);
return string(line);
}

/*____________________________________________________________ */



ostream& operator<<(ostream& out, Diplotype& diplotype)
       {
//    char line[10];
//line[0]='\0';
//if (markUnphased)
//sprintf(line, " %d %d", (int)Dip.Left, (int)Dip.Right);
//else
//sprintf(line, " %d %d", abs((int)Dip.Left), abs((int)Dip.Right));
//return string(line);
if (diplotype.leftIsMissing()) out << "?";
else out << (int)diplotype.getLeftAllele(); 
out << " ";
if (diplotype.rightIsMissing()) out << "?";
else out<< (int)diplotype.getRightAllele();
return out;
}

};  // End of Namespace

#endif

/* End of file: Genotype.h */




