#ifndef GWAS_cpp//
#define GWAS_cpp//






//using namespace UTILS;

namespace BIOS
{


	/*___________________________________________________________ */
	/*
		void GWAS::setupForInternalHoldout()
		{
			this->internalTestMode_ = ( TestMode ) tHoldout;
			this->externalTestMode_=tTraining;
		}

		void GWAS::setupForTraining()
		{
			this->internalTestMode_ = tTraining;
			this->externalTestMode_=tTraining;
		}
	*/

	GWAS::GWAS()
	{
		set();
	}

	/*___________________________________________________________ */

	GWAS::GWAS ( ListOfGenericMeasures* measures, char* fileSample, bool trios, const char* resultsDir, int totalSamples, TestMode internalTestMode, int internalNumberOfFolds, int externalNumberOfFolds,
	             int totalPermutations, int iniPos, int length, bool measureFiles, bool useOnlyHetero, bool returnPVals, AlleleOrderType genotypeOrder, PhaseAlg phaseAlg, EMDistributions emDistributions, EMRestriction emRestriction,   intList* alpha,  TestMode externalTestMode, bool printGWASConfig, int verbatim )
	{
		try
		{



			set ( measures, fileSample, resultsDir, totalSamples, internalTestMode, internalNumberOfFolds, externalNumberOfFolds, totalPermutations, iniPos, length, measureFiles, useOnlyHetero, returnPVals, genotypeOrder, phaseAlg, emDistributions, emRestriction, alpha, externalTestMode, printGWASConfig, verbatim );
			char wholefilename[256];
			strcpy ( wholefilename, fileSample );
			int totalTrue=0;
			for ( int i=0; i<totalSamples; i++ )
			{
				if ( i%10==0 ) cout <<"\nSample " << i+1;
				if ( totalSamples!=1 ) sprintf ( wholefilename, "%s%d.gou", fileSample, i );
				genericMLTests[i]=NULL;
				if ( fileExists ( wholefilename ) && fileSize ( wholefilename ) !=0 )
				{
					totalTrue++;
					if ( trios) // triosample
					{
						genericMLTests[i]=new TUMLTest ( wholefilename, internalTestModeClass, externalTestModeClass, hapExtractionConfiguration, totalPermutations, useOnlyHetero, verbatim );
					}
					else // unrelated sample 
if (genotypeOrder==NotChanged) // genotypes						
genericMLTests[i]=new GenomeMLTest ( wholefilename, internalTestModeClass, externalTestModeClass, hapExtractionConfiguration, totalPermutations, 1, verbatim );
else genericMLTests[i]=new HaplotypeCaseControlMLTest ( wholefilename, internalTestModeClass, externalTestModeClass, hapExtractionConfiguration, totalPermutations, verbatim );


					if ( length==-1 && i==0 ) length=genericMLTests[0]->getSize()-iniPos;
					genericMLTests[i]->setSubsamples ( iniPos, length ); // cannot be done in the constructor of GenericMLTest because it uses virtual methods
				}
				else
					if ( totalSamples==1 )
						throw ErrorFile ( wholefilename, "GWAS::set(ListOfGenericMeasures* measures, char* fileSample, const char*resultsDir, i..." );
			}
			if ( totalTrue==0 )
			{
				if ( totalSamples!=1 ) sprintf ( wholefilename, "%s%d.gou", fileSample, 0 );
				throw ErrorFile ( wholefilename, "GWAS::set(ListOfGenericMeasures* measures, char* fileSample, const char*resultsDir, i..." );
			}
			this->length=length;

			if ( length==-1 ) this->length=genericMLTests[0]->getSize()-iniPos;

//printGWASConf();
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from GWAS::GWAS(ListOfGenericMeasures* measures,, ..." ); throw;};

	}



	/*___________________________________________________________ */

	GWAS::GWAS ( ListOfGenericMeasures* measures, char* trainingFileSample, char* testFileSample, bool trios, const char* resultsDir, int totalPermutations, int iniPos, int length, bool measureFiles, bool useOnlyHetero, bool returnPVals, AlleleOrderType genotypeOrder, PhaseAlg phaseAlg, EMDistributions emDistributions, EMRestriction emRestriction,   intList* alpha,  bool printGWASConfig, int verbatim )
	{
		try
		{

			int totalSamples=1;
			TestMode internalTestMode=tHoldout;
			int internalNumberOfFolds=1;
			int externalNumberOfFolds=1;
			TestMode externalTestMode=tTraining;
			this->secondFileSample=testFileSample;
			set ( measures, trainingFileSample, resultsDir, totalSamples, internalTestMode, internalNumberOfFolds, externalNumberOfFolds, totalPermutations, iniPos, length, measureFiles, useOnlyHetero, returnPVals, genotypeOrder, phaseAlg, emDistributions, emRestriction, alpha, externalTestMode, printGWASConfig, verbatim );
			genericMLTests[0]=NULL;
			if ( ! fileExists ( trainingFileSample ) || fileSize ( trainingFileSample ) ==0 )
			{
				throw ErrorFile ( trainingFileSample, "GWAS::set(ListOfGenericMeasures* measures, char* fileSample, const char*resultsDir, i..." );
				exit ( 0 );
			}

			if ( ! fileExists ( testFileSample ) || fileSize ( testFileSample ) ==0 )
			{
				throw ErrorFile ( testFileSample, "GWAS::set(ListOfGenericMeasures* measures, char* fileSample, const char*resultsDir, i..." );
				exit ( 0 );
			}

			/*if ( ! fileExists ( wholeFileSample ) || fileSize ( wholeFileSample ) ==0 )
			{
				throw ErrorFile ( wholeFileSample, "GWAS::set(ListOfGenericMeasures* measures, char* fileSample, const char*resultsDir, i..." );
				exit ( 0 );
			}*/
			if ( trios ) // triosample
				genericMLTests[0]=new TUMLTest ( trainingFileSample, testFileSample, hapExtractionConfiguration, totalPermutations, useOnlyHetero, verbatim );
			  else // unrelated sample 
if (genotypeOrder==NotChanged) // genotypes	
{					
genericMLTests[0]=new GenomeMLTest (trainingFileSample, testFileSample,hapExtractionConfiguration, totalPermutations, 1, verbatim );
}
else 
{
  genericMLTests[0]=new HaplotypeCaseControlMLTest ( trainingFileSample, testFileSample, hapExtractionConfiguration, totalPermutations, verbatim );
}


	genericMLTests[0]->setSubsamplesForTrainingTestFiles ( iniPos, length ); // cannot be done in the constructor of GenericMLTest because it uses virtual methods
			this->length=length;
			if ( length==-1 ) this->length=genericMLTests[0]->getSize()-iniPos;
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from GWAS::GWAS(ListOfGenericMeasures* measures,, ..." ); throw;};

	}
	/*___________________________________________________________ */

	void GWAS::set ( ListOfGenericMeasures* measures, char* fileSample, const char*resultsDir, int totalSamples, TestMode internalTestMode, int internalNumberOfFolds, int externalNumberOfFolds,
	                 int totalPermutations, int iniPos, int length, bool measureFiles, bool useOnlyHetero, bool returnPVals, AlleleOrderType genotypeOrder, PhaseAlg phaseAlg, EMDistributions emDistributions, EMRestriction emRestriction,   intList* alphaBasic, TestMode externalTestMode, bool printGWASConfig, int verbatim )
	{
		try
		{
			this->length=length;
		  
			this->verbatim=verbatim;
			if ( phaseAlg==weighted ) throw NonImplemented ( "weighted phased not implemented yet" );
			this->returnPVals=returnPVals;


			if ( resultsDir!=NULL ) strcpy ( this->resultsDir,resultsDir );
			else strcpy ( this->resultsDir, getFilePath ( fileSample ) );

			this->measureFiles=measureFiles;
			this->fileSample=fileSample;
			this->totalSamples=totalSamples;
			internalTestModeClass=new TestModeClass ( internalTestMode, internalNumberOfFolds );
			externalTestModeClass=new TestModeClass ( externalTestMode, externalNumberOfFolds );
			if ( printGWASConfig ) printGWASConf();
			hapExtractionConfiguration=new HapExtractionConfiguration ( genotypeOrder, phaseAlg, emDistributions, emRestriction );
			genericMLTests=new GenericMLTest*[totalSamples];
			alpha=new PairOfDoublesVector();


			if ( alphaBasic!=NULL )
				for ( int i=0; i<alphaBasic->size(); i++ )
					alpha->insertElement ( new PairOfDoubles ( -MAXFLOAT, alphaBasic->getElement ( i ) ) );
			else
			{
				alpha->insertElement ( new PairOfDoubles ( -MAXFLOAT, 0.01 ) );
				alpha->insertElement ( new PairOfDoubles ( -MAXFLOAT, 0.05 ) );
				alpha->insertElement ( new PairOfDoubles ( -MAXFLOAT, 0.001 ) );
				alpha->insertElement ( new PairOfDoubles ( -MAXFLOAT, 0.005 ) );
			}


			resultsForChunks=NULL;
			this->measures=measures;
			this->totalMeasures=measures->size();

			;

		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from GWAS::set(ListOfGenericMeasures* measures, char* fileSample, int totalSamples, TestMode testMode, int totalPermutations, i, ..." ); throw;};
	}

	/*___________________________________________________________ */

	GWAS::~GWAS()
	{

		for ( int i=0; i<totalMeasures;i++ )
		{
			zaparr ( resultsForChunks[i], totalChunks );
		}

		zaparr ( resultsForChunks, totalMeasures );

		zaparr ( genericMLTests, totalSamples );
		zap ( internalTestModeClass );
		zap ( externalTestModeClass );
		zap ( hapExtractionConfiguration );
		zap ( alpha );
	}

	/*___________________________________________________________ */

	void GWAS::set()
	{
		internalTestModeClass=NULL;
		externalTestModeClass=NULL;
		hapExtractionConfiguration=NULL;
		genericMLTests=NULL;
	}

	/*___________________________________________________________ */

	void GWAS::printGWASConf()
	{
		cout << "internal test mode is: " << *internalTestModeClass;
		cout << "external test mode is: " << *externalTestModeClass;
	}


	/*___________________________________________________________ */

	Container<vector<ofstream*>,ofstream*>* GWAS::getChunksStreams ( const char* extension )
	{
		Container<vector<ofstream*>,ofstream*>* listOfStreams=new Container<vector<ofstream*>,ofstream*>();
		ofstream* os;
		char filename[1024], filename2[1024], *single;
		strcpy ( filename, resultsDir );
		single=removeDir ( fileSample );
		if ( totalSamples>1 ) strcat ( filename, single );
		else
		{
			char * tmp = removeExtension ( single );
			strcat ( filename, tmp );
			zaparr ( tmp );
			strcat ( filename, "_" );
		}
		zaparr ( single );
		string description=getDescription();
string r;

		for ( int i=0; i<totalMeasures;i++ )
		{
r=string("resultsFor");
if (hapExtractionConfiguration->alleleOrderType==NotChanged) r=r+string("GenotypesAnd");
//if (!trios && hapExtractionConfiguration->alleleOrderType==LeftRightUsingTrios) r=r+string("UnreAnd");
			sprintf ( filename2, "%s%sExternalTestMode%sAndInternalTestMode%s%s_%s.", filename, r.c_str(), externalTestModeClass->print ().c_str(), internalTestModeClass->print ().c_str(), description.c_str(), measures->getElement ( i )->getName().c_str() );
			if ( extension==NULL )
				if ( returnPVals ) strcat ( filename2, "pVal" );
				else strcat ( filename2, "mult" );
			else strcat ( filename2, extension );
			os=new ofstream ( filename2, std::ios::out );
			listOfStreams->insertElement ( os );

			cout <<"\nResults will be written in: " << filename2<<endl;
		}
		return listOfStreams;
	}
	/*___________________________________________________________ */

	void   GWAS::printResultsForChunks ( bool verticalOutput, bool oneFile, const char* extension, stringList* firstPartHeading, stringList* rowHeading )
	{
		try
		{
			if ( firstPartHeading!=NULL )
			{
				firstPartHeading->setOutputSeparator ( '\t' );
				firstPartHeading->setDelimiters ( '\0', '\0' );
			}
			if ( rowHeading!=NULL )
			{
				rowHeading->setOutputSeparator ( '\t' );
				rowHeading->setDelimiters ( '\0', '\0' );
			}
			Container<vector<ofstream*>,ofstream*>*listOfStreams=getChunksStreams ( extension );
			ofstream *outputFile=listOfStreams->getFirstElement();
			char basicSeparator='\n';
			if ( oneFile && verticalOutput )  basicSeparator='\t';
// print heading
			if ( verticalOutput )
			{
				for ( int i=0; i<totalMeasures;i++ )
				{
					if ( !oneFile ) outputFile=listOfStreams->getElement ( i );
					if ( firstPartHeading!=NULL && ( !oneFile || i==0 ) ) *outputFile << *firstPartHeading << "\t";
					if ( oneFile && i==0 ) *outputFile << "window/block ";
					resultsForChunks[i][0]->printHeadingPlus ( "Ex"+externalTestModeClass->getShortName() + "In" + internalTestModeClass->getShortName() + "." + measures->getElement ( i )->getShortName(),  *outputFile );
//if (i<(totalMeasures<1))
					if ( i< ( totalMeasures-1 ) ) *outputFile << basicSeparator;
				}
//if (oneFile)
				*outputFile <<"\n";
			}

// print body

			for ( int j=0; j<totalChunks; j++ )
			{
				for ( int i=0; i<totalMeasures;i++ )
				{
					if ( !oneFile ) outputFile=listOfStreams->getElement ( i );
					if ( rowHeading!=NULL  && ( !oneFile || i==0 ) ) *outputFile << *rowHeading << "\t" << j << "\t";

					resultsForChunks[i][j]->print ( *outputFile, verticalOutput );
					if ( i< ( totalMeasures-1 ) || !verticalOutput ) *outputFile << basicSeparator;

				}
				*outputFile <<"\n";
			}

			for ( Container<vector<ofstream*>,ofstream*>::iterator it=listOfStreams->begin(); it<listOfStreams->end(); it++ )
			{
				listOfStreams->getElement ( it )->close();
//cout <<"\nResults have been written for measure " << measures->getElement ( listOfStreams->getPosition ( it ) //)->getName().c_str() <<" in file ";
			}
			zap ( listOfStreams );
		}

		catch ( BasicException& be ) {be.addMessage ( "\ncalled from 	void   GWASByWindows::printResultsForWindows ( bool verticalOutput, bool oneFile, const char* extension, stringList* firstPartHeading, stringList* rowHeading )" ); throw;};
	}
	/*___________________________________________________________ */

	void  GWAS::setResults()
	{
		try
		{
			Container<vector<ofstream*>,ofstream*>* listOfStreams=NULL;
			if ( measureFiles ) listOfStreams=getChunksStreams ( "detail" );
			resultsForChunks=new MeasureResults**[totalMeasures];
			for ( int k=0; k<totalMeasures; k++ )
				resultsForChunks[k]=new MeasureResults*[totalChunks];
			int* pos;
			MeasureResults*** temp, * temp2[totalSamples];
			cout <<"\nTotal number of windows/blocks calculated: " << totalChunks<<endl;
			for ( int i=0; i<totalChunks; i++ )  // WINDOWS or BLOCKS
			{
				// for each given window, repeat the process of calculating p-values


				if ( ( i+1 ) %10==0  || verbatim>0)
					cout <<"\nwindow/block number: " << i+1;


				pos=getPositions ( i );

if (verbatim>0)
{
cout <<"Processing samples and computing measures\n";
}
				temp=new MeasureResults**[totalSamples];

				for ( int j=0; j<totalSamples; j++ )  // SAMPLES
				{
					temp[j]=NULL;
					// for each sample file in disk (in the corresponding window) it calculates p-values
					if ( totalSamples>1 && (( j+1 ) %10==0 || verbatim))
						cout <<"sample number: " << j+1 <<endl;
					if ( genericMLTests[j]!=NULL )
					{
						// genericMLTests has the data for each sample
						if (verbatim>0) cout <<"Reading samples\n";
						genericMLTests[j]->setSampleGenericCounts ( pos, getSizeOfChunk ( i ) );
						
						if (verbatim>0) {cout << "Calculating p-values for  measures "; for (ListOfGenericMeasures::iterator it=measures->begin(); it<measures->end(); it++) cout << measures->getElement(it)->getName() <<"\n";}
						temp[j]=genericMLTests[j]->getResults ( measures, listOfStreams );  // <-- P-VALUES
						if (verbatim>0) cout <<"Releasing memory of SampleGeneticUnitCounts generated";
						genericMLTests[j]->emptyCounts();
					}
					else	temp[j]=NULL;
				}
if (verbatim>0 && totalSamples>1) cout <<"Computing association rates (only when using more than one sample)\n";
				for ( int k=0; k<totalMeasures; k++ )
				{
					// for each measure it computes association rates if more than one sample is used
					for ( int j=0; j<totalSamples; j++ )
						if ( temp[j]!=NULL ) temp2[j]=temp[j][k];
						else temp2[j]=NULL;
					if ( totalSamples==1 )
						if ( temp2[0]==NULL ) throw NullValue ( "the first sample cannot be null" );
						else resultsForChunks[k][i]=temp2[0]->clone();
					else resultsForChunks[k][i]=new MultipleSamplesRateResults ( temp2, totalSamples, alpha, returnPVals );
					//cout <<"measure:" << measures->getElement(k)->getName();
					//cout <<"pval:" << *resultsForWindows[k][i] <<"\n";
				}
if (verbatim>0) cout << "\nDeleting arrays used to store temporal measure results";
				for ( int j=0; j<totalSamples; j++ )
					zaparr ( temp[j], totalMeasures );
				zaparr ( temp, totalSamples );
				zaparr ( pos );
//				exit(0);
			} // LOOP FOR CALCULATION OF P-VALUES
if (verbatim>0) cout << "\nComputing average results for each SNP position";
			// begin STATISTICS FOR RESULTS?
			setAverageResults();

			if ( measureFiles )
				for ( Container<vector<ofstream*>,ofstream*>::iterator it=listOfStreams->begin(); it<listOfStreams->end(); it++ )
					listOfStreams->getElement ( it )->close();

			// end STATISTICS FOR RESULTS?

		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from GWASByWindows::setResults()" ); throw;};
	}






} // end namespace
#endif
