#ifndef GWASByWindows_cpp//
#define GWASByWindows_cpp//






//using namespace UTILS;

namespace BIOS
{


	/*___________________________________________________________ */

	GWASByWindows::GWASByWindows ( ListOfGenericMeasures* measures, char* fileSample, bool trios, const char* resultsDir, int totalSamples, TestMode internalTestMode, int internalNumberOfFolds, int externalNumberOfFolds,
	             int width, int offset, int totalPermutations, int iniPos, int length, bool measureFiles, bool useOnlyHetero, bool returnPVals, AlleleOrderType genotypeOrder, PhaseAlg phaseAlg, EMDistributions emDistributions, EMRestriction emRestriction,   intList* alpha,  TestMode externalTestMode, bool printGWASByWindowsConfig, int verbatim ): GWAS (measures, fileSample, trios, resultsDir, totalSamples, internalTestMode, internalNumberOfFolds, externalNumberOfFolds,
	             totalPermutations, iniPos, length, measureFiles, useOnlyHetero, returnPVals, genotypeOrder, phaseAlg, emDistributions, emRestriction,   alpha,  externalTestMode, printGWASByWindowsConfig, verbatim)
	{
		try
		{


			
		  
				this->width=width;
				this->originalWidth=width;
			cout <<"Widht is: " << width << " and legth is:" << length <<"\n";
			if ( width>this->length ) this->width=this->length;
			this->sw=new SlidingWindows (this->width, offset, this->length );
//cout << "sliding windows is: " << *this->sw << "\n";
			this->totalWindows=sw->getTotalCompleteWindows();
totalChunks=totalWindows;
			this->totalUsedSNPs= sw->getTotalUsedSNPs();
this->resultsForWindows=resultsForChunks;
			averageResults=NULL;
						setResults();
		  
//printGWASByWindowsConf();
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from GWASByWindows::GWASByWindows(ListOfGenericMeasures* measures,, ..." ); throw;};

	}
	
	
	
	/*___________________________________________________________ */

	GWASByWindows::GWASByWindows ( ListOfGenericMeasures* measures, char* trainingFileSample, char* testFileSample, bool trios, const char* resultsDir, int width, int offset, int totalPermutations, int iniPos, int length, bool measureFiles, bool useOnlyHetero, bool returnPVals, AlleleOrderType genotypeOrder, PhaseAlg phaseAlg, EMDistributions emDistributions, EMRestriction emRestriction,   intList* alpha,  bool printGWASByWindowsConfig, int verbatim ):GWAS( measures, trainingFileSample, testFileSample, trios, resultsDir, totalPermutations, iniPos, length, measureFiles, useOnlyHetero, returnPVals, genotypeOrder, phaseAlg, emDistributions, emRestriction,    alpha,  printGWASByWindowsConfig, verbatim )
	{
		try
		{

					
								this->width=width;
this->originalWidth=width;
			//cout <<"Widht is: " << width << " and legth is:" << length <<"\n";
			if ( width>this->length ) this->width=this->length;
			this->sw=new SlidingWindows (this->width, offset, this->length );

			this->totalWindows=sw->getTotalCompleteWindows();
totalChunks=totalWindows;

			this->totalUsedSNPs= sw->getTotalUsedSNPs();

this->resultsForWindows=resultsForChunks;
			averageResults=NULL;
			setResults();

		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from GWASByWindows::GWASByWindows(ListOfGenericMeasures* measures,, ..." ); throw;};

	}

	
	/*___________________________________________________________ */

	GWASByWindows::~GWASByWindows()
	{
		for ( int i=0; i<totalMeasures;i++ )
		{
			zaparr ( averageResults[i], totalUsedSNPs );
		}
		zaparr ( averageResults, totalMeasures );
resultsForWindows=NULL;
		zap ( sw );


		zaparr ( genericMLTests, totalSamples );
		zap ( internalTestModeClass );
		zap ( externalTestModeClass );
		zap ( hapExtractionConfiguration );
		zap ( alpha );
	}

	/*___________________________________________________________ */

	void GWASByWindows::set()
	{
		internalTestModeClass=NULL;
		externalTestModeClass=NULL;
		hapExtractionConfiguration=NULL;
		genericMLTests=NULL;
	}

	/*___________________________________________________________ */
/*
	void GWASByWindows::printGWASConf()
	{
		cout << "internal test mode is: " << *internalTestModeClass;
		cout << "external test mode is: " << *externalTestModeClass;
	}


	/*___________________________________________________________ */
/*
	void  GWASByWindows::setResults()
	{
		try
		{
			Container<vector<ofstream*>,ofstream*>* listOfStreams=NULL;
			if ( measureFiles ) listOfStreams=getWindowsStreams ( false, "detail" );
			resultsForWindows=new MeasureResults**[totalMeasures];
			averageResults=new MeasureResults**[totalMeasures];
			for ( int k=0; k<totalMeasures; k++ )
			{
				resultsForChunks[k]=new MeasureResults*[totalWindows];
				averageResults[k]=new MeasureResults*[totalUsedSNPs];
			}
			int* pos;
			MeasureResults*** temp, * temp2[totalSamples];
			cout <<"\nTotal number of windows calculated: " << totalWindows<<endl;
//totalWindows=2;
			for ( int i=0; i<totalWindows; i++ )  // WINDOWS
			{
				// for each given window, repeat the process of calculating p-values
				if ( ( i+1 ) %10==0 )
					cout <<"window number: " << i+1 <<"\n";
				pos=sw->getAbsolutePositions ( i );
//cout <<"positions:\n";
//print(pos, sw->getWindowSize());
				temp=new MeasureResults**[totalSamples];
				for ( int j=0; j<totalSamples; j++ )  // SAMPLES
				{
    					temp[j]=NULL;
					// for each sample file in disk (in the corresponding window) it calculates p-values
					if ( totalSamples>1 && ( j+1 ) %10==0 )
						cout <<"sample number: " << j+1 <<endl;

					if ( genericMLTests[j]!=NULL )
					{
						// genericMLTests has the data for each sample
						genericMLTests[j]->setSampleGenericCounts ( pos, sw->getSizeOfWindow ( i ) );
						//cout << "calculate p-values for 'measures'";
						 temp[j]=genericMLTests[j]->getResults ( measures, listOfStreams );  // <-- P-VALUES

						// free memory of tuCounts generated
					genericMLTests[j]->emptyCounts();
					}
					else	temp[j]=NULL;
				}
				for ( int k=0; k<totalMeasures; k++ )
				{

					// for each measure it computes association rates if more than one sample is used
					for ( int j=0; j<totalSamples; j++ )
						if ( temp[j]!=NULL ) temp2[j]=temp[j][k];
						else temp2[j]=NULL;
					if ( totalSamples==1 )
						if ( temp2[0]==NULL ) throw NullValue ( "the first sample cannot be null" );
						else resultsForChunks[k][i]=temp2[0]->clone();
					else resultsForChunks[k][i]=new MultipleSamplesRateResults ( temp2, totalSamples, alpha, returnPVals );



					//cout <<"measure:" << measures->getElement(k)->getName();
					//cout <<"pval:" << *resultsForWindows[k][i] <<"\n";
				}
				for ( int j=0; j<totalSamples; j++ )
					zaparr ( temp[j], totalMeasures );

				zaparr ( temp, totalSamples );
				zaparr ( pos );

				//cout <<"iniSecond\n";
				//for (int x=0; x<100000; x++)
				//for (int y=0; y<20000; y++);
				//cout <<"end\n";

			} // LOOP FOR CALCULATION OF P-VALUES

			// begin STATISTICS FOR RESULTS?
			{
			 intSet* windowOverlaps;
				MeasureResults** mr=NULL;
				int totalOverlaps;
				for ( int i=0; i<totalUsedSNPs; i++ )
				{
					windowOverlaps=sw->getWindowOverlapsForPosition ( i );
					totalOverlaps=windowOverlaps->size();
					mr=new MeasureResults*[totalOverlaps];
					for ( int j=0; j<measures->size(); j++ )
					{
						for ( int k=0; k<totalOverlaps; k++ )
							mr[k]=resultsForChunks[j][windowOverlaps->getElement ( k ) ];
						averageResults[j][i]=mr[0]->getAverage ( mr, totalOverlaps );
					}
					zaparr ( mr);  // DO NOT CHANGE: we do not want to delete the objetcs, only the pos
				}
				if ( measureFiles )
					for ( Container<vector<ofstream*>,ofstream*>::iterator it=listOfStreams->begin(); it<listOfStreams->end(); it++ )
						listOfStreams->getElement ( it )->close();
			}
			// end STATISTICS FOR RESULTS?

		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from GWASByWindows::setResults()" ); throw;};
	}

	/*___________________________________________________________ */

	void GWASByWindows::setAverageResults()
	{

			averageResults=new MeasureResults**[totalMeasures];
			 intSet* windowOverlaps;
				MeasureResults** mr=NULL;
				int totalOverlaps;

                  for ( int k=0; k<totalMeasures; k++ )
                        averageResults[k]=new MeasureResults*[totalUsedSNPs];
                        



				for ( int i=0; i<totalUsedSNPs; i++ )
//if (i<50)
				{
					windowOverlaps=sw->getWindowOverlapsForPosition ( i );
					totalOverlaps=windowOverlaps->size();
					mr=new MeasureResults*[totalOverlaps];
					//cout <<"snp: " << i <<"\n";
					//cout <<"windows overlaps are:" << *windowOverlaps <<"\n";
					for ( int j=0; j<measures->size(); j++ )
					{
						for ( int k=0; k<totalOverlaps; k++ )
							{
							mr[k]=resultsForChunks[j][windowOverlaps->getElement ( k ) ];
							 //cout << "pval para ventana " << windowOverlaps->getElement ( k ) <<": " << mr[k]->getMainResult();
							}
						averageResults[j][i]=mr[0]->getAverage ( mr, totalOverlaps );
						//cout <<" average results is: " << averageResults[j][i]->getMainResult() <<" and now is ";
//averageResults[j][i]->print(cout, 1);
					}
					zaparr ( mr);  // DO NOT CHANGE: we do not want to delete the objetcs, only the pos
				}
//exit(0);
}

	/*___________________________________________________________ */

	int* GWASByWindows::getPositions(int i)
	{
		return sw->getAbsolutePositions ( i );
	}

	/*___________________________________________________________ */

	int GWASByWindows::getSizeOfChunk(int i)
	{
		return sw->getSizeOfWindow ( i );
	}

	/*___________________________________________________________ */
/*
	MeasureResults***  GWASByWindows::getResultsForWindows()
	{
		return getResultsForChunks();
	}


	/*___________________________________________________________ */

	MeasureResults***  GWASByWindows::getAverageResults()
	{
		return averageResults;
	}
	/*___________________________________________________________ */

	MeasureResults**  GWASByWindows::getResultsForWindowsForMeasure ( int measureIndex )
	{
		return getResultsForWindowsForMeasure(measureIndex);
	}
	/*___________________________________________________________ */

	MeasureResults**  GWASByWindows::getAverageResultsForMeasure ( int measureIndex )
	{
		return averageResults[measureIndex];
	}

/*___________________________________________________________ */

	string   GWASByWindows::getDescription ()
	{

return string("_SWOfSize")+tos(originalWidth)+"AndOffsetOf"+tos(sw->getOffset());
}
	/*___________________________________________________________ */

	void  GWASByWindows::printAverageResults ( bool verticalOutput, const char* extension )
	{
		try
		{
			char filename[512], filename2[512], *single;

			strcpy ( filename, resultsDir );
			single=removeDir ( fileSample );
			if ( totalSamples>1 ) strcat ( filename, single );
			else
			{
				strcat ( filename, removeExtension ( single ) );
				strcat ( filename, "_" );
			}

			zaparr ( single );

//int trainingSize= measures->getElement ( i )->partialTuCountsTraining[0]->getParentalGenotypes()->size() <<" plus " << partialTuCountsTest[0]->getParentalGenotypes()->size() <<"\n";
//cout << "size of test:" << genericExternalCounts[i]->getParentalGenotypes()->size() <<"\n";


			for ( int i=0; i<totalMeasures;i++ )
			{

				sprintf ( filename2, "%saverageResultsForExternalTestMode%sAndInternalTestMode%s_SWOfSize%dAndOffsetOf%d_%s.", filename, externalTestModeClass->print ().c_str(), internalTestModeClass->print ().c_str(), originalWidth, sw->getOffset(), measures->getElement ( i )->getName().c_str() );
				if ( extension==NULL )
					if ( returnPVals ) strcat ( filename2, "pVal" );
					else strcat ( filename2, "mult" );
				else strcat ( filename2, extension );
				OpenOutput ( filename2, &OutputFile );
				if ( averageResults[0][0]==NULL ) throw NullValue ( "GWASByWindows::printAverageResults()" );
				if ( verticalOutput )
				{
					averageResults[0][0]->printHeading ( OutputFile );
					OutputFile << "\n";
				}
				for ( int j=0; j<totalUsedSNPs; j++ )
				{
					averageResults[i][j]->print ( OutputFile, verticalOutput );
					OutputFile << "\n";
				}
				OutputFile.close();
				cout <<"\nResults have been written in: " << filename2;
			}
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from GWASByWindows::printAverageResults(bool verticalOutput, const char* dir, const char* extension)" ); throw;};
	}
	/*___________________________________________________________ */
/*
	Container<vector<ofstream*>,ofstream*>*    GWASByWindows::getWindowsStreams ( bool oneFile, const char* extension )
	{



return getChunksStreams(oneFile, extension);
}
/*___________________________________________________________ */
/*
	Container<vector<ofstream*>,ofstream*>*    GWASByWindows::getChunksStreams ( bool oneFile, const char* extension)
	{

return getWindowsStreams(oneFile, extension);
}
	
	/*___________________________________________________________ */

	void   GWASByWindows::printResultsForWindows ( bool verticalOutput, bool oneFile, const char* extension, stringList* firstPartHeading, stringList* rowHeading )
	{
printResultsForChunks(verticalOutput, oneFile, extension, firstPartHeading, rowHeading);
	}

	/*___________________________________________________________ */
	/*
	void  GWASByWindows::printResultsForWindow()
	{
	char filename[256];
	for (int i=0; i<totalMeasures;i++)
	{
	strcpy(filename, fileSample);
	sprintf(filename, "%s_resultsForSWOfSize%dAndOffsetOf%d_%s.mult", fileSample, sw->getWindowSize(), sw->getOffset(), measures->getElement(i)->getName().c_str());
	cout <<"Results have been written in: " << filename <<"\n";
	OpenOutput(filename, &OutputFile);
	resultsForWindows[0][0]->printHeading(OutputFile);
	OutputFile << "\n";
	for (int j=0; j<totalWindows; j++)
	 OutputFile << *resultsForWindows[i][j] << "\n";
	OutputFile.close();
	}
	}

	/*___________________________________________________________ */
	/*
	MeasureResults**  GenericMLTest::getResults(ListOfGenericMeasures* measures, int*pos, int size)
	{
	MeasureResults*** results=new MeasureResults**[measures->size()], **finalResults=new MeasureResults*[measures->size()];
	GenericMeasure** training=NULL, **test=NULL;
	char file[256], currentFile[256];
	stringSample*sample, *result;
	string t;
	SampleGenericCounts* genericCounts=NULL;
	//GenericSample* gs;
	for (int k=0; k<measures->size();k++)
	{
	results[k]=new MeasureResults*[testMod->numberOfFolds];
	}
	for (int i=0; i<testMod->numberOfFolds;i++)
	{
	cout <<"fold number: " << i <<"\n";
	 training=new GenericMeasure*[measures->size()];
	 test=new GenericMeasure*[measures->size()];
	for (int j=0; j<2;j++)
	{
	if (j==0) t=string("dat"); else t=string("test");
	 changeExtension(fileName, file, (t+tos(i)).c_str());


	 for (int k=0; k<measures->size(); k++)
	 if (j==0)
	 {
	  if (k==0) {genericCounts=getCounts(file, pos, size);}
	  training[k]=measures->getElement(k)->getNewGenericMeasure(genericCounts);
	   cout <<"meuasreis:" << training[k]->getName()<<"\n";
	      cout << *training[k]<<"\n";
	 }
	 else
	 {
	 test[k]=training[k]->getNewGenericMeasure(genericCounts, true);
	 results[k][i]=test[k]->getResults();
	       cout <<"meuasreis:" << *test[k]<<"\n";
	       cout << *results[k][i] <<"\n";
	 }
	 remove(currentFile);
	 }
	  zap(genericCounts);
	  zaparr(training, measures->size()); zaparr(test, measures->size());
	}
	for (int k=0; k<measures->size();k++)
	{
	finalResults[k]=results[k][0]->getAverage(results[k], testMod->numberOfFolds);
	zaparr(results[k], testMod->numberOfFolds);
	}
	zaparr(results, measures->size());
	zaparr(pos);

	return finalResults;
	}
	*/
} // end namespace
#endif
