/* File: GWAS.h */


#ifndef __GWASByWindows_h__
#define __GWASByWindows_h__



namespace BIOS {


/************************/
/* SNP'S GENOTYPE DEFINITION */
/************************/


/**
        @memo GWAS

	@doc
        Definition:
	IT decomposes a region of regionLength snps, starting at snp "firstSNP" in slinding windows of size "windowSize" and offset "offset"        

        Memory space:

        @author Maria M. Abad Grau
	@version 1.0
*/

//typedef TestMode;
 
class GWASByWindows: public GWAS {


protected:


    /** @name Implementation of class Genotype
        @memo Private part.
    */

SlidingWindows* sw;
int width, originalWidth, totalWindows;
MeasureResults*** resultsForWindows;
MeasureResults*** averageResults;// first pointer is for each measure, second pointer is for SNP index

private:


virtual int* getPositions(int pos);
virtual int getSizeOfChunk(int pos);
public:


  
  // List of params for the constructor
  
ListOfGenericMeasures* measures_;
char* fileSample_;
const char* resultsDir_;
int totalSamples_;
TestMode internalTestMode_;
TestMode externalTestMode_;
int externalNumberOfFolds_;
int internalNumberOfFolds_; 
int width_;
int offset_;
int totalPermutations_;
int iniPos_;
int length_;
bool measureFiles_;
bool useOnlyHetero_;
bool returnPVals_;
AlleleOrderType genotypeOrder_;
PhaseAlg phaseAlg_;
EMDistributions emDistributions_;
EMRestriction emRestriction_;
intList* alpha_;
bool printGWASConf_;
  
/**
 * Sets gwas necessary parameters to compute measures with holdout internal to the measures.
 */
void setupForInternalHoldout();

/**
 * GWAS for training. The whole sample is given to the measures.
 */
void setupForTraining();


GWASByWindows();
void set();
//void setMeasureFiles(bool measureFiles=true);

GWASByWindows(char* fileSample, ListOfGenericMeasures* measures){

measures_ = measures;
fileSample_ = fileSample;
resultsDir_="./";
totalSamples_=1;
internalTestMode_=tTraining;
externalNumberOfFolds_=-1;
internalNumberOfFolds_=-1; 
width_=10;
offset_=1;
totalPermutations_=100;
iniPos_=0;
length_=-1;
measureFiles_=false;
useOnlyHetero_=true;
returnPVals_=false;
genotypeOrder_=BIOS::incompleteLeftRight;
phaseAlg_=weighted;
emDistributions_=UTDistributions;
emRestriction_=triosBasedRestriction;
alpha_=NULL;
externalTestMode_=tTraining;
printGWASConf_=false;
}
/*
void start(){
// 
try
{
set(measures_, fileSample_, resultsDir_, totalSamples_, internalTestMode_, internalNumberOfFolds_, externalNumberOfFolds_, width_, offset_, totalPermutations_, iniPos_, length_, measureFiles_, useOnlyHetero_, returnPVals_, genotypeOrder_, phaseAlg_, emDistributions_, emRestriction_, alpha_, externalTestMode_, printGWASConf_);
}
catch (BasicException& be){be.addMessage("\ncalled from GWAS::start()"); throw;};
  
}
*/

// testModeForInsideMeasure: 0,1,2 (0: false, 1: true and external is training default, 2: true and external is halfTraining)
GWASByWindows(ListOfGenericMeasures* measures, char* fileSample, bool trios=true, const char* resultsDir=NULL, int totalSamples=1, TestMode internalTestMode=tTraining, int internalNumberOfFolds=5, int externalNumberOfFolds=5, 
int width=10, int offset=1, int totalPermutations=100, int iniPos=0, int length=-1, bool measureFiles=false, bool useOnlyHetero=true, bool returnPVals=false,
AlleleOrderType genotypeOrder=incompleteLeftRight, PhaseAlg phaseAlg=weighted, EMDistributions emDistributions=UTDistributions, EMRestriction emRestriction=triosBasedRestriction,   intList* alpha=NULL, TestMode externalTestMode=tTraining, bool printGWASConf=false, int verbatim=0);
//GWAS(GenericMLTest** genericMLTest, char* fileSample, int totalSamples, TestModeClass *testMod, bool useOnlyHetero, int iniPos, int length, int width, int offset, ListOfGenericMeasures* measures, PairOfDoublesVector* alpha);

GWASByWindows ( ListOfGenericMeasures* measures, char* trainingFileSample, char* testFileSample, bool trios, const char* resultsDir, int width, int offset, int totalPermutations=0, int iniPos=0, int length=-1, bool measureFiles=true, bool useOnlyHetero=true, bool returnPVals=false, AlleleOrderType genotypeOrder=incompleteLeftRight, PhaseAlg phaseAlg=onlyKnown, EMDistributions emDistributions=UTDistributions, EMRestriction emRestriction=triosBasedRestriction,   intList* alpha=NULL,  bool printGWASConfig=false, int verbatim=0 );

MeasureResults** getResultsForWindowsForMeasure(int measureIndex);// results for a measure
//MeasureResults*** getResultsForWindows();// results for all windows
MeasureResults** getAverageResultsForMeasure(int measureIndex);// results for a SNP
MeasureResults*** getAverageResults();// results for all SNPs
~GWASByWindows();
void  printAverageResults(bool verticalOutput=true, const char* extension=NULL);
void  printResultsForWindows(bool verticalOutput=true, bool oneFile=true, const char* extension=NULL, stringList* firstPartHeading=NULL, stringList* rowHeading=NULL);
void printGWASConf();

virtual void setAverageResults();

//Container<vector<ofstream*>,ofstream*>*    getWindowsStreams ( bool oneFile, const char* extension );

//virtual Container<vector<ofstream*>,ofstream*>*    getChunksStreams ( bool oneFile, const char* extension );

virtual string getDescription();


};
} // end namespace
#endif


