/* File: MultimarkerMeasure.h */


#ifndef __GeneticCounts_cpp__
#define __GeneticCounts_cpp__





//using namespace stats;

namespace BIOS {


/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/



///////////////////
//// public ////////
///////////////////

/*____________________________________________________________ */
/*
GeneticCounts* GeneticCounts::clone()
{
return new GeneticCounts(*this);
} 


/*_________________________________________________________________*/

GeneticCounts::GeneticCounts(int* pos, int length, HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations): GenericCounts(totalPermutations)
{
this->hapExtractionConfiguration=hapExtractionConfiguration;
this->length=length;
if (pos!=NULL)
{
this->pos=new int[length];
for (int i=0; i<length; i++)
 this->pos[i]=pos[i];
}
else this->pos=NULL;
}

/*_________________________________________________________________*/

GeneticCounts::GeneticCounts(GeneticCounts& tu): GenericCounts((GenericCounts&) tu)
{
pos=NULL;
if (tu.pos!=NULL)
{
pos=new int[tu.getTotalPos()];
for (int i=0; i<tu.getTotalPos(); i++)
 pos[i]=tu.pos[i];
}
length=tu.length;
this->hapExtractionConfiguration=tu.hapExtractionConfiguration;
}

 


/*_________________________________________________________________*/

GeneticCounts::~GeneticCounts ()
{
empty();
}

/*_________________________________________________________________*/

void GeneticCounts::empty ()
{
zaparr(pos);


}



/*_________________________________________________________________*/

GeneticCounts::GeneticCounts(): GenericCounts()
{
length=0;
hapExtractionConfiguration=NULL;
pos=NULL;
}

/*_________________________________________________________________*/

void GeneticCounts::print(ostream& out)
       {
          out <<"size is:" << getTotalPos() <<"\n";
for (int i=0; i<getTotalPos();i++)
out <<"pos at " << i << ": " << pos[i] <<"\n";

out <<*getHapExtractionConfiguration() <<"\n";

};



/*_________________________________________________________________*/

HapExtractionConfiguration* GeneticCounts::getHapExtractionConfiguration()
{
return hapExtractionConfiguration;
}

  /*_________________________________________________________________*/

   int GeneticCounts::getTotalPos()
  {
  return length;
  }

  /*_________________________________________________________________*/

   int* GeneticCounts::getPositions()
  {
  return pos;
  }





};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */

//stringList * BIOS::GeneticCounts::getTDTFreqsResults(SNPPos snpPos)
//{
//}






