/* File: PhylogeneticDistance.h */

#ifndef __GeneticCounts_h__
#define __GeneticCounts_h__

//using namespace stats;

namespace BIOS {


/************************/
/* SNP'S MultimarkerMeasure DEFINITION */
/************************/


/**
        @memo TUCounters for a given window in a TrioSample

	@doc
        Definition:

       Class used mainly to compute multimarker TU measures. In order to similarity measures to can be applied, haplotype counters (or freqs if EM-freq is used) for each couple must be independently kept 

       With this purpose, the data structures required is:
 
       Container<vector, ParentalHaplotypes> *parentalHaps   

        @author Maria M. Abad
	@version 1.0
*/


class HapExtractionConfiguration;


 
class	GeneticCounts: public GenericCounts {

protected:

HapExtractionConfiguration* hapExtractionConfiguration;//how haps were extracted from genotytpes
//GeneticCounts** permutations;

int* pos; // used positions (NULL if all positions from parentalGenotypes are used)
int length;




/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

private:


//void set(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations);  



      public:

GeneticCounts();

//	GeneticCounts(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, AlleleOrderType alleleOrderType=LeftRight, PhaseAlg=weighted, EMDistributions emDistributions=UTDistributions, EMRestriction emRestriction=triosBasedRestriction, int totalPermutations=100);

GeneticCounts(int*pos, int length, HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations);

//GeneticCounts(char* filename, HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations);
	
 GeneticCounts(GeneticCounts& source);
 
virtual int getTotalPos();

int* getPositions();
 
 //GeneticCounts(char*filename);

 //virtual GeneticCounts* clone();

virtual ~GeneticCounts();

virtual void empty();

HapExtractionConfiguration* getHapExtractionConfiguration();

//virtual void setPermutations();



void print(ostream&);

};  // End of class GeneticCounts








};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */




