/* File: GeneticUnit.cpp */


#ifndef __GeneticUnit_cpp__
#define __GeneticUnit_cpp__

//using namespace UTILS;


namespace BIOS
{



	void GeneticUnit::checkRangeSNP ( SNPPos SNP )
	{
		if ( SNP<0 || SNP>=size() ) throw OutOfBounds ( SNP, size(), "GeneticUnit::CheckRangeSNP(SNPPos SNP)" );
	}
	
	/*____________________________________________________________ */

	void GeneticUnit::setOutputSeparator ( char outputSeparator )
	{
//cout << "outputseparator is assigned to be" << outputSeparator << "me gusta\n";
		this->outputSeparator=outputSeparator;

	};

	/*_____________________________________________________*/
/*
	void GeneticUnit::print()
	{
		cout << *this <<endl;
	}


	/*_____________________________________________________*/

	GeneticUnit::GeneticUnit ( SNPPos totalPos, char outputSeparator , char leftDelimiter, char rightDelimiter )
	{
		totalSNPs=totalPos;
		this->outputSeparator=outputSeparator;
						this->leftDelimiter=leftDelimiter;
		this->rightDelimiter=rightDelimiter;
	}



	/*_____________________________________________________*/

	GeneticUnit::GeneticUnit ( char outputSeparator , char leftDelimiter, char rightDelimiter )
	{
		totalSNPs=0;
		this->outputSeparator=outputSeparator;
				this->leftDelimiter=leftDelimiter;
		this->rightDelimiter=rightDelimiter;
	}


	

	

	/*_____________________________________________________*/


	GeneticUnit::GeneticUnit ( const GeneticUnit & source )
	{
		try
		{
			totalSNPs=source.totalSNPs;
			
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from 	GeneticUnit::GeneticUnit ( const GeneticUnit & source )" ); throw;};

	}
	
	
	/*_____________________________________________________*/
/*_____________________________________________________*/

	void GeneticUnit::setLength( int totalLength)
	{
		totalSNPs=totalLength;
	}

	

	/*_____________________________________________________*/

	int GeneticUnit::size()
	{
		return totalSNPs;
	}

	

	
	;
	/*_____________________________________________________*/


	bool GeneticUnit::operator!= ( GeneticUnit & g )
	{
		return ! ( g==*this );
	}



	

	

	



};  // End of Namespace

#endif

/* End of file: GeneticUnit.h */




