/* File: GeneticUnit.h */


#ifndef __GeneticUnit_h__
#define __GeneticUnit_h__

//using namespace UTILS;


namespace BIOS {


/************************/
/* SNP'S GeneticUnit DEFINITION */
/************************/


/**
        @memo GeneticUnit for SNPs

	@doc
        Definition:
        A unordered pair of SNPs values for an individual and a genetic position.
        One has been transmitted from the father, one for the mother. Who transmits
        each one of them does not matter.

        Memory space: O(1). 

        @author Maria M. Abad
	@version 1.0
*/
//class GeneticUnit;
//typedef Set<GeneticUnit*>::Class GeneticUnitSet;




 
class GeneticUnit {


private:
    /** @name Implementation of class GeneticUnit
        @memo Private part.
    */

	

 //  char* line;
/**
   @memo Pointer to the array of snps. It's NULL if snps has not been assigned yet.
*/


/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

/* Head */




		/* PUBLIC FUNCTIONS (INTERFACE) */

public:



	SNPPos totalSNPs;
	char outputSeparator, leftDelimiter, rightDelimiter;

      /** @name Operations on GeneticUnit 
        @memo Operations on a GeneticUnit 
    */

      /**
         @memo Constructor 
         @doc
          Allocate memory an initialize to null.
          Complexity O(1).

      */
GeneticUnit(char outputSeparator='\0', char leftDelimiter='\0', char rightDelimiter='\n');

GeneticUnit(SNPPos TotalSNPs, char outputSeparator='\0', char leftDelimiter='\0', char rightDelimiter='\n');


virtual ~GeneticUnit (){};

void setOutputSeparator ( char outputSeparator );


void setLength(int totalPos);

virtual GeneticUnit* clone()=0;

GeneticUnit ( const GeneticUnit & source );


virtual bool operator==(const GeneticUnit & g)=0;//{cout <<"Not implemented yet"; exit(0);};;

bool operator!=(GeneticUnit & g);


void checkRangeSNP ( SNPPos SNP );


virtual double getDistance ( GeneticUnit* otherG, int position=0, bool toLeft=false )=0;

	//void print();

		virtual void print(ostream& out)=0;

	//	bool  operator>(const GeneticUnit & ge);

		virtual bool  operator<(const GeneticUnit & ge)=0;

//bool  operator> ( GeneticUnit * ge ); 



	int size();

virtual bool  operator< ( const GeneticUnit * ge ) const=0; 

virtual string getName()=0;

static GeneticUnit* fromString(string s){throw NonImplemented("static GeneticUnit* fromString(string s)");};


};  // End of class GeneticUnit

/*__________________________________________*/

ostream& operator<<(ostream& os, GeneticUnit& hap)//{throw NonImplemented("ostream& operator<<(ostream& os, GeneticUnit& hap");};
{
GeneticUnit* h=&hap;
h->print(os);
return os;
}

//bool operator<( const GeneticUnit& a1, const GeneticUnit& a2 )=0;


//bool operator<( const HapP& a1, const HapP& a2 );

};  // End of Namespace



#endif

/* End of file: GeneticUnit.h */




