#ifndef __GeneticUnitCounts_h__
#define __GeneticUnitCounts_h__

namespace BIOS
{

	/**
	GeneticUnitCounts: a genetic unit (haplotype or genotype) and their frequencies in a given sample 
**/


	class GeneticUnitCounts
	{
		public:

GeneticUnit * geneticUnit;

		public:

			double firstFreq, secondFreq;

			/**
			* Constructor
			*/
			GeneticUnitCounts ();

		
			GeneticUnitCounts ( GeneticUnitCounts& other );

			GeneticUnitCounts ( GeneticUnit* unit, float first, float second );


			virtual GeneticUnitCounts * filter(int *pos, int length)=0;

			virtual ~GeneticUnitCounts();

void empty(){zap(geneticUnit);};

			GeneticUnit* getGeneticElement();


			void add(int firstFreq, int secondFreq);


			int size();

		
			/**
			*	Compares two haplotypes. Only compares alleles, not frecuencies and other properties.
			*	@return true if both have the same alleles. false otherwise
			*/
			bool hasSameAllelesAs ( GeneticUnitCounts * h );

			/**
			*	Compares two haplotypes, inluding all properties
			*	@return true if haplotypes are equal
			*/
			virtual bool operator== ( GeneticUnitCounts & h );

virtual bool operator!= ( GeneticUnitCounts & h );

			/**
			*	Compares two haplotypes, inluding all properties
			*	@return true if haplotypes are different
			*/
			//virtual bool operator!= ( GeneticUnitCounts & h )=0;

			virtual void sumProps(GeneticUnitCounts * h);


			virtual int getCommonPositions(GeneticUnitCounts* other, intList* positions)=0; 

			virtual GeneticUnitCounts* fromString ( string s ) {throw NonImplemented ( "GeneticUnitCounts::fromString(string s)" );};

			virtual GeneticUnitCounts* clone()=0;// {return new GeneticUnitCounts ( *this );};

			/**
			* Prints the GeneticUnitCounts in the following manner: [ a0 a1 ... an ][frequency][T/U]
			* @param output Output stream
			* @param h Vector to print
			*/
			friend ostream& operator<< ( ostream& output,  GeneticUnitCounts& h )
			{
h.print(output);
return output;
}


			/*
						static void print(GeneticUnitCounts *h){
							for(int i=0; i< h->size()-1; i++)
								printf("%i ", (*h)[i]);
						}
				*/
			virtual void print(ostream& output);

double getFirstFrequency();

double getSecondFrequency();

virtual double getThirdFrequency();

void setFirstFrequency(double f);
void setSecondFrequency(double f);
virtual void setThirdFrequency(double f);

	};
	
	/*___________________________________________________________________________________*/

 

template <>
	template <>
Container< vector<GeneticUnitCounts*, allocator<BIOS::GeneticUnitCounts*> > , GeneticUnitCounts*>::iterator
Container< vector<GeneticUnitCounts*, allocator<BIOS::GeneticUnitCounts*> > , GeneticUnitCounts*>::findElementContainingInternalElement ( GeneticUnit* element )
	{
//cout <<" findinel" << *element <<"\n";
		for ( GeneticUnitCountsList::iterator p=this->getFirst();p!=this->end();p++ )
		{
			if ( *this->getElement ( p )->getGeneticElement() ==*element ) return p;
		}

		return this->end();

	};


	
		/*___________________________________________________________________________________*/
		
	template <> Container< vector<GeneticUnitCounts*, allocator<BIOS::GeneticUnitCounts*> > , GeneticUnitCounts*>::iterator
	Container< vector<GeneticUnitCounts*, allocator<BIOS::GeneticUnitCounts*> > , GeneticUnitCounts*>::findEqualElement (  GeneticUnitCounts* const & element )
	
	//	template <> template <> GeneticUnitCountsList::iterator GeneticUnitCountsList::findEqualElement(const GeneticUnitCounts*& element)
	{
		try
		{

//cout <<"element is: " << *element << "\n";
//GeneticUnitCounts* g;
			for ( GeneticUnitCountsList::iterator it=this->begin(); it!=this->end(); it++ )
			{

//cout <<"el" << **it <<"\n";
				//g=*it;
				if ( (*it)->hasSameAllelesAs(element) )
				{
					return it;
				}
//cout <<"INNN333\n";
			}
//cout <<"INNN44\n";
			return this->end();
		}
		catch ( BasicException & be )
		{
			be.addMessage ( "\ncalled from typename Container<Cont, T>::iterator Container<Cont, T>::findEqualElement (const T& element)" );
			throw;
		};
	}



};

#endif
