
/* File: GenomaSample.cpp */



#ifndef __GenomaSample_cpp__
#define __GenomaSample_cpp__





namespace BIOS
{
  
#include "../commonc++/Container.cpp" 
  #include "GeneticUnitCounts.h"
  

//bool GenomaSample::extendedMakeped=true;

/*____________________________________________________________ */


GenomaSample* GenomaSample::clone()
{
try{

    return new GenomaSample ( ( GenomaSample& ) *this );
}
    catch ( BasicException& be ) {
        be.addMessage ( "\ncalled from GenomaSample* GenomaSample::clone()" );
        throw;
    };
}


/*____________________________________________________________ */
/*
GenomaSample* GenomaSample::copyElementsWithPositionsIn(intSet* positions, bool inThis)
{
PhenotypeSample* rP=(PhenotypeSample*)this->phenotypeSample->copyElementsWithPositionsIn(positions, inThis);
GenotypeSample* gP=(GenotypeSample*)this->genotypeSample->copyElementsWithPositionsIn(positions, inThis);
GenomaSample* result= new  GenomaSample(*rP, *gP);
//result->PrintPhenotypes();
if (this.Marked!=NULL) {cout <<"\nIndividuals cannot be marked in the source sample when selection of individuals is to be performed"; throw BadFormat("");}
result.Marked=NULL;
result.currentIc=currentIc;
result.currentGender=currentGender;
result.currentAffectation=currentAffectation;
zap(rP);
zap(gP);
return result;
}
/*____________________________________________________________ */

GenomaSample::GenomaSample(int verbose):GenericSample(verbose)
{
    phenotypeSample=NULL;
    genotypeSample=NULL;
    currentIc=everybody;
    currentGender=everyGender;
    currentAffectation=allAffectation;
    Marked=NULL;
};
/*____________________________________________________________ */
/*
GenomaSample::GenomaSample(GenomaSample& source, Container<vector<SNPPos>, SNPPos>* SNPSampling)
{
cout << "GenomaSample(GenomaSample& source, Container<vector<SNPPos>, SNPPos>* SNPSampling) non implemented. Try GenomaSample(GenomaSample& source, Container<set<SNPPos>, SNPPos>* SNPSampling)";
exit(0);
};
/*____________________________________________________________ */

GenomaSample::GenomaSample ( GenomaSample& source, Container<vector<SNPPos>, SNPPos>* SNPSampling, bool selectInds ):GenericSample(source.verbose, source.outputSeparator, source.leftDelimiter, source.rightDelimiter)
{
try{
    copy ( source, SNPSampling, selectInds );
}
    catch ( BasicException& be ) {
        be.addMessage ( "\ncalled from GenomaSample::GenomaSample ( GenomaSample& source, Container<vector<SNPPos>, SNPPos>* SNPSampling, bool selectInds )" );
        throw;
    };
};

/*____________________________________________________________ */

GenomaSample::GenomaSample ( GenomaSample& source, Container<vector<string>, string>* selectedPositions, char* filePos, bool missingData ):GenericSample(source.verbose)
{
// it creates a GenomeSample with only genotypes in source whose positions (physical or rs numbers) are in the set of selectedPositions. In order to know the position in the source that will be used, a filePos is provided to match the set of positions with them
try{
    if ( selectedPositions==NULL )
    {
        copy ( source );
        return;
    }
    stringList* sourcePositions=new stringList ( filePos, "", '\n' );
    intList*selectedFilePositions=sourcePositions->copyPositionsWithElementsIn ( selectedPositions, false, missingData );
//cout << "positions selected: " << *selectedFilePositions <<"\n";
    copy ( source, selectedFilePositions, false, missingData );
    zap ( selectedFilePositions );
    zap ( sourcePositions );
}
    catch ( BasicException& be ) {
        be.addMessage ( "\ncalled from GenomaSample::GenomaSample ( GenomaSample& source, Container<vector<string>, string>* selectedPositions, char* filePos, bool missingData )" );
        throw;
    };
}
/*____________________________________________________________ */

GenomaSample* GenomaSample::selectPositions ( Container<vector<string>, string>* selectedPositions, char* filePos, bool missingData )
{
    return new GenomaSample ( *this, selectedPositions, filePos, missingData );

}
/*____________________________________________________________ */

GenomaSample* GenomaSample::filter ( SNPPos* positions, int size )
{
try
{
    intList* selectedPositions=new intList ( positions, size );
//cout <<"current genome sample is: " << *this << endl;
cout <<"first genotype has size: " << genotypeSample->getFirstElement()->size() << " snps\n";
    GenomaSample* result= new GenomaSample ( *this, selectedPositions, false );
    zap ( selectedPositions );
    return result;
   }
    catch ( BasicException& be ) {
        be.addMessage ( "\ncalled from GenomaSample::filter ( SNPPos* positions, int size )" );
        throw;
    };
}
/*____________________________________________________________ */

GenomaSample::GenomaSample ( PhenotypeSample& sourceP, GenotypeSample& sourceG, int verbose ):GenericSample(verbose)
{
    phenotypeSample=new PhenotypeSample ( sourceP );
    genotypeSample=new GenotypeSample ( sourceG );
    currentIc=everybody;
    currentGender=everyGender;
    currentAffectation=allAffectation;
    Marked=NULL;
};
/*____________________________________________________________ */

void GenomaSample::copyPaste ( GenericSample* source )
{
    GenomaSample* sourc=(GenomaSample*)source;
    if ( ( sourc->genotypeSample==NULL ) || ( sourc->phenotypeSample==NULL ) )
        throw NullValue ( "GenomaSample::copyPaste" );

    phenotypeSample->copyPaste(sourc->phenotypeSample);
    genotypeSample->copyPaste(sourc->genotypeSample);

    setMarked ( currentIc );
}

/*____________________________________________________________ */

void GenomaSample::copy ( GenomaSample& source, Container<vector<SNPPos>, SNPPos>* SNPSampling, bool selectInds, bool missingData )
{
try
{
    if ( ( source.genotypeSample==NULL ) || ( source.phenotypeSample==NULL ) )
        throw NullValue ( "GenomaSample::copy" );
    phenotypeSample=NULL;
    genotypeSample=NULL;
    Marked=NULL;
    currentIc=source.currentIc;
    currentGender=source.currentGender;
    currentAffectation=source.currentAffectation;
    this->verbose=source.verbose;
    if ( selectInds )
    {
        phenotypeSample= ( PhenotypeSample* ) source.phenotypeSample->copyElementsWithPositionsIn ( SNPSampling );
        genotypeSample= ( GenotypeSample* ) source.genotypeSample->copyElementsWithPositionsIn ( SNPSampling);
    }
    else // genome positions
    {
        Marked=NULL;
        currentIc=source.currentIc;
        currentGender=source.currentGender;
        currentAffectation=source.currentAffectation;
        phenotypeSample=new PhenotypeSample ( *source.phenotypeSample );
        genotypeSample=new GenotypeSample ( *source.genotypeSample, SNPSampling, missingData );
    };
//if (currentIc!=everybody)
    setMarked ( currentIc );
}
    catch ( BasicException& be ) {
        be.addMessage ( "\ncalled fromGenomaSample::copy ( GenomaSample& source, Container<vector<SNPPos>, SNPPos>* SNPSampling, bool selectInds, bool missingData)" );
        throw;
    };
}

/*____________________________________________________________ */

GenomaSample::GenomaSample ( char* filename, int*pos, int size, IndCategory ic, AlleleOrderType AlleleOrderMod, int inputFormat, int verbose, char outputSeparator, char leftDelimiter, char rightDelimiter ):GenericSample(verbose, outputSeparator, leftDelimiter, rightDelimiter)
{
    try
    {
        //GenomaSample::extendedMakeped=extendedMakeped;
        phenotypeSample=new PhenotypeSample ( filename, inputFormat );
        genotypeSample=new GenotypeSample ( filename, pos, size, AlleleOrderMod, inputFormat, outputSeparator, leftDelimiter, rightDelimiter );
        currentIc=ic;
        currentGender=everyGender;
        currentAffectation=allAffectation;
        Marked=NULL;
	//if (currentIc!=nobody)
        setMarked ( ic );
//cout <<"genomaSample ended\n";
    }
    catch ( BasicException& be ) {
        be.addMessage ( "\ncalled from GenomaSample::GenomaSample (char * filename, int*pos..." );
        throw;
    };
}
/*____________________________________________________________ */

void GenomaSample::setAffectationRandomly ()
{
    phenotypeSample->setAffectationRandomly();
}
/*____________________________________________________________ */

bool GenomaSample::isATrioDataset ()
{
    return phenotypeSample->isATrioDataset();
}

/*____________________________________________________________ */

int GenomaSample::size () const
{
    return phenotypeSample->size();
}

/*____________________________________________________________ */

GenomaSample* GenomaSample::solvePhase ( int windowSize, BayesType  Bay, float alphaBayes, float distance )
	{
// solve phase using EM and assigning that with maxFreq (PhaseAlg=maxFreq)
		try
		{
throw new NonImplemented("GenomaSample* GenomaSample::solvePhase ");

			longLongList* maleList, *femaleList;
//cout <<"inisolvephase\n";
			SNPPos TotalSNPs=genotypeSample->GetTotalSNPs();
			bool onlyHetero=false, includeMissing=true;
//cout <<"inisolvephase2\n";
			GenomaSample* result=new GenomaSample ( *this );

			HapCounters*HC=NULL;
			int *pos=NULL, size, cont=0, * leftHap, *rightHap;
			Genotype* G;
			SNPPos SNP=0, SNP2=0;
			InferredHaplotypes* haplotypes;
			SlidingWindows *sw=new SlidingWindows ( windowSize, windowSize, TotalSNPs );
			int totalWindows=sw->getTotalWindows();
			GenotypeCounters* gc;
			InferredHaplotypesList hapList;
			intList* dimList;
			GenotypeArray* genotypeArray;
//cout <<"toatlwiowis:" << totalWindows <<"\n";
//cout <<"inisolvephase4\n";
//cout << "total snos:" << TotalSNPs <<"\ntotal windows: " << totalWindows <<"\n";
//cout <<"totalcompletewindows:" << sw->getTotalCompleteWindows() <<"\n";;
			for ( int i=0; i<totalWindows;i++ )
			{
				//	cout <<"\nwin: " << i+1 <<" out of " << totalWindows;
				cont=0;
				size=sw->getSizeOfWindow ( i );
				pos=new int[size];
				               dimList=new intList();
//cout <<"size:" << size <<"\n";
				for ( int j=0; j<size; j++ )
				{
					pos[j]=SNP+j;
//cout <<pos[j] <<" ";
					if ( pos[j]<0 || pos[j]>=TotalSNPs ) throw OutOfBounds ( pos[j], TotalSNPs, "1. TrioSample::solvePhase" );
					dimList->insertElement(getTotalGenotypes(genotypeSample->totalAlleles[pos[j]]));
				}
                   


                genotypeArray=new GenotypeArray(dimList, pos, genotypeSample->totalAlleles, genotypeSample->allAlleles);

                zap(dimList);

                maleList=getGenotypeCounts (pos, size, male, allAffectation, genotypeArray, false, includeMissing);
                femaleList=getGenotypeCounts (pos, size, female, allAffectation, genotypeArray, false, includeMissing);
	
                gc=new GenotypeCounters (size, maleList, femaleList, genotypeArray );
		
		zap(genotypeArray);
		zap(maleList);
		zap(femaleList);
		

		HC = new HapCounters (gc, maxFreq, Bay, alphaBayes, distance);
										
		if ( HC->hapByFreqs==NULL )
		{
		cout <<"nullhapcounts:\n";
		cout <<"gencounters:"<< *gc <<"\n";
		exit ( 0 );
		}
		
		// por implementar
		/*
		for (int gender=0;gender<2; gender++)
		{
		  if (gender==0)  hapList=HC->maleHaps; else hapList=HC->femaleHaps;
		  if ( hapList!=NULL )
		  for ( InferredHaplotypesList::iterator it= hapList->getFirst(); it<hapList->end(); it++ )
		    {
			if ( HC->hapList->getElement ( cont ) !=NULL )
			{
			haplotypes=HC->hapList->getElement ( it );
			leftHap=HC->haplotypeTable->getPositions ( haplotypes->leftHaplotype );
			rightHap=TM->haplotypeTable->getPositions ( haplotypes->rigtHaplotype );
			for ( int ind=0; ind<3; ind++ ) // father, mother, offspring
			  {
			  SNP2=SNP;
			  G=result->getGenotype ( it, ( IndCategory ) ind );
			  for ( int j=0; j<size; j++ )
			    {
			    if ( SNP2<0 || SNP2>=TotalSNPs ) throw OutOfBounds ( SNP2, TotalSNPs, "2. TrioSample::solvePhase" );
			    if ( fatherT[j]<0 || fatherT[j]>=genotypeSample->totalAlleles[SNP2] )
			    {
			    cout << "ind " << ** ( ( ( Trio* ) *it )->getFatherPhenotype() ) << "\n";
			    cout << "ind partner" << ** ( ( ( Trio* ) *it )->getMotherPhenotype() ) << "\n";
			    cout << "ind child" << ** ( ( ( Trio* ) *it )->getChildPhenotype() ) << "\n";
			    cout << "fatherT at SNP " << SNP2 << " is: " << fatherT[j] << " while there are only " << genotypeSample->totalAlleles[SNP2] <<"\n";
			    BIOS::print ( genotypeSample->allAlleles[SNP2], genotypeSample->totalAlleles[SNP2], cout );
			    throw OutOfBounds ( fatherT[j], genotypeSample->totalAlleles[SNP2], "3. TrioSample::solvePhase" );
			    }
			    if ( fatherU[j]<0 || fatherU[j]>=genotypeSample->totalAlleles[SNP2] )
			    {
			    cout << "ind " << ** ( ( ( Trio* ) *it )->getFatherPhenotype() ) << "\n";
			    cout << "ind partner" << ** ( ( ( Trio* ) *it )->getMotherPhenotype() ) << "\n";
			    cout << "ind child" << ** ( ( ( Trio* ) *it )->getChildPhenotype() ) << "\n";
			    cout << "fatherU at SNP " << SNP2 << " is: " << fatherU[j] << " while there are only " << genotypeSample->totalAlleles[SNP2] <<"\n";
			    BIOS::print ( genotypeSample->allAlleles[SNP2], genotypeSample->totalAlleles[SNP2], cout );
			    throw OutOfBounds ( fatherU[j], genotypeSample->totalAlleles[SNP2], "4. TrioSample::solvePhase" );
			    }
			    if ( motherT[j]<0 || motherT[j]>=genotypeSample->totalAlleles[SNP2] )
			    {
			    cout << "ind " << ** ( ( ( Trio* ) *it )->getMotherPhenotype() ) << "\n";
			    cout << "ind partner" << ** ( ( ( Trio* ) *it )->getFatherPhenotype() ) << "\n";
			    cout << "ind child" << ** ( ( ( Trio* ) *it )->getChildPhenotype() ) << "\n";
			    cout << "motherT at SNP " << SNP2 << " is: " << motherT[j] << " while there are only " << genotypeSample->totalAlleles[SNP2] <<"\n";
			    cout << "mother hap is: " << haplotypes->motherT;
			    cout << "mother pos:";
			    BIOS::print ( motherT, size, cout );
			    cout << " with conflicting pos being " << j;
			    cout << " and the whole tabla is:\n"  << *TM->haplotypeTable <<" and allAlleles are:\n";
			    BIOS::print ( genotypeSample->allAlleles[SNP2], genotypeSample->totalAlleles[SNP2], cout );
			    cout << "\nwhile all alleles in GenotypeArray are:\n";
			    BIOS::print ( tc->genotypeArray->allAlleles[j], tc->genotypeArray->totalAlleles[j], cout );
			    cout << "\nwhile all alleles in result are:\n";
			    BIOS::print ( result->genotypeSample->allAlleles[SNP2], result->genotypeSample->totalAlleles[SNP2], cout );
			    throw OutOfBounds ( motherT[j], genotypeSample->totalAlleles[SNP2], "5. TrioSample::solvePhase" );
			    }
			    if ( motherU[j]<0 || motherU[j]>=genotypeSample->totalAlleles[SNP2] )
			    {
			    cout << "ind " << ** ( ( ( Trio* ) *it )->getMotherPhenotype() ) << "\n";
			    cout << "ind partner" << ** ( ( ( Trio* ) *it )->getFatherPhenotype() ) << "\n";
			    cout << "ind child" << ** ( ( ( Trio* ) *it )->getChildPhenotype() ) << "\n";
			    cout << "motherU at SNP " << SNP2 << " is: " << motherU[j] << " while there are only " << genotypeSample->totalAlleles[SNP2] <<"\n";
			    BIOS::print ( genotypeSample->allAlleles[SNP2], genotypeSample->totalAlleles[SNP2], cout );
			    throw OutOfBounds ( motherU[j], genotypeSample->totalAlleles[SNP2], "6. TrioSample::solvePhase" );
			    }

			    if ( genotypeSample->allAlleles[SNP2][fatherT[j]]<0 || genotypeSample->allAlleles[SNP2][fatherU[j]]<0 ) throw UnsolvedPhase ( genotypeSample->allAlleles[SNP2][fatherT[j]], genotypeSample->allAlleles[SNP2][fatherU[j]], "7. TrioSample::solvePhase" );
			    if ( genotypeSample->allAlleles[SNP2][motherT[j]]<0 || genotypeSample->allAlleles[SNP2][motherU[j]]<0 ) throw UnsolvedPhase ( genotypeSample->allAlleles[SNP2][motherT[j]], genotypeSample->allAlleles[SNP2][motherU[j]], "8. TrioSample::solvePhase" );
			    switch ( ind )
			    {
			    case 0: // father
			    G->SetAlleles ( genotypeSample->allAlleles[SNP2][fatherT[j]], genotypeSample->allAlleles[SNP2][fatherU[j]], SNP2 );
			    break;
			    case 1: // mother
			    G->SetAlleles ( genotypeSample->allAlleles[SNP2][motherT[j]], genotypeSample->allAlleles[SNP2][motherU[j]], SNP2 );
			    break;
			    case 2: // offspring
			    G->SetAlleles ( genotypeSample->allAlleles[SNP2][fatherT[j]], genotypeSample->allAlleles[SNP2][motherT[j]], SNP2 );
			    break;
			    }
			    SNP2++;
			    }
			    }
			    zaparr ( motherT );
			    zaparr ( fatherT );
			    zaparr ( motherU );
			    zaparr ( fatherU );
			    }
			    cont++;
			    if ( it== ( hapList->end()-1 ) ) SNP=SNP+size;
			    }
			    }
			    */
			    zap ( HC );
			    zap ( gc );
			    zaparr ( pos );
			}
			zap ( sw );
			return result;
		}
		catch ( BasicException & be )
		{
			be.addMessage ( "\ncalled from TrioSample::solvePhase" );
			throw;
		};
	}


/*____________________________________________________________ */

GenomaSample* GenomaSample::setTransmissionRandomly ( SNPPos firstSNP, SNPPos nextLastSNP )
{
    GenomaSample* genomaSample=this->clone();
    GenotypeSample* genotypeSample2=genomaSample->genotypeSample->setTransmissionRandomly ( firstSNP, nextLastSNP );
//zap(genotypeSample2);
    zap ( genomaSample->genotypeSample );
//cout << "gg\n";
    genomaSample->genotypeSample=genotypeSample2;
    return genomaSample;
}

/*____________________________________________________________ */

GenomaSample* GenomaSample::permute ()
{
    GenomaSample*  genomaSample=this->clone();
    PhenotypeSample* phenotypeSample2=phenotypeSample->permute();
    zap ( phenotypeSample );
    phenotypeSample=phenotypeSample2;
    return genomaSample;
}
/*____________________________________________________________ */

void GenomaSample::setMarked ( IndCategory ic, int gender, int affectation )
{
    //if ( ( Marked!=NULL && ( ic!=currentIc || gender!=currentGender || affectation != currentAffectation ) ) || Marked==NULL )
    {
        if ( Marked!=NULL ) zaparr ( Marked );
        Marked=Initialize ( phenotypeSample->size(), false );
        phenotypeSample->SetMarked ( Marked, ic, gender, affectation );
// this has to be done because current marked settings have to be stored
        currentIc=ic;
        currentGender=gender;
        currentAffectation=affectation;
    }
//if (Marked!=NULL)
//for (int i=0; i<genotypeSample->size(); i++)
//cout <<" \n i:" << i << " is " << Marked[i];
}
/*____________________________________________________________ */

stringSample* GenomaSample::ExportForMLC ( bool orderedByValue )
{
    return ExportForMLCAndMLCHAP ( MLC, ut, orderedByValue );
}
/*_______________________________________________________________*/

stringSample* GenomaSample::ExportToBeagle ( stringList* Pos )
{
    stringSample* l=new stringSample();
    SNPPos TotalSNPs=genotypeSample->GetTotalSNPs();

//cout <<"Exporting to Beagle\n";

// heading
    stringList* row=new stringList();
    string s;
    s=string ( "I" );
    row->insertElement ( s );
    s=string ( "id" );
    row->insertElement ( s );
    for ( int i=0; i<genotypeSample->size(); i++ )
        for ( int j=0; j<2; j++ )
        {
            s=tos ( i );
            row->insertElement ( s );
        }
    l->insertElement ( row );

// affectation row
    row=new stringList ();
    s=string ( "A" );
    row->insertElement ( s );
    s=string ( "affectation" );
    row->insertElement ( s );
    Phenotype* phen;
    for ( PhenotypeSample::iterator it=phenotypeSample->begin(); it!=phenotypeSample->end(); it++ )
    {
        phen=phenotypeSample->getElement ( it );
        for ( int j=0; j<2; j++ )
        {
            s=tos ( phen->getAffectation() );
            row->insertElement ( s );
        }
    }
    l->insertElement ( row );

// genotype rows

    Genotype* gen;
    for ( SNPPos i=0; i<genotypeSample->GetTotalSNPs(); i++ )
    {
        row=new stringList ();
        s=string ( "M" );
        row->insertElement ( s );
        s=Pos->getElement ( i );
        row->insertElement ( s );
        for ( GenotypeSample::iterator it=genotypeSample->begin(); it!=genotypeSample->end(); it++ )
        {
            gen=genotypeSample->getElement ( it );
            s=gen->printAllele ( i, true );
            row->insertElement ( s );
            s=gen->printAllele ( i, false );
            row->insertElement ( s );
        }
        l->insertElement ( row );
    }

    return l;

}
/*_______________________________________________________________*/

stringSample* GenomaSample::ExportToPLINK ()
{
    stringSample* l=new stringSample();

//cout <<"Exporting to PLINK\n";

    string s;
    stringList* row;
    Phenotype* phen;
    Genotype* gen;
    for ( PhenotypeSample::iterator it=phenotypeSample->begin(); it!=phenotypeSample->end(); it++ )
    {
        row=new stringList ();
        phen=phenotypeSample->getElement ( it );
        s=phen->printPhenotypeInMakePed();
        gen=genotypeSample->getElement ( phenotypeSample->getPosition ( it ) );
        //s=s+gen->print();
        throw NonImplemented("stringSample* GenomaSample::ExportToPLINK ()");
        l->insertElement ( row );
    }

    return l;

}
/*_______________________________________________________________*/

stringSample* GenomaSample::ExportPositionsToPLINK ( stringList* RS, stringList* Pos, int chrom )
{
    stringSample* l=new stringSample();

    if ( RS->size() !=Pos->size() )
        throw BadFormat ( "GenomaSample::ExportPositionsToPLINK ( stringList* RS, stringList* Pos, int chrom )" );
//cout <<"Exporting to PLINK\n";

    string s;
    stringList* row;

    for ( stringList::iterator it=RS->begin(); it!=RS->end(); it++ )
    {
        row=new stringList ();
        row->insertElement ( tos ( chrom ) );
        row->insertElement ( *it );
        row->insertElement ( Pos->getElement ( RS->getPosition ( it ) ) );
        l->insertElement ( row );
    }

    return l;

}

/*____________________________________________________________ */
/*
HeteroListPair<long long int, double>* GenomaSample::getHapCounts (const SNPPos *pos, int totalPos, IndCategory ic, int gender, int affectation,Transmission transmission, AlleleOrderType alleleOrderMode, int phaseMethod, MultidimensionalTable<double>* hapFreqs)
{

// It returns a map with those haplotypes existing in the sample (key is double) and their frequencies (an integer)
longLongList* haps=NULL;
long long int key;
longLongList::iterator it;
doubleList::iterator it2;
IndPos TotalInds=0; //=genotypeSample->GetHap(FirstSNP, LastSNP, IsMajor1, IsMajor2, Marked);
HeteroListPair<long long int, double>* result=new HeteroListPair<long long int, double>();
longLongList * keys=result->First;
doubleList* freqs=result->Second;
Container<vector, Genotype*>::iterator GenoPos=genotypeSample->getFirst();
Container<vector, Phenotype*>::iterator PhenoPos=phenotypeSample->getFirst();
Genoma* G;
Phenotype* phen;
int current=0;

while (GenoPos!=genotypeSample->end())
{
phen=phenotypeSample->getElement(PhenoPos);
if (ic==offspring && phen->IsAChild() || ic==father && phen->IsAFather() || ic==mother && phen->IsAMother() || ic==everybody || (ic==parent && phen->IsAParent()))
if (phen->GetPhenotype().Gender==gender || gender==everyGender)
if (phen->getAffectation()==affectation || affectation==allAffectation)
{
haps=genotypeSample->getElement(GenoPos)->getHapCounts(pos, totalPos, genotypeSample->allAlleles, genotypeSample->totalAlleles, transmission, alleleOrderMode);
int i;
for (int c=0; c<haps->size(); c++)// for each pair
{
key=haps->getElement(c);
if (key!=-1)
{
it=keys->findElement(key);
 if (it!=keys->end())
{
i=keys->getPosition(it);
if (transmission==ut & haps->size()==2)// EM or no ambiguous
(*freqs)[i]=(*freqs)[i]+1;
else // Zhao et al 2000 AJHG
if (transmission==ut)
(*freqs)[i]=(*freqs)[i]+2/(double)haps->size();
else (*freqs)[i]=(*freqs)[i]+2/(double)haps->size();
}
else
{
keys->(key);
if (transmission==ut & haps->size()==2)// EM or no ambiguous
freqs->insertElement(1);
else
if (transmission==ut)
freqs->insertElement(2/(double)haps->size());
else
freqs->insertElement(2/(double)haps->size());
}
}
}
zap(haps);
TotalInds=TotalInds+current;
delete G;
}
GenoPos=genotypeSample->getNext(GenoPos);
PhenoPos=phenotypeSample->getNext(PhenoPos);
}
return result;
}

/*____________________________________________________________ */

stringSample* GenomaSample::ExportForMLCAndMLCHAP ( FormatType alg, Transmission trans, bool orderedByValue=false )
{
    cout <<"Exporting to ML\n";
    SNPPos TotalSNPs=genotypeSample->GetTotalSNPs();
    stringSample* l;
    if ( alg==MLCHAP ) l=genotypeSample->ExportForMLHAP ( trans );
    else l=genotypeSample->ExportForML ( orderedByValue );//ML
    stringList* row;
    char value;
    string s;
    PhenotypeSample::iterator IndPhenotype=phenotypeSample->getFirst();
    stringSample::iterator pList=l->getFirst();
    Phenotype *p;
    while ( IndPhenotype!=phenotypeSample->end() )
    {
        row=l->getElement ( pList );
        p=phenotypeSample->getElement ( IndPhenotype );
        if ( p->isAffected() ) s= string ( "1" );
        else s= string ( "0" );
        row->insertElement ( s );
        pList=l->getNext ( pList );
        IndPhenotype=phenotypeSample->getNext ( IndPhenotype );
    }

    return l;
}
/*____________________________________________________________ */

stringSample* GenomaSample::ExportForMLCHAP ( Transmission t )
{
    return ExportForMLCAndMLCHAP ( MLCHAP, t );
}
/*____________________________________________________________ */

void GenomaSample::flipPositions ( intSet* selectedPositions )
{
    genotypeSample->flipPositions ( selectedPositions );
}

/*____________________________________________________________ */

stringSample* GenomaSample::ExportMetaForMLCAndMLCHAP ( FormatType alg )
{
    stringSample* l;
    if ( alg==MLCHAP ) l=genotypeSample->ExportMetaForMLHAP();
    else l=genotypeSample->ExportMetaForML();
    stringList* row=new stringList();
    string s=string ( "0 Class: 0, 1" );
    row->insertElement ( s );
    l->insertElement ( row );
    return l;
}
/*____________________________________________________________ */

stringSample* GenomaSample::ExportMetaForMLC ()
{
    return ExportMetaForMLCAndMLCHAP ( MLC );
}
/*____________________________________________________________ */

stringSample* GenomaSample::ExportMetaForMLCHAP ()
{
    return ExportMetaForMLCAndMLCHAP ( MLCHAP );
}
/*____________________________________________________________ */

longLongList* GenomaSample::getGenotypeCounts ( const SNPPos *pos, int totalPos, int gender, int affectation, AmbiguousArray* tableGenotypes, bool onlyHetero, bool includeMissing )
{
// It returns a list of the genotype codes of all the individuals in the sample who match gender, affectation, onlyHetero and includeMissing
    try
    {
        long long int position;
        longLongList* result=new longLongList();
//cout <<"number of trios:" << TrioList->size();
        Genotype* G;
        Phenotype *phen;
        GenotypeSample::iterator it2=genotypeSample->getFirst();
        for ( PhenotypeSample::iterator it=phenotypeSample->getFirst(); it!=phenotypeSample->end(); it++ )
        {
            phen=phenotypeSample->getElement ( it );
            if ( phen->GetPhenotype().Gender==gender || gender==everyGender )
                if ( phen->getAffectation() ==affectation || affectation==allAffectation )
                {
                    G=genotypeSample->getElement ( it2 );
                    position=G->getGenotypeCounts ( pos, totalPos, genotypeSample->allAlleles, genotypeSample->totalAlleles, tableGenotypes, genotypeSample->AlleleOrderMode, onlyHetero, includeMissing );
                    result->insertElement ( position );
                }
            it2++;
        }
        return result;
    }
    catch ( BasicException & be ) {
        be.addMessage ( "\ncalled from GenomaSample::getGenotypeCounts" );
        throw;
    };
}
/*____________________________________________________________ */

Pair<HaplotypeVector*>* GenomaSample::getHaplotypes ( SNPPos *pos, int totalPos, int gender)
{
// It returns a list of the case/control haplotype codes of all the individuals in the sample who match gender
try
    {
        HaplotypeList* caseList=new HaplotypeList();
        HaplotypeList* controlList=new HaplotypeList();
        Pair<HaplotypeList*>* result=new Pair<HaplotypeList*>();
        result->First=caseList;
        result->Second=controlList;
//cout <<"number of trios:" << TrioList->size();
        Genotype* G;
        Haplotype*left, *right, *reducedLeft, *reducedRight;
        Phenotype *phen;
        GenotypeSample::iterator it2=genotypeSample->getFirst();
        for ( PhenotypeSample::iterator it=phenotypeSample->getFirst(); it!=phenotypeSample->end(); it++ )
        {
            phen=phenotypeSample->getElement ( it );
            if ( phen->GetPhenotype().Gender==gender || gender==everyGender )
                
                    G=genotypeSample->getElement ( it2 );
                    left=G->getLeftHaplotype();
                    right=G->getRightHaplotype();
                    reducedLeft=left->filter ( pos, totalPos );
                    reducedRight=right->filter ( pos, totalPos );
                    zap ( left );
                    zap ( right );
		    if ( phen->getAffectation() ==affected  )
                {
                    caseList->insertElement ( reducedLeft );
                    caseList->insertElement ( reducedRight );
                }
                  if ( phen->getAffectation() ==unaffected  )
		    {
                    controlList->insertElement ( reducedLeft );
                    controlList->insertElement ( reducedRight );
                }
            it2++;
        }
        return result;
    }
    catch ( BasicException & be ) {
        be.addMessage ( "\ncalled from GenomaSample::getHaplotypeCounts" );
        throw;
    };
}
/*____________________________________________________________ */

GeneticUnitCountsVector* GenomaSample::getHaplotypeCaseControlCountsVector ( SNPPos *pos, int totalPos, int gender)
{
// It returns a list of the left/right haplotype codes of all the individuals in the sample who match gender, affectation, onlyHetero and includeMissing
    try
    {
    //  cout << "inside GenomaSample::getHaplotypeCaseControlCountsVector\n";
      Pair<HaplotypeList*>* haplotypes=getHaplotypes(pos, totalPos, gender);
      HaplotypeList* caseHaplotypes=haplotypes->getFirst(), *controlHaplotypes=haplotypes->getSecond(), *hapList=NULL;
	    //Haplotype*h;
	     HaplotypeCounts* hc, *hc2;
	     GeneticUnitCountsVector* result=new GeneticUnitCountsVector();
	     HaplotypeList::iterator it;
	     GeneticUnitCountsVector::iterator it2;
	     for (int i=0; i<2; i++)
	     {
	       if (i==0) hapList=caseHaplotypes; else hapList=controlHaplotypes;
	
	     
	    for (HaplotypeList::iterator it=hapList->begin(); it<hapList->end(); it++)
	    {
	      it2=result->findElementContainingInternalElement((GeneticUnit*)*it);
	      if (it2==result->end())
	      {
	      hc=new HaplotypeCaseControlCounts(*it, (float)i==0, (float)i==1); 
	      result->insertElement(hc);
	      }
	      else (*it2)->add( i==0, i==1);
	    }
	     }
	    
      return result;
           }
    catch ( BasicException & be ) {
        be.addMessage ( "\ncalled from GenomaSample::getHaplotypeCounts" );
        throw;
    };
}
/*____________________________________________________________ */

SampleGenotypeCaseControlCounts* GenomaSample::getSampleGenotypeCaseControlCounts (int totalPermutations, SNPPos *pos, int totalPos, int gender, bool includeMissing )
{
//
    try
    {
        if (totalPermutations!=0)
            throw NonImplemented("	CaseControlCounts* GenomaSample::getCaseControlCounts (HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations, SNPPos *pos, int totalPos, int gender )");
        GeneticUnitCountsVector* caseControlCountsVector=new   GeneticUnitCountsVector();
	
	throw NonImplemented("SampleGenotypeCaseControlCounts* GenomaSample::getCaseControlCounts");

        GenotypeList* caseGenotypes=new GenotypeList(), *controlGenotypes=new GenotypeList();
		// fatal asignar caseControlCountsVector a partir de los genotipos
	int* relPos=new int[totalPos];
for (int i=0; i<totalPos; i++)
relPos[i]=i;
      SampleGenotypeCaseControlCounts* result= new SampleGenotypeCaseControlCounts (relPos, pos, totalPos,  caseControlCountsVector, totalPermutations, caseGenotypes, controlGenotypes );
zaparr(relPos);
return result;
    }
    catch ( BasicException & be ) {
        be.addMessage ( "\ncalled from SampleGenotypeCaseControlCounts* GenomaSample::getCaseControlHaplotypeCounts (" );
        throw;
    };
}
/*____________________________________________________________ */

SampleHaplotypeCaseControlCounts* GenomaSample::getSampleHaplotypeCaseControlCounts (int totalPermutations, SNPPos *pos, int totalPos, int gender, bool includeMissing )
{
//
    try
    {
      
            //cout << "inside GenomaSample::getSampleHaplotypeCaseControlCounts\n";
      
        if (totalPermutations!=0)
            throw NonImplemented("	CaseControlCounts* GenomaSample::getCaseControlHaplotypeCounts (HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations, SNPPos *pos, int totalPos, int gender )");
        GeneticUnitCountsVector* haplotypeCaseControlCountsVector=getHaplotypeCaseControlCountsVector(pos, totalPos, gender);
//cout << "haplotypes are:" << *haplotypeCaseControlCountsVector << endl;
	int* relPos=new int[totalPos];
	for (int i=0; i<totalPos; i++) relPos[i]=i;
	SampleHaplotypeCaseControlCounts* result=new SampleHaplotypeCaseControlCounts (relPos, pos, totalPos,  haplotypeCaseControlCountsVector, totalPermutations );
zaparr(relPos);
	//cout << "SampleHaplotypeCaseControlCounts is: "<< endl;
	//cout << *result << endl;
	return result;


    }
    catch ( BasicException & be ) {
        be.addMessage ( "\ncalled from SampleGenotypeCaseControlCounts* GenomaSample::getCaseControlHaplotypeCounts (" );
        throw;
    };
}

/*____________________________________________________________ */

SNPPos GenomaSample::GetTotalAllele ( SNPPos SNP, allele allele1, const IndCategory ic, int gender, int affectation )
{
    setMarked ( ic, gender, affectation );
    return genotypeSample->GetTotalAllele ( SNP, allele1, Marked );
};
/*____________________________________________________________ */

allele GenomaSample::getMajorAllele ( SNPPos SNP, const IndCategory ic, int gender, int affectation )
{
    setMarked ( ic, gender, affectation );
    return genotypeSample->getMajorAllele ( SNP, Marked );
};
/*____________________________________________________________ */

allele GenomaSample::getMinorAllele ( SNPPos SNP, const IndCategory ic, int gender, int affectation )
{
    setMarked ( ic, gender, affectation );
    return genotypeSample->getMinorAllele ( SNP, Marked );
};


/*____________________________________________________________ */
/*
void GenomaSample::WriteResults (char* filename, bool PrintPhenotypes, IndCategory ic, SNPPos first,SNPPos last, bool markUnphased)
 {
// it has to be reviewed, it changed alleles
 if (genotypeSample->size()!=0)
{
  PhenotypeSample::iterator IndPhenotype=phenotypeSample->getFirst();
  GenotypeSample::iterator IndGenotype=genotypeSample->getFirst();
  Genotype* genotype;

  SNPPos TotalSNPs=genotypeSample->GetTotalSNPs();
  OpenOutput(filename, &OutputFile);
Phenotype *P;
int c=0;
while (IndPhenotype!=phenotypeSample->end() && IndGenotype!=genotypeSample->end())
  {
	P=phenotypeSample->getElement(IndPhenotype);
	 if ((ic==offspring && P->isAChild ()) || (ic==parent && P->isAParent (phenotypeSample))
		|| (ic==everybody) || (ic==father && P->isAFather(phenotypeSample)) || (ic==mother && P->isAMother(phenotypeSample))  || (ic==unrelated && P->isUnrelated(phenotypeSample)))
	 {
	if (PrintPhenotypes==true)
	OutputFile << P->PrintPhenotype() <<" ";
    genotype=genotypeSample->getElement(IndGenotype);
//cout << "line is " << c <<"\n";
//cout << "length for gen " << genotypeSample->getPosition(IndGenotype) << "is: " << genotype->size() <<"\n";
    OutputFile << genotype->print(first, last, markUnphased);
    OutputFile << "\n";
c++;
	 }
  IndGenotype=genotypeSample->getNext(IndGenotype);
  IndPhenotype=phenotypeSample->getNext(IndPhenotype);
  }
  OutputFile.close();
//cout << "\nInformation about phased genotype has been saved in file " << filename <<"\n";
}
 }


/*____________________________________________________________ */

void GenomaSample::RemoveByCategory ( IndCategory ic=parent )
{
    PhenotypeSample::iterator IndPhenotype=phenotypeSample->getFirst();
    GenotypeSample::iterator IndGenotype=genotypeSample->getFirst();
    Genotype* genotype;
    Phenotype* P;

    SNPPos TotalSNPs=genotypeSample->GetTotalSNPs();
    while ( IndPhenotype!=phenotypeSample->end() && IndGenotype!=genotypeSample->end() )
    {
        P=phenotypeSample->getElement ( IndPhenotype );
        if ( ( ic==offspring && P->isAChild () ) || ( ic==parent && P->isAParent ( phenotypeSample ) )
                || ( ic==everybody ) || ( ic==father && P->isAFather ( phenotypeSample ) ) || ( ic==mother && P->isAMother ( phenotypeSample ) ) )
        {
            genotypeSample->removeNode ( IndGenotype );
            phenotypeSample->removeNode ( IndPhenotype );
        }

        IndGenotype=genotypeSample->getNext ( IndGenotype );
        IndPhenotype=phenotypeSample->getNext ( IndPhenotype );

    }
}


/*____________________________________________________________ */

IndPos GenomaSample::getTotalMarked ()
{
    SNPPos total=0;
    if ( Marked!=NULL )
        for ( int i=0; i<phenotypeSample->size();i++ )
            if ( Marked[i] ) total++;
    return total;
}
/*____________________________________________________________ */

GenotypeSample::iterator GenomaSample::GetGenotype ( PhenotypeSample::iterator p )
{
    return genotypeSample->getNode ( phenotypeSample->getPosition ( p ) );

}
/*____________________________________________________________ */

GenomaSample::~GenomaSample ()
{

    zaparr ( Marked );
    zap ( genotypeSample );
    zap ( phenotypeSample );

}

/*______________________________________________________*/

void GenomaSample::print ( ostream& out )
{
    /*out << *phenotypeSample <<"\n";
    out << *genotypeSample <<"\n";
    */
    for ( int i=0; i<phenotypeSample->size();i++ )
        out << * phenotypeSample->getElement ( i ) << " " << *genotypeSample->getElement ( i )  << this->genotypeSample->rightDelimiter;
};
/*______________________________________________________*/

void GenomaSample::printUsingAlleleNumbers ( ostream& out )
{
    /*out << *phenotypeSample <<"\n";
    out << *genotypeSample <<"\n";
    */
    for ( int i=0; i<phenotypeSample->size();i++ )
    {
        out << * phenotypeSample->getElement ( i ) << " ";
        genotypeSample->printUsingAlleleNumbers ( out, i );
    }
};

};  // Fin del Namespace

#endif

/* Fin Fichero: GenomaSample.h */
