
/* File: GenomaSample.h */



#ifndef __GenomaSample_h__
#define __GenomaSample_h__


namespace BIOS
{

	class GenericSample;

class SampleGenotypeCaseControlCounts;

class SampleHaplotypeCaseControlCounts;

class HapExtractionConfiguration;

typedef Vector<GeneticUnitCounts*>::Class GeneticUnitCountsVector;

	class GenomaSample: public GenericSample
	{

			//  public:


			/** @name Implementation of class GenomaSample
			    @memo Private part.
			*/

		public:

			PhenotypeSample* phenotypeSample;
			GenotypeSample* genotypeSample;

//static bool extendedMakeped;

			GenomaSample* clone();

			void setMarked ( IndCategory ic,  int gender=everyGender, int affectation=allAffectation );


			/* PUBLIC FUNCTIONS (INTERFACE) */

		public:

			virtual void print ( ostream& );

virtual int size() const;

			IndCategory currentIc;

//AlleleOrderType AlleleOrderMode;

			int currentGender, currentAffectation;

			bool *Marked;
			/**
			 @memo Destructor
			 @doc
			       Deallocate memory used by individual.
			       Time complexity O(1).

			  */
			~GenomaSample ();

			Trio* GetTrioMembers ( PhenotypeSample::iterator IndPhenotype, GenotypeSample::iterator IndGenotype );

   void replaceIndividualCodes(char* filename);
			/**7
			  @memo Constructor
			  @doc
			   Allocate memory an initialize to null.
			   Complexity O(1).

			*/

			/**
			       @memo Constructor
			       @doc
			        Allocate memory an initialize to null.
			        Complexity O(1).

			    */

			GenomaSample(int verbose=0);


			GenomaSample ( PhenotypeSample& sourceP, GenotypeSample& sourceG, int verbose=0 );

			GenomaSample ( GenomaSample& source, Container<vector<SNPPos>, SNPPos>* SNPSampling=NULL, bool selectInds=false );
			//GenomaSample(GenomaSample& source, Container<vector<SNPPos>, SNPPos>* SNPSampling);

			GenomaSample ( GenomaSample& source, Container<vector<string>, string>* selectedPositions, char* filePos, bool missingData=false );

			void printUsingAlleleNumbers ( ostream& out );
			/**
			        @memo Constructor
			        @doc
			         Allocate memory an initialize to null.
			         Complexity O(1).

			     */

//		GenomaSample(char* filename, unsigned short int ReduceSample, bool CompleteMissing, AlleleOrderType AlleleOrderMode);

			GenomaSample ( char* filename, int*pos=NULL, int size=0, IndCategory ic=parent, AlleleOrderType AlleleOrderMode=MajorFirst, int inputFormat=1, int verbose=0, char outputSeparator='\0', char leftDelimiter='\0', char rightDelimiter='\n' );

			void copy ( GenomaSample& source, Container<vector<SNPPos>, SNPPos>* SNPSampling=NULL, bool indPos=false, bool missingData=false );

			void flipPositions ( intSet *selectedPositions );
			
			virtual void copyPaste (GenericSample* other);

			GenotypeSample::iterator GetGenotype ( PhenotypeSample::iterator p );

//		void WriteResults (char* filename, bool PrintPhenotypes=true, IndCategory ic=everybody, SNPPos first=0,SNPPos last=-1, bool markUnphased=false);

			virtual GenomaSample* selectPositions(Container<vector<string>, string>* selectedPositions, char* filePos, bool missingData=false);

			GenomaSample* filter(SNPPos* positions, int size);

			void RemoveByCategory ( IndCategory ic );
			
			GenomaSample* solvePhase (int windowSize=10, BayesType  Bay=MLE, float alphaBayes=0, float distance=0.0);

		SampleGenotypeCaseControlCounts* getSampleGenotypeCaseControlCounts (int totalPermutations,  SNPPos *pos, int totalPos, int gender=everyGender, bool includeMissing=false );
		
		SampleHaplotypeCaseControlCounts* getSampleHaplotypeCaseControlCounts (int totalPermutations, SNPPos *pos, int totalPos, int gender, bool includeMissing );
		
		GeneticUnitCountsVector* getHaplotypeCaseControlCountsVector(SNPPos *pos, int totalPos, int gender=everyGender);


			stringSample* ExportForMLC ( bool );

			stringSample* ExportForMLCHAP ( Transmission t );

			virtual stringSample* ExportToBeagle ( stringList* Pos );

			stringSample* ExportToPLINK ();

			stringSample* ExportPositionsToPLINK ( stringList* RS, stringList* Pos, int chrom );

			stringSample* ExportForMLCAndMLCHAP ( FormatType alg, Transmission t, bool orderedByValue );

			stringSample* ExportMetaForMLCAndMLCHAP ( FormatType alg );

			stringSample* ExportMetaForMLC ();

			stringSample* ExportMetaForMLCHAP ();

			int* countAlleles ( const SNPPos *pos, int totalPos, IndCategory ic, int gender=everyGender, int affectation=allAffectation )
			{
				setMarked ( ic, gender, affectation ); return genotypeSample->countAlleles ( pos, totalPos, Marked );
			};
			;

			SNPPos GetTotalAllele ( SNPPos SNP, allele allele1, IndCategory ic, int gender=everyGender, int affectation=allAffectation );

			allele getMajorAllele ( SNPPos SNP, const IndCategory ic, int gender=everyGender, int affectation=allAffectation );

			allele getMinorAllele ( SNPPos SNP, const IndCategory ic, int gender=everyGender, int affectation=allAffectation );

//		SNPPos GetTotalType (SNPPos SNP, IndCategory ic, GenotypeType type, int gender=everyGender, int affectation=allAffectation) {
//	    	setMarked(ic, gender, affectation); return genotypeSample->GetTotalType (SNP, type, Marked);};

			SNPPos GetTotalHomozygous1 ( SNPPos SNP, IndCategory ic, int gender=everyGender, int affectation=allAffectation ) { setMarked ( ic, gender, affectation ); return genotypeSample->GetTotalHomozygous1 ( SNP, Marked );};

			SNPPos GetTotalHomozygous2 ( SNPPos SNP, IndCategory ic, int gender=everyGender, int affectation=allAffectation ) { setMarked ( ic, gender, affectation ); return genotypeSample->GetTotalHomozygous2 ( SNP, Marked );};

			SNPPos GetTotalHeterozygous ( SNPPos SNP, IndCategory ic, int gender=everyGender, int affectation=allAffectation ) { setMarked ( ic, gender, affectation ); return genotypeSample->GetTotalHeterozygous ( SNP, Marked );};

			SNPPos GetTotalMissing ( SNPPos SNP, IndCategory ic, int gender=everyGender, int affectation=allAffectation ) { setMarked ( ic, gender, affectation ); return genotypeSample->getTotalMissing ( SNP, Marked );};

			IndPos getTotalMissingGenotypes ( IndCategory ic, int gender=everyGender, int affectation=allAffectation ) { setMarked ( ic, gender, affectation ); return genotypeSample->getTotalMissingGenotypes ( Marked );};

			SNPPos GetTotalNonMissing ( SNPPos SNP, IndCategory ic, int gender=everyGender, int affectation=allAffectation ) { setMarked ( ic, gender, affectation ); return genotypeSample->getTotalNonMissing ( SNP, Marked );};

//		SNPPos getPairwiseGenotype (PairedGenotype pg, SNPPos FirstSNP, SNPPos LastSNP, IndCategory ic, int gender=everyGender, int affectation=allAffectation){ setMarked(ic, gender, affectation); return genotypeSample->getPairwiseGenotype(pg, FirstSNP, LastSNP, Marked);};

//		SNPPos GetDoubleHeterozygous (SNPPos FirstSNP, SNPPos LastSNP, MultiallelicHetero i, MultiallelicHetero j, IndCategory ic, int gender=everyGender, int affectation=allAffectation){ setMarked(ic, gender, affectation); return genotypeSample->getDoubleHeterozygous(FirstSNP, LastSNP, i, j, Marked);};

//		SNPPos GetUnsolvedDoubleHeterozygous (SNPPos FirstSNP, SNPPos LastSNP, MultiallelicHetero i, MultiallelicHetero j, IndCategory ic, bool phase, int gender=everyGender, int affectation=allAffectation, AlleleOrderType alleleOrderType=LeftRight){ setMarked(ic, gender, affectation); return genotypeSample->GetUnsolvedDoubleHeterozygous(FirstSNP, LastSNP, i, j, alleleOrderType, Marked);};

			SNPPos* getAlleleFrequencies ( allele alleleType, IndCategory ic,  int gender=everyGender, int affectation=allAffectation )
			{
				setMarked ( ic, gender, affectation );
				return genotypeSample->getAlleleFrequencies ( alleleType, Marked );
			};

			//void ComputeHaps (hprobs probs, SNPPos SNP1, SNPPos SNP2, LDType mode, bool Semi, unsigned short int Bayes);
			/*
					double GetHap (SNPPos FirstSNP, SNPPos LastSNP, IndCategory ic, allele allele1, allele allele2, Transmission transmission, int gender=everyGender, int affectation=allAffectation) { setMarked(ic, gender, affectation); return genotypeSample->GetHap(FirstSNP, LastSNP, allele1, allele2, transmission, Marked);};

					double GetnAB(SNPPos SNP1, SNPPos SNP2, IndCategory ic, Transmission transmission, int gender=everyGender, int affectation=allAffectation) { setMarked(ic, gender, affectation); return genotypeSample->GetnAB(SNP1, SNP2, transmission, Marked);};

					double GetnAb(SNPPos SNP1, SNPPos SNP2, IndCategory ic, Transmission transmission, int gender=everyGender, int affectation=allAffectation) { setMarked(ic, gender, affectation); return genotypeSample->GetnAb(SNP1, SNP2, transmission, Marked);};

					double GetnaB(SNPPos SNP1, SNPPos SNP2, IndCategory ic, Transmission transmission, int gender=everyGender, int affectation=allAffectation) { setMarked(ic, gender, affectation); return genotypeSample->GetnaB(SNP1, SNP2, transmission, Marked);};

					double Getnab(SNPPos SNP1, SNPPos SNP2, IndCategory ic, Transmission transmission, int gender=everyGender, int affectation=allAffectation) { setMarked(ic, gender, affectation); return genotypeSample->Getnab(SNP1, SNP2, transmission, Marked);};
			*/
			//        GenomaSample* copyElementsWithPositionsIn(intSet* positions, bool inThis=true);

			IndPos getTotalMarked();
			GenomaSample* permute();

			void setAffectationRandomly ();

			GenomaSample* setTransmissionRandomly ( SNPPos firstSNP=0, SNPPos nextLastSNP=0 );

			bool isATrioDataset();

			longLongList* getGenotypeCounts ( const SNPPos *pos, int totalPos, int gender, int affectation, AmbiguousArray* tableGenotypes, bool onlyHetero, bool includeMissing );


	Pair<HaplotypeVector*>* getHaplotypes (  SNPPos *pos, int totalPos, int gender);

	HaplotypeCountsVector* getHaplotypeCounts ( SNPPos *pos, int totalPos, int gender);


	};  // End of class GenomaSample
	
};  // Fin del Namespace

#endif

/* Fin Fichero: GenomaSample.h */
