/* File: Genotype.cpp */


#ifndef __Genotype_cpp__
#define __Genotype_cpp__




//using namespace UTILS;


namespace BIOS
{



int Genotype::inputFormat=1;

	/*____________________________________________________________ */

void  Genotype::setInputFormat(int inputFormat)
{
Genotype::inputFormat=inputFormat;
}


	/*____________________________________________________________ */

SNPPos  Genotype::GetTotalSNPs()
{
return size();
}

/*_____________________________________________________*/

	double Genotype::getDistance ( GeneticUnit* otherG, int position, bool toLeft )
	{
try
{
Genotype* other=(Genotype*) otherG;
throw NonImplemented("double Genotype::getDistance ( Genotype* other, int position, bool toLeft )");
		
		return size();
}
		catch ( BasicException& be )
		{
			be.addMessage ( "\ncalled from  double Haplotype::getDistance ( Haplotype* other, int position, bool toLeft )" );
			throw;
		};
	}


	/*____________________________________________________________ */


	Pair<Container<vector<allele>,allele>*>*  Genotype::readDiplotype ( const char * source, int len )
	{
		try
		{

			Container<vector<allele>, allele> *left=new Container<vector<allele>, allele>();
			Container<vector<allele>, allele> *right=new Container<vector<allele>, allele>();
			//allele** ld=new allele*[2];
			long long int cont=0;
int phenSize=7;
if (inputFormat==0) phenSize=6;
if (inputFormat==2) phenSize=1;
//cout << "inputformat:" << inputFormat <<"\n";
//cout << "extende:" << extendedMakeped <<"\n";
			char line[200], c1, c2, sep, * genotypebuf=new char[len], *cad, cadena[2], cadena2[2], *phenotype=new char[100];
			strncpy ( genotypebuf, source, len );
//cout << "buffer before is "  << genotypebuf <<"\n";
			strncpy ( phenotype, source, 100 );
			while ( genotypebuf[cont]!='\0' ) {if ( genotypebuf[cont]==',' ) genotypebuf[cont]=' ';cont++;	};

//cout << "buffer midde is "  << genotypebuf <<"\n";
			cont=0;
			cad = strtok ( genotypebuf," \t" );
//cout << "buffer middle2 is "  << genotypebuf <<"\n";
			//  cout <<"vee\n";
			for ( int phen=0;phen<phenSize;phen++ ) cad = strtok ( NULL," \t" );
//cout <<"inside\n";

//cout << "buffer now is "  << genotypebuf <<"\n";
//if (strlen(cad)==1) cout << "cad " << cad << " is a correct allele:" << IsACorrectAllele (cad[0]) << "\n";

	while ( cad!=NULL && strlen ( cad ) <=2 &&
			        ( ( strlen ( cad ) ==2 && cad[0]=='-' && (IsACorrectAllele ( cad[1] ) || isCNV ( cad[1] )) )
			          || ( strlen ( cad ) ==1 && (IsACorrectAllele ( cad[0] ) || isCNV ( cad[0] ) ) ) ) )
			{
			  if  (isCNV ( cad[0] ))
			  {
			  cout << " error in file: " << cad[0] << " is a CNV\n";
			 throw BadFormat ( "Genotype::readDiplotype (const char * source, int len) - 1" );
			  }
			
			if  (isCNV ( cad[1] ))
			{
			  cout << " error in file: " << cad[1] << " is a CNV\n";
			  throw BadFormat ( "Genotype::readDiplotype (const char * source, int len) -2" );
			}
			  
			 
				if ( strlen ( cad ) ==1 || ( strlen ( cad ) ==2 && cad[0]=='-' ) )
				{
					strcpy ( cadena, "\0" );
					sscanf ( cad, "%s", cadena );
				
if (inputFormat==2)
{
if ((atoi(cadena)>2) || (atoi(cadena)<0))
 throw BadFormat ( "Genotype::readDiplotype (const char * source, int len)" );
switch (atoi(cadena))
{
case 0:
	left->insertElement ( A );
	right->insertElement ( A );
break;
case 1:
	left->insertElement ( A );
	right->insertElement ( C);
break;
case 2:
	left->insertElement ( C );
	right->insertElement ( C );
break;
}
}
else		
{
	left->insertElement ( ConvertAllele ( cadena ) );
					cad = strtok ( NULL," \t\r\n" );
					if ( cad==NULL ) 	throw NullValue ( string("Container<vector<Diplotype*>, Diplotype*>*  Genotype::readDiplotype (const char * source, int len) at snp ")+tos(cont+1)+string(" for ind with phenotype ")+string(phenotype) );
					sscanf ( cad, "%s", cadena );
					right->insertElement ( ConvertAllele ( cadena ) );
				}
		}
				else{sprintf ( line, "vector<Diplotype>::ReadElementB value: \"%c\"", c1 );throw NonSNP ( ( const char* ) &c1, "B Container<vector<Diplotype*>, Diplotype*>*  Genotype::readDiplotype" );}

				cad = strtok ( NULL," \t" );
				cont=cont+1;
			}// end while
			
			
			if ( cad!=NULL && ((strlen ( cad ) >2 && inputFormat!=2) || ((strlen(cad)>1) && inputFormat==2)) ) throw BadFormat ( "Genotype::readDiplotype (const char * source, int len)" );
			if ( left->size() ==0 )
			{
//cout << "blank genotype\n";
//cout << "buffer is "  << genotypebuf <<"\n";
				throw BadFormat ( "readDiplotype\n" );
			}
			zaparr ( genotypebuf );//, len);
zaparr(phenotype);
			Pair<Container<vector<allele>,allele>*>* result=new Pair<Container<vector<allele>,allele>*>();
			result->First=left;
			result->Second=right;
			//cout << "print diplotype:" << *result->First << "\n" << *result->Second <<"\n";
			return result;
		}
		catch ( BasicException & be ) {be.addMessage ( "\ncalled from Genotype::readDiplotype" ); throw;};

	}


	/*________________________________________________________________________________________*/

	GeneticUnit* Genotype::fromString ( string source )
	{
		try
		{
//cout << "source is " << source << "\n";
			Genotype* targetGenotype=NULL;
			Pair<Container<vector<allele>,allele>*>* diplotypeList=Genotype::readDiplotype ( source.c_str(), source.length() +1 );
			if ( diplotypeList==NULL ) throw NullValue ( "Genotype* Genotype::fromString (string source)" );
			SNPPos cont=0, position, totalSNPs=diplotypeList->getFirst()->size();
			targetGenotype= new Genotype();
			allele** result=new allele*[2];
			result[0]=new allele[totalSNPs];
			result[1]=new allele[totalSNPs];
			int i=0;
			for ( Container<vector<allele>,allele>::iterator it=diplotypeList->getFirst()->begin(); it!=diplotypeList->getFirst()->end(); it++ )
			{
				result[0][i]=*it;
				i++;
			}
			i=0;
			for ( Container<vector<allele>,allele>::iterator it=diplotypeList->getSecond()->begin(); it!=diplotypeList->getSecond()->end(); it++ )
			{
				result[1][i]=*it;
				i++;
			}
			zap ( diplotypeList );

			targetGenotype->setDiplotypeArray ( result, totalSNPs );
			/*		Container<vector<Diplotype*>, Diplotype*>::iterator p=DiplotypeList->getFirst();
				while (p!=DiplotypeList->end())
				{
					targetGenotype->SetDiplotype(DiplotypeList->getElement(p), cont);
					p=DiplotypeList->getNext(p);
					cont++;
				};
			zap(DiplotypeList);
			*/
			return targetGenotype;
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from  Genotype* Genotype::fromString (string source)" ); throw;};
	};

	/**********************************/
	/* DEFINITIONS OF THE FUNCTIONS */
	/**********************************/
	/*
	void Genotype::copyDiplotypeArray (Diplotype ** DiplotypeArraySource)
	{
	try
	{
	if (this->DiplotypeArray!=NULL) throw BadFormat("void Genotype::copy (Diplotype ** DiplotypeArraySource)");
	if (DiplotypeArraySource==NULL) return;
	 if ((this->DiplotypeArray=new Diplotype* [totalSNPs])==NULL)
		throw NoMemory("Genotype::copy");
	for (SNPPos i=0;i<totalSNPs;i++)
	 this->DiplotypeArray[i]=new Diplotype(*DiplotypeArraySource[i]);
	}
	 catch (OverflowedSNP & os) {
			 os.addMessage("\ncalled from Genotype::copy"); throw;}
	}


	///////////////////
	//// public ////////
	///////////////////

	/*____________________________________________________________ */

	Genotype::Genotype(char outputSeparator):GeneticUnit(outputSeparator)
	{
		this->DiplotypeArray=NULL;
	}

/*_____________________________________________________*/



	bool Genotype::operator== ( const GeneticUnit & h )
	{
		Genotype& g=(Genotype&) h;
		if ( g.DiplotypeArray==NULL || this->DiplotypeArray==NULL )
			throw NullValue ( "bool Haplotype::operator==(Haplotype & g)" );
		if ( g.size() !=size() ) return false;
		for ( int i=0; i<size();i++ )
			if ( g.getLeftAllele(i)!=this->getLeftAllele(i) || g.getRightAllele(i)!=this->getRightAllele(i) ) return false;
		return true;
	};
	/*____________________________________________________________ */

	void Genotype::iniDiplotypeArray ( SNPPos TotalS )
	{
		try
		{
		this->totalSNPs=TotalS;

                if (this->DiplotypeArray!=NULL)
		throw BadFormat("void Genotype::iniDiplotypeArray ( SNPPos TotalS )");
			if ( ( ( this->DiplotypeArray=new allele*[2] ) ==NULL ) || ( ( this->DiplotypeArray[0]=new allele[totalSNPs] ) ==NULL ) || ( ( this->DiplotypeArray[1]=new allele[totalSNPs] ) ==NULL ) )
				throw NoMemory ( "Genotype::iniDiplotypeArray(SNPPos TotalS)" );
			for ( int i=0; i<totalSNPs; i++ )
			{
				this->DiplotypeArray[0][i]=NA;
				this->DiplotypeArray[1][i]=NA;
			}

		}
		catch ( OverflowedSNP & os )
		{
			os.addMessage ( "\ncalled from Genotype::Genotype" ); throw;
		}
	}
	/*____________________________________________________________ */

	void Genotype::flipPositions ( intSet* selectedPositions )
	{
		try
		{
			int i;
			if ( this->DiplotypeArray==NULL )
				throw NullValue ( "Genotype::flipPositions(intSet selectedPositions)" );
			for ( intSet::iterator it=selectedPositions->begin(); it!=selectedPositions->end(); it++ )
			{
				i=*it;
				for ( int j=0; j<2; j++ )
				{
					if ( this->DiplotypeArray[j][i]==A ) this->DiplotypeArray[j][i]=T;
					else if ( this->DiplotypeArray[j][i]==UA ) this->DiplotypeArray[j][i]=UT;
					else if ( this->DiplotypeArray[j][i]==C ) this->DiplotypeArray[j][i]=G;
					else if ( this->DiplotypeArray[j][i]==UC ) this->DiplotypeArray[j][i]=UG;
					else if ( this->DiplotypeArray[j][i]==G ) this->DiplotypeArray[j][i]=C;
					else if ( this->DiplotypeArray[j][i]==UG ) this->DiplotypeArray[j][i]=UC;
					else if ( this->DiplotypeArray[j][i]==T ) this->DiplotypeArray[j][i]=A;
					else if ( this->DiplotypeArray[j][i]==UT ) this->DiplotypeArray[j][i]=UA;
				}
			}

		}
		catch ( OverflowedSNP & os )
		{
			os.addMessage ( "\ncalled from Genotype::Genotype" ); throw;
		}
	}

	/*____________________________________________________________ */

	Genotype::Genotype ( SNPPos TotalS, char outputSeparator ):GeneticUnit(TotalS, outputSeparator)
	{
DiplotypeArray=NULL;

		try
		{
			iniDiplotypeArray ( TotalS );

		}
		catch ( BasicException & os )
		{
			os.addMessage ( "\ncalled from Genotype::Genotype ( SNPPos TotalS )" ); throw;
		}
	}
	/*____________________________________________________________ */

	void Genotype::changePhase()
	{
		for ( int i=0; i<totalSNPs; i++ )
			ChangeAlleles ( i );
	}
	/*____________________________________________________________ */

	Genotype::Genotype ( const Genotype & Source, Container<vector<SNPPos>, SNPPos> *sampling, bool missingData ): GeneticUnit(Source.outputSeparator, Source.leftDelimiter, Source.rightDelimiter )
	{
try		
{
		this->DiplotypeArray=NULL;
		if ( sampling==NULL )
		{
			this->totalSNPs=Source.totalSNPs;
			if ( Source.DiplotypeArray!=NULL )
			{
				iniDiplotypeArray ( this->totalSNPs ); //)//==NULL)
				for ( SNPPos i=0;i<this->totalSNPs;i++ )
				{
					this->DiplotypeArray[0][i]=Source.DiplotypeArray[0][i];
					this->DiplotypeArray[1][i]=Source.DiplotypeArray[1][i];
				}
			}
		}
		else
		{
			this->totalSNPs=sampling->size();
			iniDiplotypeArray ( this->totalSNPs );
			int i=0;
			for ( Container<vector<SNPPos>, SNPPos>::iterator p=sampling->getFirst();p!=sampling->end(); p++ )
			{
				if ( sampling->getElement ( p ) >= Source.totalSNPs )
{
//cout << "sampling is: " << *sampling << "while there are " << Source.totalSNPs << " snps\n";
					throw OutOfRange<int> ( Source.totalSNPs,"Genotype(const Genotype & Source, Container<vector<SNPPos>, SNPPos> *sampling)" );
}
				if ( sampling->getElement ( p ) ==-1)
					if ( !missingData ) throw OutOfRange<int> ( Source.totalSNPs,"Genotype(const Genotype & Source, Container<vector<SNPPos>, SNPPos> *sampling)-2" );
					else 
				{ 

				this->DiplotypeArray[0][i]=NA;
				this->DiplotypeArray[1][i]=NA;
				}
				else
				{ 
//cout <<"element pos is:" << sampling->getElement ( p ) << " with value: " << Source.DiplotypeArray[0][sampling->getElement ( p ) ];
//cout <<" was put in pos: " << i <<"\n";
				this->DiplotypeArray[0][i]=Source.DiplotypeArray[0][sampling->getElement ( p ) ];
				this->DiplotypeArray[1][i]=Source.DiplotypeArray[1][sampling->getElement ( p ) ];
				/*if (i==351)
				{
				  cout << "alleles at pos: " << i <<": " << this->DiplotypeArray[0][i] << "/" << this->DiplotypeArray[1][i] <<"\n";
				  cout <<"sampling is:\n" << *sampling ;
				  exit (0);
				}
				*/
				}
				i++;
			}
		}
}
    catch ( BasicException& be ) {
        be.addMessage ( "\ncalled from Genotype::Genotype ( const Genotype & Source, Container<vector<SNPPos>, SNPPos> *sampling, bool missingData )" );
        throw;
    };

	}
// 	/*____________________________________________________________ */

	Genotype* Genotype::clone()
	{
		return new Genotype ( *this );
	}

	/*____________________________________________________________ */
	/*
	Genotype& Genotype::operator=(const Genotype & Source)
	{
	  if (this!=&Source)
	  {
	  totalSNPs=Source.totalSNPs;
	  zaparr(DiplotypeArray);
	  copyDiplotypeArray (Source.DiplotypeArray);
	  }
	  return *this;
	}
	/*____________________________________________________________ */

	Genotype::~Genotype()
	{
		if ( this->DiplotypeArray!=NULL )
		{
			for ( int i=0; i<totalSNPs; i++ )
			{
				zaparr ( this->DiplotypeArray[0], totalSNPs );
				zaparr ( this->DiplotypeArray[1], totalSNPs );
			}

			zaparr ( this->DiplotypeArray, 2 );
		}
		this->DiplotypeArray=NULL;
//cout <<"genotype will be erased\n";
//cout <<"total nnos is:" << totalSNPs <<"\n";
//zaparr (this->DiplotypeArray, totalSNPs);
	}
	/*_____________________________________________________*/


	Genotype* Genotype::filter ( const int *positions, int length )
	{
		Genotype* result=new Genotype ( length );
		for ( int i=0; i<length;i++ )
		{
			if ( positions[i]<0 || positions[i]>=totalSNPs )
				throw OutOfBounds ( positions[i], totalSNPs, "Genotype::filter (int *positions, int length)" );
			result->DiplotypeArray[0][i]=this->DiplotypeArray[0][positions[i]];
			result->DiplotypeArray[1][i]=this->DiplotypeArray[1][positions[i]];
		}
		return result;
	}
	/*____________________________________________________________ */

	SNPPos Genotype::hasMajorMajor ( allele MajorAllele1, allele MajorAllele2, Diplotype D1, Diplotype D2 )
	{
		return ( D1.getLeftAllele() ==MajorAllele1 && D2.getLeftAllele() ==MajorAllele2 )
		       || ( D1.getRightAllele() ==MajorAllele1 && D2.getRightAllele() ==MajorAllele2 );
	}
	/*____________________________________________________________ */

	SNPPos Genotype::isMajorMajor ( allele MajorAllele1, allele MajorAllele2, Diplotype D1, Diplotype D2, bool left )
	{
		return ( left && D1.getLeftAllele() ==MajorAllele1 && D2.getLeftAllele() ==MajorAllele2 )
		       || ( !left && D1.getRightAllele() ==MajorAllele1 && D2.getRightAllele() ==MajorAllele2 );
	}
	/*____________________________________________________________ */

	SNPPos Genotype::isAlleleAllele ( allele allele1, allele allele2, Diplotype D1, Diplotype D2, bool left )
	{
		return ( left && D1.getLeftAllele() ==allele1 && D2.getLeftAllele() ==allele2 )
		       || ( !left && D1.getRightAllele() ==allele1 && D2.getRightAllele() ==allele2 );
	}

	/*____________________________________________________________ */

	SNPPos Genotype::hasAlleleAllele ( allele allele1, allele allele2, Diplotype D1, Diplotype D2 )
	{
		return ( D1.getLeftAllele() ==allele1 && D2.getLeftAllele() ==allele2 )
		       || ( D1.getRightAllele() ==allele1 && D2.getRightAllele() ==allele2 );
	}

	
	/*____________________________________________________________ */

	SNPPos Genotype::GetTotalHeterozygousPos()
	{
		SNPPos total=0;
		for ( SNPPos i=0;i<totalSNPs;i++ )
		{
			if ( Diplotype::isHeterozygous ( DiplotypeArray[0][i], DiplotypeArray[1][i] ) )
				total++;
		}
		return total;
	}

	/*____________________________________________________________ */

	void Genotype::OrderMajorFirst ( allele * * allAlleles )
	{
		// for those heterozygous positions, rewrite first MajorAllele, second Minor Allele.
		// NOT implemented: if only one allele is missing, write it in the second positions
		try
		{
			if ( DiplotypeArray==NULL )
				throw NullValue ( "Genotype::OrderMajorFirst(allele * * allAlleles)" );
			for ( SNPPos i=0; i<totalSNPs;i++ )
			{
// cout << DiplotypeArray[i].print(); //
				Diplotype::orderMajorFirst ( DiplotypeArray[0][i], DiplotypeArray[1][i], allAlleles[i][0] );
			} //cout << "\n";
		}
		catch ( BasicException & be ) {be.addMessage ( string ( "\ncalled from void Genotype::OrderMajorFirst(allele * * allAlleles)" ) ); throw;};

	}
	
		/*____________________________________________________________ */

	void Genotype::orderByAlphabeticOrder ( allele * * allAlleles )
	{
		// for those heterozygous positions, rewrite first MajorAllele, second Minor Allele.
		// NOT implemented: if only one allele is missing, write it in the second positions
		try
		{
			if ( DiplotypeArray==NULL )
				throw NullValue ( "Genotype::OrderMajorFirst(allele * * allAlleles)" );
			for ( SNPPos i=0; i<totalSNPs;i++ )
			{
// cout << DiplotypeArray[i].print(); //
				Diplotype::orderByAlphabeticOrder ( DiplotypeArray[0][i], DiplotypeArray[1][i], allAlleles[i][0] );
			} //cout << "\n";
		}
		catch ( BasicException & be ) {be.addMessage ( string ( "\ncalled from void Genotype::OrderMajorFirst(allele * * allAlleles)" ) ); throw;};

	}
	/*____________________________________________________________ */

	bool Genotype::isMissing ( SNPPos SNP )
	{
		return !Diplotype::isANonMissingSNP ( DiplotypeArray[0][SNP], DiplotypeArray[1][SNP] );
	}
	/*____________________________________________________________ */

	bool Genotype::isHeterozygous ( SNPPos SNP )
	{
		return Diplotype::isHeterozygous ( DiplotypeArray[0][SNP], DiplotypeArray[1][SNP] );
	}
	/*____________________________________________________________ */

	bool Genotype::isHomozygous ( SNPPos SNP )
	{
		return Diplotype::isHomozygous ( DiplotypeArray[0][SNP], DiplotypeArray[1][SNP] );
	}
	/*____________________________________________________________ */

	bool Genotype::isHomozygous1 ( SNPPos SNP, allele a )
	{
		return Diplotype::isHomozygous1 ( DiplotypeArray[0][SNP], DiplotypeArray[1][SNP], a );
	}
	/*____________________________________________________________ */

	bool Genotype::isHomozygous2 ( SNPPos SNP, allele a )
	{
		return Diplotype::isHomozygous2 ( DiplotypeArray[0][SNP], DiplotypeArray[1][SNP], a );
	}

	/*____________________________________________________________ */

	void Genotype::OrderRandomly ( allele ** allAlleles )
	{
		// for those heterozygous positions, rewrite alleles randomly

		for ( SNPPos i=0; i<totalSNPs;i++ )
			Diplotype::orderRandomly ( DiplotypeArray[0][i], DiplotypeArray[1][i], allAlleles[i][0] );

	}

	/*____________________________________________________________ */

	void Genotype::markUnphasedAlleles ()
	{
try
{
		// for those heterozygous positions, rewrite first MajorAllele, second Minor Allele.
		// NOT implemented: if only one allele is missing, write it in the second positions
for (SNPPos SNP=0; SNP<size(); SNP++)
if (Diplotype::isANonMissingSNP( DiplotypeArray[0][SNP], DiplotypeArray[1][SNP]))
if (Diplotype::isHeterozygous( DiplotypeArray[0][SNP], DiplotypeArray[1][SNP]))
		Diplotype::markAlleles ( DiplotypeArray[0][SNP], DiplotypeArray[1][SNP] );
}
		catch ( BasicException & be ) {be.addMessage ( string ( "\ncalled from void Genotype::markUnphasedAlleles ()" ) ); throw;};

	}
	/*____________________________________________________________ */

	void Genotype::ChangeAlleles ( SNPPos SNP )
	{
		// for those heterozygous positions, rewrite first MajorAllele, second Minor Allele.
		// NOT implemented: if only one allele is missing, write it in the second positions
		Diplotype::changeAlleles ( DiplotypeArray[0][SNP], DiplotypeArray[1][SNP] );
	}
	/*____________________________________________________________ */

	void Genotype::markAlleles ( SNPPos SNP )
	{
		// for those heterozygous positions, rewrite first MajorAllele, second Minor Allele.
		// NOT implemented: if only one allele is missing, write it in the second positions

		Diplotype::markAlleles ( DiplotypeArray[0][SNP], DiplotypeArray[1][SNP] );

	}
	/*____________________________________________________________ */

	bool Genotype::IsMarked ( SNPPos SNP )
	{

		return Diplotype::isMarked ( DiplotypeArray[0][SNP], DiplotypeArray[1][SNP] );

	}
	/*__________________________________________________________*/

	void Genotype::CheckRangeSNP ( SNPPos SNP )
	{
		if ( this->totalSNPs==0 ) throw ZeroValue ( "void Genotype::CheckRangeSNP(SNPPos SNP)" );
		if ( SNP>=totalSNPs || SNP<0 ) throw OverflowedSNP ( SNP, totalSNPs, " Genotype::CheckRangeSNP" );
	}
	/*__________________________________________________________*/
	/*
	Diplotype* Genotype::getDiplotype(SNPPos SNP)
	{
	try
	{
	CheckRangeSNP(SNP);
	if (DiplotypeArray==NULL) throw NullValue("Genotype::getDiplotype(SNPPos SNP)");
	return DiplotypeArray[SNP];
	}
	catch (OverflowedSNP & os) {os.addMessage("\ncalled from Genotype::getDiplotype"); throw;}
	}
	/*__________________________________________________________*/

	void Genotype::SetAlleles ( allele Left, allele Right, SNPPos SNP )
	{
		try
		{
			CheckRangeSNP ( SNP );
			DiplotypeArray[0][SNP]=Left;
			DiplotypeArray[1][SNP]=Right;
		}
		catch ( OverflowedSNP & os )
		{
			os.addMessage ( "\ncalled from Genotype::SetAlleles" ); throw;
		}
	}
	/*__________________________________________________________*/

	void Genotype::setLeftAllele ( SNPPos SNP, allele a )
	{
		try
		{
			CheckRangeSNP ( SNP );
			DiplotypeArray[0][SNP]=a;
		}
		catch ( OverflowedSNP & os )
		{
			os.addMessage ( "\ncalled from Genotype::SetAlleles" ); throw;
		}
	}
	/*__________________________________________________________*/

	void Genotype::setRightAllele ( SNPPos SNP, allele a )
	{
		try
		{
			CheckRangeSNP ( SNP );
			DiplotypeArray[1][SNP]=a;
		}
		catch ( OverflowedSNP & os )
		{
			os.addMessage ( "\ncalled from Genotype::SetAlleles" ); throw;
		}
	}
	/*__________________________________________________________*/

	void Genotype::setDiplotypeArray ( allele** Dip, SNPPos totalSNPs )
	{
		try
		{
			this->totalSNPs=totalSNPs;
			if ( DiplotypeArray!=NULL )
			{
				zaparr ( DiplotypeArray[0] );
				zaparr ( DiplotypeArray[1] );
				zaparr ( DiplotypeArray );
				DiplotypeArray=NULL;
			}
			DiplotypeArray=Dip;
		}
		catch ( OverflowedSNP & os )
		{
			os.addMessage ( "\ncalled from Genotype::SetDiplotype" ); os.PrintMessage(); throw;
		}
	}
	/*__________________________________________________________*/
	/*
	void Genotype::SetDiplotype(Diplotype* Dip, SNPPos SNP)
	{
	try
	{
	CheckRangeSNP(SNP);
	if (this->DiplotypeArray==NULL)
	throw NullValue("Genotype::SetDiplotype(Diplotype* Dip, SNPPos SNP)");
	this->DiplotypeArray[SNP]=new Diplotype(*Dip);
	}
	 catch (OverflowedSNP & os) {
			 os.addMessage("\ncalled from Genotype::SetDiplotype"); os.PrintMessage(); throw;}
	}
	/*__________________________________________________________*/

	void Genotype::setDiplotype ( allele left, allele right, SNPPos SNP )
	{
		try
		{
			CheckRangeSNP ( SNP );
			if ( this->DiplotypeArray==NULL )
				throw NullValue ( "Genotype::SetDiplotype(Diplotype* Dip, SNPPos SNP)" );
			this->DiplotypeArray[0][SNP]=left;
			this->DiplotypeArray[1][SNP]=right;
		}
		catch ( OverflowedSNP & os )
		{
			os.addMessage ( "\ncalled from Genotype::SetDiplotype" ); os.PrintMessage(); throw;
		}
	}
	/*_____________________________________________________________*/

	bool Genotype::HaveTheSameAllelesAtPoss ( GeneticUnit& otherGenotype, SNPPos Pos[], SNPPos TotalPos )
	{
//
Genotype& OtherGenotype=(Genotype&)otherGenotype;

		if ( TotalPos!=sizeof ( Pos ) || TotalPos>totalSNPs )
		{
			cerr << "in HaveTheSameHomoPos";
			exit ( 0 );
		};

		SNPPos i=0;
		while ( i<TotalPos )
		{
			if ( ( OtherGenotype.DiplotypeArray[0][Pos[i]]!=DiplotypeArray[0][Pos[i]] ) ||
			        ( OtherGenotype.DiplotypeArray[1][Pos[i]]!=DiplotypeArray[1][Pos[i]] ) )
				return false;
			i++;
		}
		return true;
	}
	/*_____________________________________________________________*/

	long long int Genotype::getGenotypeCounts ( const SNPPos Pos[], SNPPos TotalPos, allele** allAlleles, int* totalAlleles, AmbiguousArray* tableGenotypes, AlleleOrderType alleleOrderMode, bool onlyHetero, bool includeMissing )
// It returns the genotype position in the current genotype. If any genotype is missing and !includeMissing, it will return -1
// If onlyHetero && IsHomozygous(), it will return -1
	{
		try
		{
			int* res=getGenotypeCountsArray ( Pos, TotalPos, allAlleles, totalAlleles, tableGenotypes, alleleOrderMode, onlyHetero, includeMissing );
			long long int result;
if (tableGenotypes->getDimension()!=TotalPos)
throw OutOfBounds(TotalPos, tableGenotypes->getDimension(), "long long int Genotype::getGenotypeCounts ( const SNPPos Pos[], SNPPos TotalPos, allele** allAlleles, int* totalAlleles, AmbiguousArray* tableGenotypes, AlleleOrderType alleleOrderMode, bool onlyHetero, bool includeMissing )");
			if ( res!=NULL ) result=tableGenotypes->getPos ( res ); else result=-1;
//if (result<0) throw OutOfRange<long long int>(result, "Genotype::getGenotypeCounts, genotypes are too long");
//cout <<"dddd\n";
			zaparr ( res );
			return result;
		}
catch (BasicException & e) {e.addMessage("\n called from long long int Genotype::getGenotypeCounts ( const SNPPos Pos[], SNP..."); throw; }

	};

	/*_____________________________________________________________*/

	int*  Genotype::getGenotypeCountsArray ( const SNPPos Pos[], SNPPos TotalPos, allele ** allAlleles, int* totalAlleles, AmbiguousArray* tableGenotypes, AlleleOrderType alleleOrderMode, bool onlyHetero, bool includeMissing )
// It returns the genotype positions for the current genotype. If genotype at any position is missing and !includeMissing, it will return NULL
	{
		try
		{
			if ( 1==0 )
				if ( includeMissing )
				{
					cout << "Missing values cannot be handle so far\n";
					throw NonImplemented();
				}
			SNPPos pos1=0, pos2=0, cont=0, i=0;
			int allPos1, allPos2, *positions=new int[TotalPos];

			bool isHomo=true;
			if ( onlyHetero )
			{
				for ( int i=0; i<TotalPos; i++ )
				{
					if ( Diplotype::isHeterozygous ( DiplotypeArray[0][Pos[i]], DiplotypeArray[1][Pos[i]] ) )
						isHomo=false;
				}
				if ( isHomo )
				{
					zaparr ( positions );
					return NULL;
				}
			}

			for ( int i=0; i<TotalPos; i++ )
			{
				if ( !includeMissing && !Diplotype::isANonMissingSNP ( DiplotypeArray[0][Pos[i]], DiplotypeArray[1][Pos[i]] ) )
				{
					zaparr ( positions );
					return NULL;
				}
				else//positions[i]=getTotalGenotypes(totalAlleles[Pos[i]]);
				{
					if ( Pos[i]<0 || Pos[i]>=totalSNPs ) throw OutOfBounds ( Pos[i], totalSNPs, "Genotype::getGenotypeCountsArray" );
					allPos1=MAXINT;
					allPos2=MAXINT;
					for ( int j=0; j<totalAlleles[Pos[i]]; j++ )
					{
//cout << "\ntotalalleles at pos:" << Pos[i] <<": " << totalAlleles[Pos[i]] <<" val is:" << allAlleles[Pos[i]][j] <<" while actual left is: " << DiplotypeArray[0][Pos[i]] << " and actual right is: " << DiplotypeArray[0][Pos[i]] ;
						if ( allAlleles[Pos[i]][j]== ( DiplotypeArray[0][Pos[i]] ) ) allPos1=j;
						else if ( ( int ) allAlleles[Pos[i]][j]==abs ( ( int ) DiplotypeArray[0][Pos[i]] ) ) allPos1=-j;
						if ( allAlleles[Pos[i]][j]== ( DiplotypeArray[1][Pos[i]] ) ) allPos2=j;
						else if ( ( int ) allAlleles[Pos[i]][j]==abs ( ( int ) DiplotypeArray[1][Pos[i]] ) ) allPos2=-j;
					}
					if ( allPos1==MAXINT )
					{
						cout <<"vals at SNP pos " << Pos[i] <<" are:\n";
						for ( int j=0; j<totalAlleles[Pos[i]]; j++ )
							cout <<allAlleles[Pos[i]][j] << " ";
						throw OutOfBounds ( ( int ) DiplotypeArray[0][Pos[i]],totalAlleles[Pos[i]], "1. Genotype::getGenotypeCountsArray..." );
					}
					if ( allPos2==MAXINT )
					{
					  cout << "current genotype is:";
					 this->print(cout);
					cout <<"\n";
						cout <<"vals at SNP pos " << Pos[i] <<" are:\n";
						for ( int j=0; j<totalAlleles[Pos[i]]; j++ )
							cout <<allAlleles[Pos[i]][j] << " ";
						throw OutOfBounds ( ( int ) DiplotypeArray[1][Pos[i]],totalAlleles[Pos[i]], "2. Genotype::getGenotypeCountsArray..." );
					}
					if ( alleleOrderMode==LeftRight ) {allPos1=abs ( allPos1 ); allPos2=abs ( allPos2 );}
//else cout << "allpos1:" << allPos1 << ", allpos2:" << allPos2 << "\n";
					positions[i]=tableGenotypes->getAmbiguousPosition ( allPos1, allPos2, i );
//cout << "nextpos\n";
//cout << " pos at: " << i << ": " << positions[i] <<", ";
				}
//cout <<"\nals are:" << allPos1 << " and " << allPos2;
//cout << "\n pos at :" << i <<": " << positions[i];
			}
			return positions;
		}
catch (BasicException & e) {e.addMessage("\n called from long long int Genotype::getGenotypeCountsArray ( const SNPPos Pos[], SNP..."); throw; }

	}

	/*_____________________________________________________________*/

	void Genotype::CountGenotypes ( MultidimensionalTable<double>* Genotypes, const SNPPos Pos[], SNPPos TotalPos, allele ** allAlleles, int* totalAlleles,  AmbiguousArray* tableGenotypes )
// Haps is a multidimensionalTable with the TotalPos dimensions and 10 values each dimension (considering multiallelic SNPs)
	{
		SNPPos pos1=0, pos2=0, cont=0;
		bool missing=false;
		bool FoundHetero=false;
//SNPPos totalSNPs=GettotalSNPs();
		SNPPos i=0;
		int allPos1, allPos2;
		int *positions=new int[TotalPos];
		for ( int i=0; i<TotalPos; i++ )
		{
			if ( !Diplotype::isANonMissingSNP ( DiplotypeArray[0][Pos[i]], DiplotypeArray[1][Pos[i]] ) ) missing=true;
			else//or simply: positions[i]=getGenotypeValue(Pos[i],  tableGenotypes??, totalAlleles[Pos[i]], allAlleles[Pos[i]])
			{


				for ( int j=0; j<totalAlleles[Pos[i]]; j++ )
				{
					if ( allAlleles[Pos[i]][j]==DiplotypeArray[0][Pos[i]] ) allPos1=j;
					if ( allAlleles[Pos[i]][j]==DiplotypeArray[1][Pos[i]] ) allPos2=j;
				};
				positions[i]=tableGenotypes->getAmbiguousPosition ( allPos1, allPos2, Pos[i] );
			}
		}
		if ( !missing ) Genotypes->addValue ( positions, 1 );
		zaparr ( positions );
	};

	/*____________________________________________________________ */

int Genotype::getAllelePos(allele value, SNPPos SNP, bool right, int totalAlleles, allele* allAlleles)
{
// it returns the index of this allele in the allAlleles[SNP] array
int val;
for ( int i=0; i<totalAlleles; i++ )
				
if ( allAlleles[i]==DiplotypeArray[right][SNP] ) return i;
throw BadFormat("int getAllelePos(allele value, SNPPos SNP, bool right)");
}

/*____________________________________________________________ */

int Genotype::getAllelePosLeft(allele value, SNPPos SNP, int totalAlleles, allele* allAlleles)
{
return getAllelePos(value, SNP, 0, totalAlleles, allAlleles);
}

/*____________________________________________________________ */

int Genotype::getAllelePosRight(allele value, SNPPos SNP, int totalAlleles, allele* allAlleles)
{
return getAllelePos(value, SNP, 1, totalAlleles, allAlleles);
}
/*____________________________________________________________ */

int Genotype::getGenotypeValue(SNPPos SNP,  int totalValuesAtCurrentPos, int totalAlleles, allele* allAlleles)
{
return getPosGenotype ( getAllelePosLeft(DiplotypeArray[0][SNP] , SNP, totalAlleles, allAlleles), getAllelePosRight(DiplotypeArray[1][SNP] , SNP, totalAlleles, allAlleles), totalValuesAtCurrentPos );
}
	/*____________________________________________________________ */

	void Genotype::print ( ostream& out )
	{
//out <<"Heello\n";
		if ( DiplotypeArray==NULL ) {cout << "null diplotype vector";exit ( 0 );}

		for ( SNPPos i=0;i<size();i++ )
		{
//cout <<"snp:" << i <<"\n";
			out << printSNP ( i );
			if (i<(size()-1)) out <<" ";
//cout << "and now are " << printSNP(i, markUnphased) <<"\n";
		}
	}
	



	/*____________________________________________________________ */

	string Genotype::printSNP ( SNPPos snp )
	{
		string s=string ();
//cout << "values are: " <<  DiplotypeArray[0][snp] << " and " <<  DiplotypeArray[1][snp] << "\n";
  s=s+UnconvertAllele ( DiplotypeArray[0][snp] );
  s=s+string(" ");
  s=s+UnconvertAllele ( DiplotypeArray[1][snp] );
		return s;
	}
	/*____________________________________________________________ */

	string Genotype::printSNPUsingAlleleNumbers ( SNPPos snp )
	{
		string s=string ();
//cout << "values are: " <<  DiplotypeArray[0][snp] << " and " <<  DiplotypeArray[1][snp] << "\n";
if (  abs(DiplotypeArray[0][snp])==5) s=s+string("?");
else s=s+tos(abs(DiplotypeArray[0][snp]));
  s=s+string(" ");
if (  abs(DiplotypeArray[1][snp])==5) s=s+string("?");
else  s=s+tos(abs(DiplotypeArray[1][snp]));
		return s;
	}
	/*____________________________________________________________ */

	string Genotype::printAllele ( SNPPos snp, bool left )
	{
		string s=string();
		s=s+UnconvertAllele ( DiplotypeArray[1-left][snp] ) ;
		return s;
	}
	/*____________________________________________________________ */

	string Genotype::print ( HaplotypeType h )
	{
		char *l;
		if ( ( l=new char [totalSNPs*5] ) ==NULL )
			throw NoMemory();

		strcpy ( l, "\0" );
		for ( SNPPos i=0;i<totalSNPs;i++ )
			strcat ( l, printAllele ( i, h==left ).c_str() );
		string s=string ( l );
		zaparr ( l );
		return s;
	}

	/*___________________________________________________*/

	bool Genotype::IsHomozygous1Homozygous1 ( SNPPos position, SNPPos position2, allele allele1, allele allele2 )
	{
		try
		{
			CheckRangeSNP ( position );
			CheckRangeSNP ( position2 );


			return Diplotype::isHomozygous1 ( DiplotypeArray[0][position], DiplotypeArray[1][position], allele1 ) && Diplotype::isHomozygous1 ( DiplotypeArray[0][position2], DiplotypeArray[1][position2],allele2 );
		}
		catch ( OverflowedSNP & os )
		{
			os.addMessage ( "\ncalled from Genotype::IsHomozygous1Homozygous1" ); throw;
		}
	};
	/*___________________________________________________*/

	bool Genotype::IsHomozygousHomozygous ( SNPPos position, SNPPos position2 )
	{
		try
		{
			CheckRangeSNP ( position );
			CheckRangeSNP ( position2 );

			return Diplotype::isHomozygous ( DiplotypeArray[0][position], DiplotypeArray[1][position] ) && Diplotype::isHomozygous ( DiplotypeArray[0][position2], DiplotypeArray[1][position2] );
		}
		catch ( OverflowedSNP & os )
		{
			os.addMessage ( "\ncalled from Genotype::IsHomozygousHomozygous" ); throw;
		}
	};
	/*__
	};
	/*___________________________________________________*/

	bool Genotype::IsHomozygous1Heterozygous ( SNPPos position, SNPPos position2, allele oneAllele )
	{
		try
		{
			CheckRangeSNP ( position );
			CheckRangeSNP ( position2 );


			return Diplotype::isHomozygous1 ( DiplotypeArray[0][position], DiplotypeArray[1][position], oneAllele ) && Diplotype::isHeterozygous ( DiplotypeArray[0][position2], DiplotypeArray[1][position2] );
		}
		catch ( OverflowedSNP & os )
		{
			os.addMessage ( "\ncalled from Genotype::IsHomozygous1Heterozygous" ); throw;
		}
	};
	/*__
	}
	/*___________________________________________________*/

	bool Genotype::IsHeterozygousHomozygous1 ( SNPPos position, SNPPos position2, allele oneAllele )
	{
		try
		{
			CheckRangeSNP ( position );
			CheckRangeSNP ( position2 );


			return Diplotype::isHeterozygous ( DiplotypeArray[0][position], DiplotypeArray[1][position] ) && Diplotype::isHomozygous1 ( DiplotypeArray[0][position2], DiplotypeArray[1][position2],oneAllele );
		}
		catch ( OverflowedSNP & os )
		{
			os.addMessage ( "\ncalled from Genotype::IsHeterozygousHomozygous1" ); throw;
		}
	};
	/*__
	};

	/*___________________________________________________*/

	bool Genotype::IsHomozygousHeterozygous ( const SNPPos position, SNPPos position2 )
	{
		try
		{
			CheckRangeSNP ( position );
			CheckRangeSNP ( position2 );

			return Diplotype::isHeterozygous ( DiplotypeArray[0][position2], DiplotypeArray[1][position2] ) && Diplotype::isHomozygous ( DiplotypeArray[0][position], DiplotypeArray[1][position] );
		}
		catch ( OverflowedSNP & os )
		{
			os.addMessage ( "\ncalled from Genotype::IsHomozygousHeterozygous" ); throw;
		}
	};
	/*___________________________________________________*/

	bool Genotype::IsHeterozygousHomozygous ( const SNPPos position, SNPPos position2 )
	{
		try
		{
			CheckRangeSNP ( position );
			CheckRangeSNP ( position2 );

			return Diplotype::isHeterozygous ( DiplotypeArray[0][position],DiplotypeArray[1][position] ) && Diplotype::isHomozygous ( DiplotypeArray[0][position2],DiplotypeArray[1][position2] );
		}
		catch ( OverflowedSNP & os )
		{
			os.addMessage ( "\ncalled from Genotype::IsHeterozygousHomozygous" ); throw;
		}
	};

	/*___________________________________________________*/

	bool Genotype::IsHeterozygousHeterozygous ( const SNPPos position, SNPPos position2 )
	{
		try
		{
			CheckRangeSNP ( position );
			CheckRangeSNP ( position2 );


			return Diplotype::isHeterozygous ( DiplotypeArray[0][position], DiplotypeArray[1][position] ) && Diplotype::isHeterozygous ( DiplotypeArray[0][position2], DiplotypeArray[1][position2] );
		}
		catch ( OverflowedSNP & os )
		{
			os.addMessage ( "\ncalled from Genotype::IsHeterozygousHeterozygous" ); throw;
		}
	};
	/*___________________________________________________*/
	/*
	bool Genotype::IsHeterozygousHeterozygous (const SNPPos position, SNPPos position2, MultiallelicHetero i, MultiallelicHetero j, allele* alleles1, allele* alleles2, int totalAlleles1, int totalAlleles2)
	{
	CheckRangeSNP(position, "IsHetHet");
	CheckRangeSNP(position2, "IsHetHet2");

	Diplotype* D=DiplotypeArray[position];
	Diplotype* D2=DiplotypeArray[position2];

	return D->isHeterozygous(i, alleles1, totalAlleles1) && D2->isHeterozygous(j, alleles2, totalAlleles2);
	};


	/*___________________________________________________*/

	bool Genotype::IsMissingMissing ( const SNPPos position, SNPPos position2 )
	{
		try
		{
			CheckRangeSNP ( position );
			CheckRangeSNP ( position2 );


			return !Diplotype::isANonMissingSNP ( DiplotypeArray[0][position], DiplotypeArray[1][position] ) && !Diplotype::isANonMissingSNP ( DiplotypeArray[0][position2], DiplotypeArray[1][position2] );
		}
		catch ( OverflowedSNP & os )
		{
			os.addMessage ( "\ncalled from Genotype::IsMissingMissing" ); throw;
		}

	};

	/*___________________________________________________*/

	bool Genotype::IsNotMissingNotMissing ( const SNPPos position, SNPPos position2 )
	{
		try
		{
			CheckRangeSNP ( position );
			CheckRangeSNP ( position2 );

			return Diplotype::isANonMissingSNP ( DiplotypeArray[0][position], DiplotypeArray[1][position] ) && Diplotype::isANonMissingSNP ( DiplotypeArray[0][position2], DiplotypeArray[1][position2] );
		}
		catch ( OverflowedSNP & os )
		{
			os.addMessage ( "\ncalled from Genotype::IsNotMissingNotMissing" ); throw;
		}


	};

	/*___________________________________________________*/

	bool Genotype::IsHomozygous1Missing ( const SNPPos position, SNPPos position2, allele oneAllele )
	{
		try
		{
			CheckRangeSNP ( position );
			CheckRangeSNP ( position2 );

			return Diplotype::isHomozygous1 ( DiplotypeArray[0][position], DiplotypeArray[1][position], oneAllele ) && !Diplotype::isANonMissingSNP ( DiplotypeArray[0][position2], DiplotypeArray[1][position2] );
		}
		catch ( OverflowedSNP & os )
		{
			os.addMessage ( "\ncalled from Genotype::IsHomozygous1Missing" ); throw;
		}
	};
	/*___________________________________________________*/

	bool Genotype::IsMissingHomozygous1 ( const SNPPos position, SNPPos position2, allele oneAllele )
	{
		try
		{
			CheckRangeSNP ( position );
			CheckRangeSNP ( position2 );


			return !Diplotype::isANonMissingSNP ( DiplotypeArray[0][position], DiplotypeArray[1][position] ) && Diplotype::isHomozygous1 ( DiplotypeArray[0][position2], DiplotypeArray[1][position2], oneAllele );
		}
		catch ( OverflowedSNP & os )
		{
			os.addMessage ( "\ncalled from Genotype::IsMissingHomozygous1" ); throw;
		}

	};
	/*___________________________________________________*/

	bool Genotype::IsHeterozygousMissing ( const SNPPos position, SNPPos position2 )
	{
		try
		{
			CheckRangeSNP ( position );
			CheckRangeSNP ( position2 );


			return Diplotype::isHeterozygous ( DiplotypeArray[0][position], DiplotypeArray[1][position] ) && !Diplotype::isANonMissingSNP ( DiplotypeArray[0][position2], DiplotypeArray[1][position2] );
		}
		catch ( OverflowedSNP & os )
		{
			os.addMessage ( "\ncalled from Genotype::IsHeterozygousMissing" ); throw;
		}

	};
	/*___________________________________________________*/

	bool Genotype::IsMissingHeterozygous ( const SNPPos position, SNPPos position2 )
	{
		try
		{
			CheckRangeSNP ( position );
			CheckRangeSNP ( position2 );


			return !Diplotype::isANonMissingSNP ( DiplotypeArray[0][position], DiplotypeArray[1][position] ) && Diplotype::isHeterozygous ( DiplotypeArray[0][position2], DiplotypeArray[1][position2] );
		}
		catch ( OverflowedSNP & os )
		{
			os.addMessage ( "\ncalled from Genotype::IsMissingHeterozygous" ); throw;
		}

	};
	/*___________________________________________________*/

	allele Genotype::getLeftAllele ( const SNPPos position )
	{
		try
		{
			CheckRangeSNP ( position );
			return DiplotypeArray[0][position];
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from allele Genotype::getLeftAllele (const SNPPos position) with SNP pos "+tos(position)+" and value at that pos: "+tos( DiplotypeArray[0][position]) ); throw;}
		;
	};
	/*___________________________________________________*/

	allele Genotype::getRightAllele ( const SNPPos position )
	{
		try
		{
			CheckRangeSNP ( position );
			return DiplotypeArray[1][position];
		}
		catch ( OverflowedSNP & os )
		{
			os.addMessage ( "\ncalled from Genotype::getRightAllele" ); throw;
		}
	};
	/*___________________________________________________*/

	bool Genotype::IsPhaseKnown ( const SNPPos SNP1, const SNPPos SNP2, AlleleOrderType alleleOrderMode )
	{
		SNPPos pos[2];
		pos[0]=SNP1;
		pos[1]=SNP2;
		return IsPhaseKnown ( pos, 2, alleleOrderMode );
	}
	/*___________________________________________________*/

	bool Genotype::hasMissingSNPs ( const SNPPos *pos, SNPPos totalPos )
	{
		try
		{
			if ( pos==NULL ) totalPos=size();
			SNPPos i=0;
			while ( i<totalPos )
			{
				if ( pos!=NULL )
				{
					CheckRangeSNP ( pos[i] );
					if ( !Diplotype::isANonMissingSNP ( DiplotypeArray[0][pos[i]], DiplotypeArray[1][pos[i]] ) ) return true;
				}
				else
					if ( !Diplotype::isANonMissingSNP ( DiplotypeArray[0][i], DiplotypeArray[1][i] ) ) return true;
				i++;
			}
			return false;
		}
		catch ( OverflowedSNP & os )
		{
			os.addMessage ( "\ncalled from Genotype::hasMissingSNPs" ); throw;
		}

	}

 /*___________________________________________________*/

        bool Genotype::hasUnphasedSNPs ( const SNPPos *pos, SNPPos totalPos )
        {
                try
                {
                        if ( pos==NULL ) totalPos=size();
                        SNPPos i=0;
                        while ( i<totalPos )
                        {
                                if ( pos!=NULL )
                                {
                                        CheckRangeSNP ( pos[i] );
                                        if ( Diplotype::isAnUnphasedSNP ( DiplotypeArray[0][pos[i]], DiplotypeArray[1][pos[i]] ) ) return true;
                                }
                                else
                                        if ( Diplotype::isAnUnphasedSNP ( DiplotypeArray[0][i], DiplotypeArray[1][i] ) ) return true;
                                i++;
                        }
                        return false;
                }
                catch ( OverflowedSNP & os )
                {
                        os.addMessage ( "\ncalled from Genotype::hasMissingSNPs" ); throw;
                }

        }

	/*___________________________________________________*/

	bool Genotype::IsPhaseKnown ( const SNPPos *pos, SNPPos totalPos, AlleleOrderType alleleOrderType )
	{
		try
		{
			if ( alleleOrderType==LeftRight ) return true;
			bool KnownHap=true;
			bool FoundHetero=false;
			SNPPos i=0;
			while ( KnownHap==true && i<totalPos )
			{
				CheckRangeSNP ( pos[i] );
				if ( !Diplotype::isANonMissingSNP ( DiplotypeArray[0][pos[i]], DiplotypeArray[1][pos[i]] ) ) return false;
				if ( Diplotype::isHeterozygous ( DiplotypeArray[0][pos[i]], DiplotypeArray[1][pos[i]] ) && FoundHetero==true ) return false;
				if ( Diplotype::isHeterozygous ( DiplotypeArray[0][pos[i]], DiplotypeArray[1][pos[i]] ) && FoundHetero==false ) FoundHetero=true;
				i++;
			}
			return true;
		}
		catch ( OverflowedSNP & os )
		{
			os.addMessage ( "\ncalled from Genotype::IsPhaseKnown" ); throw;
		}
	}

	/*___________________________________________________*/
	/*
	double Genotype::GetHap (SNPPos SNP1, SNPPos SNP2, allele allele1, allele allele2, allele ** allAlleles, int* totalAlleles, Transmission transmission, AlleleOrderType alleleOrderMode)
	{
	CheckRangeSNP(SNP1, "GetHap");
	CheckRangeSNP(SNP2, "GetHap2");
	BidimensionalTable<int>* table=new BidimensionalTable<int>(totalAlleles[SNP1], totalAlleles[SNP2]);
	int al1, al2;
	for (int i=0; i<4; i++)
	{
	if (allAlleles[SNP1][i]==allele1) al1=i;
	if (allAlleles[SNP2][i]==allele2) al2=i;
	}
	int totalPos=2;
	int pos[2];
	pos[0]=SNP1;
	pos[1]=SNP2;
	double result=0;
	int* position;
	longLongList* res=getHapCounts(pos, totalPos, allAlleles, totalAlleles, transmission, alleleOrderMode);
	for (int i=0; i<res->size(); i++)
	if (res->getElement(i)!=-1)
	{
	position=table->getPositions(res->getElement(i));
	if (res->size()<=2)
	if (position[0]==al1 && position[1]==al2) result++;
	else if (position[0]==al1 && position[1]==al2) result=result+2*((double)1/(double)res->size());

	zaparr(position);
	}
	zap(table);
	zap(res);
	return result;
	};

	/*___________________________________________________*/
	/*
	double Genotype::GetAB (SNPPos SNP1, SNPPos SNP2, allele* *allAlleles, int* totalAlleles, Transmission transmission, AlleleOrderType AlleleOrderMode)
	{
		CheckRangeSNP(SNP1, "GetAB");
		CheckRangeSNP(SNP2, "GetAB2");

		return GetHap(SNP1, SNP2, allAlleles[SNP1][0], allAlleles[SNP2][0], allAlleles, totalAlleles, transmission, AlleleOrderMode);
	}
	/*___________________________________________________*/
	/*
	double Genotype::GetAb (SNPPos SNP1, SNPPos SNP2, allele * *allAlleles, int* totalAlleles, Transmission transmission, AlleleOrderType AlleleOrderMode)
	{
		CheckRangeSNP(SNP1, "GetAb");

		CheckRangeSNP(SNP2, "GetAb2");

		return GetHap(SNP1, SNP2, allAlleles[SNP1][0], allAlleles[SNP2][1], allAlleles, totalAlleles, transmission, AlleleOrderMode);
	}/*___________________________________________________*/
	/*
	double Genotype::GetaB (SNPPos SNP1, SNPPos SNP2, allele * *allAlleles, int* totalAlleles, Transmission transmission, AlleleOrderType AlleleOrderMode)
	{
	CheckRangeSNP(SNP1, "GetaB");

	CheckRangeSNP(SNP2, "GetaB2");

	return GetHap(SNP1, SNP2, allAlleles[SNP1][1], allAlleles[SNP2][0], allAlleles, totalAlleles, transmission, AlleleOrderMode);
	}/*___________________________________________________*/
	/*
	double Genotype::Getab (SNPPos SNP1, SNPPos SNP2, allele * *allAlleles, int* totalAlleles, Transmission transmission, AlleleOrderType AlleleOrderMode)
	{
		CheckRangeSNP(SNP1, "Getab");

		CheckRangeSNP(SNP2, "Getab2");

		return GetHap(SNP1, SNP2, allAlleles[SNP1][1], allAlleles[SNP2][1], allAlleles, totalAlleles, transmission, AlleleOrderMode);
	}

	/*____________________________________________________________ */

	allele** Genotype::GetGenotype ()
	{
		return DiplotypeArray;
	}
	/*____________________________________________________________ */

	Haplotype* Genotype::getLeftHaplotype (bool allowUnphased)
	{
try
{
		return getHaplotype ( true, allowUnphased );
}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from Haplotype* Genotype::getLeftHaplotype (bool allowUnphased) " ); throw;};
	}
	/*____________________________________________________________ */

	Haplotype* Genotype::getRightHaplotype (bool allowUnphased)
	{
try
{
		return getHaplotype ( false, allowUnphased );
}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from Haplotype* Genotype::getRightHaplotype (bool allowUnphased) " ); throw;};

	}

	/*____________________________________________________________ */

	void Genotype::missData ( int percentage )
	{
		try
		{
   int totalMissing=ceil((float)totalSNPs*percentage/100);
   Sampling* sampling=new Sampling(totalSNPs);
			for ( int i=0; i<totalMissing; i++ )
    {
 setLeftAllele (sampling->getPos(i), NA);
 setRightAllele (sampling->getPos(i), NA);
}
  zap(sampling);
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from Haplotype* Genotype::getHaplotype (bool left) " ); throw;};
	}
	/*____________________________________________________________ */

	Haplotype* Genotype::getHaplotype ( bool left, bool allowUnphased )
	{
//cout << "allowUnphased is" << allowUnphased <<"\n";
//cout <<"left is " << left <<"\n";
//cout << "total snps is " << totalSNPs <<"\n";
		try
		{
			Haplotype* result=new Haplotype ( totalSNPs );
			for ( int i=0; i<totalSNPs; i++ )
{
//cout << "left allele is: " << getLeftAllele(i) << " and right allele is: " << getRightAllele(i) <<"\n";
   if ((left && !isABaseAllele( getLeftAllele ( i ))) ||  (!left && !isABaseAllele(getRightAllele ( i ))))

   if (!allowUnphased) 
   if (left) throw NonSNP ( ( int ) getLeftAllele ( i ), "Haplotype::checkBase(SNPPos SNP)" );
   else throw NonSNP ( ( int ) getRightAllele ( i ), "Haplotype::checkBase(SNPPos SNP)" );
   else // allow unphased
 result->alleleArray[i]=na;

else // is a baseAllele
				if ( left ) 
result->alleleArray[i]= ( base ) getLeftAllele ( i );
				else result->alleleArray[i]= ( base ) getRightAllele ( i );
		}
return result;
}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from Haplotype* Genotype::getHaplotype (bool left) " ); throw;};
	}
	/*___________________________________________________*/

	bool Genotype::CanBeSolved ( SNPPos SNP1, SNPPos SNP2, AlleleOrderType alleleOrderMode )
	{
		return IsPhaseKnown ( SNP1, SNP2, alleleOrderMode );
	}

	/*___________________________________________________*/

	SNPPos Genotype::getFirstHeterozygous ()
	{
		SNPPos SNP=0;
		while ( SNP<totalSNPs )
		{
			if ( Diplotype::isHeterozygous ( DiplotypeArray[0][SNP], DiplotypeArray[1][SNP] ) )
				return SNP;
			SNP++;
		}
		return SNP;
	}

	/*___________________________________________________*/


	void Genotype::printUsingAlleleNumbers (ostream& os)
	{
		if ( DiplotypeArray==NULL ) os << "null diplotype vector";
		int last=totalSNPs;
		if ( DiplotypeArray!=NULL )
			for ( SNPPos i=0;i<last;i++ )
			{
				os << printSNPUsingAlleleNumbers (i );
				if ( i< ( last-1 ) ) os  <<" "; else os <<"\n";
			}
		//return os;
	}

	/*___________________________________________________*/

/*
	ostream& operator<< ( ostream& out, Genotype& genotype )
	{
		if ( genotype.DiplotypeArray==NULL ) out << "null diplotype vector";
		int last=genotype.totalSNPs;
		if ( genotype.DiplotypeArray!=NULL )
			for ( SNPPos i=0;i<last;i++ )
			{
				out << genotype.printSNP ( i );
				if ( i< ( last-1 ) ) out  <<" "; //else out <<"\n";
			}
		return out;
	}
	/*___________________________________________________*/

};  // End of Namespace

#endif

/* End of file: Genotype.h */




