#ifndef __GenotypeCaseControlCounts_cpp__
#define __GenotypeCaseControlCounts_cpp__

void print ( BIOS::GenotypeCaseControlCounts *h )
{
	cout << *h << endl;
}

void print2 ( BIOS::GenotypeCaseControlCounts *h )
{
	cout << "hola" << endl;
}

namespace BIOS
{

	GenotypeCaseControlCounts::GenotypeCaseControlCounts ( int size ):GeneticUnitCounts()
	{
		if ( size!=0)  geneticUnit=new Genotype ( size );
	};


	/*_________________________________________________________________*/


	GenotypeCaseControlCounts::GenotypeCaseControlCounts ( Genotype* genotype, float frequencyCases, float frequencyControls ):GeneticUnitCounts(genotype,frequencyCases, frequencyControls )
	{
	}

	/*_________________________________________________________________*/

	GenotypeCaseControlCounts::GenotypeCaseControlCounts ( GenotypeCaseControlCounts& other ):GeneticUnitCounts(other)
	{
		
		setFrequencyCases(other.getFrequencyCases());
		setFrequencyControls(other.getFrequencyControls());
	}

	






				/*_________________________________________________________________*/
	
Genotype* GenotypeCaseControlCounts::getGenotype()
	{
		return (Genotype*) geneticUnit;
	}



		/*_________________________________________________________________*/
	
	allele GenotypeCaseControlCounts::getLeftAllele(int position)
	{
	try
	{
	Genotype* g=getGenotype();
	if (g==NULL) throw NullValue("GenotypeCaseControlCounts::getLeftAllele(int position)");
	return g->getLeftAllele(position);
	}
	catch ( BasicException & be ) {be.addMessage ( "\ncalled from GenotypeCaseControlCounts::getLeftAllele(int position)" ); throw;};
	}

		/*_________________________________________________________________*/
	
	allele GenotypeCaseControlCounts::getRightAllele(int position)
	{
	try
	{
	Genotype* g=getGenotype();
	if (g==NULL) throw NullValue("GenotypeCaseControlCounts::getLeftAllele(int position)");
	return g->getRightAllele(position);
	}
	catch ( BasicException & be ) {be.addMessage ( "\ncalled from GenotypeCaseControlCounts::getLeftAllele(int position)" ); throw;};
	}

	
			/*_________________________________________________________________*/
	
	int GenotypeCaseControlCounts::getCommonPositions(GeneticUnitCounts* other, intList* positions) 
	{
GenotypeCaseControlCounts* g=(GenotypeCaseControlCounts*) other;

		if (g->size()!=size()) throw OutOfBounds(g->size(), size(), "2. HaplotypeCounts::getCommonPositions"); 
		int commonPositions=0;
		for (intList::iterator it=positions->begin(); it!=positions->end(); it++)
		if (*it>=g->size() || *it<0) throw OutOfBounds(*it, g->size(), "2. HaplotypeCounts::getCommonPositions"); 
		//else if (this->getElement(*it)!= hap->getElement(*it)) return commonPositions; 
		else 
		if (g->getLeftAllele(*it)!= getLeftAllele(*it) || g->getRightAllele(*it)!= getRightAllele(*it)) return commonPositions; 
		else commonPositions++;
		return commonPositions;
	}
	


	/*_________________________________________________________________*/
/*
	void GenotypeCaseControlCounts::sumProps ( GenotypeCaseControlCounts * other )
	{
GenotypeCaseControlCounts* h=(GenotypeCaseControlCounts*) other;
		this->frequencyCases += h->frequencyCases;
		this->frequencyControls += h->frequencyControls;
	}


	/*_________________________________________________________________*/
/*
	void GenotypeCaseControlCounts::add ( int cases, int controls )
	{
		this->frequencyCases += cases;
		this->frequencyControls += controls;
	}

	/*_________________________________________________________________*/



	/*_________________________________________________________________*/

	double GenotypeCaseControlCounts::getThirdFrequency()
	{
		NonDefinedMethod("double GenotypeCaseControlCounts::getThirdFrequency()");
	}


	/*_________________________________________________________________*/

	double GenotypeCaseControlCounts::getFrequencyCases()
	{
		return firstFreq;
	}

	/*_________________________________________________________________*/

	double GenotypeCaseControlCounts::getFrequencyControls()
	{
		return secondFreq;
	}
/*_________________________________________________________________*/

	void GenotypeCaseControlCounts::setFrequencyCases(double f)
	{
		firstFreq=f;
	}

	/*_________________________________________________________________*/

	void GenotypeCaseControlCounts::setFrequencyControls(double f)
	{
		secondFreq=f;
	}


	/*_________________________________________________________________*/
/*
	void GenotypeCaseControlCounts::print ( ostream& output )
	{
		output << "[";
		//cout <<"size is " << h.size() << "\n";

		output << *this->geneticUnit;

		output << "][" << this->getFrequencyCases() << "]";
		output << "[" << this->getFrequencyControls() << "]";


		//return output;
	}
*/

};

#endif
