#ifndef __GenotypeCaseControlCounts_h__
#define __GenotypeCaseControlCounts_h__

namespace BIOS
{



	/**
	GenotypeCaseControlCounts: an haplotype and its case/control frequencies in a given sample
	**/
	class GenotypeCaseControlCounts;
	typedef Set<GenotypeCaseControlCounts*>::Class SetOfGenotypeCaseControlCounts;



	class GenotypeCaseControlCounts: public GeneticUnitCounts
	{



		public:



			



			/**
			* Constructor
			*/
			GenotypeCaseControlCounts ( int size=0 );


			GenotypeCaseControlCounts ( GenotypeCaseControlCounts& other );


			GenotypeCaseControlCounts ( Genotype* genotype, float frequencyCases, float frequencyControls );


virtual GeneticUnitCounts * filter(int *pos, int length){throw NonImplemented(" GeneticUnitCounts * filter");};


			virtual ~GenotypeCaseControlCounts(){};

			Genotype* getGenotype();

			
			//allele** & operator[] ( int position ) ;
			allele getLeftAllele(int position);
			allele getRightAllele(int position);




			/**
			*	Compares two genotypes, inluding all properties
			*	@return true if GenotypeCaseControlCounts are equal
			*/
			//bool operator== ( GeneticUnitCounts & h );

			



			GenotypeCaseControlCounts* fromString ( string s ) {throw NonImplemented ( "GenotypeCaseControlCounts::fromString(string s)" );};



		


			/*
						static void print(HaplotypeCounts *h){
							for(int i=0; i< h->size()-1; i++)
								printf("%i ", (*h)[i]);
						}
				*/



			//void add ( int cases, int controls );




			//void sumProps ( GeneticUnitCounts * h );




			GenotypeCaseControlCounts* clone() {return new GenotypeCaseControlCounts ( *this );};

			
			double getThirdFrequency();

			double getFrequencyCases();
			double getFrequencyControls();

			void setFrequencyCases(double f);
			void setFrequencyControls(double f);




	int getCommonPositions(GeneticUnitCounts* hap, intList* positions);

		/**
			* Prints the GenotypeCaseControlCounts in the following manner: [ a0 a1 ... an ][frequency][T/U]
			* @param output Output stream
			* @param h Vector to print
			*/
			
			// virtual void print ( ostream& output );
			/*
						static void print(GenotypeCaseControlCounts *h){
							for(int i=0; i< h->size()-1; i++)
								printf("%i ", (*h)[i]);
						}
				*/
			//	virtual void print();


	};



};

#endif
