#ifndef __GenotypeCaseControlTable_cpp__
#define __GenotypeCaseControlTable_cpp__


namespace BIOS
{



	GenotypeCaseControlTable::GenotypeCaseControlTable (GeneticUnitCountsSample * countsPartition, double minFreq) :AssociationTable (countsPartition, 2, minFreq, false )
	{
filter();
	};



	/*_____________________________________________________________________________________________________________*/


	GenotypeCaseControlTable::GenotypeCaseControlTable ( const GenotypeCaseControlTable& other ) :AssociationTable ( ( AssociationTable& ) other )
	{
filter();
	};

	/*_____________________________________________________________________________________________________________*/


	AssociationTable* GenotypeCaseControlTable::clone()
	{
		return new GenotypeCaseControlTable ( *this );
	}

/*_____________________________________________________________________________________________________________*/


	AssociationTable* GenotypeCaseControlTable::createEmptyTable(int totalCols)
	{
		GenotypeCaseControlTable* result=new GenotypeCaseControlTable(totalCols, this->minFreq, false);
		return result;
	}

	
GenotypeCaseControlTable::GenotypeCaseControlTable ( int cols, double minFreq, bool HWE) :AssociationTable ( cols, minFreq, HWE )
	{
	};

	


	
	

	



};

#endif
