/* File: GenotypeCounters.h */

#ifndef __GenotypeCounters_h__
#define __GenotypeCounters_h__

//using namespace stats;

namespace BIOS {


/************************/
/* SNP'S GenotypeCounters DEFINITION */
/************************/


/**
        @memo GenotypeCounters for SNPs

	@doc
        Definition:
        A unordered pair of SNPs values for an individual and a genetic position.
        One has been transmitted from the father, one for the mother. Who transmits
        each one of them does not matter.

        Memory space: O(1). 

        @author Maria M. Abad
	@version 1.0
*/

class GenotypeArray;
class GenomaSample;

 
class GenotypeCounters {


public:

    /** @name Declaration of class GenotypeCounters
        @memo Private part.
    */

	 
protected:


       
/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

/* Head */



		/* PUBLIC FUNCTIONS (INTERFACE) */

      public:

double** SNPAbsFreqsMale, **SNPAbsFreqsFemale;


SNPPos *pos;

SNPPos totalPos;

double totalGenotypes;

GenotypeArray* genotypeArray;

//GenomaSample * genomaSample;


 
longLongList* genotypeCountsMale,* genotypeCountsFemale; // there are as many genotypes in each list as the number of individuals for each gender

      /** @name Operations on GenotypeCounters 
        @memo Operations on a GenotypeCounters 
    */
//	GenotypeCounters(SNPPos Pos[], SNPPos totalPos, GenomaSample * samp, int affectation=allAffectation, bool includeMissing=true) ;

virtual void setCounters (VectorOfParentalGenotypes* sample, int affectation);


  
 GenotypeCounters(GenotypeCounters& source);
 GenotypeCounters();
 
  GenotypeCounters(SNPPos totalPos, longLongList* maleList, longLongList* femaleList, GenotypeArray* genotypeArray);

//	void set(SNPPos Pos[], SNPPos totalPos, GenomaSample * samp, int affectation);

	void set(SNPPos Pos[], SNPPos totalPos, VectorOfParentalGenotypes * samp, int affectation);
	
	
	//GenotypeCounters(GenomaSample * samp);

//GenotypeCounters<T>* convertToKnownGenotypes(MultidimensionalTable<double>* haplotypeFreqsTab, MultidimensionalTable<double>* haplotypeFreqsTabU);

 void empty();


	~GenotypeCounters()
	{
empty();
	};

//void setGenotypeFreqs ();

//void setGenotypeTable();

//void setGenotypeTableDimensions(GenomaSample * samp);

//MultidimensionalTable<longLongList*>* getPointersToPartnerGenotypes(IndCategory ic);

longLongList* permuteInGender(bool male);


//double getTotalKnown();

virtual void setSNPFreqs();

//IndPos getHapFreq(int* pos);

//IndPos getHapFreq(int pos);

   //     int GetAllelePair();

//	int getTotalDifferentHaplotypes();


MultidimensionalTable<double>*  getGenotypeAbsFreqs(gender gend); //, BayesType Bayes, float distance, float alpha); 
	
//longLongList* updatePermutationsInChildren(longLongList* genotypeCountsFather, longLongList* genotypeCountsMother);

//	void GetSampleFrequencies(IndPos & bnAB, IndPos & bnAb,IndPos & bnaB,IndPos & bnab);

	 GenotypeCounters* clone();


	// void set(GenomaSample* sample, int affectation) ;


	 void set(VectorOfParentalGenotypes* sample, int affectation) ;
	 
	 	

	// virtual void setCounters(GenomaSample* sample, int affectation) ;


 void setGenotypeTableDimensions(VectorOfParentalGenotypes * samp);
 
  
void setTotalGenotypes();


// BidimensionalTable<double>* getMultiallelicFreqs(SNPPos a, SNPPos b, Transmission trans);



//bool isSNP(SNPPos i);

//BidimensionalTable<double>* getMultiallelicFreqs(SNPPos a, SNPPos b, Transmission trans);

virtual GenotypeCounters * getPermutation ();

// ostream& print (ostream& out) {out << *this; return out;};

//CPT* getCPT(bool disease0-sex1);




};  // End of class GenotypeCounters

ostream& operator<<(ostream& out, GenotypeCounters& pm)
       {

out <<"pos: ";
for (int i=0; i<pm.totalPos; i++)
 out << pm.pos[i] <<" ";

out <<"\n";


if (pm.genotypeCountsMale!=NULL)
{
pm.genotypeCountsMale->setOutputSeparator('\n');
out <<"\nmale genotypes: \n" << *pm.genotypeCountsMale;
}
//if (pm.fatherPedigrees!=NULL)
//cout <<"\nfather pedigree: " << *pm.fatherPedigrees;

if (pm.genotypeCountsFemale!=NULL)
{
pm.genotypeCountsFemale->setOutputSeparator('\n');
out <<"\nfemale genotypes: \n" << *pm.genotypeCountsFemale;
}

//if (pm.motherPedigrees!=NULL)
//cout <<"\nmother pedigree: " << *pm.motherPedigrees;

  // out << *pm.haplotypeCounts;
// out << pm.GetnA() <<", " << pm.GetnB()  <<", " << pm.GetTotalKnown() <<", " << pm.GetTotalUnKnown()  <<", " << pm.GetnAB() <<"\n";

return out;
};



};  // End of Namespace

#endif

/* End of file: GenotypeCounters.h */




