/* File: GenotypeSample.cpp */


#ifndef __GenotypeSample_cpp__
#define __GenotypeSample_cpp__



//using namespace UTILS;

namespace BIOS
{




	/*________________________________________________________________________________________*/

	template <> Genotype* Container<vector<Genotype*>, Genotype*>::readElement ( ifstream * source, const char* tokens, int* pos, int size )
//  Genotype* GenotypeSample::readElement (ifstream * source, const char* tokens, int* pos, int size)
	{
		try
		{

//cout <<"v\n";
			char *line =CaptureLine ( source );

//cout <<"cap\n";
			string s=string ( line );
//cout <<"herr\n";
//cout <<"now3 s is:" << s << "\n";
			Genotype* genotype=(Genotype*)Genotype::fromString ( s ), *genotypeTemp=NULL;
//Genotype* genotype=new Genotype(102), *genotypeTemp=NULL;
//cout <<*genotype;
//cout << "genotype length is " << genotype->GetTotalSNPs() << "\n";
//exit(0);
			zaparr ( line );
//zap(genotype);

//zaparr (genotype->DiplotypeArray, genotype->TotalSNPs);



//return genotype;

//cout <<"wqw\n";
			if ( pos!=NULL )
			{
//      cout <<"aaa\n";

				genotypeTemp=genotype, genotype= new Genotype ( size );

//cout <<"vvv\n";
				for ( int i=0; i<size; i++ )
					genotype->setDiplotype ( genotypeTemp->DiplotypeArray[0][pos[i]], genotypeTemp->DiplotypeArray[1][pos[i]], i );


//cout <<"aazz\n";
				zap ( genotypeTemp );
			}

			//cout <<"endGenotypeSample::readElement\n";

//zap(genotype);
//return NULL;
			return genotype;
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from  GenotypeSample::readElement (ifstream * source, const char* tokens, int* pos, int size) " ); throw;};
//catch (OverflowedSNP& os){os.addMessage("\ncalled from GenotypeSample::readElement (ifstream * source, const char* tokens, int* pos, int size) "); os.PrintMessage(); throw;}
	};







	/**********************************/
	/* DEFINITIONS OF THE FUNCTIONS */
	/**********************************/


//////////// privates /////////////





	/*____________________________________________________________ */

	GenotypeSample::~GenotypeSample ()
	{
		if ( allAlleles!=NULL )
		{
			for ( int i=0; i<GetTotalSNPs(); i++ )
				zaparr ( allAlleles[i] );
			zaparr ( allAlleles );
		}
		if ( totalAlleles!=NULL ) zaparr ( totalAlleles );
	};
	/*____________________________________________________________ */

	GenotypeSample::GenotypeSample() :Container<vector<Genotype*>, Genotype*>()
	{
		outputSeparator=' ';
//MajorAllele=NULL;
//MinorAllele=NULL;
		allAlleles=NULL;
		totalAlleles=NULL;
	}

	/*____________________________________________________________ */

	GenotypeSample::GenotypeSample ( GenotypeSample& source, Container<vector<SNPPos>, SNPPos> * SNPSampling, bool missingData ) :Container<vector<Genotype*>, Genotype*>()
	{
try
{
		if ( source.AlleleOrderMode==MajorFirst || source.AlleleOrderMode==random )
		{
			cout <<" Not available at GenotypeSample::GenotypeSample (GenotypeSample& source)";
			exit ( 0 );
		}
		outputSeparator=source.outputSeparator;
		leftDelimiter=source.leftDelimiter;
		rightDelimiter=source.rightDelimiter;
		AlleleOrderMode=source.AlleleOrderMode;
		totalAlleles=NULL;
		allAlleles=NULL;
		iterator p=source.getFirst();
		Genotype* g=NULL;//,*g2=NULL;
int i=0;
		while ( p!=source.end() )
		{

			g=source.getElement ( p );
//cout << "filtering genotype " << i << " with size: " << g->size() << endl;
//g2=new Genotype(*g, SNPSampling);
			insertElement ( new Genotype ( *g, SNPSampling, missingData ) );
			p=source.getNext ( p );
i++;
		}
//setAllAlleles(NULL);
		SNPPos totalSNPs, k;
		if (SNPSampling==NULL) totalSNPs=this->GetTotalSNPs();
		else totalSNPs=SNPSampling->size();
		if ( source.allAlleles!=NULL && source.totalAlleles!=NULL )
		{
			totalAlleles=new int[totalSNPs];
			allAlleles=new allele*[totalSNPs];
		}
		if (SNPSampling==NULL)
		for ( int j=0;j<totalSNPs;j++ )
			{
					allAlleles[j]=new allele[source.totalAlleles[j]];
					for ( int i=0; i<source.totalAlleles[j]; i++ )
					allAlleles[j][i]=source.allAlleles[j][i];
					totalAlleles[j]=source.totalAlleles[j];
			}
			else
			{
			int j=0;
			for (Container<vector<SNPPos>, SNPPos>::iterator it=SNPSampling->begin();it<SNPSampling->end(); it++ )
			{
				if ( *it!=-1 )
				{
					allAlleles[j]=new allele[source.totalAlleles[*it]];
					for ( int i=0; i<source.totalAlleles[*it]; i++ )
						allAlleles[j][i]=source.allAlleles[*it][i];
					totalAlleles[j]=source.totalAlleles[*it];
				}
				else
				  if ( !missingData ) throw OutOfRange<int> ( source.getFirstElement()->totalSNPs,"GenotypeSample(GenotypeSample & Source, Container<vector<SNPPos>, SNPPos> *sampling)" );
				else
				{
					allAlleles[j]=new allele[1];
					allAlleles[j][0]=NA;
					totalAlleles[j]=1;
				}			
				j++;
			}
		}
}
    catch ( BasicException& be ) {
        be.addMessage ( "\ncalled from GenotypeSample::GenotypeSample ( GenotypeSample& source, Container<vector<SNPPos>, SNPPos> * SNPSampling, bool missingData ) " );
        throw;
    };
	}
	/*____________________________________________________________ */
	/*
	GenotypeSample::GenotypeSample (GenotypeSample& source, Container<set<string>, string> * selectedPositions, char* filePos):Container<vector<Genotype*>, Genotype*>()
	{
	if (SNPSampling==NULL)
	{
	GenotypeSample(source);
	return;
	}
	stringList* sourcePositions=new stringList(filePos, "", '\n');
	intSet*selectedFilePositions=sourcePositions->copyPositionsWithElementsInSet(selectedPositions);

	GenotypeSample(source, selectedFilePositions);

	}
	/*____________________________________________________________ */

	GenotypeSample::GenotypeSample ( char * filename, int*pos, int size,  AlleleOrderType AlleleOrderMod, int inputFormat, char outputSeparator, char leftDelimiter, char rightDelimiter) :Container<vector<Genotype*>, Genotype*>(outputSeparator, leftDelimiter, rightDelimiter)
	{
		try
		{
			Genotype::setInputFormat ( inputFormat );
			//outputSeparator=' ';
			
			getInfo ( filename, NULL, pos, size );
				allAlleles=NULL;
			totalAlleles=NULL;
			AlleleOrderMode=AlleleOrderMod;
			setAllAlleles ( NULL );
			//la comento porque no sé por qué se usa: if ( AlleleOrderMode==MajorFirst || AlleleOrderMode==random || AlleleOrderMode==alphabeticOrder) markUnphasedAlleles();//LeftRight means known and LeftRightUsingTrios has phase solved in TrioSample which requires to start with unmarked genotypes
			switch ( AlleleOrderMode )
			{
				case NotChanged: break;
				case LeftRight: case LeftRightUsingTrios: case incompleteLeftRight: break;
				case MajorFirst: OrderMajorFirst(); break;
				case random: OrderRandomly(); break;
				case alphabeticOrder: orderByAlphabeticOrder(); break;
			};
		}
		catch ( BasicException& be ) {be.addMessage ( string ( "\ncalled from GenotypeSample::GenotypeSample (char * filename,... with filename " ) +string ( filename ) ); throw;};
	}


	/*____________________________________________________________ */

	GenotypeSample& GenotypeSample::operator= ( const GenotypeSample & Source )
	{
		if ( &Source!=NULL )
		{

			if ( this!=&Source )
			{

				if ( this->getFirst() !=this->end() )
					this->empty();

				this->copyPaste ( ( GenotypeSample* ) &Source );


				//SetMajorAllele (NULL);
				//SetMinorAllele (NULL);
				setAllAlleles ( NULL );
			}
		}

		return *this;
	}

	/*____________________________________________________________ */

	GenotypeSample* GenotypeSample::setTransmissionRandomly ( SNPPos firstSNP, SNPPos nextLastSNP )
	{
		SNPPos last=nextLastSNP;
		GenotypeSample* newGenotypeSample=this->clone();

		GenotypeSample::iterator p=newGenotypeSample->getFirst();
		Genotype* genotype;
		int totalSNPs=GetTotalSNPs();
		if ( last==0 ) last=totalSNPs;
		while ( p!=newGenotypeSample->end() )
		{
			genotype=getElement ( p );

			for ( int i=firstSNP; i<last; i++ )
				if ( rand() %2==0 )
					genotype->ChangeAlleles ( i );
			p=newGenotypeSample->getNext ( p );
		}

		return newGenotypeSample;
	}
	/*____________________________________________________________ */

	SNPPos GenotypeSample::GetTotalSNPs ()
	{
		return getElement ( getFirst() )->GetTotalSNPs();
	}
	/*____________________________________________________________ */

	void GenotypeSample::flipPositions ( intSet* selectedPositions )
	{
		for ( GenotypeSample::iterator p=this->getFirst();p!=this->end(); p++ )
			this->getElement ( p )->flipPositions ( selectedPositions );
	}

	/*____________________________________________________________ */

	void GenotypeSample::missData ( int percentage )
	{
		for (	iterator IndGenotype=getFirst(); IndGenotype!=end();  IndGenotype++ )
			getElement ( IndGenotype )->missData ( percentage );
	}

	/*____________________________________________________________ */

	SNPPos GenotypeSample::GetTotalAllele ( SNPPos SNP, allele allele1, const bool Marked[] )
	{
		iterator IndGenotype=getFirst();
		Genotype *genotype;
		SNPPos Total=0, cont=0;
		while ( IndGenotype!=end() )
		{
			if ( Marked==NULL || Marked[cont]==true )
			{
				genotype=getElement ( IndGenotype );
				if ( abs ( genotype->DiplotypeArray[0][SNP] ) ==allele1 ) Total++;
				if ( abs ( genotype->DiplotypeArray[1][SNP] ) ==allele1 ) Total++;
			}
			IndGenotype=getNext ( IndGenotype );
			cont++;
		}
		return Total;
	}
	/*____________________________________________________________ */

	void GenotypeSample::markUnphasedAlleles ()
	{

		for ( iterator IndGenotype=getFirst();IndGenotype!=end(); IndGenotype++ )
			( ( Genotype* ) *IndGenotype )->markUnphasedAlleles();
	}
	/*____________________________________________________________ */

	int GenotypeSample::getTotalNonMissingAlleles ( SNPPos SNP, const bool Marked[] )
	{

		int total;
		if ( Marked!=NULL ) setAllAlleles ( Marked );

		total=totalAlleles[SNP];
		if ( isMissing ( allAlleles[SNP][total-1] ) ) total--;
		return total;
	}
	/*____________________________________________________________ */

	allele GenotypeSample::getMajorAllele ( SNPPos SNP, const bool Marked[] )
	{


		if ( allAlleles==NULL ) setAllAlleles ( Marked );


//cout <<MajorAllele[SNP] <<"-";
		return allAlleles[SNP][0];
	}
	/*____________________________________________________________ */

	allele GenotypeSample::getMinorAllele ( SNPPos SNP, const bool Marked[] )
	{
		if ( allAlleles==NULL ) setAllAlleles ( Marked );
//cout <<MinorAllele[SNP] <<"\n";
		return allAlleles[SNP][1];
	}

	/*____________________________________________________________ */
	/*
	intList* GenotypeSample::getIndList(SNPPos SNP1, SNPPos SNP2, allele allele1, allele allele2, Transmission transmission, const bool Marked[])
	{
	// it returns a list with the position number of individuals in the sample which have haplotype allele1 for SNP1 and allele2 for SNP2
	iterator IndGenotype=getFirst();
	Genotype * genotype;
	double Total=0;
	int cont=0;
	bool phased=false;
	intList* result=new intList();
	//cout <<"\n";
	while (IndGenotype!=end())
	{
	 if (Marked==NULL || Marked[cont]==true)
	 {
	 genotype=getElement(IndGenotype);
	 Total=genotype->GetHap(SNP1, SNP2, allele1, allele2, allAlleles, totalAlleles, transmission, AlleleOrderMode);
	 if (Total>0) result->insertElement(cont);
	//cout << "contmarked:" << cont;
	 }
	 IndGenotype=getNext(IndGenotype);
	cont++;
	}
	//cout <<"\n";
	return result;
	}


	/*____________________________________________________________ */
	/*
	int* GenotypeSample::countAlleles(const SNPPos *pos, int totalPos, const bool Marked[])
	{
	int* alleleCounts=Initialize(totalPos, 0);
	unsigned int* Basis=Initialize(5, (unsigned int)0);

	for (int i=0; i<totalPos;i++)
	 alleleCounts[i]=CountAlleles(pos[i], Basis, Marked);
	zaparr(Basis);
	return alleleCounts;
	}
	/*____________________________________________________________ */

	MultidimensionalTable<double>* GenotypeSample::countGenotypes ( const SNPPos *pos, int totalPos, allele** allAlleles, const bool Marked[] )
	{
		intList* dimensionList=new intList();
		for ( int i=0; i<totalPos;i++ ) dimensionList->insertElement ( totalAlleles[pos[i]] );

		MultidimensionalTable<double>* result=new MultidimensionalTable<double> ( dimensionList );
		zap ( dimensionList );

		dimensionList=new intList();
		for ( int i=0; i<totalPos;i++ ) dimensionList->insertElement ( getTotalGenotypes ( totalAlleles[pos[i]] ) );

		AmbiguousArray* tableGenotypes=new AmbiguousArray ( dimensionList );
		zap ( dimensionList );

		iterator IndGenotype=getFirst();
		Genotype * genotype;
		SNPPos Total=0, cont=0;
		bool phased=false;
		int* positions;
		while ( IndGenotype!=end() )
		{
			if ( Marked==NULL || Marked[cont]==true )
			{
				genotype=getElement ( IndGenotype );
				genotype->CountGenotypes ( result, pos, totalPos, allAlleles, totalAlleles, tableGenotypes );
			}
			IndGenotype=getNext ( IndGenotype );
		}
		zap ( tableGenotypes );
		return result;
	}
	/*____________________________________________________________ */
	/*
	double GenotypeSample::GetHap(SNPPos SNP1, SNPPos SNP2, allele allele1, allele allele2, Transmission transmission, const bool Marked[])
	{
	iterator IndGenotype=getFirst();
	Genotype * genotype;
	double Total=0;
	int cont=0;
	bool phased=false;

	while (IndGenotype!=end())
	{
	 if (Marked==NULL || Marked[cont]==true)
	 {
	 genotype=getElement(IndGenotype);
	 Total=Total+genotype->GetHap(SNP1, SNP2, allele1, allele2, allAlleles, totalAlleles, transmission, AlleleOrderMode);
	 }
	 cont++;
	 IndGenotype=getNext(IndGenotype);
	}
	return Total;
	}
	/*____________________________________________________________ */
	/*
	SNPPos GenotypeSample::GetUnsolvedDoubleHeterozygous (SNPPos FirstSNP, SNPPos LastSNP, MultiallelicHetero i, MultiallelicHetero j, AlleleOrderType alleleOrderType, const bool Marked[]=NULL)
	{
	SNPPos Total=0, cont=0;
	iterator IndGenotype=getFirst();
	Genotype *G;
	while (IndGenotype!=end())
	{
	 if (Marked==NULL || Marked[cont]==true)
	 {
	 G=getElement(IndGenotype);
	 if (G->IsHeterozygousHeterozygous (FirstSNP, LastSNP, i, j, allAlleles[FirstSNP], allAlleles[LastSNP], totalAlleles[FirstSNP], totalAlleles[LastSNP]))
	{
	  if (G->CanBeSolved (FirstSNP, LastSNP, alleleOrderType)==false)
	   Total=Total+1;
	}
	 };
	 IndGenotype=getNext(IndGenotype);
	 cont++;
	}
	return Total;
	}

	/*____________________________________________________________ */


	int* GenotypeSample::getAlleleFrequencies ( allele alleleType, const bool Marked[] )
	{
		SNPPos totalSNPs=GetTotalSNPs();
		int * result=Initialize ( totalSNPs, 0 );
		for ( SNPPos i=0;i<totalSNPs;i++ )
//if (alleleType==NA) // NA
//result[i]=GetTotalType (i, missing, Marked)*2;
			result[i]=GetTotalAllele ( i, alleleType, Marked );
		return result;
	}

	/*____________________________________________________________ */
	/*
	double GenotypeSample::GetnAB(SNPPos SNP1, SNPPos SNP2, Transmission transmission, const bool Marked[]=NULL)
	{
	return GetHap(SNP1, SNP2, allAlleles[SNP1][0], allAlleles[SNP2][0], transmission, Marked);
	};
	/*____________________________________________________________ */
	/*
	double GenotypeSample::GetnAb(SNPPos SNP1, SNPPos SNP2, Transmission transmission, const bool Marked[]=NULL)
	{
	return GetHap(SNP1, SNP2, allAlleles[SNP1][0], allAlleles[SNP2][1], transmission, Marked);
	};
	/*____________________________________________________________ */
	/*
	double GenotypeSample::GetnaB(SNPPos SNP1, SNPPos SNP2, Transmission transmission, const bool Marked[]=NULL)
	{
	return GetHap(SNP1, SNP2, allAlleles[SNP1][1], allAlleles[SNP2][0], transmission, Marked);
	};
	/*____________________________________________________________ */
	/*
	double GenotypeSample::Getnab(SNPPos SNP1, SNPPos SNP2, Transmission transmission, const bool Marked[]=NULL)
	{
	return GetHap(SNP1, SNP2, allAlleles[SNP1][1], allAlleles[SNP2][1], transmission, Marked);
	};
	/*____________________________________________________________ */

	void GenotypeSample::OrderMajorFirst ()
	{
		try
		{
			if ( allAlleles==NULL )
				throw NullValue ( "GenotypeSample::OrderMajorFirst" );

			iterator IndGenotype=getFirst();
			Genotype *g;
			while ( IndGenotype!=end() )
			{
				g=getElement ( IndGenotype );
//cout << g->print() <<"\n";
				g->OrderMajorFirst ( allAlleles );
				IndGenotype=getNext ( IndGenotype );
			}
		}
		catch ( BasicException& be ) {be.addMessage ( string ( "\ncalled from void GenotypeSample::OrderMajorFirst ()" ) ); throw;};
	}
	/*____________________________________________________________ */

	void GenotypeSample::OrderRandomly ()
	{
		iterator IndGenotype=getFirst();
		Genotype *g;
		while ( IndGenotype!=end() )
		{
			g=getElement ( IndGenotype );
			g->OrderRandomly ( allAlleles );
			//ReplaceNode(IndGenotype, g);
			IndGenotype=getNext ( IndGenotype );
		}
//   cout <<"Sorting randomly has finished\n";

	}
		/*____________________________________________________________ */

	void GenotypeSample::orderByAlphabeticOrder ()
	{
		iterator IndGenotype=getFirst();
		Genotype *g;
		while ( IndGenotype!=end() )
		{
			g=getElement ( IndGenotype );
			g->orderByAlphabeticOrder ( allAlleles );
			//ReplaceNode(IndGenotype, g);
			IndGenotype=getNext ( IndGenotype );
		}
//   cout <<"Sorting randomly has finished\n";

	}

	/*____________________________________________________________ */

	void GenotypeSample::PrintHaplotypes ( char* filename )
	{

		GenotypeSample::iterator IndGenotype=getFirst();
		Genotype *genotype;
		OpenOutput ( filename, &OutputFile );

		SNPPos TotalSNPs=GetTotalSNPs();

		while ( IndGenotype!=end() )
		{
			genotype=getElement ( IndGenotype );
			OutputFile << genotype->print ( left );
			OutputFile << "\n";
			OutputFile << genotype->print ( right );
			OutputFile << "\n";
			IndGenotype=getNext ( IndGenotype );
		}
		OutputFile.close();

		cout << "\nInformation about haplotypes has been saved in file " << filename <<"\n";
	}

	/*____________________________________________________________ */

	void GenotypeSample::PrintGenotypes ( char* filename )
	{

		OpenOutput ( filename, &OutputFile );
		OutputFile << *this;
		OutputFile.close();

		cout << "\nInformation about genotypes has been saved in file " << filename <<"\n";
	}
	/*__________________________________________________________*/

	SNPPos GenotypeSample::getTotalType ( SNPPos SNP, int typ, const bool Marked[] )
	{
		GenotypeSample::iterator IndGenotype=GenotypeSample::getFirst();
		Genotype* genotype;
		IndPos Total=0, cont=0;
		while ( IndGenotype!=end() )
		{
			if ( Marked==NULL || Marked[cont]==true )
			{
				genotype=getElement ( IndGenotype );


				if ( typ==genotype->getGenotypeValue ( SNP, getTotalGenotypes ( totalAlleles[SNP] ),totalAlleles[SNP], allAlleles[SNP] ) ) Total++;// plus 1 to count missing values
			}
			IndGenotype=GenotypeSample::getNext ( IndGenotype );
			cont++;
		}
		return Total;
	}

	/*__________________________________________________________*/

	SNPPos GenotypeSample::getTotalMarked ( const bool Marked[] )
	{
		if ( Marked==NULL ) return size();
		int cont=0;
		for ( int i=0; i<size();i++ )
			if ( Marked[cont]==true ) cont++;
		return cont;
	}
	/*___________________________________________________________*/
	/*
	SNPPos GenotypeSample::GetTotalHomozygous1 (SNPPos SNP, const bool Marked[]=NULL)
	{
		return (GetTotalType (SNP, homozygous1, Marked));
	}
	/*___________________________________________________________*/
	/*
	SNPPos GenotypeSample::GetTotalHomozygous2 (SNPPos SNP, const bool Marked[]=NULL)
	{
		return (GetTotalType (SNP, homozygous2, Marked));
	}
	/*___________________________________________________________*/
	/*
	SNPPos GenotypeSample::GetTotalHeterozygous (SNPPos SNP, const bool Marked[]=NULL)
	{
		return (GetTotalType (SNP, heterozygous, Marked));
	}
	/*___________________________________________________________*/

	bool GenotypeSample::checkNonPartialMissing ( SNPPos SNP, const bool Marked[] )
	{
		if ( Marked!=NULL ) setAllAlleles ( Marked );
		if ( isAMissingSNP ( SNP ) ) return true;

		iterator IndGenotype=GenotypeSample::getFirst();
		Genotype * G;
		int cont=0;
		while ( IndGenotype!=GenotypeSample::end() )
		{
			if ( Marked==NULL || Marked[cont]==true )
			{
				G=GenotypeSample::getElement ( IndGenotype );
				if ( ( ( abs ( G->DiplotypeArray[0][SNP] ) ==NA ) &&     abs ( G->DiplotypeArray[1][SNP] ) !=NA )
				        || ( ( abs ( G->DiplotypeArray[0][SNP] ) !=NA ) &&     abs ( G->DiplotypeArray[1][SNP] ) ==NA ) )
					return false;
			}
			IndGenotype=GenotypeSample::getNext ( IndGenotype );
			cont++;
		}
		return true;
	}
	/*___________________________________________________________*/

	bool GenotypeSample::isAMissingSNP ( SNPPos SNP, const bool Marked[] )
	{
		if ( Marked!=NULL ) setAllAlleles ( Marked );
		return ( getTotalNonMissingAlleles ( SNP, Marked ) <totalAlleles[SNP] );
	}
	/*___________________________________________________________*/

	SNPPos GenotypeSample::getTotalMissing ( SNPPos SNP, const bool Marked[] )
	{
		if ( !checkNonPartialMissing ( SNP ) )
			throw BadFormat ( "SNPPos GenotypeSample::getTotalMissing ( SNPPos SNP, const bool Marked[] )" );

		if ( !isAMissingSNP ( SNP,  Marked ) ) return 0;

		int pos=getPosGenotype ( totalAlleles[SNP]-1, totalAlleles[SNP]-1, getTotalGenotypes ( totalAlleles[SNP] ) );
		cout <<"pos should be the last:" << pos <<"\n";
		return getTotalType ( SNP, pos, Marked );

	}
	/*___________________________________________________________*/

	SNPPos GenotypeSample::getTotalNonMissing ( SNPPos SNP, const bool Marked[] )
	{
		int total=0;
		if ( Marked==NULL ) total=size();
		else
			for ( int i=0; i<size();i++ )
				if ( Marked[i]==1 ) total++;
		return total-getTotalMissing ( SNP, Marked );

//	return GetTotalHomozygous1 (SNP, Marked)+GetTotalHomozygous2(SNP, Marked)+GetTotalHeterozygous(SNP, Marked);
	}

	/*____________________________________________________________ */

	IndPos GenotypeSample::getTotalMissingGenotypes ( const bool Marked[] )
	{
		IndPos Total=0, i, cont=0;
		iterator IndGenotype=GenotypeSample::getFirst();
		Genotype * G;
		bool missing;
		while ( IndGenotype!=GenotypeSample::end() )
		{
			if ( Marked==NULL || Marked[cont]==true )
			{
				G=GenotypeSample::getElement ( IndGenotype );
				missing=false;
				i=0;
				while ( missing==false && i<GetTotalSNPs() )
				{
					if ( G->isMissing ( i ) ) missing=true;
					i++;
				}
				if ( missing ) Total++;
			}
			IndGenotype=GenotypeSample::getNext ( IndGenotype );
			cont++;
		}
		return Total;
	}
	/*____________________________________________________________ */

	SNPPos GenotypeSample::getHeterozygousHomozygous1 ( SNPPos FirstSNP, SNPPos LastSNP, const bool Marked[] )
	{
		SNPPos Total=0, cont=0;
		iterator IndGenotype=GenotypeSample::getFirst();
		Genotype * G;
		while ( IndGenotype!=GenotypeSample::end() )
		{
			if ( Marked==NULL || Marked[cont]==true )
			{
				G=GenotypeSample::getElement ( IndGenotype );
				if ( G->IsHeterozygousHomozygous1 ( FirstSNP, LastSNP, allAlleles[LastSNP][0] ) ) Total=Total+1;
			}
			IndGenotype=GenotypeSample::getNext ( IndGenotype );
			cont++;
		}
		return Total;
	}
	/*____________________________________________________________ */

	SNPPos GenotypeSample::getHomozygous1Heterozygous ( SNPPos FirstSNP, SNPPos LastSNP, const bool Marked[] )
	{
		SNPPos Total=0, cont=0;
		iterator IndGenotype=GenotypeSample::getFirst();
		Genotype * G;
		while ( IndGenotype!=GenotypeSample::end() )
		{
			if ( Marked==NULL || Marked[cont]==true )
			{
				G=GenotypeSample::getElement ( IndGenotype );
				if ( G->IsHomozygous1Heterozygous ( FirstSNP, LastSNP, allAlleles[FirstSNP][0] ) ) Total=Total+1;
			}
			IndGenotype=GenotypeSample::getNext ( IndGenotype );
			cont++;
		}
		return Total;
	}
	/*____________________________________________________________ */

	SNPPos GenotypeSample::getHomozygous1Homozygous1 ( SNPPos FirstSNP, SNPPos LastSNP, const bool Marked[] )
	{
		SNPPos Total=0, cont=0;
		iterator IndGenotype=GenotypeSample::getFirst();
		Genotype * G;
		while ( IndGenotype!=GenotypeSample::end() )
		{
			if ( Marked==NULL || Marked[cont]==true )
			{
				G=GenotypeSample::getElement ( IndGenotype );
				if ( G->IsHomozygous1Homozygous1 ( FirstSNP, LastSNP, allAlleles[FirstSNP][0], allAlleles[LastSNP][0] ) ) Total=Total+1;
			}
			IndGenotype=GenotypeSample::getNext ( IndGenotype );
			cont++;
		}
		return Total;
	}
	/*____________________________________________________________ */
	/*
	SNPPos GenotypeSample::getDoubleHeterozygous (SNPPos FirstSNP, SNPPos LastSNP, MultiallelicHetero i, MultiallelicHetero j, const bool Marked[])
	{
	SNPPos Total=0, cont=0;
	iterator IndGenotype=GenotypeSample::getFirst();
	Genotype * G;
	while (IndGenotype!=GenotypeSample::end())
	{
	 if (Marked==NULL || Marked[cont]==true)
	 {
	 G=GenotypeSample::getElement(IndGenotype);
	 if (G->IsHeterozygousHeterozygous(FirstSNP, LastSNP, i, j, allAlleles[FirstSNP], allAlleles[LastSNP], totalAlleles[FirstSNP], totalAlleles[LastSNP])) Total=Total+1;
	 }
	 IndGenotype=GenotypeSample::getNext(IndGenotype);
	 cont++;
	 }
	return Total;
	}


	/*____________________________________________________________ */

	int* GenotypeSample::CountAlleles ( SNPPos SNP, const bool Marked[]=NULL )
	{
// It returns the total frequencies of the different alleles used in marked genotypes.
// It includes missing as a different allele

Genotype * genotype=NULL;
iterator indGenotype;
		try
		{
			IndPos cont=0;
			int* Basis=Initialize ( 5, 0 );

			
			for ( indGenotype=getFirst(); indGenotype<end(); indGenotype++ )
			{

				if ( Marked==NULL || Marked[cont]==true )
				{

					genotype=getElement ( indGenotype );
// absolute values has to be used to catch those marked as unphased
					Basis[abs ( ( int ) genotype->getLeftAllele ( SNP ) )-1]++;
					Basis[abs ( ( int ) genotype->getRightAllele ( SNP ) )-1]++;

				}
				cont++;
			}
			return Basis;
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from int* GenotypeSample::CountAlleles (SNPPos SNP, const bool Marked[]=NULL) gave error when processing ind at pos "+tos(this->getPosition(indGenotype)) ); throw;};
	}

	/*____________________________________________________________ */

	allele** GenotypeSample::setAllAlleles ( const bool Marked[], const bool Marked2[] )
	{
// it fills an array of array of SNPs with all the alleles at each position considering Marked individuals
// Marked2 is used to consider if there is some missing values in other individual genotypes even if there were not in the Marked ones
		try
		{
			SNPPos TotalSNPs=GetTotalSNPs();
			if ( allAlleles!=NULL )
			{


				for ( int i=0; i<TotalSNPs; i++ )
					zaparr ( allAlleles[i] );
				zaparr ( allAlleles );
			}
			zaparr ( totalAlleles );
//cout <<"Computing major alleles...\n";
			int*Basis=NULL, *Basis2=NULL, ChosenPos, ChosenVal;
// Basis first positions is for missing allele, 1 - 4 positions are for A, G, C, T respectively

			totalAlleles=new int[TotalSNPs];// for the total number of different alleles at each SNP, excluding missing
			allAlleles=new allele*[TotalSNPs]; // for the alleles ordered in decreasing frequencies except the missing allele, which goes at the end
			for ( SNPPos SNP=0;SNP<TotalSNPs;SNP++ )
			{
				Basis=CountAlleles ( SNP, Marked );

				if ( 1==0 )
				{
					cout <<"before\n";
					for ( int h=0; h<5; h++ )
						cout <<"Basis for pos: " << h <<" is: " << Basis[h] <<"\n";
				}
				totalAlleles[SNP]=0;
				for ( int c2=0;c2<5;c2++ ) // 0: 3 for known nucleotides, 4 for missing values
					if ( Basis[c2]>0 )
						totalAlleles[SNP]++;


				if ( Basis[4]==0 && Marked2!=NULL )
				{
					Basis2=CountAlleles ( SNP, Marked2 );
					if ( Basis2[4]>0 )
						totalAlleles[SNP]++;
				}

				if ( ( allAlleles[SNP]=new allele[totalAlleles[SNP]] ) ==NULL )
					throw NoMemory ( "GenotypeSample::setAllAlleles" );


				for ( int i=0; i< ( totalAlleles[SNP]- ( Basis[4]>0 ) );i++ )
				{
					allAlleles[SNP][i]= ( allele ) ( GetMaxPos ( & ( Basis[0] ),4 ) +1 );// missing allele is not used
					Basis[allAlleles[SNP][i]-1]=0;
				}
				if ( 1==0 )
				{
					cout <<"after\n";
					for ( int h=0; h<5; h++ )
						cout <<"Basis for pos: " << h <<" is: " << Basis[h] <<"\n";
				}


				if ( Basis[4]>0 || ( Marked2!=NULL && Basis2[4]>0 ) ) // if missing values
					allAlleles[SNP][totalAlleles[SNP]-1]= ( allele ) 5;

				zaparr ( Basis );
				zaparr ( Basis2 );
				if ( 1==0 )
					//if (SNP==28)
				{
					for ( int i=0; i<totalAlleles[SNP];i++ )
					{
						cout <<" \nallele at pos " << i << " is: " << UnconvertAllele ( allAlleles[SNP][i] );
					}
					cout <<"\ntotalalleles at snp " << SNP << ":  " << totalAlleles[SNP];
				}
			}

		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from allele** GenotypeSample::setAllAlleles(const bool Marked[], const bool Marked2[])" ); throw;};
	}
	/*___________________________________________________________*/

	void GenotypeSample::RemoveInconsistentIndividuals ( SNPPos HomoPos, iterator IndGenotypeRef )
	{
		SNPPos Total=0, cont=0;
		iterator IndGenotype=getFirst();
		Genotype *G, *GRef;
		Diplotype *D, *DRef;
		allele majorAllele=allAlleles[HomoPos][0];
		while ( IndGenotype!=end() )
		{
			GRef=getElement ( IndGenotype );
			G=getElement ( IndGenotypeRef );
			if ( ( Diplotype::isHomozygous1 ( G->DiplotypeArray[0][HomoPos], G->DiplotypeArray[1][HomoPos], majorAllele ) && Diplotype::isHomozygous2 ( GRef->DiplotypeArray[0][HomoPos], GRef->DiplotypeArray[1][HomoPos], majorAllele ) )
			        || ( Diplotype::isHomozygous2 ( G->DiplotypeArray[0][HomoPos], G->DiplotypeArray[1][HomoPos], majorAllele ) && Diplotype::isHomozygous1 ( GRef->DiplotypeArray[0][HomoPos], GRef->DiplotypeArray[1][HomoPos], majorAllele ) ) )
				removeNode ( IndGenotype );
			IndGenotype=getNext ( IndGenotype );
		}
	};
	/*_______________________________________________________________*/

	stringSample* GenotypeSample::genericExportation ( FormatType alg, Transmission t, bool orderedByValue )
	{
		stringSample* l=new stringSample();
		SNPPos TotalSNPs=GetTotalSNPs();

		stringList* row;
		string s;
//cout <<"Exporting to ML, file " << filename << "\n";
		iterator IndGenotype=getFirst();
		Genotype* g;
		Diplotype *D;
		while ( IndGenotype!=end() )
		{
			row=new stringList();
			g=getElement ( IndGenotype );
			for ( SNPPos i=0; i<TotalSNPs;i++ )
			{
				switch ( alg )
				{
					case SNPHAP: // SNPHAP
						s=ExportIndividualGenotypeForSNPHAP ( g->DiplotypeArray[0][i], g->DiplotypeArray[1][i] );
						break;
					case HTYPER: // HTYPER
					case PLEM: // PLEM
						row->outputSeparator=0;
						s=ExportIndividualGenotypeForHTYPERAndPLEM ( g->DiplotypeArray[0][i], g->DiplotypeArray[1][i], i );
						break;
					case ML:
						s=ExportIndividualGenotypeForML ( g->DiplotypeArray[0][i], g->DiplotypeArray[1][i], i, orderedByValue );
						break;
					case MLHAP:
						s=ExportIndividualGenotypeForMLHAP ( g->DiplotypeArray[0][i], g->DiplotypeArray[1][i], i, t );
						break;
					case HAP: // HAP
						s=ExportIndividualGenotypeForHAP ( g->DiplotypeArray[0][i], g->DiplotypeArray[1][i] );
						break;
					case IHAP:
						s=ExportIndividualGenotypeForIHAP ( g->DiplotypeArray[0][i], g->DiplotypeArray[1][i], i, t );
						break;
				}
				row->insertElement ( s );
			}
			l->insertElement ( row );
			IndGenotype=getNext ( IndGenotype );
			//exit(0);
		}
		return l;
	}

	/*_______________________________________________________________*/

	stringSample* GenotypeSample::ExportForPHASE ( stringList* Pos )
	{
		stringSample* l=new stringSample();
		SNPPos TotalSNPs=GetTotalSNPs();

//cout <<"Exporting to PHASE\n";

// row 1
		stringList* row=new stringList();
		string s;
		s=tos ( size() );
		row->insertElement ( s );
		l->insertElement ( row );

// row 2
		row=new stringList ();
		s=tos ( TotalSNPs );
		row->insertElement ( s );
		l->insertElement ( row );

// row 3
		row=new stringList ();
		s=string ( "P" );
		row->insertElement ( s );

		for ( SNPPos i=0; i<TotalSNPs;i++ )

		{
			s=Pos->getElement ( i ) ;
			row->insertElement ( s );
		}
		l->insertElement ( row );

// row 4
		row=new stringList ( ' ' );
		s=string ( "" );
		for ( SNPPos i=0; i<TotalSNPs;i++ )
			s=s+"S";

		row->insertElement ( s );
		l->insertElement ( row );

// next rows

		iterator IndGenotype=getFirst();

		Genotype* g;
		string s2;

		IndPos Ind=0;
		while ( IndGenotype!=end() )
		{
			row=new stringList ();
			g=getElement ( IndGenotype );
			row=new stringList ();
			s=string ( "#" );
			row->insertElement ( s );
			s=string ( "Id" );
			row->insertElement ( s );
			s=tos ( Ind );
			row->insertElement ( s );
			l->insertElement ( row );



			row=new stringList ();
			s=string ( "" );
			for ( SNPPos i=0; i<TotalSNPs;i++ )
				if ( !Diplotype::isANonMissingSNP ( g->DiplotypeArray[0][i], g->DiplotypeArray[1][i] ) )
					s=s+string ( "?" );
				else s=s+tos ( abs ( g->DiplotypeArray[0][i] ) );
			row->insertElement ( s );
			l->insertElement ( row );
			row=new stringList ();
			s=string ( "" );
			for ( SNPPos i=0; i<TotalSNPs;i++ )
					if ( !Diplotype::isANonMissingSNP ( g->DiplotypeArray[0][i], g->DiplotypeArray[1][i] ) ) s=s+string ( "?" ); else  s=s+tos ( abs ( g->DiplotypeArray[1][i] ) );
			row->insertElement ( s );
			l->insertElement ( row );
			IndGenotype=getNext ( IndGenotype );
			Ind++;
		}
		return l;

	}

	/*____________________________________________________________ */
	/*
	  string GenotypeSample::ExportIndividualGenotypeForHTYPERAndPLEM (Diplotype &D, SNPPos i)
	  {
	    if (D.isAMissingSNP() ) return string ("3");
	    if (D.isHeterozygous (allAlleles[i][0]) ) return string ("0");
	    if (D.isHomozygous1 (allAlleles[i][0]) )  return string ("1");
	    if (D.isHomozygous1 (allAlleles[i][1]) )  return string ("2");
	  }
	  /*____________________________________________________________ */

	string GenotypeSample::ExportIndividualGenotypeForHTYPERAndPLEM ( allele&left, allele& right, SNPPos i )
	{
		if ( !Diplotype::isANonMissingSNP ( left, right ) ) return string ( "3" );
		if ( Diplotype::isHeterozygous ( left, right,allAlleles[i][0] ) ) return string ( "0" );
		if ( Diplotype::isHomozygous1 ( left, right,allAlleles[i][0] ) )  return string ( "1" );
		if ( Diplotype::isHomozygous1 ( left, right,allAlleles[i][1] ) )  return string ( "2" );
	}

	/*____________________________________________________________ */

	stringSample* GenotypeSample::ExportForHTYPERAndPLEM ( FormatType alg )
	{
		return genericExportation ( alg );
	}
	/*____________________________________________________________ */

	stringSample* GenotypeSample::ExportForML ( bool orderedByValue )
	{
		return genericExportation ( ML, ut, orderedByValue );
	}
	/*____________________________________________________________ */

	stringSample* GenotypeSample::ExportForMLHAP ( Transmission t )
	{
		return genericExportation ( MLHAP, t );
	}
	/*____________________________________________________________ */

	GenotypeSample* GenotypeSample::clone ()
	{
		return new GenotypeSample ( ( GenotypeSample& ) *this );
	}
	/*____________________________________________________________ */

	GenotypeSample* GenotypeSample::emptyCopy ()
	{
		return new GenotypeSample();
	}
	/*____________________________________________________________ */

	stringSample* GenotypeSample::ExportForIHAP ()
	{
		stringSample* result, *result2, *result3=new stringSample();
		result=genericExportation ( IHAP, t );
		result2=genericExportation ( IHAP, u );
		int i=0;
		stringList* hap;
		for ( stringSample::iterator it = result->begin(); it!=result->end(); it++ )
		{
//hap=new stringList(*result->getElement(it));
			result3->insertElement ( result->getElement ( it ) );
//hap=new stringList(*result2->getElement(i));
			result3->insertElement ( result2->getElement ( i ) );
			i++;
		}
//zap(result);
//zap(result2);
		return result3;
	}
	/*____________________________________________________________ */

	stringSample* GenotypeSample::ExportForSNPHAPAndHAP ( FormatType alg )
	{
		stringSample* l=genericExportation ( alg );
		string s;
		int i=1;

		for ( stringSample::iterator it = l->getFirst();
		        it != l->getLast(); it++ )
		{
			s=tos ( i );
			l->getElement ( it )->insertElementAtPos ( s, 0 );
			i++;
		}
		return l;
	}

	/*____________________________________________________________ */

	string GenotypeSample::ExportIndividualGenotypeForML ( allele&left, allele&right, SNPPos i, bool orderedByValue )
	{
//ordered by value means to consider de major allele that one with the lowest number/letter: (A,C,G,T)
		char value;
		string s;
		if ( !Diplotype::isANonMissingSNP ( left, right ) ) return string ( "?" );
		/*
		if ( !orderedByValue )
		{
			if ( Diplotype::getGenotypeCode ( left, right ) >9 || Diplotype::getGenotypeCode ( left, right ) <0 )
				throw BadFormat ( tos ( Diplotype::getGenotypeCode ( left, right ) ) +string ( "GenotypeSample::ExportIndividualGenotypeForML" ) );
			return tos ( Diplotype::getGenotypeCode ( left, right ) );
		}

		cout << "ordered value ia: " << orderedByValue <<"\n";
		cout << "diplotype is:" << left << " " << right <<"\n";
		cout <<"is hetero:" << Diplotype::isHeterozygous ( left, right, allAlleles[i][0] )  <<"\n";
		cout <<"is homo1:" <<Diplotype::isHomozygous1 ( left, right, allAlleles[i][0] )   <<"\n";
		*/
		if ( Diplotype::isHeterozygous ( left, right, allAlleles[i][0] ) )
			value='1';
		else
			if ( Diplotype::isHomozygous1 ( left, right, allAlleles[i][0] ) )
				if ( orderedByValue ) value= ( allAlleles[i][0]<allAlleles[i][1] ) ? '0' : '2';
				else
					value= '0'; // most common allele
			else
				if ( orderedByValue ) value= ( allAlleles[i][0]<allAlleles[i][1] ) ? '2' : '0';
				else value= '2'; // wild type

		s=tos ( value );
		return s;
	}

	/*____________________________________________________________ */

	string GenotypeSample::ExportIndividualGenotypeForIHAP ( allele&left, allele& right, SNPPos i, Transmission trans )
	{
		string s;
		if ( trans==t ) s=tos ( ( ( int ) ( left )-1 ) );
		if ( trans==u ) s=tos ( ( ( int ) ( right )-1 ) );
		if ( trans==ut )
		{
			throw BadFormat ( "GenotypeSample::ExportIndividualGenotypeForIHAP" );
			exit ( 0 );
		}
		return s;
	};

	/*____________________________________________________________ */

	string GenotypeSample::ExportIndividualGenotypeForMLHAP ( allele& left, allele& right, SNPPos i, Transmission trans )
	{
		string s=string ( "" );
		if ( trans==ut || trans==t ) s=s+tos ( ( int ) left );
		if ( trans==ut || trans==u ) s=s+tos ( ( int ) right );
		return s;
	};

	/*____________________________________________________________ */

	stringSample* GenotypeSample::ExportMetaForML ()
	{
		stringSample* l=new stringSample();
		stringList* row;
		string s;
		SNPPos TotalSNPs=GetTotalSNPs();
		for ( SNPPos i=0;i<TotalSNPs;i++ )
		{
			row=new stringList ( ' ' );
			s=string ( "0 SNP" ) +tos ( i+1 ) +string ( ": 0, 1, 2" ); //, 3, 4, 5, 6, 7, 8, 9" );
// we will consider the four alleles, therefore it would be 10 different values:
// AA, CC, GG, TT, AC, AG, AT, CG, CT, GT
//
			row->insertElement ( s );
			l->insertElement ( row );
		}
		return l;
	}
	/*____________________________________________________________ */

	stringSample* GenotypeSample::ExportMetaForMLHAP ()
	{

		SNPPos TotalSNPs=GetTotalSNPs();
		stringSample* l=new stringSample();
		stringList* row;
		string s;
		for ( SNPPos i=0;i<TotalSNPs;i++ )
		{
			row=new stringList ( ' ' );
			s=string ( "0 SNP" );
			row->insertElement ( s );
			s=tos ( i );
			s=s+string ( ": 12, 21, 11, 22 //" );
			row->insertElement ( s );
			l->insertElement ( row );
		}
		return l;
	}


	/*____________________________________________________________ */

	string GenotypeSample::ExportIndividualGenotypeForSNPHAP ( allele& left, allele& right ) //ExportForSNPHAP (char *filename)
	{
		string s, s2;
		if ( !Diplotype::isANonMissingSNP ( left, right ) ) s=string ( "? ?" );
		else
		{
			s=string ( UnconvertAllele ( left ) );
			s2=string ( UnconvertAllele ( right ) );
		}
		s=s+" "+s2;
		return s;
	}
	/*____________________________________________________________ */

	string GenotypeSample::ExportIndividualGenotypeForHAP ( allele& left, allele & right ) //ExportForSNPHAP (char *filename)
	{
		string s, s2;
		if ( !Diplotype::isANonMissingSNP ( left, right ) ) s=string ( "S S" );
		else
		{
			s= string ( UnconvertAllele ( left ) );
			s2= string ( UnconvertAllele ( right ) );
		}
		s=s+" "+s2;
		return s;
	}

	/*____________________________________________________________ */

	void GenotypeSample::SNPSampling ( Container<vector<SNPPos>, SNPPos> *Sampling )
	{

		Genotype *genotype, *genotype2;
		iterator p=getFirst(), pOld, pNext;
		while ( p!=end() )
		{
			genotype=getElement ( p );
			genotype2=new Genotype ( *genotype, Sampling );
			pOld=p;
			p=getNext ( p );
			removeNode ( pOld );
			pNext=p;
			insertElement ( genotype2, p );
			p=pNext;

		}

	}

	/*________________________________________________________________________________________________*/
	/*
	void GenotypeSample::ImportFormat (char *filename)
	{
	if (size()>0)
	{
	cout <<"Importing must be done when there is not any individuals in this object";
	exit(0);
	}
	AlleleOrderMode=NotChanged;
	ExistPhenotype=false;
	SNPPos TotalSNPs, TotalSNPsOld, i=0;
	SNPPos size=GetLineLength(filename)+1;


	InputFile.open (filename, ifstream::in);
	if (!InputFile || InputFile.peek()==EOF)
		throw ErrorFile();


	    char *genotypebuf=NULL, *cad;
	    if ((genotypebuf=new char[size])==NULL)
	     throw NoMemory();

	Genotype* targetGenotype=NULL;
	while (InputFile.peek()!=EOF)
	{
	InputFile.getline (genotypebuf, size, '\n');
	TotalSNPs=strlen(genotypebuf);

	if (i>0 && TotalSNPs!=TotalSNPsOld)
	{
	cout <<"\nError in input file. The individual " << i <<" has " << TotalSNPs+1 <<" SNPs, while the others before had " << TotalSNPsOld+1 << " SNPs.";
	exit(0);
	}
	Diplotype* diplotype;
	targetGenotype= new Genotype(TotalSNPs);
	for (int d=0;d<TotalSNPs;d++)
	{
	 switch (genotypebuf[d])
	 {
	 case '0': diplotype= new Diplotype((allele)1,(allele)2); break;
	 case '1': diplotype= new Diplotype((allele)1,(allele)1); break;
	 case '2': diplotype= new Diplotype((allele)2,(allele)2); break;
	 case '3': diplotype= new Diplotype((allele)0,(allele)0); break;
	 case '4': diplotype= new Diplotype((allele)1,(allele)0); break;
	 case '5': diplotype= new Diplotype((allele)2,(allele)0); break;
	default: cout <<"\nError, value " << genotypebuf[d] << " is not allowed."; exit(0); break;
	 }

	targetGenotype->SetDiplotype(diplotype, d);
	zap(diplotype);
	};
	insertElement(targetGenotype);

	i++;
	TotalSNPsOld=TotalSNPs;
	}
	InputFile.close();
	zaparr(genotypebuf);



	}

	/*________________________________________________________________________________________________*/

	void GenotypeSample::printUsingAlleleNumbers ( ostream& os, IndPos i )
	{

		Genotype* genotype=getElement ( i );
		genotype->printUsingAlleleNumbers ( os );
	}

	/*________________________________________________________________________________________________*/


	ostream& operator<< ( ostream& out, GenotypeSample& genotypeSample )
	{
		GenotypeSample::iterator IndGenotype=genotypeSample.getFirst();
		Genotype *genotype;

		//SNPPos TotalSNPs=genotypeSample.GetTotalSNPs();

		/* this cannot be written here, as genotypesample may be printed to build .gou files. If required, anoter class or method should be created
		for (int i=0; i<genotypeSample.GetTotalSNPs(); i++)
		{
		 out <<"\nAlleles at position " << i <<" ordered by frequencies are : ";
		 for (int j=0; j<genotypeSample.totalAlleles[i]; j++)
		  out << genotypeSample.allAlleles[i][j] <<" ";
		}
		cout <<"\n";
		*/
//cout <<"we are hre and delimier are:" << genotypeSample.leftDelimiter <<" and " << genotypeSample.rightDelimiter;
		while ( IndGenotype!=genotypeSample.end() )
		{
			genotype=genotypeSample.getElement ( IndGenotype );
			out << genotypeSample.leftDelimiter << *genotype  << genotypeSample.rightDelimiter;
			IndGenotype=genotypeSample.getNext ( IndGenotype );
		}
		return out;
	}


}
// End of Namespace

#endif

/* End of file: GenotypeSample.h */




